/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.recog.GridDebugger;
import de.tum.in.gagern.ornament.recog.Peak;
import de.tum.in.gagern.ornament.recog.RecognitionListener;
import de.tum.in.gagern.ornament.recog.Recognizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class VisualGridDebugger
extends JPanel
implements GridDebugger,
RecognitionListener {
    private int wImg;
    private int hImg;
    private Point[] vectorCandidates;
    private List peaks;
    private Point av;
    private Point bv;
    private BufferedImage background;
    private double best;
    private JudgedPeak current;
    private List judged = new ArrayList();
    private JSlider gridSizeSlider;
    private int gridSize;
    private JLabel msgLabel;
    private double bestPairScore;
    private int bestPairSize;
    private double bestScore;
    private int blockLevel = 5;
    private boolean blocked;

    VisualGridDebugger() {
    }

    public static void main(String[] args) throws Exception {
        JFrame frm = new JFrame("grid debugger");
        VisualGridDebugger vgdbg = new VisualGridDebugger();
        frm.getContentPane().add((Component)vgdbg, "Center");
        frm.getContentPane().add(vgdbg.getControls(), "South");
        frm.setSize(400, 400);
        frm.setLocationRelativeTo(null);
        frm.setDefaultCloseOperation(3);
        frm.setVisible(true);
        BufferedImage img = ImageIO.read(new File(args[0]));
        Recognizer recog = new Recognizer(vgdbg, vgdbg, img, true);
        recog.gdbg = vgdbg;
        recog.run();
        System.exit(3);
    }

    private Component getControls() {
        JPanel ctrls = new JPanel();
        ctrls.setLayout(new GridLayout(0, 1, 5, 5));
        ctrls.add(new JButton(new AbstractAction("Next pair"){

            public void actionPerformed(ActionEvent evnt) {
                VisualGridDebugger.this.unblock(5);
            }
        }));
        ctrls.add(new JButton(new AbstractAction("Next best"){

            public void actionPerformed(ActionEvent evnt) {
                VisualGridDebugger.this.unblock(10);
            }
        }));
        ctrls.add(new JButton(new AbstractAction("Finish"){

            public void actionPerformed(ActionEvent evnt) {
                VisualGridDebugger.this.unblock(20);
            }
        }));
        this.gridSizeSlider = new JSlider();
        ctrls.add(this.gridSizeSlider);
        this.gridSizeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evnt) {
                VisualGridDebugger.this.updateGridSize(VisualGridDebugger.this.gridSizeSlider.getValue());
            }
        });
        this.msgLabel = new JLabel("");
        ctrls.add(this.msgLabel);
        return ctrls;
    }

    public synchronized void paintComponent(Graphics g) {
        if (this.background == null) {
            super.paintComponent(g);
            return;
        }
        g.drawImage(this.background, 0, 0, this);
        g.translate(this.wImg - 1, this.hImg - 1);
        g.setColor(Color.BLUE);
        if (this.av != null) {
            g.drawLine(0, 0, this.av.x, this.av.y);
        }
        if (this.bv != null) {
            g.drawLine(0, 0, this.bv.x, this.bv.y);
        }
        if (this.peaks != null) {
            g.setColor(Color.BLACK);
            for (int i = 0; i < this.gridSize; ++i) {
                Peak peak = (Peak)this.peaks.get(i);
                this.drawCross(g, peak.getX(), peak.getY(), 3);
            }
        }
    }

    private void drawX(Graphics g, int x, int y, int size) {
        g.drawLine(x - size, y - size, x + size, y + size);
        g.drawLine(x - size, y + size, x + size, y - size);
    }

    private void drawCross(Graphics g, int x, int y, int size) {
        g.drawLine(x - size, y, x + size, y);
        g.drawLine(x, y - size, x, y + size);
    }

    public void imageSizes(int wImg, int hImg) {
        Container p;
        this.wImg = wImg;
        this.hImg = hImg;
        int w = 2 * wImg - 1;
        int h = 2 * hImg - 1;
        this.background = new BufferedImage(w, h, 1);
        this.setPreferredSize(new Dimension(2 * wImg - 1, 2 * hImg - 1));
        Container c = this;
        while ((p = c.getParent()) != null) {
            c = p;
        }
        if (c instanceof Window) {
            ((Window)c).pack();
        }
    }

    public void vectorCandidates(Point[] vectorCandidates) {
        this.vectorCandidates = vectorCandidates;
    }

    public void peaks(List peaks) {
        this.peaks = peaks;
        this.gridSizeSlider.setMaximum(peaks.size());
    }

    public synchronized void currentPair(int ax, int ay, int bx, int by) {
        this.av = new Point(ax, ay);
        this.bv = new Point(bx, by);
        Point2D.Double p = new Point2D.Double();
        double maxFit = Recognizer.calculateFit(0.0, 0.0);
        double minFit = Recognizer.calculateFit(0.5, 0.5);
        AffineTransform trv = new AffineTransform(ax, ay, bx, by, 0.0f, 0.0f);
        try {
            AffineTransform trvi = trv.createInverse();
            for (int y = 0; y < this.background.getHeight(); ++y) {
                int dy = y - this.hImg + 1;
                for (int x = 0; x < this.background.getWidth(); ++x) {
                    int dx = x - this.wImg + 1;
                    p.setLocation(dx, dy);
                    trvi.transform(p, p);
                    double ca = p.x;
                    double cb = p.y;
                    int ia = (int)Math.round(ca);
                    int ib = (int)Math.round(cb);
                    double fit = Recognizer.calculateFit(ca - (double)ia, cb - (double)ib);
                    double brightness = (fit - minFit) / (maxFit - minFit);
                    brightness = 0.6 * brightness + 0.2;
                    double hue = fit >= 0.0 ? 0.3333333333333333 : 0.0;
                    int color = Color.HSBtoRGB((float)hue, 1.0f, (float)brightness);
                    this.background.setRGB(x, y, color);
                }
            }
        }
        catch (NoninvertibleTransformException e) {
            Graphics2D g = this.background.createGraphics();
            g.setColor(Color.YELLOW);
            g.fillRect(0, 0, this.background.getWidth(), this.background.getHeight());
            g.dispose();
        }
        this.judged.clear();
        this.bestPairScore = Double.NEGATIVE_INFINITY;
        this.bestPairSize = 0;
        this.block(2);
    }

    public void beginPoint(int ci, Peak cp, Point ip, double fit, double overlap) {
        this.current = new JudgedPeak(ci, cp, ip, fit, overlap);
        this.judged.add(this.current);
    }

    public void skipPoint() {
    }

    public void replacePoint(Peak op) {
    }

    public void judgePoint(double score, double gridCoverage, double peakCoverage) {
        this.current.judge(score, gridCoverage, peakCoverage);
        if (score > this.bestPairScore) {
            this.bestPairScore = score;
            this.bestPairSize = this.current.ci + 1;
            if (score > this.bestScore && this.bestPairSize > 8) {
                this.bestScore = score;
            }
        }
    }

    public void donePair() {
        this.updateGridSize(this.bestPairSize);
        if (this.bestPairScore == this.bestScore) {
            this.block(10);
        } else {
            this.block(5);
        }
    }

    private synchronized void block(int level) {
        this.repaint();
        if (level < this.blockLevel) {
            return;
        }
        this.blocked = true;
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.blocked);
    }

    public synchronized void unblock(int level) {
        this.blockLevel = level;
        this.blocked = false;
        this.notify();
    }

    private void updateGridSize(int size) {
        this.gridSize = size;
        this.gridSizeSlider.setValue(this.gridSize);
        if (this.gridSize == 0) {
            this.msgLabel.setText("beginning");
        } else if (this.gridSize > this.judged.size()) {
            this.msgLabel.setText("past end: " + this.gridSize + " > " + this.judged.size());
        } else {
            JudgedPeak jp = (JudgedPeak)this.judged.get(this.gridSize - 1);
            this.msgLabel.setText(jp.toString());
        }
        this.repaint();
    }

    public void recognitionSuccessful(Group group, BufferedImage median, AffineTransform transform) {
        System.exit(0);
    }

    public void recognitionCanceled() {
        System.exit(2);
    }

    public void recognitionFailed(Throwable e) {
        e.printStackTrace();
        System.exit(1);
    }

    private static class JudgedPeak {
        int ci;
        Peak cp;
        Point ip;
        double fit;
        double overlap;
        double score;
        double gridCoverage;
        double peakCoverage;

        public JudgedPeak(int ci, Peak cp, Point ip, double fit, double overlap) {
            this.ci = ci;
            this.cp = cp;
            this.ip = ip;
            this.fit = fit;
            this.overlap = overlap;
        }

        public void judge(double score, double gridCoverage, double peakCoverage) {
            this.score = score;
            this.gridCoverage = gridCoverage;
            this.peakCoverage = peakCoverage;
        }

        public String toString() {
            String format = "score={0,number,0.###} gc={1,number,0.###} pk={2,number,0.###} fit={3,number,0.###}";
            Object[] args = new Object[]{new Double(this.score * 10000.0), new Double(this.gridCoverage * 100.0), new Double(this.peakCoverage * 100.0), new Double(this.fit)};
            return MessageFormat.format(format, args);
        }
    }
}

