/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.recog.CanceledOperationException;
import de.tum.in.gagern.ornament.recog.Peak;
import de.tum.in.gagern.ornament.recog.ProgressPhase;
import de.tum.in.gagern.ornament.recog.RecognitionException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Correlator {
    private static final int tileBits = 5;
    private static final int tileSize = 32;
    private static final int tileMask = 31;
    private static final int tileArea = 1024;
    private static final boolean doSymmetricColors = false;
    private final boolean auto;
    private final int wBits;
    private final int hBits;
    private final int wFFT;
    private final int hFFT;
    private final float[] tileArray;
    private final float[] omegas;
    private final float[] realArray;
    private final float[] imagArray;
    private final float[] realArray2;
    private final float[] imagArray2;
    private final FloatBuffer accuBuf;
    private final FloatBuffer realBuf1;
    private final FloatBuffer imagBuf1;
    private final FloatBuffer realBuf2;
    private final FloatBuffer imagBuf2;
    private final int[] xBitrev;
    private final int[] yBitrev;
    private int wImg;
    private int hImg;
    private static final int peakGridShift = 8;

    public Correlator(int width, int height, boolean auto) throws IOException {
        this.wBits = Math.max(Correlator.numBits(width), 5);
        this.hBits = Math.max(Correlator.numBits(height), 5);
        this.auto = auto;
        if (this.wBits < 5 || this.hBits < 5) {
            throw new IllegalArgumentException("FFT data sizes too small");
        }
        if (this.wBits + this.hBits > 30) {
            throw new IllegalArgumentException("FFT data sizes too large");
        }
        this.wFFT = 1 << this.wBits;
        this.hFFT = 1 << this.hBits;
        int maxFFT = Math.max(this.wFFT, this.hFFT);
        this.tileArray = new float[1024];
        this.realArray = new float[maxFFT];
        this.imagArray = new float[maxFFT];
        if (auto) {
            this.realArray2 = null;
            this.imagArray2 = null;
        } else {
            this.realArray2 = new float[maxFFT];
            this.imagArray2 = new float[maxFFT];
        }
        this.omegas = new float[maxFFT];
        for (int i = 0; i < this.omegas.length; i += 2) {
            double angle = Math.PI * (double)i / (double)this.omegas.length;
            this.omegas[i] = (float)Math.cos(angle);
            this.omegas[i + 1] = (float)Math.sin(angle);
        }
        this.xBitrev = Correlator.bitrevArray(this.wBits);
        this.yBitrev = Correlator.bitrevArray(this.hBits);
        File tmpFile = File.createTempFile("orna", null);
        tmpFile.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(tmpFile, "rw");
        long bufSize = 4L * (long)this.wFFT * (long)this.hFFT;
        raf.setLength((long)(auto ? 3 : 5) * bufSize);
        FileChannel chan = raf.getChannel();
        this.accuBuf = this.createBuf(chan, 0L, bufSize);
        this.realBuf1 = this.createBuf(chan, bufSize, bufSize);
        this.imagBuf1 = this.createBuf(chan, 2L * bufSize, bufSize);
        if (auto) {
            this.realBuf2 = null;
            this.imagBuf2 = null;
        } else {
            this.realBuf2 = this.createBuf(chan, 3L * bufSize, bufSize);
            this.imagBuf2 = this.createBuf(chan, 4L * bufSize, bufSize);
        }
        chan.close();
    }

    private FloatBuffer createBuf(FileChannel chan, long position, long size) throws IOException {
        MappedByteBuffer byteBuf = chan.map(FileChannel.MapMode.READ_WRITE, position, size);
        byteBuf.order(ByteOrder.nativeOrder());
        return byteBuf.asFloatBuffer();
    }

    public void correlate(BufferedImage img1, BufferedImage img2, ProgressPhase progress) throws CanceledOperationException {
        int band;
        if (this.auto) {
            throw new IllegalArgumentException("autocorrelations only");
        }
        int numBands = img1.getSampleModel().getNumBands();
        if (img2.getSampleModel().getNumBands() != numBands) {
            throw new IllegalArgumentException("different number of bands");
        }
        ProgressPhase[] progressBands = new ProgressPhase[numBands];
        for (band = 0; band < numBands; ++band) {
            progressBands[band] = progress.createPhase(1.0f);
        }
        this.wImg = Math.max(img1.getWidth(), img2.getWidth());
        this.hImg = Math.max(img1.getHeight(), img2.getHeight());
        progress.begin();
        this.zero(this.accuBuf);
        for (band = 0; band < numBands; ++band) {
            ProgressPhase progressBand = progressBands[band];
            ProgressPhase progressRead1 = progressBand.createPhase(1.0f);
            ProgressPhase progressRead2 = progressBand.createPhase(1.0f);
            ProgressPhase progressFFT1 = progressBand.createPhase(10.0f);
            ProgressPhase progressFFT2 = progressBand.createPhase(10.0f);
            ProgressPhase progressMult = progressBand.createPhase(4.0f);
            ProgressPhase progressIFFT = progressBand.createPhase(10.0f);
            ProgressPhase progressAccu = progressBand.createPhase(3.0f);
            progressBand.setNoticeSuffix(" band " + (band + 1));
            progressRead1.setNoticeSuffix(" image 1");
            progressRead2.setNoticeSuffix(" image 2");
            progressFFT1.setNoticeSuffix(" image 1");
            progressFFT2.setNoticeSuffix(" image 2");
            this.read(img1, band, this.realBuf1, this.imagBuf1, progressRead1);
            this.read(img2, band, this.realBuf2, this.imagBuf2, progressRead2);
            this.fft2D(this.realBuf1, this.imagBuf1, false, progressFFT1);
            this.fft2D(this.realBuf2, this.imagBuf2, false, progressFFT2);
            this.multiply(progressMult);
            this.fft2D(this.realBuf1, this.imagBuf1, true, progressIFFT);
            this.accumulate(progressAccu);
        }
        progress.done();
    }

    public void autocorrelate(BufferedImage img, ProgressPhase progress) throws CanceledOperationException {
        int band;
        int numBands = img.getSampleModel().getNumBands();
        ProgressPhase[] progressBands = new ProgressPhase[numBands];
        for (band = 0; band < numBands; ++band) {
            progressBands[band] = progress.createPhase(1.0f);
        }
        this.wImg = img.getWidth();
        this.hImg = img.getHeight();
        progress.begin();
        this.zero(this.accuBuf);
        for (band = 0; band < numBands; ++band) {
            ProgressPhase progressBand = progressBands[band];
            ProgressPhase progressRead = progressBand.createPhase(1.0f);
            ProgressPhase progressFFT = progressBand.createPhase(10.0f);
            ProgressPhase progressMult = progressBand.createPhase(3.0f);
            ProgressPhase progressIFFT = progressBand.createPhase(10.0f);
            ProgressPhase progressAccu = progressBand.createPhase(3.0f);
            progressBand.setNoticeSuffix(" band " + (band + 1));
            progressBand.begin();
            this.read(img, band, this.realBuf1, this.imagBuf1, progressRead);
            this.fft2D(this.realBuf1, this.imagBuf1, false, progressFFT);
            this.multiplyAuto(progressMult);
            this.fft2D(this.realBuf1, this.imagBuf1, true, progressIFFT);
            this.accumulate(progressAccu);
            progressBand.done();
        }
        progress.done();
    }

    private void read(BufferedImage img, int band, FloatBuffer realBuf, FloatBuffer imagBuf, ProgressPhase progress) throws CanceledOperationException {
        int wImg = img.getWidth();
        int hImg = img.getHeight();
        if (wImg > this.wFFT || hImg > this.hFFT) {
            throw new IllegalArgumentException("image too large");
        }
        progress.begin("reading", Correlator.numTiles(wImg) * Correlator.numTiles(hImg));
        WritableRaster raster = img.getRaster();
        this.zero(realBuf);
        this.zero(imagBuf);
        for (int y = 0; y < hImg; y += 32) {
            realBuf.position(y * this.wFFT);
            for (int x = 0; x < wImg; x += 32) {
                int w = wImg - x;
                int h = hImg - y;
                if (h >= 32) {
                    h = 32;
                } else {
                    Correlator.zero(this.tileArray);
                }
                if (w >= 32) {
                    w = 32;
                }
                raster.getSamples(x, y, w, h, band, this.tileArray);
                if (w < 32) {
                    int pFrom = h * w;
                    int pTo = h * 32;
                    while (pTo > 0) {
                        int x2;
                        for (x2 = w; x2 < 32; ++x2) {
                            this.tileArray[--pTo] = 0.0f;
                        }
                        for (x2 = 0; x2 < w; ++x2) {
                            this.tileArray[--pTo] = this.tileArray[--pFrom];
                        }
                    }
                }
                realBuf.put(this.tileArray);
                progress.step();
            }
        }
        progress.done();
    }

    private void multiply(ProgressPhase progress) throws CanceledOperationException {
        progress.begin("combining", this.realBuf1.limit() / this.realArray.length);
        this.realBuf1.rewind();
        this.imagBuf1.rewind();
        this.realBuf2.rewind();
        this.imagBuf2.rewind();
        while (this.realBuf1.hasRemaining()) {
            this.realBuf1.mark();
            this.imagBuf1.mark();
            this.realBuf1.get(this.realArray);
            this.imagBuf1.get(this.imagArray);
            this.realBuf2.get(this.realArray2);
            this.imagBuf2.get(this.imagArray2);
            for (int i = 0; i < this.realArray.length; ++i) {
                float real1 = this.realArray[i];
                float imag1 = this.imagArray[i];
                float real2 = this.realArray2[i];
                float imag2 = this.imagArray2[i];
                this.realArray[i] = real1 * real2 + imag1 * imag2;
                this.imagArray[i] = real1 * imag2 - real2 * imag1;
            }
            this.realBuf1.reset();
            this.realBuf1.put(this.realArray);
            this.imagBuf1.reset();
            this.imagBuf1.put(this.imagArray);
            progress.step();
        }
        progress.done();
    }

    private void multiplyAuto(ProgressPhase progress) throws CanceledOperationException {
        progress.begin("multiplying", this.realBuf1.limit() / this.realArray.length);
        this.realBuf1.rewind();
        this.imagBuf1.rewind();
        while (this.realBuf1.hasRemaining()) {
            this.realBuf1.mark();
            this.realBuf1.get(this.realArray);
            this.imagBuf1.get(this.imagArray);
            for (int i = 0; i < this.realArray.length; ++i) {
                float real = this.realArray[i];
                float imag = this.imagArray[i];
                this.realArray[i] = real * real + imag * imag;
            }
            this.realBuf1.reset();
            this.realBuf1.put(this.realArray);
            progress.step();
        }
        this.zero(this.imagBuf1);
        progress.done();
    }

    private void accumulate(ProgressPhase progress) throws CanceledOperationException {
        progress.begin("accumulating", this.accuBuf.limit() / this.realArray.length);
        this.accuBuf.rewind();
        this.realBuf1.rewind();
        while (this.accuBuf.hasRemaining()) {
            this.accuBuf.mark();
            this.accuBuf.get(this.imagArray);
            this.realBuf1.get(this.realArray);
            for (int i = 0; i < this.realArray.length; ++i) {
                int n = i;
                this.imagArray[n] = this.imagArray[n] + this.realArray[i];
            }
            this.accuBuf.reset();
            this.accuBuf.put(this.imagArray);
            progress.step();
        }
        progress.done();
    }

    private void fft2D(FloatBuffer realBuf, FloatBuffer imagBuf, boolean inverse, ProgressPhase progress) throws CanceledOperationException {
        ProgressPhase progress1 = progress.createPhase(1.0f);
        ProgressPhase progress2 = progress.createPhase(1.0f);
        progress.begin(inverse ? "inverse transforming" : "transforming");
        this.fft2Dim1Dir(realBuf, imagBuf, this.wFFT, 5, 0, this.hFFT, this.wBits, 5, this.hBits, this.yBitrev, inverse, progress1);
        this.fft2Dim1Dir(realBuf, imagBuf, this.hFFT, this.wBits, 5, this.wFFT, 5, 0, this.wBits, this.xBitrev, inverse, progress2);
        progress.done();
    }

    private void fft2Dim1Dir(FloatBuffer realBuf, FloatBuffer imagBuf, int aCount, int aHigh, int aLow, int bCount, int bHigh, int bLow, int bBits, int[] bitrev, boolean inverse, ProgressPhase progress) throws CanceledOperationException {
        progress.begin(aCount);
        for (int a = 0; a < aCount; ++a) {
            int pos;
            int b;
            int aPos = (a & 0xFFFFFFE0) << aHigh | (a & 0x1F) << aLow;
            for (b = 0; b < bCount; ++b) {
                pos = (b & 0xFFFFFFE0) << bHigh | (b & 0x1F) << bLow | aPos;
                this.realArray[bitrev[b]] = realBuf.get(pos);
                this.imagArray[bitrev[b]] = imagBuf.get(pos);
            }
            this.fft1D(bBits, inverse);
            for (b = 0; b < bCount; ++b) {
                pos = (b & 0xFFFFFFE0) << bHigh | (b & 0x1F) << bLow | aPos;
                realBuf.put(pos, this.realArray[b]);
                imagBuf.put(pos, this.imagArray[b]);
            }
            progress.step();
        }
        progress.done();
    }

    private void fft1D(int bits, boolean inverse) {
        int count = 1 << bits;
        int bitPower = 1;
        int omegaStep = this.omegas.length;
        for (int bit = 0; bit < bits; ++bit) {
            int omegaIndex = 0;
            for (int omegaPower = 0; omegaPower < bitPower; ++omegaPower) {
                float omegaReal = this.omegas[omegaIndex];
                float omegaImag = this.omegas[omegaIndex + 1] * (inverse ? -1.0f : 1.0f);
                int i = omegaPower;
                while (i < count) {
                    int j = i + bitPower;
                    float evenReal = this.realArray[i];
                    float oddReal = this.realArray[j];
                    float evenImag = this.imagArray[i];
                    float oddImag = this.imagArray[j];
                    float deltaReal = oddReal * omegaReal - oddImag * omegaImag;
                    float deltaImag = oddImag * omegaReal + oddReal * omegaImag;
                    this.realArray[j] = evenReal - deltaReal;
                    this.realArray[i] = evenReal + deltaReal;
                    this.imagArray[j] = evenImag - deltaImag;
                    this.imagArray[i] = evenImag + deltaImag;
                    i = j + bitPower;
                }
                omegaIndex += omegaStep;
            }
            bitPower <<= 1;
            omegaStep >>= 1;
        }
    }

    private static int numBits(int n) {
        int bits = 0;
        while (1 << bits < n) {
            ++bits;
        }
        return bits;
    }

    private static int[] bitrevArray(int bits) {
        int[] a = new int[1 << bits];
        for (int i = 0; i < a.length; ++i) {
            int in = i;
            int out = 0;
            for (int k = 0; k < bits; ++k) {
                out = out << 1 | in & 1;
                in >>= 1;
            }
            a[i] = out;
        }
        return a;
    }

    private static void zero(float[] array) {
        Arrays.fill(array, 0.0f);
    }

    private void zero(FloatBuffer buf) {
        Correlator.zero(this.tileArray);
        buf.clear();
        while (buf.hasRemaining()) {
            buf.put(this.tileArray);
        }
        buf.clear();
    }

    private static int roundUpToTileSize(int i) {
        return (i - 1 | 0x1F) + 1;
    }

    private static int numTiles(int i) {
        return (i - 1) / 32 + 1;
    }

    public BufferedImage getDebugImage(boolean gray, boolean fullArea, float blackPoint, float whitePoint, ProgressPhase progress) throws CanceledOperationException {
        int wRes = Correlator.roundUpToTileSize(this.wImg);
        int hRes = Correlator.roundUpToTileSize(this.hImg);
        if (fullArea) {
            wRes = this.wFFT / 2;
            hRes = this.hFFT / 2;
        }
        if (progress != null) {
            progress.begin("creating debug image", 4 * wRes * hRes / 1024);
        }
        int mode = gray ? 10 : 1;
        BufferedImage res = new BufferedImage(2 * wRes, 2 * hRes, mode);
        if (whitePoint <= 0.0f) {
            progress.setMaximum(8 * wRes * hRes / 1024);
            blackPoint = Float.POSITIVE_INFINITY;
            for (int yRes = 0; yRes < 2 * hRes; yRes += 32) {
                int yPos = (yRes + this.hFFT - hRes) % this.hFFT << this.wBits;
                for (int xRes = 0; xRes < 2 * wRes; xRes += 32) {
                    int pos = yPos | (xRes + this.wFFT - wRes) % this.wFFT << 5;
                    this.accuBuf.position(pos);
                    this.accuBuf.get(this.tileArray);
                    for (int i = 0; i < this.tileArray.length; ++i) {
                        if (whitePoint < this.tileArray[i]) {
                            whitePoint = this.tileArray[i];
                        }
                        if (!(blackPoint > this.tileArray[i])) continue;
                        blackPoint = this.tileArray[i];
                    }
                    progress.step();
                }
            }
        } else if (blackPoint < 0.0f) {
            blackPoint = 0.0f;
        }
        float scale = 1.0f / (whitePoint - blackPoint);
        int[] intArray = new int[1024];
        for (int yRes = 0; yRes < 2 * hRes; yRes += 32) {
            int yPos = (yRes + this.hFFT - hRes) % this.hFFT << this.wBits;
            for (int xRes = 0; xRes < 2 * wRes; xRes += 32) {
                int pos = yPos | (xRes + this.wFFT - wRes) % this.wFFT << 5;
                this.accuBuf.position(pos);
                this.accuBuf.get(this.tileArray);
                for (int i = 0; i < this.tileArray.length; ++i) {
                    float level = scale * (this.tileArray[i] - blackPoint);
                    if (level < 0.0f) {
                        level = 0.0f;
                    }
                    if (level > 1.0f) {
                        level = 1.0f;
                    }
                    intArray[i] = gray ? Color.HSBtoRGB(0.0f, 0.0f, level) : Color.HSBtoRGB(0.6666667f * (1.0f - level), 1.0f, 0.3f + 0.7f * level);
                }
                res.setRGB(xRes, yRes, 32, 32, intArray, 0, 32);
                if (progress == null) continue;
                progress.step();
            }
        }
        if (!fullArea) {
            res = res.getSubimage(1 + wRes - this.wImg, 1 + hRes - this.hImg, this.wImg * 2 - 1, this.hImg * 2 - 1);
        }
        if (progress != null) {
            progress.done();
        }
        return res;
    }

    public float normalize() {
        float minValue = Float.POSITIVE_INFINITY;
        int wRound = Correlator.roundUpToTileSize(this.wImg);
        int hRound = Correlator.roundUpToTileSize(this.hImg);
        for (int y1 = -hRound; y1 < this.hImg; y1 += 32) {
            int yPos = (y1 + this.hFFT) % this.hFFT << this.wBits;
            for (int x1 = -wRound; x1 < this.wImg; x1 += 32) {
                int pos = yPos | (x1 + this.wFFT) % this.wFFT << 5;
                this.accuBuf.position(pos);
                this.accuBuf.get(this.tileArray);
                int index = 0;
                for (int y2 = 0; y2 < 32; ++y2) {
                    int y = y1 + y2;
                    y = this.hImg + (y < 0 ? y : -y);
                    if (y <= 0) {
                        y = 1;
                    }
                    for (int x2 = 0; x2 < 32; ++x2) {
                        int x = x1 + x2;
                        x = this.wImg + (x < 0 ? x : -x);
                        float value = this.tileArray[index] / (float)(x * y);
                        if (x <= 0 || y <= 0) {
                            value = 0.0f;
                        } else if (minValue > value) {
                            minValue = value;
                        }
                        this.tileArray[index] = value;
                        ++index;
                    }
                }
                this.accuBuf.position(pos);
                this.accuBuf.put(this.tileArray);
            }
        }
        return minValue;
    }

    public List extractPeaks(float threshold, ProgressPhase progress) throws CanceledOperationException, RecognitionException {
        progress.begin("extracting peaks", Correlator.numTiles(this.wImg) * Correlator.numTiles(this.hImg) * 4);
        int gridBits = Math.max(this.wBits, this.hBits) - 8;
        if (gridBits < 0) {
            gridBits = 0;
        }
        if (gridBits > 5) {
            gridBits = 5;
        }
        int gridSize = 1 << gridBits;
        System.err.println("gridSize = " + gridSize);
        int wRound = Correlator.roundUpToTileSize(this.wImg);
        int hRound = Correlator.roundUpToTileSize(this.hImg);
        ArrayList<Peak> peaks = new ArrayList<Peak>();
        for (int y1 = -hRound; y1 < this.hImg; y1 += 32) {
            int yPos = (y1 + this.hFFT) % this.hFFT << this.wBits;
            for (int x1 = -wRound; x1 < this.wImg; x1 += 32) {
                int pos = yPos | (x1 + this.wFFT) % this.wFFT << 5;
                this.accuBuf.position(pos);
                this.accuBuf.get(this.tileArray);
                for (int y2 = 0; y2 < 32; y2 += gridSize) {
                    for (int x2 = 0; x2 < 32; x2 += gridSize) {
                        int pos2 = y2 << 5 | x2;
                        float maxValue = threshold;
                        int maxX = 0;
                        int maxY = 0;
                        for (int y3 = 0; y3 < gridSize; ++y3) {
                            int pos3 = pos2 | y3 << 5;
                            for (int x3 = 0; x3 < gridSize; ++x3) {
                                float value = this.tileArray[pos3 + x3];
                                if (maxValue >= value) continue;
                                maxValue = value;
                                maxX = x3;
                                maxY = y3;
                            }
                        }
                        if (maxValue == threshold) continue;
                        int px = x1 + x2 + maxX;
                        int py = y1 + y2 + maxY;
                        if (Math.abs(px) >= this.wImg || Math.abs(py) >= this.hImg) continue;
                        peaks.add(new Peak(px, py, maxValue, this.wImg, this.hImg));
                    }
                }
                progress.step();
            }
        }
        progress.done();
        return peaks;
    }

    public Peak getMaximum() {
        return this.getExtremum(1.0f);
    }

    public Peak getMinimum() {
        return this.getExtremum(-1.0f);
    }

    private Peak getExtremum(float direction) {
        float bestValue = Float.NEGATIVE_INFINITY;
        int bestX = 0;
        int bestY = 0;
        this.accuBuf.rewind();
        for (int y1 = 0; y1 < this.hFFT; y1 += 32) {
            for (int x1 = 0; x1 < this.wFFT; x1 += 32) {
                this.accuBuf.get(this.tileArray);
                for (int i = 0; i < 1024; ++i) {
                    float value = this.tileArray[i] * direction;
                    if (bestValue >= value) continue;
                    int x = x1 + (i & 0x1F);
                    int y = y1 + (i >> 5);
                    if (x >= this.wImg) {
                        x -= this.wFFT;
                    }
                    if (y >= this.hImg) {
                        y -= this.hFFT;
                    }
                    if (-x >= this.wImg || -y >= this.hImg) continue;
                    bestValue = value;
                    bestX = x;
                    bestY = y;
                }
            }
        }
        return new Peak(bestX, bestY, bestValue / direction, this.wImg, this.hImg);
    }

    public float getAcMaximum() {
        return this.accuBuf.get(0);
    }

    public int getWidth() {
        return this.wFFT;
    }

    public int getHeight() {
        return this.hFFT;
    }
}

