/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.Export;
import java.awt.BasicStroke;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class PostScriptExport
extends Export {
    public static final int TYPE_PS = 1;
    public static final int TYPE_PSGZ = 2;
    public static final int TYPE_EPS = 3;
    private static final String[] ids = new String[]{null, "ps", "ps.gz", "eps"};
    protected Writer writer;
    private int type;
    private float[] colorComps;
    private double[] matrix;
    private int[] vectors;
    private boolean base85 = true;

    public PostScriptExport(Ornament ornament, int type) {
        super(ornament, ids[type]);
        if (type < 1 || type > 3) {
            throw new IllegalArgumentException("invalid type: " + type);
        }
        this.type = type;
        this.colorComps = new float[3];
        this.matrix = new double[6];
        this.vectors = new int[4];
    }

    public String getDescription() {
        switch (this.type) {
            case 1: {
                return I18n._("export.descr.ps");
            }
            case 2: {
                return I18n._("export.descr.ps.gz");
            }
            case 3: {
                return I18n._("export.descr.eps");
            }
        }
        throw new IllegalStateException("invalid type");
    }

    protected void prepareStream() throws IOException {
        super.prepareStream();
        if (this.type == 2) {
            this.out = new GZIPOutputStream(this.out);
        }
        this.writer = new OutputStreamWriter(this.out, "ASCII");
    }

    protected void head() throws IOException {
        StringBuffer t = new StringBuffer();
        Group g = this.ornament.getGroup();
        for (int i = 0; i < g.countTransforms(); ++i) {
            if (i != 0) {
                t.append('\n');
            }
            g.getTransform(i).getMatrix(this.matrix);
            for (int j = 0; j < 6; ++j) {
                if (j != 0) {
                    t.append(' ');
                }
                t.append(this.matrix[j]);
            }
        }
        StringBuffer v = new StringBuffer();
        this.ornament.getVectors(this.vectors);
        v.append(this.vectors[0]).append(' ').append(-this.vectors[1]).append(' ').append(this.vectors[2]).append(' ').append(-this.vectors[3]).append(" 0 H");
        StringBuffer bg = new StringBuffer();
        this.ornament.getBackgroundColor().getRGBColorComponents(this.colorComps);
        bg.append(this.colorComps[0]).append(' ').append(this.colorComps[1]).append(' ').append(this.colorComps[2]);
        Object[] args = new Object[]{new Integer(this.type), new Integer(595), new Integer(842), t.toString(), v.toString(), bg.toString(), Ornament.getDescription(), new Date()};
        this.writer.write(MessageFormat.format(this.loadString("head"), args));
    }

    protected void tail() throws IOException {
        this.writer.write(this.loadString("foot"));
        this.writer.close();
    }

    protected void color(Color c) throws IOException {
        c.getRGBColorComponents(this.colorComps);
        this.printPlain(this.colorComps[0]);
        this.writer.write(32);
        this.printPlain(this.colorComps[1]);
        this.writer.write(32);
        this.printPlain(this.colorComps[2]);
        this.writer.write(" setrgbcolor\n");
    }

    protected void stroke(BasicStroke s) throws IOException {
        this.printPlain(s.getLineWidth());
        this.writer.write(" setlinewidth\n");
    }

    protected void coords(float[] c) throws IOException {
        int count;
        int i;
        float maxy;
        float maxx;
        float minx = maxx = c[0];
        float miny = maxy = c[1];
        for (i = 2; i < c.length; i += 2) {
            if (minx > c[i]) {
                minx = c[i];
            }
            if (maxx < c[i]) {
                maxx = c[i];
            }
            if (miny > c[i + 1]) {
                miny = c[i + 1];
            }
            if (!(maxy < c[i + 1])) continue;
            maxy = c[i + 1];
        }
        this.writer.write("{ ");
        if (this.base85) {
            this.writer.write("<~");
            this.printBase85(0x95300000 | c.length + 4);
        } else {
            this.writer.write("{\n");
        }
        this.print(minx);
        this.print(miny);
        this.print(maxx);
        this.print(maxy);
        this.print(c[0]);
        this.print(c[1]);
        for (i = 2; i < c.length; ++i) {
            if (i % 16 == 2) {
                this.writer.write(10);
            }
            this.print(c[i] - c[i - 2]);
        }
        if (this.base85) {
            this.writer.write("\n~>");
        } else {
            this.writer.write("\n}");
        }
        this.writer.write(" <0B0001");
        for (count = c.length / 2 - 1; count > 223; count -= 223) {
            this.writer.write("FF04");
        }
        this.printHexDigit((count += 32) / 16);
        this.printHexDigit(count % 16);
        this.writer.write("04> } L\n");
    }

    private void print(float f) throws IOException {
        if (this.base85) {
            this.printBase85(f);
        } else {
            this.printPlain(f);
        }
    }

    private void printPlain(float f) throws IOException {
        this.writer.write(Float.toString(f));
    }

    private void printBase85(int value) throws IOException {
        if (value == 0) {
            this.writer.write(122);
            return;
        }
        long v = (long)value & 0xFFFFFFFFL;
        for (int i = 52200625; i >= 1; i /= 85) {
            this.writer.write((int)(33L + v / (long)i % 85L));
        }
    }

    private void printBase85(float value) throws IOException {
        this.printBase85(Float.floatToIntBits(value));
    }

    private void printHexDigit(int digit) throws IOException {
        if (digit < 0 || digit >= 16) {
            throw new IllegalArgumentException();
        }
        if (digit < 10) {
            this.writer.write(digit + 48);
        } else {
            this.writer.write(digit + 55);
        }
    }
}

