/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.OutlineExport;
import de.tum.in.gagern.pdf.PdfCatalog;
import de.tum.in.gagern.pdf.PdfObject;
import de.tum.in.gagern.pdf.PdfOutputStream;
import de.tum.in.gagern.pdf.PdfPage;
import de.tum.in.gagern.pdf.PdfStream;
import de.tum.in.gagern.pdf.PdfWriter;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;
import java.text.MessageFormat;

public class PdfExport
extends OutlineExport {
    private int precision;
    private AffineTransform at;
    private PdfWriter pdfWriter;
    private PdfOutputStream patternStream;

    public PdfExport(Ornament ornament) {
        super(ornament, "pdf");
    }

    public String getDescription() {
        return I18n._("export.descr.pdf");
    }

    protected void prepareStream() throws IOException {
        this.pdfWriter = new PdfWriter();
    }

    protected void head() throws IOException {
        int i;
        int width = 640;
        int height = 480;
        int[] vec = new int[4];
        this.ornament.getVectors(vec);
        StringBuffer v = new StringBuffer("[");
        int maxDimen = Math.abs(vec[0]);
        for (i = 1; i != 4; ++i) {
            maxDimen = Math.max(maxDimen, Math.abs(vec[i]));
        }
        maxDimen *= 64;
        this.precision = 1;
        while (this.precision < maxDimen) {
            this.precision <<= 1;
        }
        this.at = AffineTransform.getScaleInstance(this.precision, this.precision);
        for (i = 0; i != 4; ++i) {
            double vi = vec[i];
            if ((i & 1) == 1) {
                vi = -vi;
            }
            v.append(vi / (double)this.precision).append(' ');
        }
        v.append("0 " + height + "]");
        String bbox = MessageFormat.format("[0 0 {0} {0}]", Integer.toString(this.precision));
        PdfObject metaData = new PdfObject(this.pdfWriter);
        metaData.put("Creator", "(" + Ornament.getDescription() + ")");
        metaData.put("Producer", "(" + Ornament.getDescription() + ")");
        metaData.put("CreationDate", PdfWriter.currentDate());
        this.pdfWriter.getTrailer().put("Info", metaData);
        PdfCatalog catalog = this.pdfWriter.getCatalog();
        catalog.put("PageLayout", "/SinglePage");
        catalog.put("PageMode", "/UseNone");
        PdfStream pattern = new PdfStream(this.pdfWriter);
        pattern.put("Type", "/Pattern");
        pattern.put("PatternType", 1);
        pattern.put("PaintType", 1);
        pattern.put("TilingType", 3);
        pattern.put("BBox", bbox);
        pattern.put("XStep", this.precision);
        pattern.put("YStep", this.precision);
        pattern.put("Matrix", v.toString());
        pattern.put("Resources", "<< /ProcSet [ /PDF ] >>");
        PdfPage page = this.pdfWriter.createPage();
        page.put("MediaBox", "[0 0 " + width + " " + height + "]");
        PdfObject resources = page.getObject("Resources", true);
        resources.getObject("Pattern", true).put("Ornament", (PdfObject)pattern);
        resources.put("ProcSet", "[ /PDF ]");
        PdfStream pageContent = page.createContentStream();
        pageContent.remove("Filter");
        PdfOutputStream pageStream = pageContent.createOutputStream();
        pageStream.setFillColor(this.ornament.getBackgroundColor());
        pageStream.fillRect(0.0, 0.0, (double)width, (double)height);
        pageStream.print("/Pattern cs\n/Ornament scn\n");
        pageStream.fillRect(0.0, 0.0, (double)width, (double)height);
        pageStream.close();
        this.patternStream = pattern.createOutputStream();
    }

    protected void area(Area area, Color color) throws IOException {
        this.patternStream.setFillColor(color);
        this.patternStream.fill(area.getPathIterator(this.at));
    }

    protected void tail() throws IOException {
        this.patternStream.close();
        this.pdfWriter.writeToStream(this.out);
    }
}

