/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.LinPath;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.Export;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public abstract class OutlineExport
extends Export {
    private Area area;
    private AffineTransform[] transforms;
    private AffineTransform inverseTransform;
    private static final double clipSlack = 0.125;
    private static final Area clipRect = new Area(new Rectangle2D.Double(-0.125, -0.125, 1.25, 1.25));

    protected OutlineExport(Ornament ornament, String id) {
        super(ornament, id);
    }

    protected void init() throws NoninvertibleTransformException {
        super.init();
        this.area = new Area();
        int[] iVec = new int[4];
        this.ornament.getVectors(iVec);
        double[] dVec = new double[6];
        for (int i = 0; i != 4; ++i) {
            dVec[i] = iVec[i];
        }
        AffineTransform aVec = new AffineTransform(dVec);
        this.inverseTransform = aVec.createInverse();
        Group g = this.ornament.getGroup();
        this.transforms = new AffineTransform[g.countTransforms()];
        for (int i = 0; i < this.transforms.length; ++i) {
            this.transforms[i] = new AffineTransform(aVec);
            this.transforms[i].concatenate(g.getTransform(i));
        }
    }

    private void prepareArea() throws IOException {
        if (this.area.isEmpty()) {
            return;
        }
        this.area.intersect(clipRect);
        this.area(this.area, this.color);
        this.area.reset();
    }

    protected void postBody() throws IOException {
        this.prepareArea();
        super.postBody();
    }

    protected void color(Color c) throws IOException {
        this.prepareArea();
        super.color(c);
    }

    protected abstract void area(Area var1, Color var2) throws IOException;

    protected void path(LinPath l) throws IOException, NoninvertibleTransformException {
        super.path(l);
        GeneralPath gp1 = this.asGeneralPath(l.getShape());
        for (int i = 0; i != this.transforms.length; ++i) {
            Shape s = gp1.createTransformedShape(this.transforms[i]);
            GeneralPath gp2 = this.asGeneralPath(this.stroke.createStrokedShape(s));
            gp2.transform(this.inverseTransform);
            Area a = new Area(gp2);
            Rectangle2D bounds = a.getBounds2D();
            int x1 = (int)Math.floor(bounds.getMinX());
            int y1 = (int)Math.floor(bounds.getMinY());
            int x2 = (int)Math.ceil(bounds.getMaxX());
            int y2 = (int)Math.ceil(bounds.getMaxY());
            AffineTransform t = new AffineTransform();
            for (int x = x1; x < x2; ++x) {
                for (int y = y1; y < y2; ++y) {
                    t.setToTranslation(-x, -y);
                    this.area.add(a.createTransformedArea(t));
                }
            }
        }
    }

    private GeneralPath asGeneralPath(Shape s) {
        if (s instanceof GeneralPath) {
            return (GeneralPath)s;
        }
        return new GeneralPath(s);
    }
}

