/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Keyboard;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.Export;
import de.tum.in.gagern.ornament.export.ExportMechanism;
import java.awt.geom.NoninvertibleTransformException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.swing.JOptionPane;

public class MailExportMechanism
extends ExportMechanism {
    private static String[] mailProperties = new String[]{"mail.debug", "mail.from", "mail.mime.address.strict", "mail.host", "mail.transport.protocol", "mail.user", "mail.smtp.class", "mail.smtp.host", "mail.smtp.port", "mail.smtp.user", "mail.smtp.localhost", "mail.subject"};

    public MailExportMechanism(Ornament main) {
        super(main);
    }

    public void export() {
        Export export = this.chooseExport();
        if (export == null) {
            return;
        }
        if (!export.configure()) {
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            export.export(os);
            byte[] data = os.toByteArray();
            String to = Keyboard.getInput(this.main, I18n._("Email Address"));
            if (to == null) {
                return;
            }
            this.sendMail(to, export, data);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Export"), 0);
        }
        catch (NoninvertibleTransformException ex) {
            JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Export"), 0);
        }
        catch (MessagingException ex) {
            JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Send"), 0);
        }
    }

    private Export chooseExport() {
        return (Export)JOptionPane.showInputDialog(this.main, I18n._("Choose file format"), I18n._("Export"), 3, null, this.exports, this.exports[0]);
    }

    private void sendMail(String to, Export export, byte[] data) throws MessagingException {
        Properties properties = new Properties(System.getProperties());
        for (int i = 0; i != mailProperties.length; ++i) {
            String value = this.main.getParameter(mailProperties[i]);
            if (value == null) continue;
            properties.setProperty(mailProperties[i], value);
        }
        Session session = Session.getInstance((Properties)properties);
        MimeMessage msg = new MimeMessage(session);
        InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])address);
        MimeBodyPart mbp1 = new MimeBodyPart();
        mbp1.setText(I18n._("mail.body"));
        MimeBodyPart mbp2 = new MimeBodyPart();
        String mimeType = "application/octet-stream";
        ByteArrayDataSource ds = new ByteArrayDataSource(data, mimeType);
        mbp2.setDataHandler(new DataHandler((DataSource)ds));
        mbp2.setFileName("ornament." + export.getExtensions()[0]);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)mbp1);
        mp.addBodyPart((BodyPart)mbp2);
        msg.setContent((Multipart)mp);
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
    }
}

