/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.LinPath;
import de.tum.in.gagern.ornament.LoopBounds;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.Export;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class BitmapExport
extends Export {
    private boolean hasAlpha;
    private String format;
    private String description;
    private AffineTransform vectorTransform;
    private LoopBounds bounds;
    private BufferedImage img;
    private Graphics2D g2d;

    public BitmapExport(Ornament ornament, String format, boolean hasAlpha, String description) {
        this(ornament, format, new String[]{format}, hasAlpha, description);
    }

    public BitmapExport(Ornament ornament, String format, String[] extensions, boolean hasAlpha, String description) {
        super(ornament, format);
        this.format = format;
        this.hasAlpha = hasAlpha;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    private Collection getClosestPoints(int ax, int ay, int bx, int by, int maxLengthSq) {
        if (ax < 0) {
            ax = -ax;
            ay = -ay;
        }
        if (bx < 0) {
            bx = -bx;
            by = -by;
        }
        if (ax < bx) {
            int tmp = ax;
            ax = bx;
            bx = tmp;
            tmp = ay;
            ay = by;
            by = tmp;
        }
        HashSet<Point> set = new HashSet<Point>();
        int a = 1;
        while (true) {
            boolean s2;
            boolean s1;
            int b = (int)Math.floor((double)(-a * ay) / (double)by);
            int x1 = a * ax + b * bx;
            int y1 = a * ay + b * by;
            if (x1 < 0) {
                x1 = -x1;
                y1 = -y1;
            }
            boolean bl = s1 = x1 * x1 + y1 * y1 <= maxLengthSq;
            if (s1) {
                set.add(new Point(x1, y1));
            }
            int x2 = a * ax + ++b * bx;
            int y2 = a * ay + b * by;
            if (x2 < 0) {
                x2 = -x2;
                y2 = -y2;
            }
            boolean bl2 = s2 = x2 * x2 + y2 * y2 <= maxLengthSq;
            if (s2) {
                set.add(new Point(x2, y2));
            }
            if (!s1 && !s2) break;
            ++a;
        }
        return set;
    }

    protected void init() throws NoninvertibleTransformException {
        super.init();
        int[] vec = new int[4];
        this.ornament.getVectors(vec);
        int ax0 = vec[0];
        int ay0 = vec[1];
        int bx0 = vec[2];
        int by0 = vec[3];
        int det0 = ax0 * by0 - ay0 * bx0;
        int area = Math.abs(det0);
        int maxLengthSq = 144 * area;
        Collection xPoints = this.getClosestPoints(ax0, ay0, bx0, by0, maxLengthSq);
        Collection yPoints = this.getClosestPoints(ay0, ax0, by0, bx0, maxLengthSq);
        int xx = 0;
        int xy = 0;
        int yx = 0;
        int yy = 0;
        double minBadness = Double.POSITIVE_INFINITY;
        Iterator xi = xPoints.iterator();
        while (xi.hasNext()) {
            Point xp = (Point)xi.next();
            Iterator yi = yPoints.iterator();
            while (yi.hasNext()) {
                Point yp = (Point)yi.next();
                double cos2 = xp.x * yp.y + xp.y * yp.x;
                cos2 *= cos2;
                cos2 /= (double)(xp.x * xp.x + xp.y * xp.y);
                double badness = 0.0;
                badness += 1000.0 * (cos2 /= (double)(yp.x * yp.x + yp.y * yp.y));
                badness += (double)(Math.abs(xp.y) + Math.abs(yp.y));
                if ((badness += 1.0E-4 * (double)xp.x * (double)yp.x) >= minBadness) continue;
                System.err.println("x=" + xp.x + "/" + xp.y + ", y=" + yp.y + "/" + yp.x + ", cos2=" + cos2 + ", xy=" + xp.y + ", yx=" + yp.y + ", area=" + xp.x * yp.x + ", badness=" + badness);
                minBadness = badness;
                xx = xp.x;
                xy = xp.y;
                yx = yp.y;
                yy = yp.x;
            }
        }
        int xa = (xx * by0 - bx0 * xy) / det0;
        int xb = (ax0 * xy - xx * ay0) / det0;
        int ya = (yx * by0 - bx0 * yy) / det0;
        int yb = (ax0 * yy - yx * ay0) / det0;
        double det1 = xa * yb - xb * ya;
        double ax1 = (double)xx / det1 * (double)yb;
        double ay1 = (double)(-yy) / det1 * (double)xb;
        double bx1 = (double)(-xx) / det1 * (double)ya;
        double by1 = (double)yy / det1 * (double)xa;
        System.err.println("Shifting from " + ax0 + "/" + ay0 + ", " + bx0 + "/" + by0 + " to " + ax1 + "/" + ay1 + ", " + bx1 + "/" + by1 + " and area " + xx + "/" + yy);
        this.vectorTransform = new AffineTransform(ax1, ay1, bx1, by1, 0.0, 0.0);
        int imgType = this.hasAlpha ? 2 : 1;
        this.img = new BufferedImage(xx, yy, imgType);
        this.g2d = this.img.createGraphics();
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.g2d.setRenderingHints(renderingHints);
        this.bounds = new LoopBounds(this.vectorTransform);
        this.bounds.boundsFor(0.0, 0.0, this.img.getWidth(), this.img.getHeight());
    }

    protected void background(BufferedImage img) throws IOException {
        int na = this.bounds.getMaxA() - this.bounds.getMinA() + 1;
        int nb = this.bounds.getMaxB() - this.bounds.getMinB() + 1;
        BufferedImage multi = Ornament.tileImage(img, na, nb);
        AffineTransform tempTrans = new AffineTransform(this.vectorTransform);
        tempTrans.translate(this.bounds.getMinA(), this.bounds.getMinB());
        tempTrans.scale(1.0 / (double)img.getWidth(), 1.0 / (double)img.getHeight());
        this.g2d.drawImage(multi, tempTrans, null);
    }

    protected void tail() throws IOException {
        this.g2d.dispose();
        ImageIO.write((RenderedImage)this.img, this.format, this.out);
    }

    protected void path(LinPath l) throws NoninvertibleTransformException {
        Group group = this.ornament.getGroup();
        GeneralPath tempPath = new GeneralPath();
        AffineTransform tempTrans = new AffineTransform();
        for (int i = 0; i < group.countTransforms(); ++i) {
            tempPath.reset();
            tempPath.append(l.getPathIterator(group.getTransform(i)), false);
            Rectangle2D bb = tempPath.getBounds2D();
            int minA = this.bounds.getMinA() - (int)Math.ceil(bb.getMaxX());
            int maxA = this.bounds.getMaxA() - (int)Math.floor(bb.getMinX());
            int minB = this.bounds.getMinB() - (int)Math.ceil(bb.getMaxY());
            int maxB = this.bounds.getMaxB() - (int)Math.floor(bb.getMinY());
            for (int da = minA; da <= maxA; ++da) {
                for (int db = minB; db <= maxB; ++db) {
                    tempTrans.setTransform(this.vectorTransform);
                    tempTrans.translate(da, db);
                    this.g2d.draw(tempPath.createTransformedShape(tempTrans));
                }
            }
        }
    }

    protected void color(Color c) {
        this.g2d.setColor(c);
    }

    protected void stroke(BasicStroke s) {
        this.g2d.setStroke(s);
    }
}

