/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public abstract class Property {
    protected int tc;

    protected Property(int tc) {
        this.tc = tc;
    }

    public int getTC() {
        return this.tc;
    }

    public abstract void paint(Graphics2D var1, AffineTransform var2);

    public static class Glide
    extends Line {
        static final BasicStroke STROKE = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 10.0f}, 0.0f);

        public Glide(double a1, double b1, double a2, double b2) {
            this(a1, b1, a2, b2, 0);
        }

        public Glide(double a1, double b1, double a2, double b2, int tc) {
            super(a1, b1, a2, b2, tc);
        }

        public void paint(Graphics2D g, Line2D line) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(STROKE);
            g.draw(line);
            g.setStroke(oldStroke);
        }
    }

    public static class Mirror
    extends Line {
        public Mirror(double a1, double b1, double a2, double b2) {
            this(a1, b1, a2, b2, 0);
        }

        public Mirror(double a1, double b1, double a2, double b2, int tc) {
            super(a1, b1, a2, b2, tc);
        }

        public void paint(Graphics2D g, Line2D line) {
            g.draw(line);
        }
    }

    private static abstract class Line
    extends Property {
        Point2D ab1;
        Point2D ab2;
        Point2D xy1;
        Point2D xy2;
        Line2D line;

        Line(double a1, double b1, double a2, double b2, int tc) {
            super(tc);
            this.ab1 = new Point2D.Double(a1, b1);
            this.ab2 = new Point2D.Double(a2, b2);
            this.xy1 = new Point2D.Double();
            this.xy2 = new Point2D.Double();
            this.line = new Line2D.Double();
        }

        public void paint(Graphics2D g, AffineTransform t) {
            t.transform(this.ab1, this.xy1);
            t.transform(this.ab2, this.xy2);
            this.line.setLine(this.xy1, this.xy2);
            this.paint(g, this.line);
        }

        public abstract void paint(Graphics2D var1, Line2D var2);
    }

    public static class Turn6
    extends Point {
        public Turn6(double a, double b) {
            this(a, b, 0);
        }

        public Turn6(double a, double b, int tc) {
            super(a, b, tc);
        }

        public void paint(Graphics2D g, int x, int y) {
            g.fillRect(x - 4, y - 4, 9, 9);
        }
    }

    public static class Turn4
    extends Point {
        public Turn4(double a, double b) {
            this(a, b, 0);
        }

        public Turn4(double a, double b, int tc) {
            super(a, b, tc);
        }

        public void paint(Graphics2D g, int x, int y) {
            g.drawRect(x - 4, y - 4, 8, 8);
        }
    }

    public static class Turn3
    extends Point {
        public Turn3(double a, double b) {
            this(a, b, 0);
        }

        public Turn3(double a, double b, int tc) {
            super(a, b, tc);
        }

        public void paint(Graphics2D g, int x, int y) {
            g.fillOval(x - 4, y - 4, 9, 9);
        }
    }

    public static class Turn2
    extends Point {
        public Turn2(double a, double b) {
            this(a, b, 0);
        }

        public Turn2(double a, double b, int tc) {
            super(a, b, tc);
        }

        public void paint(Graphics2D g, int x, int y) {
            g.drawOval(x - 4, y - 4, 8, 8);
        }
    }

    private static abstract class Point
    extends Property {
        static final int SYMB_SIZE = 4;
        Point2D ab;
        Point2D xy;

        Point(double a, double b, int tc) {
            super(tc);
            this.ab = new Point2D.Double(a, b);
            this.xy = new Point2D.Double();
        }

        public void paint(Graphics2D g, AffineTransform t) {
            t.transform(this.ab, this.xy);
            this.paint(g, (int)Math.round(this.xy.getX()), (int)Math.round(this.xy.getY()));
        }

        public abstract void paint(Graphics2D var1, int var2, int var3);
    }
}

