/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.Ornament;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

class PlaneView
extends JPanel
implements MouseInputListener {
    private Ornament main;
    private int mina;
    private int maxa;
    private int minb;
    private int maxb;
    private boolean painting;
    private float[] buf;
    private int bufpos;

    public PlaneView(Ornament ornament) {
        this.main = ornament;
        this.buf = new float[512];
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPreferredSize(new Dimension(600, 600));
        this.setDoubleBuffered(false);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PlaneView.this.recalcTiling();
            }
        });
    }

    void recalcTiling() {
        Dimension size = this.getSize();
        if (size == null) {
            return;
        }
        this.maxb = 0;
        this.minb = 0;
        this.maxa = 0;
        this.mina = 0;
        this.expandTilingToPoint(size.width, 0);
        this.expandTilingToPoint(size.width, size.height);
        this.expandTilingToPoint(0, size.height);
        this.repaint();
    }

    private void expandTilingToPoint(int x, int y) {
        double a = this.main.aFromPoint(x, y);
        double b = this.main.bFromPoint(x, y);
        if (a < (double)this.mina) {
            this.mina = (int)Math.floor(a);
        }
        if (a > (double)this.maxa) {
            this.maxa = (int)Math.ceil(a);
        }
        if (b < (double)this.minb) {
            this.minb = (int)Math.floor(b);
        }
        if (b > (double)this.maxb) {
            this.maxb = (int)Math.ceil(b);
        }
    }

    public void paint(Graphics g) {
        Image buf = this.main.getBuffer();
        for (int a = this.mina; a <= this.maxa; ++a) {
            for (int b = this.minb; b <= this.maxb; ++b) {
                int x = this.main.ax * a + this.main.bx * b;
                int y = this.main.ay * a + this.main.by * b;
                if (!g.hitClip(x, y, this.main.width, this.main.height)) continue;
                g.drawImage(buf, x, y, this);
            }
        }
    }

    public void mouseClicked(MouseEvent evnt) {
    }

    public void mousePressed(MouseEvent evnt) {
        this.painting = true;
        this.buf[0] = (float)this.main.aFromPoint(evnt.getX(), evnt.getY());
        this.buf[1] = (float)this.main.bFromPoint(evnt.getX(), evnt.getY());
        this.bufpos = 2;
        this.main.drawLine(this.buf[0], this.buf[1], this.buf[0], this.buf[1]);
    }

    public void mouseReleased(MouseEvent evnt) {
        if (this.bufpos == 2) {
            this.buf[2] = this.buf[0];
            this.buf[3] = this.buf[1];
            this.bufpos += 2;
        }
        float[] coords = new float[this.bufpos];
        System.arraycopy(this.buf, 0, coords, 0, this.bufpos);
        this.main.addLine(coords);
        this.painting = false;
    }

    public void mouseEntered(MouseEvent evnt) {
    }

    public void mouseExited(MouseEvent evnt) {
    }

    public void mouseDragged(MouseEvent evnt) {
        if (!this.painting) {
            return;
        }
        if (this.bufpos == this.buf.length) {
            float[] coords = new float[this.bufpos * 2];
            System.arraycopy(this.buf, 0, coords, 0, this.bufpos);
            this.buf = coords;
        }
        this.buf[this.bufpos] = (float)this.main.aFromPoint(evnt.getX(), evnt.getY());
        this.buf[this.bufpos + 1] = (float)this.main.bFromPoint(evnt.getX(), evnt.getY());
        this.main.drawLine(this.buf[this.bufpos - 2], this.buf[this.bufpos - 1], this.buf[this.bufpos], this.buf[this.bufpos + 1]);
        this.bufpos += 2;
    }

    public void mouseMoved(MouseEvent evnt) {
    }
}

