/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.ExportMechanism;
import de.tum.in.gagern.ornament.export.FileExportMechanism;
import de.tum.in.gagern.ornament.export.MailExportMechanism;
import de.tum.in.gagern.ornament.export.ServiceExportMechanism;
import java.awt.event.ActionEvent;
import java.security.AccessControlException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

class ExportAction
extends AbstractAction {
    private Ornament main;
    private ExportMechanism fileExportMechanism;
    private ExportMechanism serviceExportMechanism;
    private ExportMechanism mailExportMechanism;

    public ExportAction(Ornament main) {
        super(I18n.dots(I18n._("Export")));
        this.main = main;
    }

    public void actionPerformed(ActionEvent evnt) {
        try {
            this.export();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.main, e.toString(), I18n._("Export"), 0);
        }
    }

    private void export() {
        String param;
        try {
            param = this.main.getParameter("ornament.export.mechanism");
        }
        catch (Exception e) {
            param = null;
        }
        if ("mail".equals(param)) {
            MailExportMechanism exp;
            if (this.mailExportMechanism == null && (exp = new MailExportMechanism(this.main)).init()) {
                this.mailExportMechanism = exp;
            }
            if (this.mailExportMechanism != null) {
                this.mailExportMechanism.export();
            }
            return;
        }
        try {
            FileExportMechanism exp;
            if (this.fileExportMechanism == null && ((ExportMechanism)(exp = new FileExportMechanism(this.main))).init()) {
                this.fileExportMechanism = exp;
            }
            if (this.fileExportMechanism != null) {
                this.fileExportMechanism.export();
            }
        }
        catch (AccessControlException e1) {
            try {
                ServiceExportMechanism exp;
                if (this.serviceExportMechanism == null && ((ExportMechanism)(exp = new ServiceExportMechanism(this.main, e1))).init()) {
                    this.serviceExportMechanism = exp;
                }
                if (this.serviceExportMechanism != null) {
                    this.serviceExportMechanism.export();
                }
            }
            catch (LinkageError e2) {
                Object[] args = new Object[]{e1.getLocalizedMessage(), e2.getLocalizedMessage(), e1.toString(), e2.toString()};
                JOptionPane.showMessageDialog(this.main, I18n._("Access denied", args), I18n._("Export"), 0);
            }
        }
    }
}

