/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.AboutDlg;
import de.tum.in.gagern.ornament.ColorButton;
import de.tum.in.gagern.ornament.ColorChooser;
import de.tum.in.gagern.ornament.ColorDlg;
import de.tum.in.gagern.ornament.Constants;
import de.tum.in.gagern.ornament.Documentation;
import de.tum.in.gagern.ornament.ExportAction;
import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.GroupButton;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.KioskMode;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.RecogAction;
import de.tum.in.gagern.ornament.StrokeButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;

class Controls
extends JPanel
implements Constants {
    Ornament main;
    ButtonGroup bgGroup;
    ButtonGroup bgColor;
    ButtonGroup bgStroke;
    AbstractButton customColor;
    GroupButton[] grpButtons;
    ColorButton[] clrButtons;
    ColorChooser colorChooser;
    private Action bgImgAction;
    private AbstractButton bgImgItem;
    static final Insets buttonMargin = new Insets(-2, 0, 1, 0);
    static final Insets zeroMargin = new Insets(0, 0, 0, 0);
    static final Font buttonFont = new Font("Dialog", 0, 10);
    static final int[] colors = new int[]{0, 0x404040, 0x808080, 0xC0C0C0, 0xFFFFFF, 0x808000, 32768, 65280, 65408, 0xFFFF00, 0x800080, 128, 255, 33023, 65535, 0x800000, 0xFF00FF, 0xFF0080, 0xFF0000, 0xFF8000};
    static final int[] strokeWidths = new int[]{1, 2, 5, 8, 12};

    Controls(Ornament ornament) {
        AbstractButton btn;
        int i;
        this.main = ornament;
        this.colorChooser = new ColorChooser();
        this.colorChooser.setChosenColor(this.main.colors[0]);
        this.colorChooser.setBackground(this.main.colors[1]);
        this.colorChooser.addPropertyChangeListener("chosenColor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evnt) {
                Controls.this.main.setColor((Color)evnt.getNewValue());
            }
        });
        this.setLayout(new GridLayout(0, 5));
        Group[] grps = Group.getGroups();
        this.grpButtons = new GroupButton[grps.length];
        this.clrButtons = new ColorButton[colors.length];
        this.bgGroup = new ButtonGroup();
        for (i = 0; i < grps.length; ++i) {
            this.grpButtons[i] = new GroupButton(this.main, grps[i]);
            btn = this.grpButtons[i];
            this.bgGroup.add(btn);
            if (i == 10) {
                btn.doClick();
            }
            this.format(btn);
            this.add(btn);
        }
        this.add(new JLabel());
        btn = new JButton(I18n._("btn.UNDO"));
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                List l = Controls.this.main.lines;
                if (l.isEmpty()) {
                    return;
                }
                l.remove(l.size() - 1);
                Controls.this.main.repaintBuffer();
            }
        });
        this.format(btn);
        this.add(btn);
        btn = new JButton(I18n._("btn.CLEAR"));
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Controls.this.main.clearLines();
            }
        });
        this.format(btn);
        this.add(btn);
        this.bgColor = new ButtonGroup();
        for (i = 0; i < colors.length; ++i) {
            this.clrButtons[i] = new ColorButton(this.main, 40, 20, new Color(colors[i]));
            btn = this.clrButtons[i];
            this.bgColor.add(btn);
            btn.setMargin(zeroMargin);
            this.add(btn);
            if (i != 4) continue;
            btn.doClick();
        }
        this.customColor = new JRadioButton("custom color");
        this.bgColor.add(this.customColor);
        this.bgStroke = new ButtonGroup();
        for (i = 0; i < strokeWidths.length; ++i) {
            btn = new StrokeButton(this.main, strokeWidths[i]);
            this.bgStroke.add(btn);
            btn.setMargin(zeroMargin);
            this.add(btn);
            if (i != 1) continue;
            btn.doClick();
        }
    }

    void format(AbstractButton btn) {
        btn.setMargin(buttonMargin);
        btn.setFont(buttonFont);
    }

    JMenuBar createMenu() {
        JMenuBar bar = new JMenuBar();
        JMenu m = new JMenu(I18n._("File"));
        if (this.main.kioskMode == null) {
            bar.add(m);
        }
        m.add(new JMenuItem(new ExportAction(this.main)));
        m.add(new JMenuItem(new RecogAction(this.main)));
        if (this.main.window != null) {
            m.add(new JMenuItem(new AbstractAction(I18n.dots(I18n._("file.Kiosk"))){
                KioskMode kioskMode;

                public void actionPerformed(ActionEvent e) {
                    if (this.kioskMode == null) {
                        this.kioskMode = new KioskMode(Controls.this.main, Controls.this);
                    }
                    this.kioskMode.configure();
                }
            }));
        }
        m = new JMenu(I18n._("Grid"));
        bar.add(m);
        Action[] grids = new Action[]{new GridMode(1, I18n._("Tile")), new GridMode(2, I18n._("Cell")), new GridMode(4, I18n._("Properties")), new GridMode(8, I18n._("Buffer"))};
        for (int i = 0; i < grids.length; ++i) {
            m.add(new JCheckBoxMenuItem(grids[i]));
        }
        m = new JMenu(I18n._("Settings"));
        bar.add(m);
        JMenuItem itm = new JMenuItem(new AbstractAction(I18n.dots(I18n._("setting.Colors"))){
            ColorDlg cdlg;

            public void actionPerformed(ActionEvent e) {
                if (this.cdlg == null) {
                    this.cdlg = new ColorDlg(Controls.this.main, Controls.this);
                }
                this.cdlg.show();
            }
        });
        if (this.main.kioskMode == null) {
            m.add(itm);
        }
        JMenu m2 = new JMenu(I18n._("Naming"));
        m.add(m2);
        ButtonGroup bgrp = new ButtonGroup();
        Action[] namings = new Action[]{new NamingSystem(1, I18n._("Crystallographic")), new NamingSystem(3, I18n._("Orbifold")), new NamingSystem(2, I18n._("Orbifold (ASCII)"))};
        for (int i = 0; i < namings.length; ++i) {
            itm = new JRadioButtonMenuItem(namings[i]);
            bgrp.add(itm);
            m2.add(itm);
            if (i != 0) continue;
            itm.setSelected(true);
        }
        itm = new JCheckBoxMenuItem(new AbstractAction(I18n._("settings.Antialias")){

            public void actionPerformed(ActionEvent e) {
                boolean aa = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.setAntiAlias(aa);
            }
        });
        itm.setSelected(true);
        m.add(itm);
        m.add(new JCheckBoxMenuItem(new AbstractAction(I18n._("setting.Ignore Line Widths")){

            public void actionPerformed(ActionEvent e) {
                Controls.this.main.useStrokes = !((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.repaintBuffer();
            }
        }));
        m.add(new JCheckBoxMenuItem(new AbstractAction(I18n._("setting.Grid On Top")){

            public void actionPerformed(ActionEvent e) {
                Controls.this.main.gridOnTop = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.repaintBuffer();
            }
        }));
        m.add(new JCheckBoxMenuItem(new AbstractAction(I18n._("setting.Shaded Tiles")){

            public void actionPerformed(ActionEvent e) {
                Controls.this.main.tv.shadeMode = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.tv.recalcTiling();
                Controls.this.main.tv.repaint();
            }
        }));
        this.bgImgAction = new AbstractAction(I18n._("settings.Background")){

            public void actionPerformed(ActionEvent e) {
                boolean on = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.showBackground(on);
            }
        };
        this.bgImgItem = new JCheckBoxMenuItem(this.bgImgAction);
        this.hasBackground(false);
        m.add(this.bgImgItem);
        m = new JMenu(I18n._("Help"));
        if (this.main.kioskMode == null) {
            bar.add(m);
        }
        m.add(new JMenuItem(new AbstractAction(I18n._("help.Manual")){
            Documentation doc;

            public void actionPerformed(ActionEvent e) {
                if (this.doc == null) {
                    String path = I18n._("help.Manual.path");
                    this.doc = new Documentation(Controls.this.main, path);
                } else {
                    this.doc.show();
                }
            }
        }));
        m.add(new JMenuItem(new AbstractAction(I18n._("help.About")){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Controls.this.main, new AboutDlg(), I18n._("about.title"), -1);
            }
        }));
        return bar;
    }

    public void setGroup(Group group) {
        for (int i = 0; i < this.grpButtons.length; ++i) {
            GroupButton b = this.grpButtons[i];
            Group g = b.getSymmetryGroup();
            if (!g.equals(group)) continue;
            b.doClick();
            return;
        }
    }

    void setColor(Color color) {
        this.colorChooser.setChosenColor(color);
        for (int i = 0; i < this.clrButtons.length; ++i) {
            ColorButton b = this.clrButtons[i];
            if (!b.c.equals(color)) continue;
            b.doClick();
            return;
        }
        this.customColor.doClick();
    }

    void setBackgroundColor(Color color) {
        this.colorChooser.setBackground(color);
    }

    public void hasBackground(boolean hasBackground) {
        if (this.bgImgAction == null) {
            return;
        }
        this.bgImgAction.setEnabled(hasBackground);
        this.bgImgItem.setSelected(hasBackground);
    }

    class NamingSystem
    extends AbstractAction {
        final int namingSystem;

        NamingSystem(int code, String str) {
            super(str);
            this.namingSystem = code;
        }

        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < Controls.this.grpButtons.length; ++i) {
                Controls.this.grpButtons[i].setName(this.namingSystem);
                Controls.this.grpButtons[i].invalidate();
            }
            Controls.this.validate();
        }
    }

    class GridMode
    extends AbstractAction {
        int mode;

        GridMode(int mode, String str) {
            super(str);
            this.mode = mode;
        }

        public void actionPerformed(ActionEvent e) {
            Controls.this.main.setGrid(this.mode, ((AbstractButton)e.getSource()).isSelected());
        }
    }
}

