/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

class ColorChooser
extends JComponent {
    public static final String CHOSEN_COLOR_PROPERTY = "chosenColor";
    private static final int BUFSIZE = 400;
    private static final double TWOPI = Math.PI * 2;
    private static final double TWOTHIRDPI = 2.0943951023931953;
    private static final double TRIPART = 0.75;
    private RenderingHints renderingHints = new RenderingHints(null);
    private double hue;
    private double cx;
    private double cy;
    private double bx;
    private double by;
    private double wx;
    private double wy;
    private double cf = 1.0;
    private double bf = 0.0;
    private double wf = 0.0;
    private double cfx;
    private double cfy;
    private double cfo;
    private double bfx;
    private double bfy;
    private double bfo;
    private double wfx;
    private double wfy;
    private double wfo;
    private double rFull;
    private double gFull;
    private double bFull;
    private Color chosenColor;
    private BufferedImage buf;
    private boolean needRepaintBuffer;

    public ColorChooser() {
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.setHue(0.0);
        MouseHandler mh = new MouseHandler();
        this.addMouseListener(mh);
        this.addMouseMotionListener(mh);
        this.addPropertyChangeListener("background", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evnt) {
                ColorChooser.this.needRepaintBuffer = true;
                ColorChooser.this.repaint();
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.buf == null) {
            this.buf = new BufferedImage(400, 400, 1);
            this.needRepaintBuffer = true;
        }
        if (this.needRepaintBuffer) {
            this.repaintBuffer();
        }
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        int size = Math.min(w, h);
        int x = (this.getWidth() - size) / 2;
        int y = (this.getHeight() - size) / 2;
        int circSize = size / 7;
        g.setColor(this.getChosenColor());
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHints(this.renderingHints);
            g2d.drawImage(this.buf, x, y, size, size, this);
            g2d.fillOval(x + 2, y + 2, circSize, circSize);
            g2d.dispose();
        } else {
            g.drawImage(this.buf, x, y, size, size, this);
            g.fillOval(x + 2, y + 2, circSize, circSize);
        }
        int px = (int)Math.round((double)x + (double)size / 2.0 * (this.cf * this.cx + this.wf * this.wx + this.bf * this.bx + 1.0));
        int py = (int)Math.round((double)y + (double)size / 2.0 * (this.cf * this.cy + this.wf * this.wy + this.bf * this.by + 1.0));
        g.setColor(Color.WHITE);
        g.fillOval(px - 3, py - 3, 6, 6);
        g.setColor(Color.BLACK);
        g.drawOval(px - 3, py - 3, 6, 6);
    }

    private int hueToRGB(double hue) {
        return Color.HSBtoRGB((float)(hue / (Math.PI * 2)), 1.0f, 1.0f);
    }

    private int factorsToRGB(double cf, double wf) {
        int ri = (int)(cf * this.rFull + wf * 255.0 + 0.5);
        int gi = (int)(cf * this.gFull + wf * 255.0 + 0.5);
        int bi = (int)(cf * this.bFull + wf * 255.0 + 0.5);
        return 0xFF000000 | ri << 16 | gi << 8 | bi;
    }

    public Color getChosenColor() {
        return this.chosenColor;
    }

    public void setChosenColor(Color color) {
        if (this.chosenColor.equals(color)) {
            return;
        }
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int white = Math.min(Math.min(r, g), b);
        this.wf = (double)white / 255.0;
        this.bf = (double)(255 - Math.max(Math.max(r, g), b)) / 255.0;
        this.cf = 1.0 - this.wf - this.bf;
        if (this.cf < 0.00196078431372549) {
            this.updateColor();
        } else {
            this.rFull = (double)(r - white) / this.cf;
            this.gFull = (double)(g - white) / this.cf;
            this.bFull = (double)(b - white) / this.cf;
            float[] hsb = Color.RGBtoHSB((int)(this.rFull + 0.5), (int)(this.gFull + 0.5), (int)(this.bFull + 0.5), null);
            this.setHue((double)hsb[0] * (Math.PI * 2));
        }
        if (!this.chosenColor.equals(color)) {
            throw new AssertionError((Object)"Error changing color");
        }
    }

    public void setHue(double hue) {
        this.hue = hue;
        double ca = hue;
        this.cx = Math.cos(ca) * 0.75;
        this.cy = Math.sin(ca) * 0.75;
        double ba = ca - 2.0943951023931953;
        this.bx = Math.cos(ba) * 0.75;
        this.by = Math.sin(ba) * 0.75;
        double wa = ca + 2.0943951023931953;
        this.wx = Math.cos(wa) * 0.75;
        this.wy = Math.sin(wa) * 0.75;
        double d = this.cx * this.by + this.bx * this.wy + this.wx * this.cy - this.cx * this.wy - this.wx * this.by - this.bx * this.cy;
        this.cfx = (this.by - this.wy) / d;
        this.cfy = (this.wx - this.bx) / d;
        this.cfo = (this.bx * this.wy - this.wx * this.by) / d;
        this.bfx = (this.wy - this.cy) / d;
        this.bfy = (this.cx - this.wx) / d;
        this.bfo = (this.wx * this.cy - this.cx * this.wy) / d;
        this.wfx = (this.cy - this.by) / d;
        this.wfy = (this.bx - this.cx) / d;
        this.wfo = (this.cx * this.by - this.bx * this.cy) / d;
        int rgb = this.hueToRGB(hue);
        this.rFull = rgb >> 16 & 0xFF;
        this.gFull = rgb >> 8 & 0xFF;
        this.bFull = rgb & 0xFF;
        this.needRepaintBuffer = true;
        this.updateColor();
    }

    private void updateColor() {
        Color newColor;
        Color oldColor = this.chosenColor;
        this.chosenColor = newColor = new Color(this.factorsToRGB(this.cf, this.wf));
        this.firePropertyChange(CHOSEN_COLOR_PROPERTY, oldColor, newColor);
        this.repaint();
    }

    private void repaintBuffer() {
        int bg = 0xFF000000 | this.getBackground().getRGB();
        WritableRaster raster = this.buf.getRaster();
        int[] row = new int[400];
        for (int yi = 0; yi < 400; ++yi) {
            double y = ((double)yi + 0.5) / 200.0 - 1.0;
            for (int xi = 0; xi < 400; ++xi) {
                double x = ((double)xi + 0.5) / 200.0 - 1.0;
                int c = bg;
                double rsq = x * x + y * y;
                if (rsq > 0.5625) {
                    if (rsq < 1.0) {
                        c = this.hueToRGB(Math.atan2(y, x));
                    }
                } else {
                    double cf = this.cfx * x + this.cfy * y + this.cfo;
                    double bf = this.bfx * x + this.bfy * y + this.bfo;
                    double wf = this.wfx * x + this.wfy * y + this.wfo;
                    if (cf >= 0.0 && bf >= 0.0 && wf >= 0.0) {
                        c = this.factorsToRGB(cf, wf);
                    }
                }
                row[xi] = c;
            }
            raster.setDataElements(0, yi, 400, 1, row);
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private static final int MODE_NONE = 0;
        private static final int MODE_HUE = 1;
        private static final int MODE_TRI = 2;
        private int mode = 0;
        private double x;
        private double y;

        private MouseHandler() {
        }

        private void pos(MouseEvent evnt) {
            int size = Math.min(ColorChooser.this.getWidth(), ColorChooser.this.getHeight());
            int dx = (ColorChooser.this.getWidth() - size) / 2;
            int dy = (ColorChooser.this.getHeight() - size) / 2;
            this.x = ((double)(evnt.getX() - dx) + 0.5) / (double)size * 2.0 - 1.0;
            this.y = ((double)(evnt.getY() - dy) + 0.5) / (double)size * 2.0 - 1.0;
        }

        public void mousePressed(MouseEvent evnt) {
            this.pos(evnt);
            double rsq = this.x * this.x + this.y * this.y;
            if (this.mode != 0) {
                return;
            }
            this.mode = 0;
            if (rsq > 0.5625) {
                if (rsq < 1.0) {
                    this.mode = 1;
                }
            } else {
                double cf = ColorChooser.this.cfx * this.x + ColorChooser.this.cfy * this.y + ColorChooser.this.cfo;
                double bf = ColorChooser.this.bfx * this.x + ColorChooser.this.bfy * this.y + ColorChooser.this.bfo;
                double wf = ColorChooser.this.wfx * this.x + ColorChooser.this.wfy * this.y + ColorChooser.this.wfo;
                if (cf >= 0.0 && bf >= 0.0 && wf >= 0.0) {
                    this.mode = 2;
                }
            }
            this.mouseDragged(evnt);
        }

        public void mouseReleased(MouseEvent evnt) {
            this.mode = 0;
        }

        public void mouseDragged(MouseEvent evnt) {
            this.pos(evnt);
            switch (this.mode) {
                case 1: {
                    ColorChooser.this.setHue(Math.atan2(this.y, this.x));
                    break;
                }
                case 2: {
                    double cf = ColorChooser.this.cfx * this.x + ColorChooser.this.cfy * this.y + ColorChooser.this.cfo;
                    double bf = ColorChooser.this.bfx * this.x + ColorChooser.this.bfy * this.y + ColorChooser.this.bfo;
                    double wf = ColorChooser.this.wfx * this.x + ColorChooser.this.wfy * this.y + ColorChooser.this.wfo;
                    if (cf < 0.0 || bf < 0.0 || wf < 0.0) {
                        if (cf < 0.0) {
                            cf = 0.0;
                        }
                        if (bf < 0.0) {
                            bf = 0.0;
                        }
                        if (wf < 0.0) {
                            wf = 0.0;
                        }
                        double sum = cf + bf + wf;
                        cf /= sum;
                        bf /= sum;
                        wf /= sum;
                    }
                    ColorChooser.this.cf = cf;
                    ColorChooser.this.bf = bf;
                    ColorChooser.this.wf = wf;
                    ColorChooser.this.updateColor();
                }
            }
        }
    }
}

