/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.recog.CanceledOperationException;
import java.awt.Component;

class ProgressPhase {
    private final ProgressPhase parent;
    private ProgressPhase activeChild;
    private float current;
    protected float maximum;
    private float offset;
    private float weight;
    private String noticePrefix;
    private String noticeSuffix;

    protected ProgressPhase(ProgressPhase parent, float weight, float offset) {
        this.parent = parent;
        this.current = 0.0f;
        this.maximum = 0.0f;
        this.offset = offset;
        this.weight = weight;
    }

    public ProgressPhase createPhase(float weight) {
        ProgressPhase phase = new ProgressPhase(this, weight, this.maximum);
        this.maximum += weight;
        return phase;
    }

    public ProgressPhase[] createPhases(float[] weights) {
        ProgressPhase[] phases = new ProgressPhase[weights.length];
        int i = 0;
        while (i < weights.length) {
            phases[i] = this.createPhase(weights[i]);
            ++i;
        }
        return phases;
    }

    public ProgressPhase[] createPhases(int count, float weight) {
        ProgressPhase[] phases = new ProgressPhase[count];
        int i = 0;
        while (i < count) {
            phases[i] = this.createPhase(weight);
            ++i;
        }
        return phases;
    }

    public ProgressPhase[] createPhases(int count) {
        return this.createPhases(count, 1.0f);
    }

    public void setMaximum(float maximum) {
        this.maximum = maximum;
    }

    public void step() throws CanceledOperationException {
        this.step(1.0f);
    }

    public void step(float increment) throws CanceledOperationException {
        this.update(this.current + increment);
    }

    public void update(float newValue) throws CanceledOperationException {
        this.update(newValue, null);
    }

    public void update(float newValue, ProgressPhase activeChild) throws CanceledOperationException {
        this.activeChild = activeChild;
        this.current = newValue;
        if (this.maximum > 0.0f && this.current > this.maximum) {
            this.current = this.maximum;
        }
        if (this.parent != null) {
            this.parent.update(this.offset + this.weight * this.getFraction(), this);
        }
    }

    public float getFraction() {
        if (this.maximum <= 0.0f) {
            return 0.0f;
        }
        return this.current / this.maximum;
    }

    public boolean isDeterminate() {
        return this.maximum > 0.0f;
    }

    public void begin(String notice, float maximum) throws CanceledOperationException {
        this.maximum = maximum;
        this.update(0.0f);
        if (notice != null) {
            this.setNotice(notice);
        }
    }

    public void begin(float maximum) throws CanceledOperationException {
        this.begin(null, maximum);
    }

    public void begin(String notice) throws CanceledOperationException {
        if (this.maximum == 0.0f) {
            this.maximum = this.weight;
        }
        this.update(0.0f);
        if (notice != null) {
            this.setNotice(notice);
        }
    }

    public void begin() throws CanceledOperationException {
        this.begin(null);
    }

    public void done() throws CanceledOperationException {
        if (this.maximum <= 0.0f) {
            this.maximum = 1.0f;
        }
        this.update(this.maximum);
    }

    public void setNotice(String notice) {
        if (this.parent == null) {
            return;
        }
        if (notice == null) {
            this.parent.setNotice(null);
        } else {
            if (this.noticePrefix != null) {
                notice = String.valueOf(this.noticePrefix) + notice;
            }
            if (this.noticeSuffix != null) {
                notice = String.valueOf(notice) + this.noticeSuffix;
            }
            this.parent.setNotice(notice);
        }
    }

    public void setNoticePrefix(String prefix) {
        this.noticePrefix = prefix;
    }

    public void setNoticeSuffix(String suffix) {
        this.noticeSuffix = suffix;
    }

    public Component getComponent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getComponent();
    }
}

