/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.OutlineExport;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;

public class SvgExport
extends OutlineExport {
    public static final int COMPRESS_NONE = 0;
    public static final int COMPRESS_GZIP = 1;
    private static final String[] ids = new String[]{"svg", "svg.gz"};
    private int compress;
    private MessageFormat fmtPattern;
    private int precision;
    private AffineTransform at;
    private Writer writer;
    private int vw;
    private int vh;
    private String vMatrix;

    public SvgExport(Ornament ornament, int compress) {
        super(ornament, ids[compress]);
        this.compress = compress;
        this.fmtPattern = new MessageFormat(this.loadString("pattern"));
    }

    @Override
    public String getDescription() {
        switch (this.compress) {
            case 0: {
                return I18n._("export.descr.svg");
            }
            case 1: {
                return I18n._("export.descr.svg.gz");
            }
        }
        throw new IllegalStateException("invalid type");
    }

    @Override
    protected void prepareStream() throws IOException {
        super.prepareStream();
        if (this.compress == 1) {
            this.out = new GZIPOutputStream(this.out);
        }
        this.writer = new OutputStreamWriter(this.out, "ASCII");
    }

    @Override
    protected void head() throws IOException {
        int[] vec = new int[4];
        this.ornament.getVectors(vec);
        StringBuffer v = new StringBuffer();
        int maxDimen = Math.abs(vec[0]);
        int i = 0;
        while (i != 4) {
            v.append(vec[i]).append(' ');
            maxDimen = Math.max(maxDimen, Math.abs(vec[i]));
            ++i;
        }
        v.append("0 0");
        this.vMatrix = v.toString();
        maxDimen *= 64;
        this.precision = 1;
        while (this.precision < maxDimen) {
            this.precision <<= 1;
        }
        this.at = AffineTransform.getScaleInstance(this.precision, this.precision);
        int width = 640;
        int height = 480;
        String unit = "px";
        this.vw = width * this.precision;
        this.vh = height * this.precision;
        Object[] args = new Object[]{Integer.toString(width), Integer.toString(height), unit, Integer.toString(this.vw), Integer.toString(this.vh), this.vMatrix, Ornament.getDescription(), new Date(), Integer.toString(this.precision), this.vMatrix};
        this.writer.write(MessageFormat.format(this.loadString("head"), args));
    }

    private String colorToString(Color c) {
        String colStr = Integer.toString(c.getRGB() & 0xFFFFFF, 16);
        while (colStr.length() < 6) {
            colStr = "0" + colStr;
        }
        colStr = "#" + colStr;
        return colStr;
    }

    @Override
    protected void area(Area area, Color color) throws IOException {
        String fillRule;
        PathIterator pi = area.getPathIterator(this.at);
        switch (pi.getWindingRule()) {
            case 0: {
                fillRule = "evenodd";
                break;
            }
            case 1: {
                fillRule = "nonzero";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid winding rule");
            }
        }
        Object[] objectArray = new Object[5];
        objectArray[1] = Integer.toString(this.precision);
        objectArray[2] = fillRule;
        objectArray[3] = this.colorToString(color);
        objectArray[4] = this.vMatrix;
        Object[] args = objectArray;
        StringBuffer buf = new StringBuffer();
        this.fmtPattern.format(args, buf, (FieldPosition)null);
        this.writer.write(buf.toString());
        float[] coords = new float[6];
        int lastOp = 0;
        int lineLen = 0;
        int sx = 0;
        int sy = 0;
        int cx = 0;
        int cy = 0;
        while (!pi.isDone()) {
            int numCoords;
            int nextOp;
            switch (pi.currentSegment(coords)) {
                case 0: {
                    nextOp = 109;
                    numCoords = 2;
                    sx = Math.round(coords[0]);
                    sy = Math.round(coords[1]);
                    break;
                }
                case 1: {
                    nextOp = 108;
                    numCoords = 2;
                    break;
                }
                case 2: {
                    nextOp = 113;
                    numCoords = 4;
                    break;
                }
                case 3: {
                    nextOp = 99;
                    numCoords = 6;
                    break;
                }
                case 4: {
                    nextOp = 122;
                    numCoords = 0;
                    cx = sx;
                    cy = sy;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid segment type");
                }
            }
            if (nextOp == lastOp) {
                nextOp = 32;
            } else {
                lastOp = nextOp;
            }
            if (numCoords == 0) {
                this.writer.write(nextOp);
            } else {
                int i = 0;
                while (i != numCoords) {
                    int iCoord = Math.round(coords[i]);
                    iCoord = i % 2 == 0 ? (iCoord -= cx) : (iCoord -= cy);
                    String number = Integer.toString(iCoord);
                    if (lineLen + number.length() > 75) {
                        this.writer.write(10);
                        lineLen = 0;
                        if (nextOp != 32) {
                            this.writer.write(nextOp);
                            ++lineLen;
                        }
                    } else if (nextOp != 32 || number.charAt(0) != '-') {
                        ++lineLen;
                        this.writer.write(nextOp);
                    }
                    nextOp = 32;
                    this.writer.write(number);
                    lineLen += number.length();
                    ++i;
                }
                cx = Math.round(coords[numCoords - 2]);
                cy = Math.round(coords[numCoords - 1]);
            }
            pi.next();
        }
        if (lineLen + 3 > 75) {
            this.writer.write(10);
        }
        this.writer.write("\"/>\n");
    }

    @Override
    protected void tail() throws IOException {
        Object[] args = new Object[]{this.colorToString(this.ornament.getBackgroundColor()), Integer.toString(this.vw), Integer.toString(this.vh)};
        this.writer.write(MessageFormat.format(this.loadString("foot"), args));
        this.writer.close();
    }
}

