/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.Constants;
import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.Ornament;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

class TileView
extends JPanel
implements Constants,
MouseInputListener {
    Ornament main;
    int ox;
    int oy;
    int ax;
    int ay;
    int bx;
    int by;
    int mina;
    int maxa;
    int minb;
    int maxb;
    int type;
    int movingPoint;
    boolean gridMode;
    boolean shadeMode;
    Group group;
    double otherLength;
    double otherX;
    double otherY;
    RenderingHints renderingHints;
    Polygon clip;
    Shape background;
    Point[] voronoiPoints;
    AffineTransform trans;
    static final double SQRT3HALF = Math.sqrt(3.0) / 2.0;
    static final int PREFDIM = 50;
    static final Color SHADE_COLOR = new Color(0.5f, 0.5f, 0.5f, 0.85f);
    private static final double VORONOI_EPS = 0.001;

    TileView(Ornament ornament) {
        this.main = ornament;
        this.ax = this.main.ax;
        this.ay = this.main.ay;
        this.bx = this.main.bx;
        this.by = this.main.by;
        this.recalcClipping();
        this.recalcTiling();
        this.ox = (50 - this.ax - this.bx) / 2;
        this.oy = (50 - this.ay - this.by) / 2;
        this.trans = new AffineTransform(this.ax, this.ay, this.bx, this.by, this.ox, this.oy);
        this.voronoiPoints = new Point[12];
        int i = 0;
        while (i < this.voronoiPoints.length) {
            this.voronoiPoints[i] = new Point();
            ++i;
        }
        this.setPreferredSize(new Dimension(50, 50));
        this.setBackground(Color.gray);
        this.setForeground(Color.black);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.renderingHints = new RenderingHints(null);
        this.renderingHints = this.main.renderingHints;
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TileView.this.centerTile();
                TileView.this.recalcVoronoi();
                TileView.this.recalcTiling();
                TileView.this.recalcClipping();
                TileView.this.repaint();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        this.add(Box.createGlue(), gbc);
        gbc.weighty = 0.0;
        gbc.insets = new Insets(2, 0, 0, 2);
        JLabel lbl = new JLabel("written by Martin von Gagern", 4);
        lbl.setFont(new Font("SansSerif", 0, 10));
        lbl.setForeground(Color.darkGray);
        this.add((Component)lbl, gbc);
        gbc.insets = new Insets(0, 0, 2, 2);
        lbl = new JLabel("<Martin.vGagern@gmx.net>", 4);
        lbl.setFont(new Font("Monospaced", 0, 10));
        lbl.setForeground(Color.darkGray);
        this.add((Component)lbl, gbc);
    }

    void paintPoint(int x, int y, Graphics g, Color c) {
        g.setColor(c);
        g.fillOval(x - 3, y - 3, 6, 6);
        g.setColor(this.getForeground());
        g.drawOval(x - 3, y - 3, 6, 6);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.setRenderingHints(this.renderingHints);
        }
        if (this.movingPoint == 0 && g2d != null) {
            Image buf = this.main.getBuffer();
            int da = this.mina;
            while (da <= this.maxa + 1) {
                int db = this.minb;
                while (db <= this.maxb + 1) {
                    int x = this.ox + da * this.ax + db * this.bx;
                    int y = this.oy + da * this.ay + db * this.by;
                    if (this.shadeMode ? g.hitClip(x, y, this.main.width, this.main.height) : this.clip.intersects(x, y, this.main.width, this.main.height)) {
                        g2d.drawImage(buf, x, y, this);
                    }
                    ++db;
                }
                ++da;
            }
            g2d.setColor(this.shadeMode ? SHADE_COLOR : this.getBackground());
            g2d.fill(this.background);
            g2d.setColor(this.getForeground());
        } else if (this.movingPoint <= 3) {
            g.drawLine(this.ox, this.oy, this.ox + this.ax, this.oy + this.ay);
            g.drawLine(this.ox, this.oy, this.ox + this.bx, this.oy + this.by);
            g.drawLine(this.ox + this.ax, this.oy + this.ay, this.ox + this.ax + this.bx, this.oy + this.ay + this.by);
            g.drawLine(this.ox + this.bx, this.oy + this.by, this.ox + this.ax + this.bx, this.oy + this.ay + this.by);
        }
        if (this.gridMode && this.movingPoint > 3 && g2d != null) {
            g2d.draw(this.main.voronoi.getCompactGrid().createTransformedShape(this.trans));
        }
        this.paintPoint(this.ox, this.oy, g, Color.blue);
        this.paintPoint(this.ox + this.ax, this.oy + this.ay, g, Color.red);
        this.paintPoint(this.ox + this.bx, this.oy + this.by, g, Color.green);
        if (this.gridMode && !this.group.fixedGrid()) {
            this.debug("Voronoi control point: " + this.voronoiPoints[0]);
            if (this.movingPoint == 0) {
                this.paintPoint(this.voronoiPoints[0].x, this.voronoiPoints[0].y, g, Color.yellow);
            }
            if (this.movingPoint == 4) {
                int i = 0;
                while (i < this.group.countTransforms()) {
                    this.paintPoint(this.voronoiPoints[i].x, this.voronoiPoints[i].y, g, Color.yellow);
                    ++i;
                }
            }
        }
    }

    private void debug(String msg) {
    }

    public void setGroup(Group grp) {
        this.group = grp;
        this.setType(grp.getTileType());
        this.recalcVoronoi();
        this.repaint();
    }

    public void setGridMode(boolean gm) {
        if (this.gridMode == gm) {
            return;
        }
        this.gridMode = gm;
        this.repaint();
    }

    protected boolean setType(int type) {
        if (this.type == type) {
            return false;
        }
        double ra = Math.sqrt(this.ax * this.ax + this.ay * this.ay);
        double rb = Math.sqrt(this.bx * this.bx + this.by * this.by);
        double rm = (ra + rb) / 2.0;
        double ta = Math.atan2(this.ay, this.ax);
        double tb = Math.atan2(this.by, this.bx);
        double tm = Math.atan2(this.ay + this.by, this.ax + this.bx);
        switch (type) {
            case 4: {
                ta = tm + 0.5235987755982988;
                tb = tm - 0.5235987755982988;
                ra = rb = rm;
                break;
            }
            case 3: {
                ra = rb = rm;
            }
            case 2: {
                ta = tm + 0.7853981633974483;
                tb = tm - 0.7853981633974483;
                break;
            }
            case 5: {
                ra = rb = rm;
            }
        }
        this.ax = (int)Math.round(Math.cos(ta) * ra);
        this.ay = (int)Math.round(Math.sin(ta) * ra);
        this.bx = (int)Math.round(Math.cos(tb) * rb);
        this.by = (int)Math.round(Math.sin(tb) * rb);
        if (Math.abs(this.ax * this.by - this.bx * this.ay) < 10) {
            this.ax = 10;
            this.bx = 0;
            this.ay = 0;
            this.by = -10;
        }
        this.type = type;
        this.setVectors();
        return true;
    }

    public void setVectors(int ax, int ay, int bx, int by) {
        if (this.ax == ax && this.ay == ay && this.bx == bx && this.by == by) {
            return;
        }
        this.ax = ax;
        this.bx = bx;
        this.ay = ay;
        this.by = by;
        this.centerTile();
        this.setVectors();
    }

    void setVectors() {
        if (this.movingPoint != 1) {
            this.main.setVectors(this.ax, this.ay, this.bx, this.by);
        }
        this.trans.setTransform(this.ax, this.ay, this.bx, this.by, this.ox, this.oy);
        this.recalcVoronoi();
        this.recalcClipping();
        this.recalcTiling();
    }

    private void centerTile() {
        Dimension s = this.getSize();
        this.ox = (s.width - this.ax - this.bx) / 2;
        if (this.ox >= s.width) {
            this.ox = s.width - 1;
        }
        if (this.ox < 0) {
            this.ox = 0;
        }
        this.oy = (s.height - this.ay - this.by) / 2;
        if (this.oy >= s.height) {
            this.oy = s.height - 1;
        }
        if (this.oy < 0) {
            this.oy = 0;
        }
    }

    void recalcVoronoi() {
        Point2D control = this.main.getVoronoiPoint();
        Point2D.Double tmp = new Point2D.Double();
        int i = 0;
        while (i < this.group.countTransforms()) {
            this.group.getTransform(i).transform(control, tmp);
            if (tmp.x < -0.001 || tmp.x > 1.001) {
                tmp.x -= Math.floor(tmp.x);
            }
            if (tmp.y < -0.001 || tmp.y > 1.001) {
                tmp.y -= Math.floor(tmp.y);
            }
            this.trans.transform(tmp, this.voronoiPoints[i]);
            ++i;
        }
    }

    void recalcClipping() {
        this.clip = new Polygon(new int[]{this.ox, this.ox + this.ax, this.ox + this.ax + this.bx, this.ox + this.bx}, new int[]{this.oy + 1, this.oy + this.ay + 1, this.oy + this.ay + this.by + 1, this.oy + this.by + 1}, 4);
        Area bg = new Area(new Rectangle(this.getSize()));
        bg.subtract(new Area(this.clip));
        this.background = bg;
    }

    void recalcTiling() {
        int maxy;
        int maxx;
        int miny;
        int minx;
        this.maxb = 0;
        this.minb = 0;
        this.maxa = 0;
        this.mina = 0;
        if (this.shadeMode) {
            Dimension size = this.getSize();
            minx = -this.ox;
            miny = -this.oy;
            maxx = size.width - this.ox;
            maxy = size.height - this.oy;
        } else {
            minx = Math.min(Math.min(this.ax + this.bx, 0), Math.min(this.ax, this.bx));
            maxx = Math.max(Math.max(this.ax + this.bx, 0), Math.max(this.ax, this.bx));
            miny = Math.min(Math.min(this.ay + this.by, 0), Math.min(this.ay, this.by));
            maxy = Math.max(Math.max(this.ay + this.by, 0), Math.max(this.ay, this.by));
        }
        this.expandTilingToPoint(minx, miny);
        this.expandTilingToPoint(minx, maxy);
        this.expandTilingToPoint(maxx, miny);
        this.expandTilingToPoint(maxx, maxy);
    }

    void expandTilingToPoint(int x, int y) {
        double a = this.main.aFromPoint(x, y);
        double b = this.main.bFromPoint(x, y);
        if (a < (double)this.mina) {
            this.mina = (int)Math.floor(a);
        }
        if (a > (double)this.maxa) {
            this.maxa = (int)Math.ceil(a);
        }
        if (b < (double)this.minb) {
            this.minb = (int)Math.floor(b);
        }
        if (b > (double)this.maxb) {
            this.maxb = (int)Math.ceil(b);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evnt) {
    }

    @Override
    public void mousePressed(MouseEvent evnt) {
        int y;
        int dy;
        if (this.movingPoint != 0) {
            return;
        }
        int max = 100;
        int x = evnt.getX();
        int dx = this.ox - x;
        if (dx * dx + (dy = this.oy - (y = evnt.getY())) * dy <= max) {
            this.movingPoint = 1;
            max = dx * dx + dy * dy;
        }
        if ((dx = this.ox + this.ax - x) * dx + (dy = this.oy + this.ay - y) * dy <= max) {
            this.movingPoint = 2;
            max = dx * dx + dy * dy;
            this.otherX = this.bx;
            this.otherY = this.by;
            this.otherLength = Math.sqrt(this.bx * this.bx + this.by * this.by);
        }
        if ((dx = this.ox + this.bx - x) * dx + (dy = this.oy + this.by - y) * dy <= max) {
            this.movingPoint = 3;
            max = dx * dx + dy * dy;
            this.otherX = this.ax;
            this.otherY = this.ay;
            this.otherLength = Math.sqrt(this.ax * this.ax + this.ay * this.ay);
        }
        dx = this.voronoiPoints[0].x - x;
        dy = this.voronoiPoints[0].y - y;
        if (this.gridMode && !this.group.fixedGrid() && dx * dx + dy * dy <= max) {
            this.movingPoint = 4;
            max = dx * dx + dy * dy;
        }
    }

    @Override
    public void mouseReleased(MouseEvent evnt) {
        if (this.movingPoint == 0) {
            return;
        }
        if (this.movingPoint > 3) {
            this.main.repaintBuffer();
        } else {
            Dimension s = this.getSize();
            if (this.ax * this.by - this.bx * this.ay == 0 || this.ax >= s.width || this.bx >= s.width || this.ay >= s.height || this.by >= s.height) {
                this.ax = this.main.ax;
                this.ay = this.main.ay;
                this.bx = this.main.bx;
                this.by = this.main.by;
            } else {
                if (this.movingPoint == 1 && (this.ox < 0 || this.ox >= s.width) || this.movingPoint == 2 && (this.ox + this.ax < 0 || this.ox + this.ax >= s.width) || this.movingPoint == 3 && (this.ox + this.bx < 0 || this.ox + this.bx >= s.width)) {
                    this.ox = (s.width - this.ax - this.bx) / 2;
                    if (this.ox >= s.width) {
                        this.ox = s.width - 1;
                    }
                    if (this.ox < 0) {
                        this.ox = 0;
                    }
                }
                if (this.movingPoint == 1 && (this.oy < 0 || this.oy >= s.height) || this.movingPoint == 2 && (this.oy + this.ay < 0 || this.oy + this.ay >= s.height) || this.movingPoint == 3 && (this.oy + this.by < 0 || this.oy + this.by >= s.height)) {
                    this.oy = (s.height - this.ay - this.by) / 2;
                    if (this.oy >= s.height) {
                        this.oy = s.height - 1;
                    }
                    if (this.oy < 0) {
                        this.oy = 0;
                    }
                }
                this.setVectors();
            }
        }
        this.movingPoint = 0;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent evnt) {
    }

    @Override
    public void mouseExited(MouseEvent evnt) {
    }

    @Override
    public void mouseDragged(MouseEvent evnt) {
        int x = evnt.getX();
        int y = evnt.getY();
        switch (this.movingPoint) {
            case 0: {
                return;
            }
            case 1: {
                this.ox = x;
                this.oy = y;
                break;
            }
            case 2: {
                this.ax = x - this.ox;
                this.ay = y - this.oy;
                if (Math.abs(this.ay) <= Math.abs(this.ax) / 25) {
                    this.ay = 0;
                } else if (Math.abs(this.ax) <= Math.abs(this.ay) / 25) {
                    this.ax = 0;
                } else if (Math.abs(this.ax - this.ay) <= Math.abs(this.ax) / 25) {
                    this.ax = this.ay = (this.ax + this.ay) / 2;
                } else if (Math.abs(this.ax + this.ay) <= Math.abs(this.ay) / 25) {
                    this.ax = (this.ax - this.ay) / 2;
                    this.ay = -this.ax;
                }
                switch (this.type) {
                    case 2: {
                        double factor = this.otherLength / Math.sqrt(this.ax * this.ax + this.ay * this.ay);
                        if (factor >= 0.97 && factor <= 1.03) {
                            this.ax = -this.by;
                            this.ay = this.bx;
                            break;
                        }
                        this.bx = (int)Math.round((double)this.ay * factor);
                        this.by = (int)Math.round((double)(-this.ax) * factor);
                        break;
                    }
                    case 3: {
                        this.bx = this.ay;
                        this.by = -this.ax;
                        break;
                    }
                    case 4: {
                        this.bx = (int)Math.round(0.5 * (double)this.ax + SQRT3HALF * (double)this.ay);
                        this.by = (int)Math.round(-SQRT3HALF * (double)this.ax + 0.5 * (double)this.ay);
                        break;
                    }
                    case 5: {
                        double factor = Math.sqrt(this.ax * this.ax + this.ay * this.ay) / this.otherLength;
                        this.bx = (int)Math.round(this.otherX * factor);
                        this.by = (int)Math.round(this.otherY * factor);
                    }
                }
                break;
            }
            case 3: {
                this.bx = x - this.ox;
                this.by = y - this.oy;
                if (Math.abs(this.by) <= Math.abs(this.bx) / 25) {
                    this.by = 0;
                } else if (Math.abs(this.bx) <= Math.abs(this.by) / 25) {
                    this.bx = 0;
                } else if (Math.abs(this.bx - this.by) <= Math.abs(this.bx) / 25) {
                    this.bx = this.by = (this.bx + this.by) / 2;
                } else if (Math.abs(this.bx + this.by) <= Math.abs(this.by) / 25) {
                    this.bx = (this.bx - this.by) / 2;
                    this.by = -this.bx;
                }
                switch (this.type) {
                    case 2: {
                        double factor = this.otherLength / Math.sqrt(this.bx * this.bx + this.by * this.by);
                        if (factor >= 0.97 && factor <= 1.03) {
                            this.bx = this.ay;
                            this.by = -this.ax;
                            break;
                        }
                        this.ax = (int)Math.round((double)(-this.by) * factor);
                        this.ay = (int)Math.round((double)this.bx * factor);
                        break;
                    }
                    case 3: {
                        this.ax = -this.by;
                        this.ay = this.bx;
                        break;
                    }
                    case 4: {
                        this.ax = (int)Math.round(0.5 * (double)this.bx - SQRT3HALF * (double)this.by);
                        this.ay = (int)Math.round(SQRT3HALF * (double)this.bx + 0.5 * (double)this.by);
                        break;
                    }
                    case 5: {
                        double factor = Math.sqrt(this.bx * this.bx + this.by * this.by) / this.otherLength;
                        this.ax = (int)Math.round(this.otherX * factor);
                        this.ay = (int)Math.round(this.otherY * factor);
                    }
                }
                break;
            }
            default: {
                try {
                    this.voronoiPoints[0].setLocation(x, y);
                    Point2D snappedPoint = this.group.snapVoronoi(this.voronoiPoints[0], this.trans);
                    this.trans.inverseTransform(snappedPoint, this.main.getVoronoiPoint());
                    this.main.recalcVoronoi();
                }
                catch (NoninvertibleTransformException e) {
                    e.printStackTrace();
                }
                this.recalcVoronoi();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent evnt) {
    }
}

