/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.Constants;
import de.tum.in.gagern.ornament.Controls;
import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.Hooks;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.LinPath;
import de.tum.in.gagern.ornament.PlaneView;
import de.tum.in.gagern.ornament.Property;
import de.tum.in.gagern.ornament.TileView;
import de.tum.in.gagern.ornament.Voronoi;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class Ornament
extends JApplet
implements Constants {
    static final int GRID_NONE = 0;
    static final int GRID_TILE = 1;
    static final int GRID_CELL = 2;
    static final int GRID_PROPS = 4;
    static final int GRID_BUFFER = 8;
    static GraphicsDevice grafica = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private static Toolkit toolkit;
    Group group;
    int ax;
    int ay;
    int bx;
    int by;
    int width;
    int height;
    int mina;
    int maxa;
    int minb;
    int maxb;
    double dax;
    double day;
    double dbx;
    double dby;
    double denom;
    Window window;
    JMenuBar menuBar;
    TileView tv;
    PlaneView pv;
    Controls cntrl;
    JSplitPane splitPane;
    Image buf;
    boolean showBackground;
    BufferedImage backgroundTile;
    BufferedImage backgroundTiles;
    List lines;
    Voronoi voronoi;
    AffineTransform vectorTransform;
    AffineTransform tempTrans;
    GeneralPath tempPath;
    Line2D tempLine;
    Color[] colors = new Color[]{Color.white, Color.black, Color.gray, Color.darkGray, Color.darkGray, new Color(153, 153, 153), new Color(204, 51, 51), new Color(102, 102, 204), new Color(0, 204, 102), new Color(204, 204, 0)};
    BasicStroke lineStroke;
    BasicStroke gridStroke = new BasicStroke();
    BasicStroke glideStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
    int grid;
    RenderingHints renderingHints;
    boolean useBufferedImage = false;
    boolean useStrokes = true;
    boolean useAntiAlias = true;
    boolean gridOnTop = false;
    boolean debug = false;
    List hooks = new ArrayList();
    private static Properties versionInfo;

    public static void main(String[] args) {
        boolean debug = false;
        int i = 0;
        while (i < args.length) {
            if ("-debug".equals(args[i])) {
                debug = true;
            }
            ++i;
        }
        JFrame frm = new JFrame(I18n._("morenaments euc"));
        frm.setUndecorated(true);
        Ornament ornament = new Ornament(frm, debug);
        frm.setContentPane(ornament);
        frm.setDefaultCloseOperation(3);
        frm.pack();
        frm.setVisible(true);
        grafica.setFullScreenWindow(frm);
        toolkit = frm.getToolkit();
        Cursor inv = Ornament.makeInvisibleCursor();
        frm.setCursor(inv);
    }

    private static Cursor makeInvisibleCursor() {
        BufferedImage img = new BufferedImage(4, 4, 2);
        return toolkit.createCustomCursor(img, new Point(0, 0), I18n._("invisible cursor"));
    }

    public Ornament() {
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.renderingHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.lines = new ArrayList();
        this.voronoi = new Voronoi();
        this.vectorTransform = new AffineTransform();
        this.tempTrans = new AffineTransform();
        this.tempPath = new GeneralPath();
        this.tempLine = new Line2D.Float();
        this.setVectors(150, 0, 0, -150);
        this.tv = new TileView(this);
        this.pv = new PlaneView(this);
        this.cntrl = new Controls(this);
        JPanel cpanel = new JPanel();
        cpanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.menuBar = this.cntrl.createMenu();
        cpanel.add((Component)this.cntrl, gbc);
        JPanel colorControls = new Controls(this).createColorControls();
        colorControls.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        cpanel.add((Component)colorControls, gbc);
        gbc.weighty = 1.0;
        cpanel.add((Component)this.tv, gbc);
        gbc.weighty = 0.0;
        this.splitPane = new JSplitPane(1, false, this.pv, cpanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(1.0);
        this.setContentPane(this.splitPane);
    }

    public Ornament(Window wnd, boolean debug) {
        this();
        this.setStub(new AppStub());
        this.window = wnd;
        this.debug = debug;
    }

    public void addHooks(Hooks hooks) {
        this.hooks.add(hooks);
    }

    public void removeHooks(Hooks hooks) {
        this.hooks.remove(hooks);
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public void init() {
        super.init();
        JSplitPane splitPane = (JSplitPane)this.getContentPane();
        splitPane.setBorder(BorderFactory.createLoweredBevelBorder());
        int all = this.getWidth();
        int right = splitPane.getRightComponent().getPreferredSize().width;
        right += splitPane.getDividerSize();
        right += 7 - right % 5;
        splitPane.setDividerLocation(all - right);
        splitPane.getRightComponent().invalidate();
        this.validate();
    }

    void setAntiAlias(boolean aa) {
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, aa ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.useAntiAlias = aa;
        this.repaintBuffer();
    }

    void setColor(Color clr) {
        this.colors[0] = clr;
    }

    void setStroke(BasicStroke s) {
        this.lineStroke = s;
    }

    void setGroup(Group grp) {
        this.group = grp;
        this.backgroundTile = null;
        this.hasBackground(false);
        this.tv.setGroup(grp);
        this.voronoi.set(this.group, this.ax, this.ay, this.bx, this.by);
        this.repaintBuffer();
    }

    public void setVectors(int ax, int ay, int bx, int by) {
        int miny;
        int maxx;
        int minx;
        if (this.ax == ax && this.ay == ay && this.bx == bx && this.by == by) {
            return;
        }
        Iterator i = this.hooks.iterator();
        while (i.hasNext()) {
            ((Hooks)i.next()).setVectors(ax, ay, bx, by);
        }
        this.ax = ax;
        this.dax = this.ax;
        this.ay = ay;
        this.day = this.ay;
        this.bx = bx;
        this.dbx = this.bx;
        this.by = by;
        this.dby = this.by;
        if (this.tv != null) {
            this.tv.setVectors(ax, ay, bx, by);
        }
        this.voronoi.set(this.group, ax, ay, bx, by);
        this.vectorTransform.setTransform(ax, ay, bx, by, 0.0, 0.0);
        this.denom = this.dax * this.dby - this.dbx * this.day;
        int n = bx < ax && bx < 0 ? bx : (minx = ax < 0 ? ax : 0);
        int n2 = bx > ax && bx > 0 ? bx : (maxx = ax > 0 ? ax : 0);
        int n3 = by < ay && by < 0 ? by : (miny = ay < 0 ? ay : 0);
        int maxy = by > ay && by > 0 ? by : (ay > 0 ? ay : 0);
        this.width = maxx - minx;
        this.height = maxy - miny;
        this.maxb = 0;
        this.minb = 0;
        this.maxa = 0;
        this.mina = 0;
        this.expandTilingToPoint(this.width, 0);
        this.expandTilingToPoint(this.width, this.height);
        this.expandTilingToPoint(0, this.height);
        this.repaintBuffer();
        if (this.pv != null) {
            this.pv.recalcTiling();
        }
    }

    public Image getBuffer() {
        if (this.buf != null) {
            return this.buf;
        }
        Graphics2D g2d = null;
        if (!this.useBufferedImage) {
            this.buf = this.createImage(this.width, this.height);
            Graphics g = this.buf.getGraphics();
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
            } else {
                System.out.println("fallback to BufferedImage");
                this.useBufferedImage = true;
            }
        }
        if (this.useBufferedImage) {
            this.buf = new BufferedImage(this.width, this.height, 6);
            g2d = ((BufferedImage)this.buf).createGraphics();
        }
        this.paintBuffer(g2d);
        return this.buf;
    }

    void addLine(float[] coords) {
        this.lines.add(new LinPath(coords, this.colors[0], this.lineStroke));
        if (this.gridOnTop && this.grid != 0 && this.buf != null) {
            Graphics2D g2d = this.getBufferGraphics();
            this.paintGrid(g2d);
            g2d.dispose();
        }
        if (this.tv != null) {
            this.tv.repaint();
        }
        if (this.pv != null) {
            this.pv.repaint();
        }
    }

    public List getLines() {
        return this.lines;
    }

    public Group getGroup() {
        return this.group;
    }

    public void getVectors(int[] vecs) {
        if (vecs.length < 4) {
            throw new IllegalArgumentException();
        }
        vecs[0] = this.ax;
        vecs[1] = this.ay;
        vecs[2] = this.bx;
        vecs[3] = this.by;
    }

    public AffineTransform getVectorTransform() {
        return this.vectorTransform;
    }

    public Color getBackgroundColor() {
        return this.colors[1];
    }

    void clearLines() {
        this.lines.clear();
        this.repaintBuffer();
    }

    void setGrid(int mode, boolean state) {
        int g;
        int n = g = state ? this.grid | mode : this.grid & ~mode;
        if (g == this.grid) {
            return;
        }
        this.grid = g;
        if (mode == 2) {
            this.tv.setGridMode(state);
        }
        this.repaintBuffer();
    }

    Point2D getVoronoiPoint() {
        return this.voronoi.getControlPoint();
    }

    void recalcVoronoi() {
        this.voronoi.recreate();
    }

    Graphics2D getBufferGraphics() {
        if (this.buf == null) {
            throw new IllegalStateException("Buffer not ready");
        }
        if (!this.useBufferedImage) {
            return (Graphics2D)this.buf.getGraphics();
        }
        return ((BufferedImage)this.buf).createGraphics();
    }

    void repaintBuffer() {
        this.buf = null;
        if (this.tv != null) {
            this.tv.repaint();
        }
        if (this.pv != null) {
            this.pv.repaint();
        }
    }

    void paintBuffer(Graphics2D g2d) {
        g2d.setRenderingHints(this.renderingHints);
        g2d.setColor(this.colors[1]);
        g2d.fillRect(0, 0, this.width, this.height);
        if (this.showBackground) {
            int nw = this.maxa - this.mina + 1;
            int nh = this.maxb - this.minb + 1;
            int bgw = this.backgroundTile.getWidth();
            int bgh = this.backgroundTile.getHeight();
            if (this.backgroundTiles == null || this.backgroundTiles.getWidth() < nw * bgw || this.backgroundTiles.getHeight() < nh * bgh) {
                this.backgroundTiles = Ornament.tileImage(this.backgroundTile, nw, nh);
            }
            this.tempTrans.setTransform(this.vectorTransform);
            this.tempTrans.translate(this.mina, this.minb);
            this.tempTrans.scale(1.0 / (double)bgw, 1.0 / (double)bgh);
            g2d.drawImage(this.backgroundTiles, this.tempTrans, this);
        }
        if (!this.gridOnTop) {
            this.paintGrid(g2d);
        }
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            this.paintLinPath(g2d, (LinPath)i.next());
        }
        if (this.gridOnTop) {
            this.paintGrid(g2d);
        }
    }

    void paintGrid(Graphics2D g2d) {
        g2d.setStroke(this.gridStroke);
        if ((this.grid & 8) > 0) {
            g2d.setColor(this.colors[4]);
            g2d.drawRect(0, 0, this.width - 1, this.height - 1);
        }
        if ((this.grid & 2) > 0) {
            g2d.setColor(this.colors[3]);
            this.drawAll(g2d, this.voronoi.getGrid());
        }
        if ((this.grid & 1) > 0) {
            g2d.setColor(this.colors[2]);
            this.drawGridLine(g2d, 0.0f, 0.0f, 1.0f, 0.0f);
            this.drawGridLine(g2d, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        if ((this.grid & 4) > 0) {
            this.paintProps(g2d);
        }
    }

    void paintProps(Graphics2D g) {
        Property[] props = this.group.getProperties();
        AffineTransform t = new AffineTransform();
        int i = props.length - 1;
        while (i >= 0) {
            g.setColor(this.colors[5 + props[i].getTC()]);
            int da = this.mina;
            while (da <= this.maxa + 1) {
                int db = this.minb;
                while (db <= this.maxb + 1) {
                    t.setTransform(this.dax, this.day, this.dbx, this.dby, (double)da * this.dax + (double)db * this.dbx, (double)da * this.day + (double)db * this.dby);
                    props[i].paint(g, t);
                    ++db;
                }
                ++da;
            }
            --i;
        }
    }

    void paintLinPath(Graphics2D g2d, LinPath l) {
        g2d.setColor(l.getColor());
        if (this.useStrokes) {
            g2d.setStroke(l.getStroke());
        }
        int i = 0;
        while (i < this.group.countTransforms()) {
            this.drawOnce(g2d, l.getPathIterator(this.group.getTransform(i)));
            ++i;
        }
    }

    void drawAll(Graphics2D g2d, Shape s) {
        if (this.group == null) {
            System.err.println("NULL!");
            System.exit(1);
        }
        int i = 0;
        while (i < this.group.countTransforms()) {
            this.drawOnce(g2d, s.getPathIterator(this.group.getTransform(i)));
            ++i;
        }
    }

    void drawOnce(Graphics2D g2d, Shape s) {
        this.tempPath.reset();
        this.tempPath.append(s, false);
        this.drawPathOnce(g2d);
    }

    void drawOnce(Graphics2D g2d, PathIterator s) {
        this.tempPath.reset();
        this.tempPath.append(s, false);
        this.drawPathOnce(g2d);
    }

    private void drawPathOnce(Graphics2D g2d) {
        Rectangle2D bb = this.tempPath.getBounds2D();
        int min_a = this.mina - (int)Math.ceil(bb.getMaxX());
        int max_a = this.maxa - (int)Math.floor(bb.getMinX());
        int min_b = this.minb - (int)Math.ceil(bb.getMaxY());
        int max_b = this.maxb - (int)Math.floor(bb.getMinY());
        int da = min_a;
        while (da <= max_a) {
            int db = min_b;
            while (db <= max_b) {
                this.tempTrans.setTransform(this.vectorTransform);
                this.tempTrans.translate(da, db);
                g2d.draw(this.tempPath.createTransformedShape(this.tempTrans));
                ++db;
            }
            ++da;
        }
    }

    void drawLine(float a1, float b1, float a2, float b2) {
        Graphics2D g2d = this.getBufferGraphics();
        g2d.setRenderingHints(this.renderingHints);
        g2d.setColor(this.colors[0]);
        if (this.useStrokes) {
            g2d.setStroke(this.lineStroke);
        }
        this.tempLine.setLine(a1, b1, a2, b2);
        this.drawAll(g2d, this.tempLine);
        g2d.dispose();
        if (this.pv != null) {
            this.pv.repaint();
        }
        if (this.tv != null) {
            this.tv.repaint();
        }
    }

    void drawGridLine(Graphics2D g2d, float a1, float b1, float a2, float b2) {
        int da = this.mina;
        while (da <= this.maxa) {
            float a1d = a1 + (float)da;
            float a2d = a2 + (float)da;
            int db = this.minb;
            while (db <= this.maxb) {
                float b1d = b1 + (float)db;
                float b2d = b2 + (float)db;
                this.tempLine.setLine(a1d * (float)this.ax + b1d * (float)this.bx, a1d * (float)this.ay + b1d * (float)this.by, a2d * (float)this.ax + b2d * (float)this.bx, a2d * (float)this.ay + b2d * (float)this.by);
                g2d.draw(this.tempLine);
                ++db;
            }
            ++da;
        }
    }

    void expandTilingToPoint(int x, int y) {
        double a = this.aFromPoint(x, y);
        double b = this.bFromPoint(x, y);
        if (a < (double)this.mina) {
            this.mina = (int)Math.floor(a);
        }
        if (a > (double)this.maxa) {
            this.maxa = (int)Math.ceil(a);
        }
        if (b < (double)this.minb) {
            this.minb = (int)Math.floor(b);
        }
        if (b > (double)this.maxb) {
            this.maxb = (int)Math.ceil(b);
        }
    }

    double aFromPoint(double x, double y) {
        return (this.dby * x - this.dbx * y) / this.denom;
    }

    double bFromPoint(double x, double y) {
        return (-this.day * x + this.dax * y) / this.denom;
    }

    public void setRecognizedImage(Group group, int ax, int ay, int bx, int by, BufferedImage median) {
        Iterator i = this.hooks.iterator();
        while (i.hasNext()) {
            ((Hooks)i.next()).recognizedImage(group, ax, ay, bx, by, median);
        }
        this.cntrl.setGroup(group);
        this.backgroundTile = median;
        this.hasBackground(true);
        this.setVectors(ax, ay, bx, by);
    }

    private void hasBackground(boolean hasBackground) {
        this.backgroundTiles = null;
        this.showBackground = hasBackground;
        if (this.cntrl != null) {
            this.cntrl.hasBackground(hasBackground);
        }
    }

    public BufferedImage getBackgroundTile() {
        if (!this.showBackground) {
            return null;
        }
        return this.backgroundTile;
    }

    public void showBackground(boolean show) {
        if (this.backgroundTile == null) {
            return;
        }
        this.showBackground = show;
        this.repaintBuffer();
    }

    public BufferedImage renderTileAnisotropic(int width, int height, boolean transparent) {
        int imageType = transparent ? 2 : 1;
        BufferedImage img = new BufferedImage(width, height, imageType);
        Graphics2D g = img.createGraphics();
        if (!transparent) {
            g.setColor(this.colors[1]);
            g.fillRect(-1, -1, width + 2, height + 2);
        }
        g.setRenderingHints(this.renderingHints);
        if (this.showBackground) {
            g.drawImage(this.backgroundTile, 0, 0, width, height, null);
        }
        try {
            g.scale(width, height);
            g.transform(this.vectorTransform.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            this.paintLinPath(g, (LinPath)i.next());
        }
        g.dispose();
        return img;
    }

    public static BufferedImage tileImage(BufferedImage in, int xTiles, int yTiles) {
        if (xTiles == 1 && yTiles == 1) {
            return in;
        }
        int inW = in.getWidth();
        int inH = in.getHeight();
        int outW = inW * xTiles;
        int outH = inH * yTiles;
        WritableRaster inR = in.getRaster();
        ColorModel cm = in.getColorModel();
        WritableRaster outR = cm.createCompatibleWritableRaster(outW, outH);
        int x = 0;
        while (x < xTiles) {
            int y = 0;
            while (y < yTiles) {
                outR.setRect(x * inW, y * inH, inR);
                ++y;
            }
            ++x;
        }
        boolean premultiplied = in.isAlphaPremultiplied();
        BufferedImage out = new BufferedImage(cm, outR, premultiplied, null);
        return out;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public static Properties getVersionInfo() {
        InputStream in;
        if (versionInfo != null) {
            return versionInfo;
        }
        versionInfo = new Properties();
        try {
            in = Ornament.class.getResourceAsStream("version.properties");
            if (in != null) {
                versionInfo.load(in);
            } else {
                System.err.println("no such file: version.properties");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        try {
            in = Ornament.class.getResourceAsStream("bzr.properties");
            if (in != null) {
                Properties bzr = new Properties(versionInfo);
                bzr.load(in);
                versionInfo = bzr;
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return versionInfo;
    }

    public static String getDescription() {
        Properties versionInfo = Ornament.getVersionInfo();
        Object[] args = new String[]{versionInfo.getProperty("version.number", "[unknown version]"), "Martin von Gagern"};
        return MessageFormat.format("Ornament {0} by {1}", args);
    }

    private static class AppStub
    implements AppletStub {
        private AppStub() {
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public URL getDocumentBase() {
            return null;
        }

        @Override
        public URL getCodeBase() {
            return null;
        }

        @Override
        public AppletContext getAppletContext() {
            return null;
        }

        @Override
        public void appletResize(int width, int height) {
        }

        @Override
        public String getParameter(String name) {
            return System.getProperty(name);
        }
    }
}

