/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class MinGrid {
    private final int a1;
    private final int b1;
    private final int a2;
    private final int b2;
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    public MinGrid(double ax, double ay, double bx, double by) {
        int da;
        boolean swapped = false;
        double ad = ax * ax + ay * ay;
        double bd = bx * bx + by * by;
        if (bd < ad) {
            double t = ad;
            ad = bd;
            bd = t;
            t = ax;
            ax = bx;
            bx = t;
            t = ay;
            ay = by;
            by = t;
            swapped = true;
        }
        this.debug("a=" + ax + "/" + ay + ", b=" + bx + "/" + by);
        int nb = (int)Math.ceil(Math.abs((ax * ax + ay * ay) / (ax * by - bx * ay)));
        this.debug("nb = " + nb);
        double cd = ad;
        int ca = 1;
        int cb = 0;
        double cx = ax;
        double cy = ay;
        int db = 1;
        while (db < nb) {
            da = -((int)Math.round((double)db * (ax * bx + ay * by) / ad));
            double dx = (double)da * ax + (double)db * bx;
            double dy = (double)da * ay + (double)db * by;
            double dd = dx * dx + dy * dy;
            this.debug("d=" + da + "*a+" + db + "*b=" + dx + "/" + dy);
            if (dd < cd) {
                cd = dd;
                ca = da;
                cb = db;
                cx = dx;
                cy = dy;
            }
            ++db;
        }
        this.debug("c=" + ca + "*a+" + cb + "*b=" + cx + "/" + cy);
        int[] euc = MinGrid.extendedEuclid(ca, cb);
        da = euc[2];
        int db2 = euc[1];
        double dx = (double)da * ax + (double)db2 * bx;
        double dy = (double)da * ay + (double)db2 * by;
        this.debug("d'=" + da + "*a+" + db2 + "*b=" + dx + "/" + dy);
        int shift = (int)Math.ceil(-(cx * dx + cy * dy) / cd);
        dx = (double)(da += shift * ca) * ax + (double)(db2 += shift * cb) * bx;
        dy = (double)da * ay + (double)db2 * by;
        double dd = dx * dx + dy * dy;
        this.debug("d=" + da + "*a+" + db2 + "*b=" + dx + "/" + dy);
        int ea = ca - da;
        int eb = cb - db2;
        double ex = (double)ea * ax + (double)eb * bx;
        double ey = (double)ea * ay + (double)eb * by;
        double ed = ex * ex + ey * ey;
        this.debug("e=" + ea + "*a+" + eb + "*b=" + ex + "/" + ey);
        if (ed < dd) {
            da = ea;
            db2 = eb;
            dx = ex;
            dy = ey;
            dd = ed;
            this.debug("d=" + da + "*a+" + db2 + "*b=" + dx + "/" + dy);
        }
        if (cx + dx < 0.0 || cx + dx == 0.0 && cy + dy > 0.0) {
            ca = -ca;
            cb = -cb;
            cx = -cx;
            cy = -cy;
            da = -da;
            db2 = -db2;
            dx = -dx;
            dy = -dy;
            this.debug("c=" + ca + "*a+" + cb + "*b=" + cx + "/" + cy);
            this.debug("d=" + da + "*a+" + db2 + "*b=" + dx + "/" + dy);
        }
        if (swapped) {
            this.a1 = cb;
            this.b1 = ca;
            this.a2 = db2;
            this.b2 = da;
        } else {
            this.a1 = ca;
            this.b1 = cb;
            this.a2 = da;
            this.b2 = db2;
        }
        this.x1 = cx;
        this.y1 = cy;
        this.x2 = dx;
        this.y2 = dy;
    }

    public MinGrid(AffineTransform t) {
        this(t.getScaleX(), t.getShearY(), t.getShearX(), t.getScaleY());
    }

    /*
     * Unable to fully structure code
     */
    private static int[] extendedEuclid(int a, int b) {
        if (Math.abs(a) >= Math.abs(b)) {
            a1 = a;
            x1 = 1;
            y1 = 0;
            a2 = b;
            x2 = 0;
            y2 = 1;
        } else {
            a1 = b;
            x1 = 0;
            y1 = 1;
            a2 = a;
            x2 = 1;
            y2 = 0;
        }
        if (!MinGrid.$assertionsDisabled && Math.abs(a1) < Math.abs(a2)) {
            throw new AssertionError();
        }
        if (!MinGrid.$assertionsDisabled && a1 != x1 * a + y1 * b) {
            throw new AssertionError();
        }
        if (MinGrid.$assertionsDisabled || a2 == x2 * a + y2 * b) ** GOTO lbl35
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            q = a1 / a2;
            tmp = a1;
            a1 = a2;
            a2 = tmp - q * a2;
            tmp = x1;
            x1 = x2;
            x2 = tmp - q * x2;
            tmp = y1;
            y1 = y2;
            y2 = tmp - q * y2;
            if (!MinGrid.$assertionsDisabled && a1 != x1 * a + y1 * b) {
                throw new AssertionError();
            }
            if (!MinGrid.$assertionsDisabled && a2 != x2 * a + y2 * b) {
                throw new AssertionError();
            }
lbl35:
            // 3 sources

            ** while (a2 != 0)
        }
lbl36:
        // 1 sources

        if (a1 < 0) {
            return new int[]{-a1, -x1, -y1};
        }
        return new int[]{a1, x1, y1};
    }

    public int getA1() {
        return this.a1;
    }

    public int getB1() {
        return this.b1;
    }

    public int getA2() {
        return this.a2;
    }

    public int getB2() {
        return this.b2;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.x1, this.y1, this.x2, this.y2, 0.0, 0.0);
    }

    public AffineTransform getTransform(boolean posDirection) {
        if (this.x1 * this.y2 - this.x2 * this.y1 > 0.0 == posDirection) {
            return new AffineTransform(this.x1, this.y1, this.x2, this.y2, 0.0, 0.0);
        }
        return new AffineTransform(this.x2, this.y2, this.x1, this.y1, 0.0, 0.0);
    }

    public Point getAB1() {
        return new Point(this.a1, this.b1);
    }

    public Point getAB2() {
        return new Point(this.a2, this.b2);
    }

    public Point2D getXY1() {
        return new Point2D.Double(this.x1, this.y1);
    }

    public Point2D getXY2() {
        return new Point2D.Double(this.x2, this.y2);
    }

    public String toString() {
        return "MinGrid[" + this.x1 + "/" + this.y1 + ", " + this.x2 + "/" + this.y2 + "]";
    }

    private void debug(String msg) {
    }

    public static void main(String[] args) {
        new MinGrid(4.0, 0.0, 5.0, 1.0);
    }
}

