/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.io.IOException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class Documentation {
    JDialog dlg;
    JEditorPane hp;
    JScrollPane sp;
    URL url;

    public void show() {
        if (this.hp == null) {
            System.err.println("Previous loading of documentation failed");
        } else {
            try {
                this.hp.setPage(this.url);
                this.sp.getViewport().setViewPosition(new Point());
                this.dlg.setVisible(true);
            }
            catch (IOException e) {
                System.err.println("Could not load documentation: " + e);
            }
        }
    }

    Documentation(Component owner, String path) {
        this.url = this.getClass().getClassLoader().getResource(path);
        if (this.url == null) {
            System.err.println("Could not find documentation");
        } else {
            Component c = owner;
            while (this.dlg == null && c != null) {
                if (c instanceof Frame) {
                    this.dlg = new JDialog((Frame)c);
                }
                if (c instanceof Dialog) {
                    this.dlg = new JDialog((Dialog)c);
                }
                c = c.getParent();
            }
            if (this.dlg == null) {
                this.dlg = new JDialog();
            }
            this.dlg.setTitle("Ornament Help");
            try {
                this.hp = new JEditorPane(this.url);
                this.hp.setEditable(false);
                this.hp.addHyperlinkListener(new Hyperlinker());
                this.sp = new JScrollPane(this.hp);
                this.dlg.setContentPane(this.sp);
                int h = owner.getGraphicsConfiguration().getBounds().height;
                this.dlg.setSize(500, Math.max(400, h * 2 / 3));
                this.dlg.setVisible(true);
            }
            catch (IOException e) {
                System.err.println("Could not load documentation: " + e);
            }
        }
    }

    static class Hyperlinker
    implements HyperlinkListener {
        Hyperlinker() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evnt) {
            if (evnt.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            try {
                Object o = evnt.getSource();
                if (o instanceof JEditorPane) {
                    ((JEditorPane)o).setPage(evnt.getURL());
                } else {
                    System.err.println("Not an JEditorPane: " + o);
                }
            }
            catch (IOException e) {
                System.err.println("Could not load " + evnt.getURL() + ": " + e);
            }
        }
    }
}

