/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import java.util.Comparator;

class Peak {
    private int x;
    private int y;
    private float value;
    private int aod;
    private double fit;
    private Peak parent;
    private int quadrant;
    private Peak[] children;

    public Peak(int x, int y, float value, int wImg, int hImg) {
        this.x = x;
        this.y = y;
        this.value = value;
        int dist = Math.min(wImg - Math.abs(x), hImg - Math.abs(y));
        this.aod = dist * dist;
        this.parent = null;
        this.quadrant = -1;
        this.children = new Peak[4];
    }

    public float getValue() {
        return this.value;
    }

    public float getValueDenormalized(int wImg, int hImg) {
        return this.value * (float)Math.max(1, wImg - Math.abs(this.x)) * (float)Math.max(1, hImg - Math.abs(this.y));
    }

    public int getAod() {
        return this.aod;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    private int getLengthSq() {
        return this.x * this.x + this.y * this.y;
    }

    public double getFit() {
        return this.fit;
    }

    public void setFit(double fit) {
        this.fit = fit;
    }

    public void addToTree(Peak root) {
        int q;
        Peak parent = root;
        while (true) {
            int d;
            if (this.aod > (d = this.distSq(parent))) {
                this.aod = d;
            }
            if (parent.children[q = this.quadrant(parent)] == null) break;
            parent = parent.children[q];
        }
        this.parent = parent;
        this.quadrant = q;
        int neighborInterest = 15;
        Peak ancestor = this.parent;
        while (ancestor != null) {
            int dx = this.distSq(this.x, ancestor.x);
            int dy = this.distSq(this.y, ancestor.y);
            boolean neighborExam = false;
            switch (q) {
                case 0: {
                    assert (this.x >= ancestor.x && this.y >= ancestor.y);
                    if (dx >= this.aod) {
                        neighborInterest &= 0xFFFFFFFE;
                    } else {
                        this.aodNeighbor(ancestor.children[1]);
                    }
                    if (dy >= this.aod) {
                        neighborInterest &= 0xFFFFFFFB;
                        break;
                    }
                    this.aodNeighbor(ancestor.children[2]);
                    break;
                }
                case 1: {
                    assert (this.x < ancestor.x && this.y >= ancestor.y);
                    if (dx >= this.aod) {
                        neighborInterest &= 0xFFFFFFFD;
                    } else {
                        this.aodNeighbor(ancestor.children[0]);
                    }
                    if (dy >= this.aod) {
                        neighborInterest &= 0xFFFFFFFB;
                        break;
                    }
                    this.aodNeighbor(ancestor.children[3]);
                    break;
                }
                case 2: {
                    assert (this.x >= ancestor.x && this.y < ancestor.y);
                    if (dx >= this.aod) {
                        neighborInterest &= 0xFFFFFFFE;
                    } else {
                        this.aodNeighbor(ancestor.children[3]);
                    }
                    if (dy >= this.aod) {
                        neighborInterest &= 0xFFFFFFF7;
                        break;
                    }
                    this.aodNeighbor(ancestor.children[0]);
                    break;
                }
                case 3: {
                    assert (this.x < ancestor.x && this.y < ancestor.y);
                    if (dx >= this.aod) {
                        neighborInterest &= 0xFFFFFFFD;
                    } else {
                        this.aodNeighbor(ancestor.children[2]);
                    }
                    if (dy >= this.aod) {
                        neighborInterest &= 0xFFFFFFF7;
                        break;
                    }
                    this.aodNeighbor(ancestor.children[1]);
                }
            }
            if (neighborInterest == 0) break;
            q = ancestor.quadrant;
            ancestor = ancestor.parent;
        }
        this.parent.children[this.quadrant] = this;
    }

    private void aodNeighbor(Peak peak) {
        int dy;
        if (peak == null || peak.value < this.value) {
            return;
        }
        int dx = this.distSq(this.x, peak.x);
        int d = dx + (dy = this.distSq(this.y, peak.y));
        if (this.aod > d) {
            this.aod = d;
        }
        int q = this.quadrant(peak);
        this.aodNeighbor(peak.children[q]);
        if (dx < this.aod) {
            this.aodNeighbor(peak.children[q ^ 1]);
        }
        if (dy < this.aod) {
            this.aodNeighbor(peak.children[q ^ 2]);
        }
    }

    private int distSq(Peak that) {
        int dx = this.x - that.x;
        int dy = this.y - that.y;
        return dx * dx + dy * dy;
    }

    private int distSq(int a, int b) {
        int d = a - b;
        return d * d;
    }

    private int quadrant(Peak parent) {
        return (this.x >= parent.x ? 0 : 1) | (this.y >= parent.y ? 0 : 2);
    }

    public static class AodComparator
    extends StaticComparator {
        public int compare(Object o1, Object o2) {
            int aod1 = ((Peak)o1).getAod();
            int aod2 = ((Peak)o2).getAod();
            return aod2 - aod1;
        }
    }

    public static class DenormalizedComparator
    implements Comparator {
        private int wImg;
        private int hImg;

        public DenormalizedComparator(int wImg, int hImg) {
            this.wImg = wImg;
            this.hImg = hImg;
        }

        public int compare(Object o1, Object o2) {
            return -Float.compare(((Peak)o1).getValueDenormalized(this.wImg, this.hImg), ((Peak)o2).getValueDenormalized(this.wImg, this.hImg));
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DenormalizedComparator that = (DenormalizedComparator)obj;
            return this.wImg == that.wImg && this.hImg == that.hImg;
        }

        public int hashCode() {
            return this.wImg ^ this.hImg << 16 ^ this.hImg >> 16 ^ this.getClass().hashCode();
        }
    }

    public static class DenormalizedProductComparator
    implements Comparator {
        private int wImg;
        private int hImg;

        public DenormalizedProductComparator(int wImg, int hImg) {
            this.wImg = wImg;
            this.hImg = hImg;
        }

        public int compare(Object o1, Object o2) {
            Peak p1 = (Peak)o1;
            Peak p2 = (Peak)o2;
            int aod1 = p1.getAod();
            int aod2 = p2.getAod();
            float v1 = p1.getValueDenormalized(this.wImg, this.hImg);
            float v2 = p2.getValueDenormalized(this.wImg, this.hImg);
            return -Float.compare((float)aod1 * v1, (float)aod2 * v2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DenormalizedComparator that = (DenormalizedComparator)obj;
            return this.wImg == that.wImg && this.hImg == that.hImg;
        }

        public int hashCode() {
            return this.wImg ^ this.hImg << 16 ^ this.hImg >> 16 ^ this.getClass().hashCode();
        }
    }

    public static class LengthComparator
    extends StaticComparator {
        public int compare(Object o1, Object o2) {
            int l1 = ((Peak)o1).getLengthSq();
            int l2 = ((Peak)o2).getLengthSq();
            return l1 - l2;
        }
    }

    public static class ProductComparator
    extends StaticComparator {
        public int compare(Object o1, Object o2) {
            Peak p1 = (Peak)o1;
            Peak p2 = (Peak)o2;
            int aod1 = p1.getAod();
            int aod2 = p2.getAod();
            float v1 = p1.getValue();
            float v2 = p2.getValue();
            return -Float.compare((float)aod1 * v1, (float)aod2 * v2);
        }
    }

    private static abstract class StaticComparator
    implements Comparator {
        private StaticComparator() {
        }

        @Override
        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public static class ValueComparator
    extends StaticComparator {
        public int compare(Object o1, Object o2) {
            return -Float.compare(((Peak)o1).getValue(), ((Peak)o2).getValue());
        }
    }
}

