/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.groups.Cm;
import de.tum.in.gagern.ornament.groups.Cmm;
import de.tum.in.gagern.ornament.groups.P1;
import de.tum.in.gagern.ornament.groups.P2;
import de.tum.in.gagern.ornament.groups.P3;
import de.tum.in.gagern.ornament.groups.P31m;
import de.tum.in.gagern.ornament.groups.P3m1;
import de.tum.in.gagern.ornament.groups.P4;
import de.tum.in.gagern.ornament.groups.P4gm;
import de.tum.in.gagern.ornament.groups.P4mm;
import de.tum.in.gagern.ornament.groups.P6;
import de.tum.in.gagern.ornament.groups.P6mm;
import de.tum.in.gagern.ornament.groups.Pg;
import de.tum.in.gagern.ornament.groups.Pgg;
import de.tum.in.gagern.ornament.groups.Pm;
import de.tum.in.gagern.ornament.groups.Pmg;
import de.tum.in.gagern.ornament.groups.Pmm;
import de.tum.in.gagern.ornament.recog.CanceledOperationException;
import de.tum.in.gagern.ornament.recog.Correlator;
import de.tum.in.gagern.ornament.recog.Peak;
import de.tum.in.gagern.ornament.recog.ProgressPhase;
import de.tum.in.gagern.ornament.recog.Recognizer;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import javax.swing.JOptionPane;

class FeatureInspector {
    private final AffineTransform tr = new AffineTransform();
    private final AffineTransform trv;
    private final AffineTransform scale;
    private final AffineTransform triInv;
    private final BufferedImage median;
    private final BufferedImage img1;
    private final BufferedImage img2;
    private final ProgressPhase[] progress;
    private final Correlator corr;
    private final float minimumValue;
    private final float valueScale;
    private final RenderingHints rh;
    private final boolean debug;
    private static final double[] R6 = new double[]{0.0, 1.0, -1.0, 1.0, 1.0, 0.0};
    private static final double[] R3 = new double[]{-1.0, 1.0, -1.0, 0.0, 1.0, 0.0};
    private static final double[] R4 = new double[]{0.0, 1.0, -1.0, 0.0, 1.0, 0.0};
    private static final double[] R2 = new double[]{-1.0, 0.0, 0.0, -1.0, 1.0, 1.0};
    private static final double[] Mab = new double[]{0.0, 1.0, 1.0, 0.0, 0.0, 0.0};
    private static final double[] Mba = new double[]{0.0, -1.0, -1.0, 0.0, 1.0, 1.0};
    private static final double[] Ma = new double[]{1.0, 0.0, 0.0, -1.0, 0.0, 1.0};
    private static final double[] Mb = new double[]{-1.0, 0.0, 0.0, 1.0, 1.0, 0.0};
    private static final double[] M3 = new double[]{1.0, 0.0, 1.0, -1.0, 0.0, 1.0};

    public FeatureInspector(BufferedImage median, AffineTransform tri, AffineTransform trv, ProgressPhase progressPhase, boolean debug) throws CanceledOperationException, NoninvertibleTransformException, IOException {
        this.median = median;
        this.trv = trv;
        this.debug = debug;
        this.progress = progressPhase.createPhases(9);
        this.progress[0].setNoticePrefix("Symmetry reference tile: ");
        ProgressPhase progressTransform = this.progress[0].createPhase(1.0f);
        ProgressPhase progressCorrelate = this.progress[0].createPhase(5.0f);
        ProgressPhase progressRemainder = this.progress[0].createPhase(1.0f);
        progressTransform.begin("preparing tile");
        double ax = tri.getScaleX();
        double ay = tri.getShearY();
        double bx = tri.getShearX();
        double by = tri.getScaleY();
        double sizeSq = Math.max(ax * ax + ay * ay, bx * bx + by * by);
        int size = (int)Math.round(Math.sqrt(sizeSq));
        this.corr = new Correlator(size, size, false);
        size = this.corr.getWidth();
        ColorModel cm = median.getColorModel();
        this.img1 = new BufferedImage(cm, cm.createCompatibleWritableRaster(size, size), true, null);
        this.img2 = new BufferedImage(cm, cm.createCompatibleWritableRaster(size, size), true, null);
        this.rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.scale = AffineTransform.getScaleInstance(size, size);
        this.triInv = tri.createInverse();
        this.tr.setTransform(this.scale);
        this.tr.concatenate(this.triInv);
        AffineTransformOp op = new AffineTransformOp(this.tr, this.rh);
        op.filter(median, this.img1);
        progressTransform.done();
        this.corr.autocorrelate(this.img1, progressCorrelate);
        progressRemainder.begin();
        float maximumValue = this.corr.getMaximum().getValue();
        this.minimumValue = this.corr.getMinimum().getValue();
        this.valueScale = 1.0f / (maximumValue - this.minimumValue);
        this.debugImg(this.img1, "debugSymIdentityTile");
        progressRemainder.done();
    }

    private void debugImg(BufferedImage img, String name) {
        if (!this.debug) {
            return;
        }
        Recognizer.debugImgImpl(img, name);
    }

    private boolean hasMirror(String name, double[] matrix, Point2D.Double pos, ProgressPhase progress) throws CanceledOperationException, NoninvertibleTransformException, IOException {
        progress.setNoticePrefix("Symmetry " + name + ": ");
        ProgressPhase progressTransform = progress.createPhase(1.0f);
        ProgressPhase progressCorrelate = progress.createPhase(5.0f);
        ProgressPhase progressCreateImg = progress.createPhase(2.0f);
        ProgressPhase progressRemainder = progress.createPhase(1.0f);
        progressTransform.begin("preparing tile");
        AffineTransform tr = new AffineTransform(this.scale);
        tr.concatenate(new AffineTransform(matrix));
        tr.concatenate(this.triInv);
        AffineTransformOp op = new AffineTransformOp(tr, this.rh);
        op.filter(this.median, this.img2);
        this.debugImg(this.img2, "debugSym_" + name + "_Tile");
        progressTransform.done();
        this.corr.correlate(this.img1, this.img2, progressCorrelate);
        BufferedImage acImg = this.corr.getDebugImage(true, true, 0.0f, 0.0f, progressCreateImg);
        this.debugImg(acImg, "debugSym_" + name + "_Ac");
        progressRemainder.begin();
        Peak peak = this.corr.getMaximum();
        float probability = (peak.getValue() - this.minimumValue) * this.valueScale;
        pos.setLocation(peak.getX(), peak.getY());
        this.scale.inverseTransform(pos, pos);
        return this.decide(name, probability, pos, progress);
    }

    private boolean decide(String name, float probability, Point2D.Double pos, ProgressPhase progress) throws CanceledOperationException {
        boolean decision = (double)probability > 0.75;
        System.err.println("Symmetry " + name + " with probability " + probability * 100.0f + "% at location " + pos.getX() + "/" + pos.getY() + " defaults to " + decision);
        Component parent = progress.getComponent();
        if (parent != null) {
            Object[] args = new Object[]{name, new Float(probability), new Integer(decision ? 1 : 0)};
            String msg = I18n._("recog.decide", args);
            int result = JOptionPane.showConfirmDialog(parent, msg, "Recognition", 1, 3);
            switch (result) {
                case 0: {
                    decision = true;
                    break;
                }
                case 1: {
                    decision = false;
                    break;
                }
                case 2: {
                    throw new CanceledOperationException();
                }
            }
        }
        return decision;
    }

    private boolean hasRotation(String name, double[] matrix, Point2D.Double pos, ProgressPhase progress) throws CanceledOperationException, NoninvertibleTransformException, IOException {
        if (!this.hasMirror(name, matrix, pos, progress)) {
            return false;
        }
        this.tr.setTransform(matrix[0] - 1.0, matrix[1], matrix[2], matrix[3] - 1.0, 0.0, 0.0);
        this.tr.inverseTransform(pos, pos);
        pos.x -= Math.floor(pos.x);
        pos.y -= Math.floor(pos.y);
        this.trv.translate(pos.x, pos.y);
        return true;
    }

    public Group decideInnerSymmetries() throws CanceledOperationException, NoninvertibleTransformException, IOException {
        Group group;
        Point2D.Double rPos = new Point2D.Double();
        Point2D.Double mPos = new Point2D.Double();
        if (this.hasRotation(I18n._("recog.R6"), R6, rPos, this.progress[1])) {
            group = this.hasMirror(I18n._("recog.Mab"), Mab, mPos, this.progress[4]) ? new P6mm() : new P6();
        } else if (this.hasRotation(I18n._("recog.R3"), R3, rPos, this.progress[2])) {
            if (this.hasMirror(I18n._("recog.Mab"), Mab, mPos, this.progress[4])) {
                group = new P3m1();
            } else if (this.hasMirror(I18n._("recog.M3"), M3, mPos, this.progress[6])) {
                double x = -mPos.getX() - 2.0 * rPos.getX() - rPos.getY();
                double y = -mPos.getY() - rPos.getY() + rPos.getX();
                if ((x -= Math.floor(x)) + (y -= Math.floor(y)) > 0.3333333333333333 && x + y < 0.5 && x < 0.6666666666666666 && y < 0.6666666666666666) {
                    this.trv.translate(0.6666666666666666, 0.6666666666666666);
                } else if (x + y < 0.6666666666666666 && x + y >= 0.5 && x > 0.3333333333333333 && y > 0.3333333333333333) {
                    this.trv.translate(0.3333333333333333, 0.3333333333333333);
                }
                group = new P31m();
            } else {
                group = new P3();
            }
        } else if (this.hasRotation(I18n._("recog.R4"), R4, rPos, this.progress[3])) {
            if (this.hasMirror(I18n._("recog.Mab"), Mab, mPos, this.progress[6])) {
                double rd = rPos.getX() - rPos.getY();
                double x = -mPos.getX() + rd;
                double y = -mPos.getY() - rd;
                if ((x -= Math.floor(x)) + (y -= Math.floor(y)) < 0.5 || x + y > 1.5 || x - y > 0.5 || y - x > 0.5) {
                    group = new P4mm();
                } else {
                    group = new P4gm();
                    this.trv.translate(0.5, 0.0);
                }
            } else {
                group = new P4();
            }
        } else if (this.hasRotation(I18n._("recog.R2"), R2, rPos, this.progress[4])) {
            if (this.hasMirror(I18n._("recog.Mab"), Mab, mPos, this.progress[6])) {
                double x = -mPos.getX() - 2.0 * rPos.getX();
                double y = -mPos.getY() - 2.0 * rPos.getY();
                if ((x -= Math.floor(x)) + (y -= Math.floor(y)) > 0.5 && x + y < 1.5 && x - y < 0.5 && y - x < 0.5) {
                    this.trv.translate(0.0, 0.0);
                } else {
                    this.trv.translate(0.5, 0.0);
                }
                group = new Cmm();
            } else if (this.hasMirror(I18n._("recog.Ma"), Ma, mPos, this.progress[7])) {
                double x = -mPos.getX() + 0.25;
                double y = -mPos.getY() - 2.0 * rPos.getY() + 0.25;
                x -= Math.floor(x);
                y -= Math.floor(y);
                if (x < 0.5) {
                    if (y < 0.5) {
                        group = new Pmm();
                    } else {
                        group = new Pmg();
                        this.trv.translate(0.0, 0.25);
                    }
                } else if (y < 0.5) {
                    group = new Pmg();
                    this.trv.concatenate(new AffineTransform(0.0, 1.0, 1.0, 0.0, 0.25, 0.0));
                } else {
                    group = new Pgg();
                }
            } else {
                group = new P2();
            }
        } else if (this.hasMirror(I18n._("recog.Mab"), Mab, mPos, this.progress[5])) {
            group = new Cm();
        } else if (this.hasMirror(I18n._("recog.Mba"), Mba, mPos, this.progress[6])) {
            group = new Cm();
            this.trv.concatenate(new AffineTransform(0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f));
        } else if (this.hasMirror(I18n._("recog.Ma"), Ma, mPos, this.progress[7])) {
            double x = -mPos.getX() + 0.25;
            double y = -mPos.getY() / 2.0;
            x -= Math.floor(x);
            y -= Math.floor(y);
            this.trv.translate(0.0, y);
            group = x < 0.5 ? new Pm() : new Pg();
        } else if (this.hasMirror(I18n._("recog.Mb"), Mb, mPos, this.progress[8])) {
            double x = -mPos.getX() / 2.0;
            double y = -mPos.getY() + 0.25;
            x -= Math.floor(x);
            y -= Math.floor(y);
            this.trv.concatenate(new AffineTransform(0.0, 1.0, 1.0, 0.0, x, 0.0));
            group = y < 0.5 ? new Pm() : new Pg();
        } else {
            group = new P1();
        }
        this.progress[this.progress.length - 1].done();
        return group;
    }
}

