/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.recog.CanceledOperationException;
import de.tum.in.gagern.ornament.recog.Peak;
import de.tum.in.gagern.ornament.recog.ProgressPhase;
import de.tum.in.gagern.ornament.recog.RecognitionException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Correlator {
    private static final int tileBits = 5;
    private static final int tileSize = 32;
    private static final int tileMask = 31;
    private static final int tileArea = 1024;
    private static final boolean doSymmetricColors = false;
    private final boolean auto;
    private final int wBits;
    private final int hBits;
    private final int wFFT;
    private final int hFFT;
    private final float[] tileArray;
    private final float[] omegas;
    private final float[] realArray;
    private final float[] imagArray;
    private final float[] realArray2;
    private final float[] imagArray2;
    private final FloatBuffer accuBuf;
    private final FloatBuffer realBuf1;
    private final FloatBuffer imagBuf1;
    private final FloatBuffer realBuf2;
    private final FloatBuffer imagBuf2;
    private final int[] xBitrev;
    private final int[] yBitrev;
    private int wImg;
    private int hImg;
    private static final int peakGridShift = 8;

    public Correlator(int width, int height, boolean auto) throws IOException {
        this.wBits = Math.max(Correlator.numBits(width), 5);
        this.hBits = Math.max(Correlator.numBits(height), 5);
        this.auto = auto;
        if (this.wBits < 5 || this.hBits < 5) {
            throw new IllegalArgumentException("FFT data sizes too small");
        }
        if (this.wBits + this.hBits > 30) {
            throw new IllegalArgumentException("FFT data sizes too large");
        }
        this.wFFT = 1 << this.wBits;
        this.hFFT = 1 << this.hBits;
        int maxFFT = Math.max(this.wFFT, this.hFFT);
        this.tileArray = new float[1024];
        this.realArray = new float[maxFFT];
        this.imagArray = new float[maxFFT];
        if (auto) {
            this.realArray2 = null;
            this.imagArray2 = null;
        } else {
            this.realArray2 = new float[maxFFT];
            this.imagArray2 = new float[maxFFT];
        }
        this.omegas = new float[maxFFT];
        int i = 0;
        while (i < this.omegas.length) {
            double angle = Math.PI * (double)i / (double)this.omegas.length;
            this.omegas[i] = (float)Math.cos(angle);
            this.omegas[i + 1] = (float)Math.sin(angle);
            i += 2;
        }
        this.xBitrev = Correlator.bitrevArray(this.wBits);
        this.yBitrev = Correlator.bitrevArray(this.hBits);
        File tmpFile = File.createTempFile("orna", null);
        tmpFile.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(tmpFile, "rw");
        long bufSize = 4L * (long)this.wFFT * (long)this.hFFT;
        raf.setLength((long)(auto ? 3 : 5) * bufSize);
        FileChannel chan = raf.getChannel();
        this.accuBuf = this.createBuf(chan, 0L, bufSize);
        this.realBuf1 = this.createBuf(chan, bufSize, bufSize);
        this.imagBuf1 = this.createBuf(chan, 2L * bufSize, bufSize);
        if (auto) {
            this.realBuf2 = null;
            this.imagBuf2 = null;
        } else {
            this.realBuf2 = this.createBuf(chan, 3L * bufSize, bufSize);
            this.imagBuf2 = this.createBuf(chan, 4L * bufSize, bufSize);
        }
        chan.close();
    }

    private FloatBuffer createBuf(FileChannel chan, long position, long size) throws IOException {
        MappedByteBuffer byteBuf = chan.map(FileChannel.MapMode.READ_WRITE, position, size);
        byteBuf.order(ByteOrder.nativeOrder());
        return byteBuf.asFloatBuffer();
    }

    public void correlate(BufferedImage img1, BufferedImage img2, ProgressPhase progress) throws CanceledOperationException {
        if (this.auto) {
            throw new IllegalArgumentException("autocorrelations only");
        }
        int numBands = img1.getSampleModel().getNumBands();
        if (img2.getSampleModel().getNumBands() != numBands) {
            throw new IllegalArgumentException("different number of bands");
        }
        ProgressPhase[] progressBands = new ProgressPhase[numBands];
        int band = 0;
        while (band < numBands) {
            progressBands[band] = progress.createPhase(1.0f);
            ++band;
        }
        this.wImg = Math.max(img1.getWidth(), img2.getWidth());
        this.hImg = Math.max(img1.getHeight(), img2.getHeight());
        progress.begin();
        this.zero(this.accuBuf);
        band = 0;
        while (band < numBands) {
            ProgressPhase progressBand = progressBands[band];
            ProgressPhase progressRead1 = progressBand.createPhase(1.0f);
            ProgressPhase progressRead2 = progressBand.createPhase(1.0f);
            ProgressPhase progressFFT1 = progressBand.createPhase(10.0f);
            ProgressPhase progressFFT2 = progressBand.createPhase(10.0f);
            ProgressPhase progressMult = progressBand.createPhase(4.0f);
            ProgressPhase progressIFFT = progressBand.createPhase(10.0f);
            ProgressPhase progressAccu = progressBand.createPhase(3.0f);
            progressBand.setNoticeSuffix(" band " + (band + 1));
            progressRead1.setNoticeSuffix(" image 1");
            progressRead2.setNoticeSuffix(" image 2");
            progressFFT1.setNoticeSuffix(" image 1");
            progressFFT2.setNoticeSuffix(" image 2");
            this.read(img1, band, this.realBuf1, this.imagBuf1, progressRead1);
            this.read(img2, band, this.realBuf2, this.imagBuf2, progressRead2);
            this.fft2D(this.realBuf1, this.imagBuf1, false, progressFFT1);
            this.fft2D(this.realBuf2, this.imagBuf2, false, progressFFT2);
            this.multiply(progressMult);
            this.fft2D(this.realBuf1, this.imagBuf1, true, progressIFFT);
            this.accumulate(progressAccu);
            ++band;
        }
        progress.done();
    }

    public void autocorrelate(BufferedImage img, ProgressPhase progress) throws CanceledOperationException {
        int numBands = img.getSampleModel().getNumBands();
        ProgressPhase[] progressBands = new ProgressPhase[numBands];
        int band = 0;
        while (band < numBands) {
            progressBands[band] = progress.createPhase(1.0f);
            ++band;
        }
        this.wImg = img.getWidth();
        this.hImg = img.getHeight();
        progress.begin();
        this.zero(this.accuBuf);
        band = 0;
        while (band < numBands) {
            ProgressPhase progressBand = progressBands[band];
            ProgressPhase progressRead = progressBand.createPhase(1.0f);
            ProgressPhase progressFFT = progressBand.createPhase(10.0f);
            ProgressPhase progressMult = progressBand.createPhase(3.0f);
            ProgressPhase progressIFFT = progressBand.createPhase(10.0f);
            ProgressPhase progressAccu = progressBand.createPhase(3.0f);
            progressBand.setNoticeSuffix(" band " + (band + 1));
            progressBand.begin();
            this.read(img, band, this.realBuf1, this.imagBuf1, progressRead);
            this.fft2D(this.realBuf1, this.imagBuf1, false, progressFFT);
            this.multiplyAuto(progressMult);
            this.fft2D(this.realBuf1, this.imagBuf1, true, progressIFFT);
            this.accumulate(progressAccu);
            progressBand.done();
            ++band;
        }
        progress.done();
    }

    private void read(BufferedImage img, int band, FloatBuffer realBuf, FloatBuffer imagBuf, ProgressPhase progress) throws CanceledOperationException {
        int wImg = img.getWidth();
        int hImg = img.getHeight();
        if (wImg > this.wFFT || hImg > this.hFFT) {
            throw new IllegalArgumentException("image too large");
        }
        progress.begin("reading", Correlator.numTiles(wImg) * Correlator.numTiles(hImg));
        WritableRaster raster = img.getRaster();
        this.zero(realBuf);
        this.zero(imagBuf);
        int y = 0;
        while (y < hImg) {
            realBuf.position(y * this.wFFT);
            int x = 0;
            while (x < wImg) {
                int w = wImg - x;
                int h = hImg - y;
                if (h >= 32) {
                    h = 32;
                } else {
                    Correlator.zero(this.tileArray);
                }
                if (w >= 32) {
                    w = 32;
                }
                raster.getSamples(x, y, w, h, band, this.tileArray);
                if (w < 32) {
                    int pFrom = h * w;
                    int pTo = h * 32;
                    while (pTo > 0) {
                        int x2 = w;
                        while (x2 < 32) {
                            this.tileArray[--pTo] = 0.0f;
                            ++x2;
                        }
                        x2 = 0;
                        while (x2 < w) {
                            this.tileArray[--pTo] = this.tileArray[--pFrom];
                            ++x2;
                        }
                    }
                }
                realBuf.put(this.tileArray);
                progress.step();
                x += 32;
            }
            y += 32;
        }
        progress.done();
    }

    private void multiply(ProgressPhase progress) throws CanceledOperationException {
        progress.begin("combining", this.realBuf1.limit() / this.realArray.length);
        this.realBuf1.rewind();
        this.imagBuf1.rewind();
        this.realBuf2.rewind();
        this.imagBuf2.rewind();
        while (this.realBuf1.hasRemaining()) {
            this.realBuf1.mark();
            this.imagBuf1.mark();
            this.realBuf1.get(this.realArray);
            this.imagBuf1.get(this.imagArray);
            this.realBuf2.get(this.realArray2);
            this.imagBuf2.get(this.imagArray2);
            int i = 0;
            while (i < this.realArray.length) {
                float real1 = this.realArray[i];
                float imag1 = this.imagArray[i];
                float real2 = this.realArray2[i];
                float imag2 = this.imagArray2[i];
                this.realArray[i] = real1 * real2 + imag1 * imag2;
                this.imagArray[i] = real1 * imag2 - real2 * imag1;
                ++i;
            }
            this.realBuf1.reset();
            this.realBuf1.put(this.realArray);
            this.imagBuf1.reset();
            this.imagBuf1.put(this.imagArray);
            progress.step();
        }
        progress.done();
    }

    private void multiplyAuto(ProgressPhase progress) throws CanceledOperationException {
        progress.begin("multiplying", this.realBuf1.limit() / this.realArray.length);
        this.realBuf1.rewind();
        this.imagBuf1.rewind();
        while (this.realBuf1.hasRemaining()) {
            this.realBuf1.mark();
            this.realBuf1.get(this.realArray);
            this.imagBuf1.get(this.imagArray);
            int i = 0;
            while (i < this.realArray.length) {
                float real = this.realArray[i];
                float imag = this.imagArray[i];
                this.realArray[i] = real * real + imag * imag;
                ++i;
            }
            this.realBuf1.reset();
            this.realBuf1.put(this.realArray);
            progress.step();
        }
        this.zero(this.imagBuf1);
        progress.done();
    }

    private void accumulate(ProgressPhase progress) throws CanceledOperationException {
        progress.begin("accumulating", this.accuBuf.limit() / this.realArray.length);
        this.accuBuf.rewind();
        this.realBuf1.rewind();
        while (this.accuBuf.hasRemaining()) {
            this.accuBuf.mark();
            this.accuBuf.get(this.imagArray);
            this.realBuf1.get(this.realArray);
            int i = 0;
            while (i < this.realArray.length) {
                int n = i;
                this.imagArray[n] = this.imagArray[n] + this.realArray[i];
                ++i;
            }
            this.accuBuf.reset();
            this.accuBuf.put(this.imagArray);
            progress.step();
        }
        progress.done();
    }

    private void fft2D(FloatBuffer realBuf, FloatBuffer imagBuf, boolean inverse, ProgressPhase progress) throws CanceledOperationException {
        ProgressPhase progress1 = progress.createPhase(1.0f);
        ProgressPhase progress2 = progress.createPhase(1.0f);
        progress.begin(inverse ? "inverse transforming" : "transforming");
        this.fft2Dim1Dir(realBuf, imagBuf, this.wFFT, 5, 0, this.hFFT, this.wBits, 5, this.hBits, this.yBitrev, inverse, progress1);
        this.fft2Dim1Dir(realBuf, imagBuf, this.hFFT, this.wBits, 5, this.wFFT, 5, 0, this.wBits, this.xBitrev, inverse, progress2);
        progress.done();
    }

    private void fft2Dim1Dir(FloatBuffer realBuf, FloatBuffer imagBuf, int aCount, int aHigh, int aLow, int bCount, int bHigh, int bLow, int bBits, int[] bitrev, boolean inverse, ProgressPhase progress) throws CanceledOperationException {
        progress.begin(aCount);
        int a = 0;
        while (a < aCount) {
            int pos;
            int aPos = (a & 0xFFFFFFE0) << aHigh | (a & 0x1F) << aLow;
            int b = 0;
            while (b < bCount) {
                pos = (b & 0xFFFFFFE0) << bHigh | (b & 0x1F) << bLow | aPos;
                this.realArray[bitrev[b]] = realBuf.get(pos);
                this.imagArray[bitrev[b]] = imagBuf.get(pos);
                ++b;
            }
            this.fft1D(bBits, inverse);
            b = 0;
            while (b < bCount) {
                pos = (b & 0xFFFFFFE0) << bHigh | (b & 0x1F) << bLow | aPos;
                realBuf.put(pos, this.realArray[b]);
                imagBuf.put(pos, this.imagArray[b]);
                ++b;
            }
            progress.step();
            ++a;
        }
        progress.done();
    }

    private void fft1D(int bits, boolean inverse) {
        int count = 1 << bits;
        int bitPower = 1;
        int omegaStep = this.omegas.length;
        int bit = 0;
        while (bit < bits) {
            int omegaIndex = 0;
            int omegaPower = 0;
            while (omegaPower < bitPower) {
                float omegaReal = this.omegas[omegaIndex];
                float omegaImag = this.omegas[omegaIndex + 1] * (inverse ? -1.0f : 1.0f);
                int i = omegaPower;
                while (i < count) {
                    int j = i + bitPower;
                    float evenReal = this.realArray[i];
                    float oddReal = this.realArray[j];
                    float evenImag = this.imagArray[i];
                    float oddImag = this.imagArray[j];
                    float deltaReal = oddReal * omegaReal - oddImag * omegaImag;
                    float deltaImag = oddImag * omegaReal + oddReal * omegaImag;
                    this.realArray[j] = evenReal - deltaReal;
                    this.realArray[i] = evenReal + deltaReal;
                    this.imagArray[j] = evenImag - deltaImag;
                    this.imagArray[i] = evenImag + deltaImag;
                    i = j + bitPower;
                }
                omegaIndex += omegaStep;
                ++omegaPower;
            }
            bitPower <<= 1;
            omegaStep >>= 1;
            ++bit;
        }
    }

    private static int numBits(int n) {
        int bits = 0;
        while (1 << bits < n) {
            ++bits;
        }
        return bits;
    }

    private static int[] bitrevArray(int bits) {
        int[] a = new int[1 << bits];
        int i = 0;
        while (i < a.length) {
            int in = i;
            int out = 0;
            int k = 0;
            while (k < bits) {
                out = out << 1 | in & 1;
                in >>= 1;
                ++k;
            }
            a[i] = out;
            ++i;
        }
        return a;
    }

    private static void zero(float[] array) {
        Arrays.fill(array, 0.0f);
    }

    private void zero(FloatBuffer buf) {
        Correlator.zero(this.tileArray);
        buf.clear();
        while (buf.hasRemaining()) {
            buf.put(this.tileArray);
        }
        buf.clear();
    }

    private static int roundUpToTileSize(int i) {
        return (i - 1 | 0x1F) + 1;
    }

    private static int numTiles(int i) {
        return (i - 1) / 32 + 1;
    }

    public BufferedImage getDebugImage(boolean gray, boolean fullArea, float blackPoint, float whitePoint, ProgressPhase progress) throws CanceledOperationException {
        int wRes = Correlator.roundUpToTileSize(this.wImg);
        int hRes = Correlator.roundUpToTileSize(this.hImg);
        if (fullArea) {
            wRes = this.wFFT / 2;
            hRes = this.hFFT / 2;
        }
        if (progress != null) {
            progress.begin("creating debug image", 4 * wRes * hRes / 1024);
        }
        int mode = gray ? 10 : 1;
        BufferedImage res = new BufferedImage(2 * wRes, 2 * hRes, mode);
        if (whitePoint <= 0.0f) {
            progress.setMaximum(8 * wRes * hRes / 1024);
            blackPoint = Float.POSITIVE_INFINITY;
            int yRes = 0;
            while (yRes < 2 * hRes) {
                int yPos = (yRes + this.hFFT - hRes) % this.hFFT << this.wBits;
                int xRes = 0;
                while (xRes < 2 * wRes) {
                    int pos = yPos | (xRes + this.wFFT - wRes) % this.wFFT << 5;
                    this.accuBuf.position(pos);
                    this.accuBuf.get(this.tileArray);
                    int i = 0;
                    while (i < this.tileArray.length) {
                        if (whitePoint < this.tileArray[i]) {
                            whitePoint = this.tileArray[i];
                        }
                        if (blackPoint > this.tileArray[i]) {
                            blackPoint = this.tileArray[i];
                        }
                        ++i;
                    }
                    progress.step();
                    xRes += 32;
                }
                yRes += 32;
            }
        } else if (blackPoint < 0.0f) {
            blackPoint = 0.0f;
        }
        float scale = 1.0f / (whitePoint - blackPoint);
        int[] intArray = new int[1024];
        int yRes = 0;
        while (yRes < 2 * hRes) {
            int yPos = (yRes + this.hFFT - hRes) % this.hFFT << this.wBits;
            int xRes = 0;
            while (xRes < 2 * wRes) {
                int pos = yPos | (xRes + this.wFFT - wRes) % this.wFFT << 5;
                this.accuBuf.position(pos);
                this.accuBuf.get(this.tileArray);
                int i = 0;
                while (i < this.tileArray.length) {
                    float level = scale * (this.tileArray[i] - blackPoint);
                    if (level < 0.0f) {
                        level = 0.0f;
                    }
                    if (level > 1.0f) {
                        level = 1.0f;
                    }
                    intArray[i] = gray ? Color.HSBtoRGB(0.0f, 0.0f, level) : Color.HSBtoRGB(0.6666667f * (1.0f - level), 1.0f, 0.3f + 0.7f * level);
                    ++i;
                }
                res.setRGB(xRes, yRes, 32, 32, intArray, 0, 32);
                if (progress != null) {
                    progress.step();
                }
                xRes += 32;
            }
            yRes += 32;
        }
        if (!fullArea) {
            res = res.getSubimage(1 + wRes - this.wImg, 1 + hRes - this.hImg, this.wImg * 2 - 1, this.hImg * 2 - 1);
        }
        if (progress != null) {
            progress.done();
        }
        return res;
    }

    public float normalize() {
        float minValue = Float.POSITIVE_INFINITY;
        int wRound = Correlator.roundUpToTileSize(this.wImg);
        int hRound = Correlator.roundUpToTileSize(this.hImg);
        int y1 = -hRound;
        while (y1 < this.hImg) {
            int yPos = (y1 + this.hFFT) % this.hFFT << this.wBits;
            int x1 = -wRound;
            while (x1 < this.wImg) {
                int pos = yPos | (x1 + this.wFFT) % this.wFFT << 5;
                this.accuBuf.position(pos);
                this.accuBuf.get(this.tileArray);
                int index = 0;
                int y2 = 0;
                while (y2 < 32) {
                    int y = y1 + y2;
                    y = this.hImg + (y < 0 ? y : -y);
                    if (y <= 0) {
                        y = 1;
                    }
                    int x2 = 0;
                    while (x2 < 32) {
                        int x = x1 + x2;
                        x = this.wImg + (x < 0 ? x : -x);
                        float value = this.tileArray[index] / (float)(x * y);
                        if (x <= 0 || y <= 0) {
                            value = 0.0f;
                        } else if (minValue > value) {
                            minValue = value;
                        }
                        this.tileArray[index] = value;
                        ++index;
                        ++x2;
                    }
                    ++y2;
                }
                this.accuBuf.position(pos);
                this.accuBuf.put(this.tileArray);
                x1 += 32;
            }
            y1 += 32;
        }
        return minValue;
    }

    public List extractPeaks(float threshold, ProgressPhase progress) throws CanceledOperationException, RecognitionException {
        progress.begin("extracting peaks", Correlator.numTiles(this.wImg) * Correlator.numTiles(this.hImg) * 4);
        int gridBits = Math.max(this.wBits, this.hBits) - 8;
        if (gridBits < 0) {
            gridBits = 0;
        }
        if (gridBits > 5) {
            gridBits = 5;
        }
        int gridSize = 1 << gridBits;
        System.err.println("gridSize = " + gridSize);
        int wRound = Correlator.roundUpToTileSize(this.wImg);
        int hRound = Correlator.roundUpToTileSize(this.hImg);
        ArrayList<Peak> peaks = new ArrayList<Peak>();
        int y1 = -hRound;
        while (y1 < this.hImg) {
            int yPos = (y1 + this.hFFT) % this.hFFT << this.wBits;
            int x1 = -wRound;
            while (x1 < this.wImg) {
                int pos = yPos | (x1 + this.wFFT) % this.wFFT << 5;
                this.accuBuf.position(pos);
                this.accuBuf.get(this.tileArray);
                int y2 = 0;
                while (y2 < 32) {
                    int x2 = 0;
                    while (x2 < 32) {
                        int pos2 = y2 << 5 | x2;
                        float maxValue = threshold;
                        int maxX = 0;
                        int maxY = 0;
                        int y3 = 0;
                        while (y3 < gridSize) {
                            int pos3 = pos2 | y3 << 5;
                            int x3 = 0;
                            while (x3 < gridSize) {
                                float value = this.tileArray[pos3 + x3];
                                if (!(maxValue >= value)) {
                                    maxValue = value;
                                    maxX = x3;
                                    maxY = y3;
                                }
                                ++x3;
                            }
                            ++y3;
                        }
                        if (maxValue != threshold) {
                            int px = x1 + x2 + maxX;
                            int py = y1 + y2 + maxY;
                            if (Math.abs(px) < this.wImg && Math.abs(py) < this.hImg) {
                                peaks.add(new Peak(px, py, maxValue, this.wImg, this.hImg));
                            }
                        }
                        x2 += gridSize;
                    }
                    y2 += gridSize;
                }
                progress.step();
                x1 += 32;
            }
            y1 += 32;
        }
        progress.done();
        return peaks;
    }

    public Peak getMaximum() {
        return this.getExtremum(1.0f);
    }

    public Peak getMinimum() {
        return this.getExtremum(-1.0f);
    }

    private Peak getExtremum(float direction) {
        float bestValue = Float.NEGATIVE_INFINITY;
        int bestX = 0;
        int bestY = 0;
        this.accuBuf.rewind();
        int y1 = 0;
        while (y1 < this.hFFT) {
            int x1 = 0;
            while (x1 < this.wFFT) {
                this.accuBuf.get(this.tileArray);
                int i = 0;
                while (i < 1024) {
                    float value = this.tileArray[i] * direction;
                    if (!(bestValue >= value)) {
                        int x = x1 + (i & 0x1F);
                        int y = y1 + (i >> 5);
                        if (x >= this.wImg) {
                            x -= this.wFFT;
                        }
                        if (y >= this.hImg) {
                            y -= this.hFFT;
                        }
                        if (-x < this.wImg && -y < this.hImg) {
                            bestValue = value;
                            bestX = x;
                            bestY = y;
                        }
                    }
                    ++i;
                }
                x1 += 32;
            }
            y1 += 32;
        }
        return new Peak(bestX, bestY, bestValue / direction, this.wImg, this.hImg);
    }

    public float getAcMaximum() {
        return this.accuBuf.get(0);
    }

    public int getWidth() {
        return this.wFFT;
    }

    public int getHeight() {
        return this.hFFT;
    }
}

