/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.Export;
import de.tum.in.gagern.ornament.export.ExportMechanism;
import java.awt.geom.NoninvertibleTransformException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AccessControlException;
import javax.jnlp.FileSaveService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JOptionPane;

public class ServiceExportMechanism
extends ExportMechanism {
    private FileSaveService fss;
    private AccessControlException prevExn;

    public ServiceExportMechanism(Ornament main, AccessControlException prevExn) {
        super(main);
        this.prevExn = prevExn;
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            this.fss = (FileSaveService)ServiceManager.lookup(FileSaveService.class.getName());
            return true;
        }
        catch (UnavailableServiceException e) {
            Object[] args = new Object[]{this.prevExn.getLocalizedMessage(), e.getLocalizedMessage(), this.prevExn.toString(), e.toString()};
            JOptionPane.showMessageDialog(this.main, I18n._("File save service unavailable", args), I18n._("Export"), 0);
            return false;
        }
    }

    @Override
    public void export() {
        Export export = this.chooseExport();
        if (export == null) {
            return;
        }
        if (!export.configure()) {
            return;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            export.export(os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            this.fss.saveFileDialog(null, export.getExtensions(), is, null);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Export"), 0);
        }
        catch (NoninvertibleTransformException ex) {
            JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Export"), 0);
        }
    }

    private Export chooseExport() {
        return (Export)JOptionPane.showInputDialog(this.main, I18n._("Choose file format"), I18n._("Export"), 3, null, this.exports, this.exports[0]);
    }
}

