/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.geom.Vec3R;
import de.tum.in.gagern.ornament.AngleCmp;
import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.MinGrid;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Voronoi {
    private static final double ALMOST_ZERO = 0.001;
    private Group group = null;
    private Point2D.Double controlPoint = new Point2D.Double(1.0, 1.0);
    private int ax;
    private int ay;
    private int bx;
    private int by;
    private AffineTransform vectorTransform = new AffineTransform();
    private List cell = new ArrayList();
    protected GeneralPath grid = new GeneralPath();
    private GeneralPath compactGrid = new GeneralPath();

    public Voronoi set(Group group, int ax, int ay, int bx, int by) {
        if (group != this.group || ax != this.ay || ay != this.ay || bx != this.bx || by != this.by) {
            this.group = group;
            this.controlPoint.setLocation(this.controlPoint);
            this.ax = ax;
            this.ay = ay;
            this.bx = bx;
            this.by = by;
            this.vectorTransform.setTransform(ax, ay, bx, by, 0.0, 0.0);
            this.recreate();
        }
        return this;
    }

    public Point2D getControlPoint() {
        return this.controlPoint;
    }

    public void recreate() {
        if (this.group == null) {
            this.cell.clear();
            this.grid.reset();
            this.compactGrid.reset();
            return;
        }
        try {
            if (this.controlPoint.x > 1.0) {
                this.controlPoint.x = 1.0;
            }
            if (this.controlPoint.x < 0.0) {
                this.controlPoint.x = 0.0;
            }
            if (this.controlPoint.y > 1.0) {
                this.controlPoint.y = 1.0;
            }
            if (this.controlPoint.y < 0.0) {
                this.controlPoint.y = 0.0;
            }
            this.createCell();
            this.createGrid();
            this.createCompactGrid();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
    }

    private void debug(String msg) {
    }

    private void createCell() throws NoninvertibleTransformException {
        MinGrid minGrid = new MinGrid(this.ax, this.ay, this.bx, this.by);
        this.debug("Minimum grid: " + minGrid);
        Point2D.Double controlAB = new Point2D.Double();
        Point2D.Double controlXY = new Point2D.Double();
        Point2D.Double image = new Point2D.Double();
        controlAB.setLocation(this.group.sensibleVoronoiPoint(this.controlPoint, this.vectorTransform));
        double minDist = 1.0E-10;
        while (true) {
            this.floor(controlAB);
            Point2D nearestImage = null;
            int i = 1;
            while (i < this.group.countTransforms()) {
                AffineTransform trafo = this.group.getTransform(i);
                trafo.transform(controlAB, image);
                double da = ((Point2D)controlAB).getX() - ((Point2D)image).getX();
                double db = ((Point2D)controlAB).getY() - ((Point2D)image).getY();
                da -= (double)Math.round(da);
                db -= (double)Math.round(db);
                double dist = da * da + db * db;
                if (!(minDist < dist)) {
                    minDist = dist;
                    nearestImage = new Point2D.Double(((Point2D)image).getX(), ((Point2D)image).getY());
                }
                ++i;
            }
            if (nearestImage == null) break;
            this.debug("control = " + controlAB + ", nearest = " + nearestImage);
            double da = ((Point2D)controlAB).getX() - nearestImage.getX();
            double db = ((Point2D)controlAB).getY() - nearestImage.getY();
            double dl = da * da + db * db;
            if (dl == 0.0) {
                ((Point2D)controlAB).setLocation(((Point2D)controlAB).getX() + 0.00123, ((Point2D)controlAB).getY() + 0.00234);
                continue;
            }
            ((Point2D)controlAB).setLocation(nearestImage.getX() + da / dl * 0.001, nearestImage.getY() + db / dl * 0.001);
        }
        this.vectorTransform.transform(controlAB, controlXY);
        AffineTransform translate = AffineTransform.getTranslateInstance(((Point2D)controlXY).getX(), ((Point2D)controlXY).getY());
        int da = Math.max(Math.max(Math.abs(minGrid.getA1()), Math.abs(minGrid.getA2())), Math.abs(minGrid.getA1() - minGrid.getA2()));
        int db = Math.max(Math.max(Math.abs(minGrid.getB1()), Math.abs(minGrid.getB2())), Math.abs(minGrid.getB1() - minGrid.getB2()));
        this.debug("Loop bounds: da = " + da + ", db = " + db);
        ArrayList<Point2D.Double> sites = new ArrayList<Point2D.Double>(this.group.countTransforms() * (2 * da + 1) * (2 * db + 1));
        int i = 0;
        while (i < this.group.countTransforms()) {
            AffineTransform trafo = this.group.getTransform(i);
            trafo.transform(controlAB, image);
            this.floor(image);
            int ai = -da;
            while (ai <= da) {
                int bi = -db;
                while (bi <= db) {
                    if (i != 0 || ai != 0 || bi != 0) {
                        Point2D.Double site = new Point2D.Double(((Point2D)image).getX() + (double)ai, ((Point2D)image).getY() + (double)bi);
                        this.vectorTransform.transform(site, site);
                        translate.inverseTransform(site, site);
                        this.debug("Site: " + ((Point2D)site).getX() + ", " + ((Point2D)site).getY());
                        sites.add(site);
                    }
                    ++bi;
                }
                ++ai;
            }
            ++i;
        }
        Collections.sort(sites, new AngleCmp());
        minDist = Double.POSITIVE_INFINITY;
        int n = sites.size();
        int i0 = -1;
        ArrayList<Vec3R> v = new ArrayList<Vec3R>(6);
        int i2 = 0;
        while (i2 < sites.size()) {
            double dist = ((Point2D)sites.get(i2)).distanceSq(0.0, 0.0);
            if (!(minDist <= dist)) {
                minDist = dist;
                i0 = i2;
            }
            ++i2;
        }
        int i1 = i0;
        int i22 = -1;
        while (i22 != i0) {
            Point2D p1 = (Point2D)sites.get(i1);
            double p1x = p1.getX();
            double p1y = p1.getY();
            v.add(new Vec3R(-2.0 * p1x, -2.0 * p1y, p1x * p1x + p1y * p1y));
            this.debug("Vertex cell neighbour: " + p1x + ", " + p1y);
            i22 = (i1 + 1) % n;
            while (i22 != i0) {
                Point2D p2 = (Point2D)sites.get(i22);
                if (!this.inCircle(p1, p2, sites)) break;
                i22 = (i22 + 1) % n;
            }
            i1 = i22;
        }
        Vec3R e1 = (Vec3R)v.get(v.size() - 1);
        int i3 = 0;
        while (i3 < v.size()) {
            Vec3R e2 = (Vec3R)v.get(i3);
            v.set(i3, e1.cross(e2));
            e1 = e2;
            ++i3;
        }
        this.cell.clear();
        int i4 = 0;
        while (i4 < v.size()) {
            Point2D vertex = ((Vec3R)v.get(i4)).dehomog();
            translate.transform(vertex, vertex);
            this.vectorTransform.inverseTransform(vertex, vertex);
            this.cell.add(vertex);
            ++i4;
        }
    }

    private boolean inCircle(Point2D p1, Point2D p2, Collection sites) {
        double x1 = p1.getX();
        double y1 = p1.getY();
        double z1 = x1 * x1 + y1 * y1;
        double x2 = p2.getX();
        double y2 = p2.getY();
        double z2 = x2 * x2 + y2 * y2;
        for (Point2D p3 : sites) {
            double y3;
            double x3;
            double z3;
            double det;
            if (p3 == p1 || p3 == p2 || !((det = x1 * y2 * (z3 = (x3 = p3.getX()) * x3 + (y3 = p3.getY()) * y3) + x2 * y3 * z1 + x3 * y1 * z2 - x3 * y2 * z1 - x2 * y1 * z3 - x1 * y3 * z2) < -1.0E-5)) continue;
            return true;
        }
        return false;
    }

    private Point2D floor(Point2D p) {
        p.setLocation(p.getX() - Math.floor(p.getX()), p.getY() - Math.floor(p.getY()));
        return p;
    }

    public GeneralPath getGrid() {
        return this.grid;
    }

    public void createGrid() {
        this.grid.reset();
        Point2D.Float tmp = new Point2D.Float();
        int t = 0;
        while (t < this.group.countTransforms()) {
            AffineTransform tr = this.group.getTransform(t);
            tr.transform((Point2D)this.cell.get(0), tmp);
            this.grid.moveTo(tmp.x, tmp.y);
            int i = 1;
            while (i < this.cell.size()) {
                tr.transform((Point2D)this.cell.get(i), tmp);
                this.grid.lineTo(tmp.x, tmp.y);
                ++i;
            }
            this.grid.closePath();
            ++t;
        }
    }

    public GeneralPath getCompactGrid() {
        return this.compactGrid;
    }

    private void createCompactGrid() {
        this.compactGrid.reset();
        PathIterator pi = this.getGrid().getPathIterator(null);
        float a = 0.0f;
        float b = 0.0f;
        float a0 = 0.0f;
        float b0 = 0.0f;
        float[] coords = new float[6];
        Point2D.Float pos = new Point2D.Float(-1.0f, -1.0f);
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    a0 = a = coords[0];
                    b0 = b = coords[1];
                    break;
                }
                case 1: {
                    this.addCompactLine(pos, a, b, coords[0], coords[1]);
                    a = coords[0];
                    b = coords[1];
                    break;
                }
                case 4: {
                    this.addCompactLine(pos, a, b, a0, b0);
                    a = a0;
                    b = b0;
                    break;
                }
                default: {
                    throw new IllegalStateException("non-linear grid path");
                }
            }
            pi.next();
        }
    }

    private void addCompactLine(Point2D.Float pos, float a1, float b1, float a2, float b2) {
        float a1i = (float)Math.floor(a1);
        float b1i = (float)Math.floor(b1);
        float a2i = (float)Math.floor(a2);
        float b2i = (float)Math.floor(b2);
        if (a1 == a2 && b1 == b2) {
            return;
        }
        if (a1i < a2i && (a2i < a2 || a2i - a1i > 1.5f)) {
            a2i = a1i + 1.0f;
            float c = (a2i - a1) * (b2 - b1) / (a2 - a1) + b1;
            this.addCompactLine(pos, a1, b1, a2i, c);
            this.addCompactLine(pos, a2i, c, a2, b2);
        } else if (a2i < a1i && (a1i < a1 || a1i - a2i > 1.5f)) {
            a1i = a2i + 1.0f;
            float c = (a1i - a1) * (b2 - b1) / (a2 - a1) + b1;
            this.addCompactLine(pos, a1, b1, a1i, c);
            this.addCompactLine(pos, a1i, c, a2, b2);
        } else if (b1i < b2i && (b2i < b2 || b2i - b1i > 1.5f)) {
            b2i = b1i + 1.0f;
            float c = (b2i - b1) * (a2 - a1) / (b2 - b1) + a1;
            this.addCompactLine(pos, a1, b1, c, b2i);
            this.addCompactLine(pos, c, b2i, a2, b2);
        } else if (b2i < b1i && (b1i < b1 || b1i - b2i > 1.5f)) {
            b1i = b2i + 1.0f;
            float c = (b1i - b1) * (a2 - a1) / (b2 - b1) + a1;
            this.addCompactLine(pos, a1, b1, c, b1i);
            this.addCompactLine(pos, c, b1i, a2, b2);
        } else {
            a1i = Math.min(a1i, a2i);
            b1i = Math.min(b1i, b2i);
            a2 -= a1i;
            b2 -= b1i;
            if (pos.x != (a1 -= a1i) || pos.y != (b1 -= b1i)) {
                this.compactGrid.moveTo(a1, b1);
            }
            pos.x = a2;
            pos.y = b2;
            this.compactGrid.lineTo(pos.x, pos.y);
            if ((double)a1 < 0.001 && (double)a2 < 0.001) {
                this.compactGrid.moveTo(a1 + 1.0f, b1);
                pos.x = a2 + 1.0f;
                pos.y = b2;
                this.compactGrid.lineTo(pos.x, pos.y);
            } else if ((double)(1.0f - a1) < 0.001 && (double)(1.0f - a2) < 0.001) {
                this.compactGrid.moveTo(a1 - 1.0f, b1);
                pos.x = a2 - 1.0f;
                pos.y = b2;
                this.compactGrid.lineTo(pos.x, pos.y);
            } else if ((double)b1 < 0.001 && (double)b2 < 0.001) {
                this.compactGrid.moveTo(a1, b1 + 1.0f);
                pos.x = a2;
                pos.y = b2 + 1.0f;
                this.compactGrid.lineTo(pos.x, pos.y);
            } else if ((double)(1.0f - b1) < 0.001 && (double)(1.0f - b2) < 0.001) {
                this.compactGrid.moveTo(a1, b1 - 1.0f);
                pos.x = a2;
                pos.y = b2 - 1.0f;
                this.compactGrid.lineTo(pos.x, pos.y);
            }
        }
    }
}

