/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.recog.RecognitionListener;
import de.tum.in.gagern.ornament.recog.Recognizer;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

class RecogAction
extends AbstractAction
implements RecognitionListener {
    private Ornament main;
    private JFileChooser fc;

    public RecogAction(Ornament main) {
        super(I18n.dots(I18n._("Recognize")));
        this.main = main;
    }

    @Override
    public void actionPerformed(ActionEvent evnt) {
        try {
            this.recognize();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.main, e.toString(), I18n._("Recognize"), 0);
        }
    }

    private void recognize() throws IOException {
        if (this.fc == null) {
            this.fc = new JFileChooser(".");
        }
        if (this.fc.showOpenDialog(this.main) != 0) {
            return;
        }
        File file = this.fc.getSelectedFile();
        if (file == null) {
            return;
        }
        BufferedImage img = ImageIO.read(file);
        Recognizer recog = new Recognizer(this.main, this, img, this.main.isDebug());
        Thread thread = new Thread((Runnable)recog, "Recognizer");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void recognitionSuccessful(final Group group, final BufferedImage median, AffineTransform transform) {
        final int ax = (int)Math.round(transform.getScaleX());
        final int ay = (int)Math.round(transform.getShearY());
        final int bx = (int)Math.round(transform.getShearX());
        final int by = (int)Math.round(transform.getScaleY());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RecogAction.this.main.setRecognizedImage(group, ax, ay, bx, by, median);
            }
        });
    }

    @Override
    public void recognitionCanceled() {
    }

    @Override
    public void recognitionFailed(final Throwable e) {
        e.printStackTrace();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(RecogAction.this.main, e.toString(), I18n._("Recognize"), 0);
            }
        });
    }
}

