/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class LoopBounds {
    private AffineTransform tr;
    private Point2D.Double pt = new Point2D.Double();
    private int minA;
    private int maxA;
    private int minB;
    private int maxB;

    public LoopBounds() {
        this.tr = new AffineTransform();
    }

    public LoopBounds(AffineTransform transform) throws NoninvertibleTransformException {
        this.tr = transform.createInverse();
    }

    public LoopBounds(double ax, double ay, double bx, double by) throws NoninvertibleTransformException {
        this.tr = new AffineTransform(ax, ay, bx, by, 0.0, 0.0);
        this.tr = this.tr.createInverse();
    }

    public AffineTransform getTransform() {
        return this.tr;
    }

    public int getMinA() {
        return this.minA;
    }

    public int getMaxA() {
        return this.maxA;
    }

    public int getMinB() {
        return this.minB;
    }

    public int getMaxB() {
        return this.maxB;
    }

    public int getCount() {
        return (this.maxA - this.minA + 1) * (this.maxB - this.minB + 1);
    }

    public void setTransform(double ax, double ay, double bx, double by) throws NoninvertibleTransformException {
        this.tr.setTransform(ax, ay, bx, by, 0.0, 0.0);
        this.tr = this.tr.createInverse();
    }

    public void boundsFor(double minX, double minY, double maxX, double maxY) {
        this.initTo(minX, minY);
        this.expandTo(maxX, maxY);
        this.expandTo(maxX, minY);
        this.expandTo(minX, maxY);
    }

    public void boundsFor(RectangularShape rect) {
        this.boundsFor(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
    }

    public void boundsFor(RectangularShape r, RectangularShape s) {
        this.boundsFor(s.getMinX() - r.getMaxX(), s.getMinY() - r.getMaxY(), s.getMaxX() - r.getMinX(), s.getMaxY() - r.getMinY());
    }

    public void boundsFor(double width, double height) {
        this.boundsFor(0.0, 0.0, width, height);
    }

    private void initTo(double x, double y) {
        this.pointTo(x, y);
        double a = this.pt.getX();
        double b = this.pt.getY();
        this.minA = (int)Math.ceil(a);
        this.maxA = (int)Math.floor(a);
        this.minB = (int)Math.ceil(b);
        this.maxB = (int)Math.floor(b);
    }

    private void expandTo(double x, double y) {
        this.pointTo(x, y);
        double a = this.pt.getX();
        double b = this.pt.getY();
        if ((double)this.minA > a) {
            this.minA = (int)Math.ceil(a);
        }
        if ((double)this.maxA < a) {
            this.maxA = (int)Math.floor(a);
        }
        if ((double)this.minB > b) {
            this.minB = (int)Math.ceil(b);
        }
        if ((double)this.maxB < b) {
            this.maxB = (int)Math.floor(b);
        }
    }

    public void stepLowerBounds() {
        --this.minA;
        --this.minB;
    }

    private void pointTo(double x, double y) {
        this.pt.setLocation(x, y);
        this.tr.transform(this.pt, this.pt);
    }
}

