/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.geom.Vec3R;
import de.tum.in.gagern.ornament.Property;
import de.tum.in.gagern.ornament.groups.Cm;
import de.tum.in.gagern.ornament.groups.Cmm;
import de.tum.in.gagern.ornament.groups.P1;
import de.tum.in.gagern.ornament.groups.P2;
import de.tum.in.gagern.ornament.groups.P3;
import de.tum.in.gagern.ornament.groups.P31m;
import de.tum.in.gagern.ornament.groups.P3m1;
import de.tum.in.gagern.ornament.groups.P4;
import de.tum.in.gagern.ornament.groups.P4gm;
import de.tum.in.gagern.ornament.groups.P4mm;
import de.tum.in.gagern.ornament.groups.P6;
import de.tum.in.gagern.ornament.groups.P6mm;
import de.tum.in.gagern.ornament.groups.Pg;
import de.tum.in.gagern.ornament.groups.Pgg;
import de.tum.in.gagern.ornament.groups.Pm;
import de.tum.in.gagern.ornament.groups.Pmg;
import de.tum.in.gagern.ornament.groups.Pmm;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public abstract class Group {
    protected static final double ALMOST_ZERO = 1.0E-7;
    private String[] names;
    protected AffineTransform[] trans;
    protected Property[] props;
    protected Object[] snapVoronoi;

    public static Group[] getGroups() {
        return new Group[]{new P1(), new P2(), new Pm(), new Pg(), new Cm(), new Pmm(), new Pmg(), new Pgg(), new Cmm(), new P4(), new P4mm(), new P4gm(), new P3(), new P3m1(), new P31m(), new P6(), new P6mm()};
    }

    protected Group(String[] names, double[][] trans, Property[] props, Object[] snapVoronoi) {
        if (names.length != 2) {
            throw new IllegalArgumentException("Expect two names");
        }
        this.names = names;
        this.trans = new AffineTransform[trans.length];
        int i = 0;
        while (i < trans.length) {
            this.trans[i] = new AffineTransform(trans[i]);
            ++i;
        }
        this.props = props;
        this.snapVoronoi = snapVoronoi;
    }

    public final String getName() {
        return this.getName(1);
    }

    public String getName(int namingSystem) {
        switch (namingSystem) {
            case 1: {
                return this.names[0];
            }
            case 2: {
                return this.names[1];
            }
            case 3: {
                return this.names[1].replace('x', '\u00d7').replace('o', '\u2218').replace('*', '\u2217');
            }
        }
        throw new IllegalArgumentException("Unknown naming scheme");
    }

    public abstract int getTileType();

    public int countTransforms() {
        return this.trans.length;
    }

    public AffineTransform getTransform(int i) {
        return this.trans[i];
    }

    public Property[] getProperties() {
        return this.props;
    }

    public Point2D sensibleVoronoiPoint(Point2D request, AffineTransform vectorTransform) throws NoninvertibleTransformException {
        return request;
    }

    public final boolean fixedGrid() {
        return this.snapVoronoi == null;
    }

    protected Point2D snap(Point2D p, AffineTransform t, Object[] targets) {
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        Line2D.Double l1 = new Line2D.Double();
        double minDist = 80.0;
        Point2D bestPos = null;
        int i = 0;
        while (i < targets.length) {
            double dist;
            if (targets[i] instanceof Point2D) {
                t.transform((Point2D)targets[i], p1);
                dist = p1.distanceSq(p);
                if (dist < minDist) {
                    minDist = dist;
                    bestPos = new Point2D.Double(((Point2D)p1).getX(), ((Point2D)p1).getY());
                }
            } else if (targets[i] instanceof Line2D) {
                Line2D l2 = (Line2D)targets[i];
                t.transform(l2.getP1(), p1);
                t.transform(l2.getP2(), p2);
                l1.setLine(p1, p2);
                dist = l1.ptLineDistSq(p) * 4.0;
                if (dist < minDist) {
                    minDist = dist;
                    Vec3R v1 = new Vec3R(((Point2D)p1).getX(), ((Point2D)p1).getY(), 1.0);
                    Vec3R v2 = new Vec3R(((Point2D)p2).getX(), ((Point2D)p2).getY(), 1.0);
                    Vec3R vline = v1.cross(v2).normalize();
                    Vec3R vperp = new Vec3R(vline.x, vline.y, 0.0);
                    Vec3R vp = new Vec3R(p.getX(), p.getY(), 1.0);
                    Vec3R vb = vp.cross(vperp).cross(vline).normalize();
                    bestPos = vb.dehomog();
                }
            } else {
                throw new IllegalArgumentException("Unknown snap target");
            }
            ++i;
        }
        if (bestPos != null) {
            p.setLocation(bestPos);
        } else {
            bestPos = p;
        }
        return bestPos;
    }

    public Point2D snapVoronoi(Point p, AffineTransform t) {
        if (this.snapVoronoi == null) {
            return p;
        }
        return this.snap(p, t, this.snapVoronoi);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }
}

