/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

class AboutDlg
extends JTabbedPane {
    GridBagConstraints gbcLabel;
    GridBagConstraints gbcValue;
    JPanel infoPanel;

    AboutDlg() {
        Properties prop = Ornament.getVersionInfo();
        JPanel infoTab = new JPanel();
        infoTab.setLayout(new BorderLayout());
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new GridBagLayout());
        infoTab.add((Component)this.infoPanel, "Center");
        this.gbcLabel = new GridBagConstraints();
        this.gbcLabel.insets = new Insets(4, 4, 4, 4);
        this.gbcLabel.fill = 1;
        this.gbcValue = (GridBagConstraints)this.gbcLabel.clone();
        this.gbcValue.gridwidth = 0;
        String unknown = I18n._("about.info.unknown");
        JLabel title = null;
        URL url = AboutDlg.class.getResource("morenaments-euc.png");
        title = url != null ? new JLabel(new ImageIcon(url)) : new JLabel(I18n._("about.info.Ornament"));
        title.setHorizontalAlignment(0);
        infoTab.add((Component)title, "North");
        String cleanStr = prop.getProperty("clean", null);
        int clean = 2;
        if ("True".equals(cleanStr)) {
            clean = 1;
        }
        if ("False".equals(cleanStr)) {
            clean = 0;
        }
        this.addPair(I18n._("about.info.Version"), prop.getProperty("version.number", unknown));
        this.addPair(I18n._("about.info.Revision"), I18n._("about.info.revfmt", new Object[]{prop.getProperty("branch-nick", unknown), prop.getProperty("revno", unknown), new Integer(clean)}));
        this.addPair(I18n._("about.info.RevID"), prop.getProperty("revision-id", unknown));
        this.addPair(I18n._("about.info.Date"), prop.getProperty("date", unknown));
        this.addPair(I18n._("about.info.Homepage"), I18n._("homepage"));
        this.addPair(I18n._("about.info.Author"), "Martin von Gagern");
        this.addPair(I18n._("about.info.License"), I18n._("about.info.GPL2"));
        this.addTab(I18n._("about.tab.Info"), infoTab);
        this.addResourceTab(I18n._("about.tab.Copyleft"), "COPYING");
        this.addResourceTab(I18n._("about.tab.License"), "LICENSE");
    }

    void addPair(String label, String value) {
        JLabel jLabel = new JLabel(label);
        JLabel jValue = new JLabel(value);
        this.infoPanel.add((Component)jLabel, this.gbcLabel);
        this.infoPanel.add((Component)jValue, this.gbcValue);
    }

    void addResourceTab(String tabName, String resourcePath) {
        String resourceText;
        try {
            int nread;
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
            if (in == null) {
                throw new IOException(String.valueOf(resourcePath) + " not found");
            }
            InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));
            StringBuffer sbuf = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((nread = reader.read(cbuf)) != -1) {
                sbuf.append(cbuf, 0, nread);
            }
            resourceText = sbuf.toString();
        }
        catch (IOException e) {
            resourceText = e.toString();
        }
        JTextArea area = new JTextArea(resourceText, 20, 60);
        area.setEditable(false);
        this.addTab(tabName, new JScrollPane(area));
    }
}

