/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.geom;

import java.awt.geom.Point2D;

public class Vec3R {
    public final double x;
    public final double y;
    public final double z;

    public Vec3R(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec3R cross(Vec3R that) {
        return new Vec3R(this.y * that.z - this.z * that.y, this.z * that.x - this.x * that.z, this.x * that.y - this.y * that.x);
    }

    public Vec3R add(Vec3R that) {
        return new Vec3R(this.x + that.x, this.y + that.y, this.z + that.z);
    }

    public double abs() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vec3R normalize() {
        double r = this.abs();
        if (this.z < 0.0) {
            r = -r;
        }
        return new Vec3R(this.x / r, this.y / r, this.z / r);
    }

    public Point2D dehomog() {
        return new Point2D.Double(this.x / this.z, this.y / this.z);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public String toString() {
        return "Vec3R[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

