/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.servlet;

import com.sun.javaws.xml.XMLAttribute;
import com.sun.javaws.xml.XMLNode;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLParsing {
    public static XMLNode convert(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Text) {
            Text text = (Text)node;
            return new XMLNode(text.getNodeValue());
        }
        if (node instanceof Element) {
            Object object;
            Element element = (Element)node;
            XMLAttribute xMLAttribute = null;
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = namedNodeMap.getLength() - 1;
            while (n >= 0) {
                object = (Attr)namedNodeMap.item(n);
                xMLAttribute = new XMLAttribute(object.getName(), object.getValue(), xMLAttribute);
                --n;
            }
            object = new XMLNode(element.getNodeName(), xMLAttribute, null, null);
            XMLNode xMLNode = null;
            Node node2 = element.getFirstChild();
            while (node2 != null) {
                if (((XMLNode)object).getNested() == null) {
                    xMLNode = XMLParsing.convert(node2);
                    ((XMLNode)object).setNested(xMLNode);
                } else {
                    XMLNode xMLNode2 = XMLParsing.convert(node2);
                    xMLNode.setNext(xMLNode2);
                    xMLNode = xMLNode2;
                }
                xMLNode.setParent((XMLNode)object);
                node2 = node2.getNextSibling();
            }
            return object;
        }
        return null;
    }

    public static XMLNode findChildElement(XMLNode xMLNode, String string) {
        XMLNode xMLNode2 = xMLNode.getNested();
        while (xMLNode2 != null) {
            if (xMLNode2.isElement() && xMLNode2.getName().equals(string)) {
                return xMLNode2;
            }
            xMLNode2 = xMLNode2.getNext();
        }
        return null;
    }

    public static XMLNode findElementPath(XMLNode xMLNode, String string) {
        if (xMLNode == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return xMLNode;
        }
        int n = string.indexOf(62);
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1);
        return XMLParsing.findElementPath(XMLParsing.findChildElement(xMLNode, string2), string3);
    }

    public static String getElementContent(XMLNode xMLNode, String string) {
        return XMLParsing.getElementContent(xMLNode, string, null);
    }

    public static String getElementContent(XMLNode xMLNode, String string, String string2) {
        XMLNode xMLNode2 = XMLParsing.findElementPath(xMLNode, string);
        if (xMLNode2 == null) {
            return string2;
        }
        XMLNode xMLNode3 = xMLNode2.getNested();
        if (xMLNode3 != null && !xMLNode3.isElement()) {
            return xMLNode3.getName();
        }
        return string2;
    }

    public static String[] getMultiElementContent(XMLNode xMLNode, String string) {
        final ArrayList arrayList = new ArrayList();
        XMLParsing.visitElements(xMLNode, string, new ElementVisitor(){

            public void visitElement(XMLNode xMLNode) {
                String string = XMLParsing.getElementContent(xMLNode, "");
                if (string != null) {
                    arrayList.add(string);
                }
            }
        });
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getPathString(XMLNode xMLNode) {
        return xMLNode == null || !xMLNode.isElement() ? "" : String.valueOf(XMLParsing.getPathString(xMLNode.getParent())) + "<" + xMLNode.getName() + ">";
    }

    public static boolean isElementPath(XMLNode xMLNode, String string) {
        return XMLParsing.findElementPath(xMLNode, string) != null;
    }

    public static void visitChildrenElements(XMLNode xMLNode, ElementVisitor elementVisitor) {
        XMLNode xMLNode2 = xMLNode.getNested();
        while (xMLNode2 != null) {
            if (xMLNode2.isElement()) {
                elementVisitor.visitElement(xMLNode2);
            }
            xMLNode2 = xMLNode2.getNext();
        }
    }

    public static void visitElements(XMLNode xMLNode, String string, ElementVisitor elementVisitor) {
        int n = string.lastIndexOf(60);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        XMLNode xMLNode2 = XMLParsing.findElementPath(xMLNode, string2);
        if (xMLNode2 == null) {
            return;
        }
        XMLNode xMLNode3 = xMLNode2.getNested();
        while (xMLNode3 != null) {
            if (xMLNode3.isElement() && xMLNode3.getName().equals(string3)) {
                elementVisitor.visitElement(xMLNode3);
            }
            xMLNode3 = xMLNode3.getNext();
        }
    }

    public static abstract class ElementVisitor {
        public abstract void visitElement(XMLNode var1);
    }
}

