/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.servlet;

import com.sun.javaws.jardiff.JarDiff;
import com.sun.javaws.servlet.DownloadRequest;
import com.sun.javaws.servlet.DownloadResponse;
import com.sun.javaws.servlet.ErrorResponseException;
import com.sun.javaws.servlet.JnlpResource;
import com.sun.javaws.servlet.Logger;
import com.sun.javaws.servlet.ResourceCatalog;
import com.sun.javaws.util.VersionString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletContext;

public class JarDiffHandler {
    private static final String JARDIFF_MIMETYPE = "application/x-java-archive-diff";
    private HashMap _jarDiffEntries = new HashMap();
    private Logger _log = null;
    private ServletContext _servletContext = null;
    private String _jarDiffMimeType = null;

    public JarDiffHandler(ServletContext servletContext, Logger logger) {
        this._servletContext = servletContext;
        this._log = logger;
        this._jarDiffMimeType = this._servletContext.getMimeType("xyz.jardiff");
        if (this._jarDiffMimeType == null) {
            this._jarDiffMimeType = JARDIFF_MIMETYPE;
        }
    }

    private File generateJarDiff(ResourceCatalog resourceCatalog, DownloadRequest downloadRequest, JnlpResource jnlpResource, boolean bl) {
        DownloadRequest downloadRequest2 = downloadRequest.getFromDownloadRequest();
        try {
            JnlpResource jnlpResource2 = resourceCatalog.lookupResource(downloadRequest2);
            String string = this._servletContext.getRealPath(jnlpResource.getPath());
            String string2 = this._servletContext.getRealPath(jnlpResource2.getPath());
            if (string == null || string2 == null) {
                return null;
            }
            File file = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
            File file2 = File.createTempFile("jnlp", ".jardiff");
            this._log.addDebug("Generating Jardiff between " + string2 + " and " + string + " Store in " + file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            JarDiff.createPatch(string2, string, fileOutputStream, bl ^ true);
            ((OutputStream)fileOutputStream).close();
            if (file2.length() >= new File(string).length()) {
                this._log.addDebug("JarDiff discarded - since it is bigger");
                return null;
            }
            this._log.addDebug("JarDiff generation succeeded");
            return file2;
        }
        catch (IOException iOException) {
            this._log.addDebug("Failed to genereate jardiff", iOException);
            return null;
        }
        catch (ErrorResponseException errorResponseException) {
            this._log.addDebug("Failed to genereate jardiff", errorResponseException);
            return null;
        }
    }

    public synchronized DownloadResponse getJarDiffEntry(ResourceCatalog resourceCatalog, DownloadRequest downloadRequest, JnlpResource jnlpResource) {
        if (downloadRequest.getCurrentVersionId() == null) {
            return null;
        }
        boolean bl = this.isJavawsVersion(downloadRequest, "1.0 1.0.1");
        JarDiffKey jarDiffKey = new JarDiffKey(jnlpResource.getName(), downloadRequest.getCurrentVersionId(), jnlpResource.getReturnVersionId(), bl ^ true);
        JarDiffEntry jarDiffEntry = (JarDiffEntry)this._jarDiffEntries.get(jarDiffKey);
        if (jarDiffEntry == null) {
            File file;
            if (this._log.isInformationalLevel()) {
                this._log.addInformational("servlet.log.info.jardiff.gen", jnlpResource.getName(), downloadRequest.getCurrentVersionId(), jnlpResource.getReturnVersionId());
            }
            if ((file = this.generateJarDiff(resourceCatalog, downloadRequest, jnlpResource, bl)) == null) {
                this._log.addWarning("servlet.log.warning.jardiff.failed", jnlpResource.getName(), downloadRequest.getCurrentVersionId(), jnlpResource.getReturnVersionId());
            }
            jarDiffEntry = new JarDiffEntry(file);
            this._jarDiffEntries.put(jarDiffKey, jarDiffEntry);
        }
        if (jarDiffEntry.getJarDiffFile() == null) {
            return null;
        }
        return DownloadResponse.getFileDownloadResponse(jarDiffEntry.getJarDiffFile(), this._jarDiffMimeType, jarDiffEntry.getJarDiffFile().lastModified(), jnlpResource.getReturnVersionId());
    }

    private boolean isJavawsVersion(DownloadRequest downloadRequest, String string) {
        String string2 = downloadRequest.getHttpRequest().getHeader("User-Agent");
        if (!string2.startsWith("javaws-")) {
            return false;
        }
        int n = string2.indexOf("-");
        if (n == -1) {
            return false;
        }
        int n2 = string2.indexOf("/");
        if (n2 == -1 || n2 < n) {
            return false;
        }
        String string3 = string2.substring(n + 1, n2);
        return VersionString.contains(string, string3);
    }

    private static class JarDiffKey
    implements Comparable {
        private String _name;
        private String _fromVersionId;
        private String _toVersionId;
        private boolean _minimal;

        public JarDiffKey(String string, String string2, String string3, boolean bl) {
            this._name = string;
            this._fromVersionId = string2;
            this._toVersionId = string3;
            this._minimal = bl;
        }

        public int compareTo(Object object) {
            if (!(object instanceof JarDiffKey)) {
                return -1;
            }
            JarDiffKey jarDiffKey = (JarDiffKey)object;
            int n = this._name.compareTo(jarDiffKey.getName());
            if (n != 0) {
                return n;
            }
            n = this._fromVersionId.compareTo(jarDiffKey.getFromVersionId());
            if (n != 0) {
                return n;
            }
            if (this._minimal != jarDiffKey.isMinimal()) {
                return -1;
            }
            return this._toVersionId.compareTo(jarDiffKey.getToVersionId());
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public String getFromVersionId() {
            return this._fromVersionId;
        }

        public String getName() {
            return this._name;
        }

        public String getToVersionId() {
            return this._toVersionId;
        }

        public int hashCode() {
            return this._name.hashCode() + this._fromVersionId.hashCode() + this._toVersionId.hashCode();
        }

        public boolean isMinimal() {
            return this._minimal;
        }
    }

    private static class JarDiffEntry {
        private File _jardiffFile;

        public JarDiffEntry(File file) {
            this._jardiffFile = file;
        }

        public File getJarDiffFile() {
            return this._jardiffFile;
        }
    }
}

