/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.servlet;

import com.sun.javaws.servlet.JnlpDownloadServlet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.MissingResourceException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public abstract class DownloadResponse {
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String HEADER_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String JNLP_ERROR_MIMETYPE = "application/x-java-jnlp-error";
    public static final int STS_00_OK = 0;
    public static final int ERR_10_NO_RESOURCE = 10;
    public static final int ERR_11_NO_VERSION = 11;
    public static final int ERR_20_UNSUP_OS = 20;
    public static final int ERR_21_UNSUP_ARCH = 21;
    public static final int ERR_22_UNSUP_LOCALE = 22;
    public static final int ERR_23_UNSUP_JRE = 23;
    public static final int ERR_99_UNKNOWN = 99;

    static DownloadResponse getFileDownloadResponse(File file, String string, long l, String string2) {
        return new DiskFileDownloadResponse(file, string, string2, l);
    }

    static DownloadResponse getFileDownloadResponse(URL uRL, String string, long l, String string2) {
        return new ResourceFileDownloadResponse(uRL, string, string2, l);
    }

    static DownloadResponse getFileDownloadResponse(byte[] byArray, String string, long l, String string2) {
        return new ByteArrayFileDownloadResponse(byArray, string, string2, l);
    }

    static DownloadResponse getJnlpErrorResponse(int n) {
        return new JnlpErrorResponse(n);
    }

    static DownloadResponse getNoContentResponse() {
        return new NotFoundResponse();
    }

    static DownloadResponse getNotFoundResponse() {
        return new NotFoundResponse();
    }

    abstract void sendRespond(HttpServletResponse var1) throws IOException;

    public String toString() {
        return this.getClass().getName();
    }

    private static class NotFoundResponse
    extends DownloadResponse {
        NotFoundResponse() {
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.sendError(404);
        }
    }

    private static class NoContentResponse
    extends DownloadResponse {
        NoContentResponse() {
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.sendError(204);
        }
    }

    public static class JnlpErrorResponse
    extends DownloadResponse {
        private String _message;

        public JnlpErrorResponse(int n) {
            String string = Integer.toString(n);
            String string2 = "No description";
            try {
                string2 = JnlpDownloadServlet.getResourceBundle().getString("servlet.jnlp.err." + string);
            }
            catch (MissingResourceException missingResourceException) {}
            this._message = String.valueOf(string) + " " + string2;
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType(DownloadResponse.JNLP_ERROR_MIMETYPE);
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println(this._message);
        }

        public String toString() {
            return String.valueOf(super.toString()) + "[" + this._message + "]";
        }
    }

    private static abstract class FileDownloadResponse
    extends DownloadResponse {
        private String _mimeType;
        private String _versionId;
        private long _lastModified;

        FileDownloadResponse(String string, String string2, long l) {
            this._mimeType = string;
            this._versionId = string2;
            this._lastModified = l;
        }

        protected String getArgString() {
            long l = 0L;
            try {
                l = this.getContentLength();
            }
            catch (IOException iOException) {}
            return "Mimetype=" + this.getMimeType() + " VersionId=" + this.getVersionId() + " Timestamp=" + new Date(this.getLastModified()) + " Length=" + l;
        }

        abstract InputStream getContent() throws IOException;

        abstract int getContentLength() throws IOException;

        long getLastModified() {
            return this._lastModified;
        }

        String getMimeType() {
            return this._mimeType;
        }

        String getVersionId() {
            return this._versionId;
        }

        public void sendRespond(HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setContentType(this.getMimeType());
            httpServletResponse.setContentLength(this.getContentLength());
            if (this.getVersionId() != null) {
                httpServletResponse.setHeader(DownloadResponse.HEADER_JNLP_VERSION, this.getVersionId());
            }
            if (this.getLastModified() != 0L) {
                httpServletResponse.setDateHeader(DownloadResponse.HEADER_LASTMOD, this.getLastModified());
            }
            InputStream inputStream = this.getContent();
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                int n;
                byte[] byArray = new byte[32768];
                while ((n = inputStream.read(byArray)) != -1) {
                    servletOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                Object var5_6 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private static class ByteArrayFileDownloadResponse
    extends FileDownloadResponse {
        private byte[] _content;

        ByteArrayFileDownloadResponse(byte[] byArray, String string, String string2, long l) {
            super(string, string2, l);
            this._content = byArray;
        }

        InputStream getContent() {
            return new ByteArrayInputStream(this._content);
        }

        int getContentLength() {
            return this._content.length;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "[ " + this.getArgString() + "]";
        }
    }

    private static class ResourceFileDownloadResponse
    extends FileDownloadResponse {
        URL _url;

        ResourceFileDownloadResponse(URL uRL, String string, String string2, long l) {
            super(string, string2, l);
            this._url = uRL;
        }

        InputStream getContent() throws IOException {
            return this._url.openConnection().getInputStream();
        }

        int getContentLength() throws IOException {
            return this._url.openConnection().getContentLength();
        }

        public String toString() {
            return String.valueOf(super.toString()) + "[ " + this.getArgString() + "]";
        }
    }

    private static class DiskFileDownloadResponse
    extends FileDownloadResponse {
        private File _file;

        DiskFileDownloadResponse(File file, String string, String string2, long l) {
            super(string, string2, l);
            this._file = file;
        }

        InputStream getContent() throws IOException {
            return new BufferedInputStream(new FileInputStream(this._file));
        }

        int getContentLength() throws IOException {
            return (int)this._file.length();
        }

        public String toString() {
            return String.valueOf(super.toString()) + "[ " + this.getArgString() + "]";
        }
    }
}

