/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jardiff;

import com.sun.javaws.cache.Patcher;
import com.sun.javaws.jardiff.JarDiff;
import com.sun.javaws.jardiff.JarDiffConstants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class JarDiffPatcher
implements JarDiffConstants,
Patcher {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static byte[] newBytes = new byte[2048];
    private static byte[] oldBytes = new byte[2048];
    private static ResourceBundle _resources = JarDiff.getResources();

    public void applyPatch(Patcher.PatchDelegate patchDelegate, String string, String string2, OutputStream outputStream) throws IOException {
        JarEntry jarEntry;
        String string3;
        File file = new File(string);
        File file2 = new File(string2);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        JarFile jarFile = new JarFile(file);
        JarFile jarFile2 = new JarFile(file2);
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        this.determineNameMapping(jarFile2, hashSet, hashMap);
        Object[] objectArray = hashMap.keySet().toArray();
        HashSet<String> hashSet2 = new HashSet<String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                hashSet2.add(enumeration.nextElement().getName());
            }
        }
        double d = hashSet2.size() + objectArray.length + jarFile2.size();
        double d2 = 0.0;
        hashSet2.removeAll(hashSet);
        d -= (double)hashSet.size();
        Enumeration<JarEntry> enumeration2 = jarFile2.entries();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                JarEntry jarEntry2 = enumeration2.nextElement();
                if (!"META-INF/INDEX.JD".equals(jarEntry2.getName())) {
                    this.updateDelegate(patchDelegate, d2, d);
                    d2 += 1.0;
                    this.writeEntry(jarOutputStream, jarEntry2, jarFile2);
                    boolean bl = hashSet2.remove(jarEntry2.getName());
                    if (!bl) continue;
                    d -= 1.0;
                    continue;
                }
                d -= 1.0;
            }
        }
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            String string4 = (String)objectArray[n];
            string3 = (String)hashMap.get(string4);
            jarEntry = jarFile.getJarEntry(string3);
            if (jarEntry == null) {
                object = "move" + string3 + " " + string4;
                this.handleException("jardiff.error.badmove", (String)object);
            }
            object = new JarEntry(string4);
            ((ZipEntry)object).setTime(jarEntry.getTime());
            ((ZipEntry)object).setSize(jarEntry.getSize());
            ((ZipEntry)object).setCompressedSize(jarEntry.getCompressedSize());
            ((ZipEntry)object).setCrc(jarEntry.getCrc());
            ((ZipEntry)object).setMethod(jarEntry.getMethod());
            ((ZipEntry)object).setExtra(jarEntry.getExtra());
            ((ZipEntry)object).setComment(jarEntry.getComment());
            this.updateDelegate(patchDelegate, d2, d);
            d2 += 1.0;
            this.writeEntry(jarOutputStream, (JarEntry)object, jarFile.getInputStream(jarEntry));
            boolean bl = hashSet2.remove(string3);
            if (bl) {
                d -= 1.0;
            }
            ++n;
        }
        Iterator iterator = hashSet2.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                jarEntry = jarFile.getJarEntry(string3);
                this.updateDelegate(patchDelegate, d2, d);
                d2 += 1.0;
                this.writeEntry(jarOutputStream, jarEntry, jarFile);
            }
        }
        this.updateDelegate(patchDelegate, d2, d);
        jarOutputStream.finish();
    }

    private void determineNameMapping(JarFile jarFile, Set set, Map map) throws IOException {
        LineNumberReader lineNumberReader;
        String string;
        InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/INDEX.JD"));
        if (inputStream == null) {
            this.handleException("jardiff.error.noindex", null);
        }
        if ((string = (lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, "UTF-8"))).readLine()) == null || !string.equals("version 1.0")) {
            this.handleException("jardiff.error.badheader", string);
        }
        while ((string = lineNumberReader.readLine()) != null) {
            List list;
            if (string.startsWith("remove")) {
                list = this.getSubpaths(string.substring("remove".length()));
                if (list.size() != 1) {
                    this.handleException("jardiff.error.badremove", string);
                }
                set.add(list.get(0));
                continue;
            }
            if (string.startsWith("move")) {
                list = this.getSubpaths(string.substring("move".length()));
                if (list.size() != 2) {
                    this.handleException("jardiff.error.badmove", string);
                }
                if (map.put(list.get(1), list.get(0)) == null) continue;
                this.handleException("jardiff.error.badmove", string);
                continue;
            }
            if (string.length() <= 0) continue;
            this.handleException("jardiff.error.badcommand", string);
        }
    }

    public static ResourceBundle getResources() {
        return JarDiff.getResources();
    }

    /*
     * Unable to fully structure code
     */
    private List getSubpaths(String var1_1) {
        var2_2 = 0;
        var3_3 = var1_1.length();
        var4_4 = new ArrayList<String>();
        ** GOTO lbl24
        {
            ++var2_2;
            do {
                if (var2_2 < var3_3 && Character.isWhitespace(var1_1.charAt(var2_2))) continue block0;
                if (var2_2 >= var3_3) continue;
                var6_6 = var5_5 = var2_2;
                var7_7 = null;
                while (var2_2 < var3_3) {
                    var8_8 = var1_1.charAt(var2_2);
                    if (var8_8 == '\\' && var2_2 + 1 < var3_3 && var1_1.charAt(var2_2 + 1) == ' ') {
                        var7_7 = var7_7 == null ? var1_1.substring(var6_6, var2_2) : String.valueOf(var7_7) + var1_1.substring(var6_6, var2_2);
                        var6_6 = ++var2_2;
                    } else if (Character.isWhitespace(var8_8)) break;
                    ++var2_2;
                }
                if (var6_6 != var2_2) {
                    var7_7 = var7_7 == null ? var1_1.substring(var6_6, var2_2) : String.valueOf(var7_7) + var1_1.substring(var6_6, var2_2);
                }
                var4_4.add(var7_7);
lbl24:
                // 3 sources

            } while (var2_2 < var3_3);
        }
        return var4_4;
    }

    private void handleException(String string, String string2) throws IOException {
        try {
            throw new IOException(String.valueOf(JarDiffPatcher.getResources().getString(string)) + " " + string2);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Fatal error: " + string);
            new Throwable().printStackTrace(System.err);
            System.exit(-1);
            return;
        }
    }

    private void updateDelegate(Patcher.PatchDelegate patchDelegate, double d, double d2) {
        if (patchDelegate != null) {
            patchDelegate.patching((int)(d / d2));
        }
    }

    private void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, InputStream inputStream) throws IOException {
        jarOutputStream.putNextEntry(jarEntry);
        int n = inputStream.read(newBytes);
        while (n != -1) {
            jarOutputStream.write(newBytes, 0, n);
            n = inputStream.read(newBytes);
        }
        inputStream.close();
    }

    private void writeEntry(JarOutputStream jarOutputStream, JarEntry jarEntry, JarFile jarFile) throws IOException {
        this.writeEntry(jarOutputStream, jarEntry, jarFile.getInputStream(jarEntry));
    }
}

