/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.LoopBounds;
import de.tum.in.gagern.ornament.MinGrid;
import de.tum.in.gagern.ornament.groups.P1;
import de.tum.in.gagern.ornament.recog.CanceledOperationException;
import de.tum.in.gagern.ornament.recog.Correlator;
import de.tum.in.gagern.ornament.recog.FeatureInspector;
import de.tum.in.gagern.ornament.recog.GridDebugger;
import de.tum.in.gagern.ornament.recog.Peak;
import de.tum.in.gagern.ornament.recog.ProgressPhase;
import de.tum.in.gagern.ornament.recog.ProgressView;
import de.tum.in.gagern.ornament.recog.RecognitionException;
import de.tum.in.gagern.ornament.recog.RecognitionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;

public class Recognizer
implements Runnable {
    private static final boolean doNormalize = false;
    private static final ColorSpace cs = ColorSpace.getInstance(1004);
    private static final ColorModel cmOpaque = new ComponentColorModel(cs, false, true, 1, 0);
    private static final ColorModel cmAlpha = new ComponentColorModel(cs, true, true, 3, 0);
    private final Component owner;
    private final RecognitionListener listener;
    private final BufferedImage original;
    private final BufferedImage img;
    private final int wImg;
    private final int hImg;
    private final boolean hasAlpha;
    private ProgressView progressView;
    private ProgressPhase progressTransform;
    private ProgressPhase progressDebugAc;
    private ProgressPhase progressPeaks;
    private ProgressPhase progressAod;
    private ProgressPhase progressGrid;
    private ProgressPhase progressMedian1;
    private ProgressPhase progressSymmetry;
    private ProgressPhase progressMedianTile;
    private ProgressPhase progressMedian2;
    private List peaks;
    private AffineTransform trv;
    private AffineTransform tri;
    private BufferedImage median;
    private Group group;
    private boolean debug;
    GridDebugger gdbg;
    private static final int peakThresholdRank = 8;
    private static final double peakThresholdFactor = 0.2;
    private static final double gridCollinear = 0.0078125;
    private static final double gridShortness = 0.125;
    private static final double gridFitness = 0.015625;
    private static final int FEATURE_ROT6 = 0;
    private static final int FEATURE_ROT3 = 1;
    private static final int FEATURE_ROT4 = 2;
    private static final int FEATURE_ROT2 = 3;
    private static final int BIT_ROT6 = 1;
    private static final int BIT_ROT3 = 2;
    private static final int BIT_ROT4 = 4;
    private static final int BIT_ROT2 = 8;
    private static final String[] FEATURE_NAME = new String[]{"rot6", "rot3", "rot4", "rot2"};
    private static final double[][] FEATURE_MATRIX = new double[][]{{0.0, 1.0, -1.0, 1.0, 1.0, 0.0}, {-1.0, 1.0, -1.0, 0.0, 1.0, 0.0}, {0.0, 1.0, -1.0, 0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0, -1.0, 1.0, 1.0}};

    public Recognizer(Component owner, RecognitionListener listener, BufferedImage img, boolean debug) throws IOException {
        this.owner = owner;
        this.listener = listener;
        this.debug = debug;
        this.original = img;
        this.wImg = img.getWidth();
        this.hImg = img.getHeight();
        this.img = img;
        this.hasAlpha = img.getColorModel().hasAlpha();
        this.group = new P1();
    }

    @Override
    public void run() {
        try {
            try {
                this.initProgress();
                this.colorConvert();
                this.transform();
                this.aodPeaks(this.peaks, this.progressAod);
                this.thinPeaks();
                this.findGrid();
                this.median = this.getMedian(3, this.progressMedian1);
                this.innerSymmetries();
                BufferedImage medianTile = this.getMedian(1, this.progressMedianTile);
                this.debugImg(medianTile, "debugMedianTile");
                this.median = this.getMedianSquare(this.progressMedian2);
                this.debugImg(this.median, "debugMedianTile2");
                this.listener.recognitionSuccessful(this.group, this.median, this.trv);
            }
            catch (CanceledOperationException e) {
                this.listener.recognitionCanceled();
                this.progressView.close();
            }
            catch (Throwable e) {
                this.listener.recognitionFailed(e);
                this.progressView.close();
            }
        }
        finally {
            this.progressView.close();
        }
    }

    private void initProgress() {
        String title = I18n._("Recognizing pattern");
        String cancelCaption = I18n._("Cancel");
        this.progressView = new ProgressView(this.owner, title, cancelCaption);
        this.progressTransform = this.progressView.createPhase(3.0f);
        this.progressDebugAc = this.progressView.createPhase(1.0f);
        ProgressPhase peaksAndGrid = this.progressView.createPhase(2.0f);
        this.progressPeaks = peaksAndGrid.createPhase(1.0f);
        this.progressAod = peaksAndGrid.createPhase(1.0f);
        this.progressGrid = peaksAndGrid.createPhase(1.0f);
        ProgressPhase symmetry = this.progressView.createPhase(5.0f);
        this.progressMedian1 = symmetry.createPhase(9.0f);
        this.progressSymmetry = symmetry.createPhase(FEATURE_MATRIX.length + 1);
        this.progressMedianTile = symmetry.createPhase(1.0f);
        this.progressMedian2 = symmetry.createPhase(12.0f);
        this.progressView.setNotice(I18n._("initializing"));
        this.progressView.show();
    }

    private void colorConvert() throws CanceledOperationException {
        if (this.original == this.img) {
            return;
        }
        RenderingHints rh = null;
        ColorConvertOp cco = new ColorConvertOp(rh);
        cco.filter(this.original, this.img);
    }

    private void transform() throws CanceledOperationException, IOException, RecognitionException {
        Correlator ac = new Correlator(2 * this.wImg, 2 * this.hImg, true);
        ac.autocorrelate(this.img, this.progressTransform);
        float max = ac.getAcMaximum();
        if (max == 0.0f) {
            throw new RecognitionException("Black image");
        }
        this.debugImg(ac.getDebugImage(true, false, -max, max, this.progressDebugAc), "debugAcGray");
        this.peaks = ac.extractPeaks(0.0f, this.progressPeaks);
    }

    private void debugImg(BufferedImage img, String name) {
        if (!this.debug) {
            return;
        }
        Recognizer.debugImgImpl(img, name);
    }

    static void debugImgImpl(BufferedImage img, String name) {
        try {
            ImageIO.write((RenderedImage)img, "png", new File(String.valueOf(name) + ".png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void aodPeaks(List peaks, ProgressPhase progress) throws RecognitionException, CanceledOperationException {
        progress.begin("calculating area of dominance", peaks.size() * 5);
        if (peaks.isEmpty()) {
            throw new AssertionError((Object)"no peaks");
        }
        Collections.sort(peaks, new Peak.ValueComparator());
        progress.step(peaks.size());
        if (peaks == this.peaks) {
            this.debugPeaks(peaks, "debugPeaksValue", false);
        }
        progress.step(peaks.size());
        Peak root = (Peak)peaks.get(0);
        int i = 1;
        while (i < peaks.size()) {
            ((Peak)peaks.get(i)).addToTree(root);
            progress.step();
            ++i;
        }
        Collections.sort(peaks, new Peak.AodComparator());
        progress.step(peaks.size());
        if (peaks == this.peaks) {
            this.debugPeaks(peaks, "debugPeaksAod", true);
        }
        progress.done();
    }

    private void thinPeaks() throws RecognitionException {
        if (this.peaks.size() < 2) {
            throw new RecognitionException("Only " + this.peaks.size() + " peaks");
        }
        if (this.peaks.size() > 8) {
            int threshold = ((Peak)this.peaks.get(8)).getAod();
            threshold = (int)((double)threshold * 0.2);
            System.err.println("threshold = " + Math.sqrt(threshold) + "\u00ac\u2264");
            int numPeaks = 9;
            while (numPeaks < this.peaks.size()) {
                if (((Peak)this.peaks.get(numPeaks)).getAod() < threshold) break;
                ++numPeaks;
            }
            System.err.println("peak list reduced from " + this.peaks.size() + " to " + numPeaks);
            this.peaks.subList(numPeaks, this.peaks.size()).clear();
        }
        this.debugPeaks(this.peaks, "debugPeaksThin", true);
        this.debugPeaks(this.peaks, "debugPeaksThinValue", false);
        assert (((Peak)this.peaks.get(0)).getX() == 0 && ((Peak)this.peaks.get(0)).getY() == 0);
        if (this.peaks.size() < 3) {
            throw new RecognitionException("Image with insufficient structure");
        }
    }

    private void debugPeaks(List peaks, String file, boolean aod) {
        int y;
        int x;
        if (!this.debug) {
            return;
        }
        PrintStream stream = null;
        try {
            stream = new PrintStream(new FileOutputStream(String.valueOf(file) + ".peaks"));
            stream.println("dimensions(" + this.wImg + ", " + this.hImg + ");");
        }
        catch (IOException e) {
            e.printStackTrace();
            stream = System.err;
        }
        BufferedImage res = new BufferedImage(2 * this.wImg + 9, 2 * this.hImg + 9, 1);
        Graphics2D g = res.createGraphics();
        g.translate(this.wImg + 4, this.hImg + 4);
        double scale = Double.NEGATIVE_INFINITY;
        Peak peak = (Peak)peaks.get(0);
        float level = aod ? (float)peak.getAod() : peak.getValue();
        scale = peak.getX() == 0 && peak.getY() == 0 && peaks == this.peaks ? Double.NEGATIVE_INFINITY : (double)level;
        int i = 1;
        while (i < peaks.size()) {
            peak = (Peak)peaks.get(i);
            level = aod ? (float)peak.getAod() : peak.getValue();
            if (scale < (double)level) {
                scale = level;
            }
            ++i;
        }
        if (aod) {
            scale = Math.sqrt(scale);
        }
        scale = 1.0 / scale;
        i = peaks.size() - 1;
        while (i >= 0) {
            peak = (Peak)peaks.get(i);
            x = peak.getX();
            y = peak.getY();
            level = aod ? (float)(scale * Math.sqrt(peak.getAod())) : (float)(scale * (double)peak.getValue());
            if (level < 0.0f) {
                level = 0.0f;
            }
            if (level > 1.0f) {
                level = 1.0f;
            }
            stream.println("peak(" + x + ", " + y + ", " + level + ");");
            g.setColor(Color.getHSBColor(0.6666667f * (1.0f - level), 1.0f, 0.3f + 0.7f * level));
            int size = (int)(4.0f * level + 1.5f);
            g.drawLine(x, y - size, x, y + size);
            g.drawLine(x - size, y, x + size, y);
            --i;
        }
        peak = (Peak)peaks.get(0);
        x = peak.getX();
        y = peak.getY();
        g.setColor(Color.WHITE);
        if (this.trv != null && peaks == this.peaks) {
            double[] matrix = new double[4];
            this.trv.getMatrix(matrix);
            g.drawLine(0, 0, (int)Math.round(matrix[0]), (int)Math.round(matrix[1]));
            g.drawLine(0, 0, (int)Math.round(matrix[2]), (int)Math.round(matrix[3]));
        } else {
            g.drawLine(x - 5, y - 5, x + 5, y + 5);
            g.drawLine(x - 5, y + 5, x + 5, y - 5);
        }
        g.dispose();
        this.debugImg(res, file);
        if (stream != System.err) {
            stream.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void findGrid() throws RecognitionException, CanceledOperationException {
        vectorCandidateSet = new HashSet<Point>();
        comparators = new Comparator[]{new Peak.AodComparator()};
        nVectorCandidates = Math.min(this.peaks.size(), 9);
        cmp = 0;
        while (cmp < comparators.length) {
            Collections.sort(this.peaks, comparators[cmp]);
            i = 0;
            while (i < nVectorCandidates) {
                peak = (Peak)this.peaks.get(i);
                vec = new Point(peak.getX(), peak.getY());
                if (vec.x != 0 || vec.y != 0) {
                    if (vec.x < 0 || vec.x == 0 && vec.y > 0) {
                        vec.x = -vec.x;
                        vec.y = -vec.y;
                    }
                    vectorCandidateSet.add(vec);
                }
                ++i;
            }
            ++cmp;
        }
        vc = new Point[vectorCandidateSet.size()];
        vc = vectorCandidateSet.toArray(vc);
        nVectorCandidates = vc.length;
        if (this.gdbg == null) {
            this.gdbg = new GridDebugger.Nop();
        }
        this.gdbg.imageSizes(this.wImg, this.hImg);
        this.gdbg.vectorCandidates(vc);
        this.gdbg.peaks(this.peaks);
        pt = new Point2D.Double();
        bestA = null;
        bestB = null;
        bestGridsize = 0;
        iterations = (vc.length - 1) * vc.length / 2;
        this.progressGrid.begin("finding grid vectors", iterations + 20);
        bestScore = 0.0;
        gridPoints = new HashMap<Point, Peak>(this.peaks.size());
        ai = 0;
        while (ai < vc.length) {
            av = vc[ai];
            bi = ai + 1;
            while (bi < vc.length) {
                block21: {
                    this.progressGrid.step();
                    bv = vc[bi];
                    ax = av.x;
                    ay = av.y;
                    bx = bv.x;
                    by = bv.y;
                    alSq = ax * ax + ay * ay;
                    blSq = bx * bx + by * by;
                    det = ax * by - bx * ay;
                    if (det * det < alSq * blSq * 0.0078125) break block21;
                    minGrid = new MinGrid(ax, ay, bx, by);
                    ax = minGrid.getA1() * av.x + minGrid.getB1() * bv.x;
                    ay = minGrid.getA1() * av.y + minGrid.getB1() * bv.y;
                    bx = minGrid.getA2() * av.x + minGrid.getB2() * bv.x;
                    by = minGrid.getA2() * av.y + minGrid.getB2() * bv.y;
                    this.gdbg.currentPair(ax, ay, bx, by);
                    try {
                        bounds = new LoopBounds(ax, ay, bx, by);
                    }
                    catch (NoninvertibleTransformException e) {
                        break block21;
                    }
                    bounds.boundsFor(-this.wImg, -this.hImg, this.wImg, this.hImg);
                    bounds.stepLowerBounds();
                    allOverlap = 0.0;
                    allAod = 0.0;
                    gridFit = 0.0;
                    peakFit = 0.0;
                    a = bounds.getMinA();
                    while (a <= bounds.getMaxA()) {
                        b = bounds.getMinB();
                        while (b <= bounds.getMaxB()) {
                            dx = Math.abs(a * ax + b * bx);
                            dy = Math.abs(a * ay + b * by);
                            dx = Math.max(0, this.wImg - dx);
                            dy = Math.max(0, this.hImg - dy);
                            overlap = (double)dx * (double)dy;
                            allOverlap += overlap;
                            ++b;
                        }
                        ++a;
                    }
                    gridPoints.clear();
                    ci = 0;
                    while (ci < this.peaks.size()) {
                        cp = (Peak)this.peaks.get(ci);
                        cx = cp.getX();
                        cy = cp.getY();
                        ca = (double)(cx * by - bx * cy) / det;
                        cb = (double)(ax * cy - cx * ay) / det;
                        ia = (int)Math.round(ca);
                        ib = (int)Math.round(cb);
                        fit = Recognizer.calculateFit(ca - (double)ia, cb - (double)ib);
                        cp.setFit(fit);
                        overlap = (this.wImg - Math.abs(cx)) * (this.hImg - Math.abs(cy));
                        denormalize = 1.0;
                        ip = new Point(ia, ib);
                        this.gdbg.beginPoint(ci, cp, ip, fit, overlap);
                        allAod += denormalize * (double)cp.getAod();
                        op = null;
                        if (ia != 0 || ib != 0) {
                            op = gridPoints.put(ip, cp);
                        }
                        if (op == null) ** GOTO lbl112
                        if (op.getFit() > fit) {
                            gridPoints.put(ip, op);
                            this.gdbg.skipPoint();
                        } else {
                            this.gdbg.replacePoint(op);
                            gridFit -= op.getFit() * overlap;
                            peakFit -= op.getFit() * denormalize * (double)op.getAod();
lbl112:
                            // 2 sources

                            gridFitSingle = fit * overlap;
                            peakFitSingle = fit * denormalize * (double)cp.getAod();
                            gridCoverage = (gridFit += gridFitSingle) / allOverlap;
                            peakCoverage = (peakFit += peakFitSingle) / allAod;
                            score = gridCoverage > 0.0 && peakCoverage > 0.0 ? gridCoverage * peakCoverage : Math.min(gridCoverage, peakCoverage);
                            this.gdbg.judgePoint(score, gridCoverage, peakCoverage);
                            if (score > bestScore && ci >= 8) {
                                bestScore = score;
                                bestA = new Point(ax, ay);
                                bestB = new Point(bx, by);
                                bestGridsize = ci + 1;
                            }
                        }
                        ++ci;
                    }
                    this.gdbg.donePair();
                }
                ++bi;
            }
            ++ai;
        }
        this.progressGrid.step();
        if (bestA == null) {
            throw new RecognitionException("No two independent translations");
        }
        ax = bestA.x;
        bx = bestB.x;
        ay = bestA.y;
        by = bestB.y;
        if (ax * bx + ay * by < 0.0) {
            bx *= -1.0;
            by *= -1.0;
        }
        if (ax * by - ay * bx > 0.0) {
            t = ax;
            ax = bx;
            bx = t;
            t = ay;
            ay = by;
            by = t;
        }
        this.peaks.subList(bestGridsize, this.peaks.size()).clear();
        this.progressGrid.step();
        det = ax * by - bx * ay;
        a2Sum = 0.0;
        b2Sum = 0.0;
        abSum = 0.0;
        axSum = 0.0;
        aySum = 0.0;
        bxSum = 0.0;
        bySum = 0.0;
        ci = 1;
        while (ci < this.peaks.size()) {
            cp = (Peak)this.peaks.get(ci);
            cx = cp.getX();
            cy = cp.getY();
            da = (cx * by - bx * cy) / det;
            db = (ax * cy - cx * ay) / det;
            ca = Math.rint(da);
            ea = da - ca;
            err = ea * ea + (eb = db - (cb = Math.rint(db))) * eb;
            if (!(err > 0.015625)) {
                a2Sum += ca * ca;
                b2Sum += cb * cb;
                abSum += ca * cb;
                axSum += ca * cx;
                aySum += ca * cy;
                bxSum += cb * cx;
                bySum += cb * cy;
            }
            ++ci;
        }
        det = a2Sum * b2Sum - abSum * abSum;
        minGrid = new MinGrid((axSum * b2Sum - abSum * bxSum) / det, (aySum * b2Sum - abSum * bySum) / det, (a2Sum * bxSum - axSum * abSum) / det, (a2Sum * bySum - aySum * abSum) / det);
        this.trv = minGrid.getTransform(false);
        System.err.println("fit: " + this.trv);
        this.debugPeaks(this.peaks, "debugGrid", true);
        this.progressGrid.done();
    }

    static double calculateFit(double errorA, double errorB) {
        errorA = Math.abs(errorA);
        errorB = Math.abs(errorB);
        double error = ((errorA -= 0.5) * errorA + (errorB -= 0.5) * errorB) * 2.0;
        return 10.0 * error - 9.0;
    }

    private BufferedImage getMedian(int repeat, ProgressPhase progress) throws CanceledOperationException, NoninvertibleTransformException {
        Point2D.Double p = new Point2D.Double();
        p.setLocation(0.0, 0.0);
        this.trv.transform(p, p);
        Rectangle2D.Double bounds = new Rectangle2D.Double(p.getX(), p.getY(), 0.0, 0.0);
        p.setLocation(repeat, 0.0);
        this.trv.transform(p, p);
        bounds.add(p);
        p.setLocation(0.0, repeat);
        this.trv.transform(p, p);
        bounds.add(p);
        p.setLocation(repeat, repeat);
        this.trv.transform(p, p);
        bounds.add(p);
        int w = (int)Math.round(((RectangularShape)bounds).getWidth());
        int h = (int)Math.round(((RectangularShape)bounds).getHeight());
        ColorModel cm = repeat == 1 ? cmAlpha : this.img.getColorModel();
        this.tri = AffineTransform.getScaleInstance((double)w / ((RectangularShape)bounds).getWidth(), (double)h / ((RectangularShape)bounds).getHeight());
        this.tri.translate(-((RectangularShape)bounds).getX(), -((RectangularShape)bounds).getY());
        this.tri.concatenate(this.trv);
        this.tri.translate(repeat / 2, repeat / 2);
        AffineTransform invTri = this.tri.createInverse();
        boolean singleTile = repeat == 1;
        return this.getMedian(progress, w, h, cm, singleTile, invTri);
    }

    private BufferedImage getMedianSquare(ProgressPhase progress) throws CanceledOperationException, NoninvertibleTransformException {
        double ax = this.trv.getScaleX();
        double ay = this.trv.getShearY();
        double bx = this.trv.getShearX();
        double by = this.trv.getScaleY();
        double sizeSq = Math.max(ax * ax + ay * ay, bx * bx + by * by);
        int size = (int)Math.round(Math.sqrt(sizeSq));
        this.tri = AffineTransform.getScaleInstance(size, size);
        double invSize = 1.0 / (double)size;
        AffineTransform invTri = AffineTransform.getScaleInstance(invSize, invSize);
        ColorModel cm = this.img.getColorModel();
        boolean singleTile = false;
        return this.getMedian(progress, size, size, cm, singleTile, invTri);
    }

    /*
     * Unable to fully structure code
     */
    private BufferedImage getMedian(ProgressPhase progress, int w, int h, ColorModel cm, boolean singleTile, AffineTransform tr) throws CanceledOperationException, NoninvertibleTransformException {
        progress.begin("getting median tile", w * h);
        p1 = new Point2D.Double();
        p2 = new Point2D.Double();
        p3 = new Point2D.Double();
        fillInAlpha = cm.hasAlpha() != false && this.hasAlpha == false;
        in = this.img.getRaster();
        out = cm.createCompatibleWritableRaster(w, h);
        median = new BufferedImage(cm, out, true, null);
        ib = new LoopBounds(this.trv);
        ib.boundsFor(0.0, 0.0, this.wImg - 1, this.hImg - 1);
        ib.stepLowerBounds();
        samples = new int[4][ib.getCount() * this.group.countTransforms()];
        samples[3][0] = 255;
        y1 = 0;
        while (y1 < h) {
            x1 = 0;
            while (x1 < w) {
                block12: {
                    p1.setLocation((double)x1 + 0.5, (double)y1 + 0.5);
                    tr.transform(p1, p1);
                    if (singleTile) break block12;
                    p1.x -= Math.floor(p1.x);
                    p1.y -= Math.floor(p1.y);
                    ** GOTO lbl-1000
                }
                if (p1.x < 0.0 || p1.y < 0.0 || p1.x >= 1.0 || p1.y >= 1.0) {
                    progress.step();
                } else lbl-1000:
                // 2 sources

                {
                    orbitLen = 0;
                    i = 0;
                    while (i < this.group.countTransforms()) {
                        this.group.getTransform(i).transform(p1, p2);
                        p2.x -= Math.floor(p2.x);
                        p2.y -= Math.floor(p2.y);
                        a = ib.getMinA();
                        while (a <= ib.getMaxA()) {
                            b = ib.getMinB();
                            while (b <= ib.getMaxB()) {
                                p3.setLocation(p2.x + (double)a, p2.y + (double)b);
                                this.trv.transform(p3, p3);
                                x2 = (int)Math.floor(p3.x);
                                y2 = (int)Math.floor(p3.y);
                                if (x2 >= 0 && x2 < this.wImg && y2 >= 0 && y2 < this.hImg) {
                                    band = 0;
                                    while (band < in.getNumBands()) {
                                        samples[band][orbitLen] = in.getSample(x2, y2, band);
                                        ++band;
                                    }
                                    ++orbitLen;
                                }
                                ++b;
                            }
                            ++a;
                        }
                        ++i;
                    }
                    start = orbitLen / 3;
                    end = orbitLen - start;
                    count = end - start;
                    half = count / 2;
                    band = 0;
                    while (band < in.getNumBands()) {
                        sb = samples[band];
                        Arrays.sort(sb, 0, orbitLen);
                        sum = half;
                        i = start;
                        while (i < end) {
                            sum += sb[i];
                            ++i;
                        }
                        out.setSample(x1, y1, band, sum / count);
                        ++band;
                    }
                    if (fillInAlpha) {
                        out.setSample(x1, y1, 3, 255);
                    }
                    progress.step();
                }
                ++x1;
            }
            ++y1;
        }
        progress.done();
        return median;
    }

    private void innerSymmetries() throws CanceledOperationException, NoninvertibleTransformException, IOException {
        FeatureInspector fi = new FeatureInspector(this.median, this.tri, this.trv, this.progressSymmetry, this.debug);
        this.group = fi.decideInnerSymmetries();
    }
}

