/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.recog;

import de.tum.in.gagern.ornament.recog.CanceledOperationException;
import de.tum.in.gagern.ornament.recog.ProgressPhase;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

class ProgressView
extends ProgressPhase
implements Runnable,
ActionListener {
    private static final int SCALE = 32768;
    private final JDialog dlg;
    private final JProgressBar overallBar;
    private final JProgressBar taskBar;
    private final JLabel noticeLabel;
    private final JButton cancelButton;
    private boolean isCanceled = false;
    private boolean updateScheduled = false;
    private int overallValue = 0;
    private int taskValue = 0;
    private String noticeText = "";
    private float weightSum = 0.0f;

    public ProgressView(Component parent, String title, String cancelCaption) {
        super(null, 1.0f, 0.0f);
        Frame owner = JOptionPane.getFrameForComponent(parent);
        this.dlg = new JDialog(owner, title, false);
        this.overallBar = new JProgressBar(0, 32768);
        this.taskBar = new JProgressBar(0, 32768);
        this.noticeLabel = new JLabel(this.noticeText);
        this.cancelButton = new JButton(cancelCaption);
        this.cancelButton.addActionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        Container c = this.dlg.getContentPane();
        c.setLayout(new GridBagLayout());
        c.add((Component)this.overallBar, gbc);
        c.add((Component)this.noticeLabel, gbc);
        c.add((Component)this.taskBar, gbc);
        gbc.fill = 0;
        gbc.anchor = 22;
        c.add((Component)this.cancelButton, gbc);
    }

    @Override
    public synchronized void update(float newValue, ProgressPhase activeChild) throws CanceledOperationException {
        super.update(newValue, activeChild);
        if (this.isCanceled) {
            throw new CanceledOperationException();
        }
        this.overallValue = (int)Math.floor(32768.0f * this.getFraction());
        this.taskValue = (int)Math.floor(32768.0f * activeChild.getFraction());
        if (!activeChild.isDeterminate()) {
            this.taskValue = -1;
        }
        this.scheduleUpdate();
    }

    @Override
    public synchronized void setNotice(String notice) {
        super.setNotice(notice);
        this.noticeText = notice == null ? "" : notice;
        this.scheduleUpdate();
    }

    private synchronized void scheduleUpdate() {
        if (EventQueue.isDispatchThread()) {
            this.run();
        } else if (!this.updateScheduled) {
            this.updateScheduled = true;
            EventQueue.invokeLater(this);
        }
    }

    public void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = ProgressView.this.noticeLabel.getText();
                ProgressView.this.noticeLabel.setText("Some rather long text for minimum size");
                ProgressView.this.dlg.pack();
                ProgressView.this.noticeLabel.setMinimumSize(ProgressView.this.noticeLabel.getSize());
                ProgressView.this.noticeLabel.setText(text);
                ProgressView.this.dlg.setLocationRelativeTo(ProgressView.this.dlg.getOwner());
                ProgressView.this.dlg.setVisible(true);
            }
        });
    }

    public void close() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressView.this.dlg.setVisible(false);
                ProgressView.this.dlg.dispose();
            }
        });
    }

    @Override
    public synchronized void run() {
        this.updateScheduled = false;
        this.overallBar.setValue(this.overallValue);
        if (this.taskValue < 0) {
            this.taskBar.setIndeterminate(true);
            this.taskBar.setValue(0);
        } else {
            this.taskBar.setValue(this.taskValue);
            this.taskBar.setIndeterminate(false);
        }
        this.noticeLabel.setText(this.noticeText);
        this.cancelButton.setEnabled(!this.isCanceled);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evnt) {
        this.isCanceled = true;
        this.cancelButton.setEnabled(false);
    }

    @Override
    public Component getComponent() {
        return this.dlg;
    }
}

