/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class ImagePainter {
    private static Toolkit currentToolkit;
    private static Map cache;
    private final Image img;

    public static ImagePainter getInstance(Component component, String name) {
        Object cached;
        Toolkit toolkit = component.getToolkit();
        if (toolkit == null) {
            throw new NullPointerException();
        }
        if (toolkit != currentToolkit) {
            cache = new HashMap(5);
        }
        if ((cached = cache.get(name)) != null) {
            return (ImagePainter)cached;
        }
        URL url = ImagePainter.class.getResource(name);
        if (url == null) {
            return new ImagePainter(null);
        }
        Image img = toolkit.createImage(url);
        ImagePainter newPainter = new ImagePainter(img);
        MediaTracker mt = new MediaTracker(component);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        cache.put(name, newPainter);
        return newPainter;
    }

    private ImagePainter(Image img) {
        this.img = img;
    }

    public void foreground(Graphics g, Component c, int x, int y, int w, int h) {
        if (this.img == null) {
            return;
        }
        int w1 = this.img.getWidth(c);
        int h1 = this.img.getHeight(c);
        if (w1 == -1 || h1 == -1) {
            return;
        }
        int w2 = (w1 - 1) / 2;
        int h2 = (h1 - 1) / 2;
        g.drawImage(this.img, x, y, x + w2, y + h2, 0, 0, w2, h2, c);
        g.drawImage(this.img, x + w2, y, x + w - w2, y + h2, w2, 0, w1 - w2, h2, c);
        g.drawImage(this.img, x + w - w2, y, x + w, y + h2, w1 - w2, 0, w1, h2, c);
        g.drawImage(this.img, x, y + h2, x + w2, y + h - h2, 0, h2, w2, h1 - h2, c);
        g.drawImage(this.img, x + w2, y + h2, x + w - w2, y + h - h2, w2, h2, w1 - w2, h1 - h2, c);
        g.drawImage(this.img, x + w - w2, y + h2, x + w, y + h - h2, w1 - w2, h2, w1, h1 - h2, c);
        g.drawImage(this.img, x, y + h - h2, x + w2, y + h, 0, h1 - h2, w2, h1, c);
        g.drawImage(this.img, x + w2, y + h - h2, x + w - w2, y + h, w2, h2, w1 - w2, h1, c);
        g.drawImage(this.img, x + w - w2, y + h - h2, x + w, y + h, w1 - w2, h1 - h2, w1, h1, c);
    }

    public void foreground(Graphics g, Component c) {
        this.foreground(g, c, 0, 0, c.getWidth(), c.getHeight());
    }

    public void background(Graphics g, Component c, Color bg, int x, int y, int w, int h) {
        if (bg == null || this.img == null) {
            return;
        }
        int w1 = this.img.getWidth(c);
        int h1 = this.img.getHeight(c);
        if (w1 == -1 || h1 == -1) {
            return;
        }
        int w2 = (w1 - 1) / 2;
        int h2 = (h1 - 1) / 2;
        Color old = g.getColor();
        g.setColor(bg);
        g.fillRoundRect(x, y, w, h, w2 + 1, h2 + 1);
        g.setColor(old);
    }

    public void background(Graphics g, Component c) {
        this.background(g, c, c.getBackground(), 0, 0, c.getWidth(), c.getHeight());
    }
}

