/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.export.Export;
import de.tum.in.gagern.ornament.export.ExportMechanism;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileExportMechanism
extends ExportMechanism {
    private JFileChooser fdlg;

    public FileExportMechanism(Ornament main) {
        super(main);
    }

    @Override
    public boolean init() {
        if (!super.init()) {
            return false;
        }
        this.fdlg = new JFileChooser();
        this.fdlg.setAcceptAllFileFilterUsed(false);
        int i = 0;
        while (i < this.exports.length) {
            this.fdlg.addChoosableFileFilter(this.exports[i]);
            ++i;
        }
        this.fdlg.setFileFilter(this.exports[0]);
        return true;
    }

    @Override
    public void export() {
        if (this.fdlg.showDialog(this.main, I18n._("Export")) != 0) {
            return;
        }
        File file = this.fdlg.getSelectedFile();
        if (file == null) {
            JOptionPane.showMessageDialog(this.main, I18n._("No file name given"), I18n._("Export"), 2);
            return;
        }
        FileFilter filter = this.fdlg.getFileFilter();
        if (filter instanceof Export) {
            try {
                this.exportToFile((Export)filter, file);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Export"), 0);
            }
            catch (NoninvertibleTransformException ex) {
                JOptionPane.showMessageDialog(this.main, ex.getLocalizedMessage(), I18n._("Export"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.main, I18n._("Invalid file type"), I18n._("Export"), 2);
        }
    }

    private void exportToFile(Export export, File file) throws IOException, NoninvertibleTransformException {
        Object[] args;
        file = export.fixFile(file);
        this.fdlg.setSelectedFile(file);
        if (file.exists() && JOptionPane.showConfirmDialog(this.main, I18n._("export.overwrite", args = new Object[]{file.getAbsolutePath(), file.getName()}), I18n._("Export"), 0) != 0) {
            return;
        }
        if (!export.configure()) {
            return;
        }
        FileOutputStream os = new FileOutputStream(file);
        export.export(os);
    }
}

