/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament.export;

import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.LinPath;
import de.tum.in.gagern.ornament.Ornament;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.ProgressMonitor;
import javax.swing.filechooser.FileFilter;

public abstract class Export
extends FileFilter {
    protected Ornament ornament;
    private String[] extensions;
    protected Color color;
    protected BasicStroke stroke;
    protected OutputStream out;

    protected Export(Ornament ornament, String extension) {
        this(ornament, new String[]{extension});
    }

    protected Export(Ornament ornament, String[] extensions) {
        this.ornament = ornament;
        this.extensions = extensions;
        this.color = null;
        this.stroke = null;
    }

    public boolean export(OutputStream out) throws IOException, NoninvertibleTransformException {
        this.out = out;
        List lines = this.ornament.getLines();
        int nLines = lines.size();
        int maxProgress = nLines + 2;
        ProgressMonitor pm = new ProgressMonitor(this.ornament, I18n._("exporting"), null, 0, maxProgress);
        this.init();
        this.prepareStream();
        pm.setProgress(1);
        this.head();
        BufferedImage bg = this.ornament.getBackgroundTile();
        if (bg != null) {
            this.background(bg);
        }
        int i = 0;
        while (i != nLines && !pm.isCanceled()) {
            pm.setProgress(2 + i);
            this.export((LinPath)lines.get(i));
            ++i;
        }
        pm.setProgress(2 + nLines);
        this.postBody();
        this.tail();
        if (out != null) {
            out.close();
        }
        pm.close();
        return true;
    }

    public boolean configure() {
        return true;
    }

    protected void init() throws NoninvertibleTransformException {
        this.color = null;
        this.stroke = null;
    }

    protected void prepareStream() throws IOException {
        this.out = new BufferedOutputStream(this.out);
    }

    public File fixFile(File file) {
        if (this.accept(file)) {
            return file;
        }
        return new File(String.valueOf(file.getPath()) + "." + this.getExtensions()[0]);
    }

    public void export(LinPath l) throws IOException, NoninvertibleTransformException {
        Color newColor = l.getColor();
        BasicStroke newStroke = l.getStroke();
        if (!newColor.equals(this.color)) {
            this.color(newColor);
            this.color = newColor;
        }
        if (!newStroke.equals(this.stroke)) {
            this.stroke(newStroke);
            this.stroke = newStroke;
        }
        this.path(l);
    }

    protected void path(LinPath l) throws IOException, NoninvertibleTransformException {
        this.coords(l.getCoordinates());
    }

    protected void head() throws IOException {
    }

    protected void background(BufferedImage img) throws IOException {
    }

    protected void postBody() throws IOException {
    }

    protected void tail() throws IOException {
    }

    protected void color(Color c) throws IOException {
    }

    protected void stroke(BasicStroke s) throws IOException {
    }

    protected void coords(float[] c) throws IOException {
    }

    @Override
    public boolean accept(File f) {
        if (f.isHidden()) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName().toLowerCase();
        String[] exts = this.getExtensions();
        int i = 0;
        while (i < exts.length) {
            if (name.endsWith("." + exts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public abstract String getDescription();

    public String toString() {
        return this.getDescription();
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    protected String loadString(String key) throws MissingResourceException {
        String name = String.valueOf(this.getClass().getName().replace('.', '/')) + "." + key + ".txt";
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(name);
        if (stream == null) {
            throw new MissingResourceException("could not load resource file", this.getClass().getName(), key);
        }
        try {
            int len;
            char[] buf = new char[2048];
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            int pos = 0;
            while ((len = ((Reader)reader).read(buf, pos, buf.length - pos)) > 0) {
                if ((pos += len) != buf.length) continue;
                char[] newArr = new char[buf.length * 4];
                System.arraycopy(buf, 0, newArr, 0, pos);
                buf = newArr;
            }
            String string = new String(buf, 0, pos);
            return string;
        }
        catch (IOException e) {
            throw new MissingResourceException(e.toString(), this.getClass().getName(), key);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

