/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.Controls;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

class KioskMode
implements AWTEventListener,
KeyEventDispatcher,
ActionListener {
    private static final String RESET_TIMEOUT_KEY = "kioskResetTimeout";
    private static final int RESET_TIMEOUT_DEFAULT = 600000;
    private static final int RESET_TIMEOUT_MIN = 1000;
    private static final double MINUTE = 60000.0;
    private static final String CURSOR_INVISIBLE_KEY = "kioskCursorInvisible";
    private static final boolean CURSOR_INVISIBLE_DEFAULT = true;
    private final Ornament main;
    private final Controls controls;
    private final Preferences prefs;
    private JDialog dialog;
    private JCheckBox cursorInvisible;
    private JFormattedTextField timeoutField;
    private boolean active;
    private JFrame fullScreenWindow;
    private GraphicsDevice gd;
    private Toolkit toolkit;
    private Cursor invisibleCursor;
    private Timer timer;

    public KioskMode(Ornament main, Controls controls) {
        this.main = main;
        this.controls = controls;
        this.prefs = Preferences.userNodeForPackage(KioskMode.class);
        this.timer = new Timer(600000, this);
        this.timer.setRepeats(false);
    }

    private JDialog initDialog() {
        if (this.main.window == null || !(this.main.window instanceof JFrame)) {
            return null;
        }
        JDialog dlg = new JDialog((Frame)((JFrame)this.main.window), I18n._("file.Kiosk"));
        Container cp = dlg.getContentPane();
        cp.setLayout(new BoxLayout(cp, 3));
        JPanel panel = new JPanel();
        cp.add(panel);
        this.cursorInvisible = new JCheckBox(I18n._("kiosk.cursor invisible"));
        panel.add(this.cursorInvisible);
        panel = new JPanel();
        cp.add(panel);
        panel.add(new JLabel(I18n._("kiosk.reset1")));
        NumberFormat format = NumberFormat.getInstance();
        format.setParseIntegerOnly(false);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(0);
        this.timeoutField = new JFormattedTextField(format);
        this.timeoutField.setColumns(6);
        panel.add(this.timeoutField);
        panel.add(new JLabel(I18n._("kiosk.reset2")));
        panel = new JPanel();
        cp.add(panel);
        panel.add(new JLabel(I18n._("kiosk.howtoexit")));
        panel = new JPanel();
        cp.add(panel);
        panel.add(new JButton(new AbstractAction(I18n._("kiosk.Start")){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                KioskMode.this.saveConfig();
                KioskMode.this.dialog.setVisible(false);
                KioskMode.this.start();
            }
        }));
        panel.add(new JButton(new AbstractAction(I18n._("kiosk.Save")){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                KioskMode.this.saveConfig();
                KioskMode.this.dialog.setVisible(false);
            }
        }));
        panel.add(new JButton(new AbstractAction(I18n._("Cancel")){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                KioskMode.this.dialog.setVisible(false);
            }
        }));
        dlg.pack();
        return dlg;
    }

    private int getTimeout() {
        return this.prefs.getInt(RESET_TIMEOUT_KEY, 600000);
    }

    private boolean isCursorInvisible() {
        return this.prefs.getBoolean(CURSOR_INVISIBLE_KEY, true);
    }

    public void configure() {
        if (this.dialog == null) {
            this.dialog = this.initDialog();
            if (this.dialog == null) {
                return;
            }
        }
        this.loadConfig();
        this.dialog.setLocationRelativeTo(this.main);
        this.dialog.setVisible(true);
    }

    private void loadConfig() {
        this.cursorInvisible.setSelected(this.isCursorInvisible());
        this.timeoutField.setValue(new Double((double)this.getTimeout() / 60000.0));
    }

    private void saveConfig() {
        this.prefs.putBoolean(CURSOR_INVISIBLE_KEY, this.cursorInvisible.isSelected());
        double timeoutMinutes = ((Number)this.timeoutField.getValue()).doubleValue();
        int timeout = (int)Math.round(timeoutMinutes * 60000.0);
        if (timeout < 1000) {
            timeout = 1000;
        }
        this.prefs.putInt(RESET_TIMEOUT_KEY, timeout);
    }

    public void start() {
        if (this.active) {
            this.stop();
        }
        if (this.main == null) {
            this.fullScreenWindow = new JFrame();
        } else {
            if (this.main.window == null || !(this.main.window instanceof JFrame)) {
                return;
            }
            JFrame mainFrame = (JFrame)this.main.window;
            GraphicsConfiguration gc = mainFrame.getGraphicsConfiguration();
            this.fullScreenWindow = new JFrame(gc);
        }
        this.gd = this.fullScreenWindow.getGraphicsConfiguration().getDevice();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.fullScreenWindow.setUndecorated(true);
        this.fullScreenWindow.setVisible(true);
        this.toolkit = this.fullScreenWindow.getToolkit();
        this.gd.setFullScreenWindow(this.fullScreenWindow);
        this.active = true;
        this.fullScreenWindow.setContentPane(new Ornament(this.fullScreenWindow, false, this));
        this.fullScreenWindow.requestFocus();
        this.fullScreenWindow.validate();
        this.fullScreenWindow.repaint();
        if (this.isCursorInvisible()) {
            if (this.invisibleCursor == null) {
                this.invisibleCursor = this.makeInvisibleCursor();
            }
            this.fullScreenWindow.setCursor(this.invisibleCursor);
        }
        this.toolkit.addAWTEventListener(this, 32L);
        this.timer.setInitialDelay(this.getTimeout());
        this.timer.start();
    }

    public void stop() {
        if (!this.active) {
            return;
        }
        this.timer.stop();
        this.toolkit.removeAWTEventListener(this);
        this.gd.setFullScreenWindow(null);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.active = false;
        this.fullScreenWindow.dispose();
        this.fullScreenWindow = null;
        if (this.main == null) {
            System.exit(0);
        }
    }

    private Cursor makeInvisibleCursor() {
        BufferedImage img = new BufferedImage(32, 32, 2);
        return this.toolkit.createCustomCursor(img, new Point(0, 0), I18n._("invisible cursor"));
    }

    @Override
    public void eventDispatched(AWTEvent evnt) {
        if (this.active) {
            this.timer.restart();
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent evnt) {
        if (this.active && evnt.getKeyCode() == 27) {
            this.stop();
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent evnt) {
        if (!this.active) {
            return;
        }
        this.fullScreenWindow.setContentPane(new Ornament(this.fullScreenWindow, false, this));
        this.fullScreenWindow.validate();
        this.fullScreenWindow.repaint();
    }
}

