/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.AboutDlg;
import de.tum.in.gagern.ornament.ColorButton;
import de.tum.in.gagern.ornament.ColorChooser;
import de.tum.in.gagern.ornament.ColorDlg;
import de.tum.in.gagern.ornament.Constants;
import de.tum.in.gagern.ornament.Documentation;
import de.tum.in.gagern.ornament.ExportAction;
import de.tum.in.gagern.ornament.Group;
import de.tum.in.gagern.ornament.GroupButton;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.KioskMode;
import de.tum.in.gagern.ornament.Ornament;
import de.tum.in.gagern.ornament.RecogAction;
import de.tum.in.gagern.ornament.StrokeButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;

class Controls
implements Constants {
    private static final String COLORS_FIXED = "COLORS_FIXED";
    private static final String COLORS_CHOOSER = "COLORS_CHOOSER";
    Ornament main;
    ButtonGroup bgGroup;
    ButtonGroup bgColor;
    ButtonGroup bgStroke;
    AbstractButton customColor;
    GroupButton[] grpButtons;
    ColorButton[] clrButtons;
    ColorChooser colorChooser;
    private JPanel colorPanel;
    private CardLayout colorCards;
    private Action bgImgAction;
    private AbstractButton bgImgItem;
    static final Font buttonFont = new Font("Dialog", 0, 16);
    static final int[] colors;
    static final int[] strokeWidths;

    static {
        int[] nArray = new int[20];
        nArray[1] = 0x404040;
        nArray[2] = 0x808080;
        nArray[3] = 0xC0C0C0;
        nArray[4] = 0xFFFFFF;
        nArray[5] = 0x808000;
        nArray[6] = 32768;
        nArray[7] = 65280;
        nArray[8] = 65408;
        nArray[9] = 0xFFFF00;
        nArray[10] = 0x800080;
        nArray[11] = 128;
        nArray[12] = 255;
        nArray[13] = 33023;
        nArray[14] = 65535;
        nArray[15] = 0x800000;
        nArray[16] = 0xFF00FF;
        nArray[17] = 0xFF0080;
        nArray[18] = 0xFF0000;
        nArray[19] = 0xFF8000;
        colors = nArray;
        strokeWidths = new int[]{1, 2, 5, 8, 12};
    }

    Controls(Ornament ornament) {
        this.main = ornament;
    }

    public JPanel createGroupButtons() {
        JPanel panel = new JPanel();
        GridLayout layout = new GridLayout(0, 1);
        panel.setLayout(layout);
        Group[] grps = Group.getGroups();
        this.grpButtons = new GroupButton[grps.length];
        this.clrButtons = new ColorButton[colors.length];
        this.bgGroup = new ButtonGroup();
        int i = 0;
        while (i < grps.length) {
            this.grpButtons[i] = new GroupButton(this.main, grps[i]);
            GroupButton btn = this.grpButtons[i];
            this.bgGroup.add(btn);
            if (i == 10) {
                btn.doClick();
            }
            this.format(btn);
            panel.add(btn);
            ++i;
        }
        return panel;
    }

    public JPanel createMiscControls() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        panel.add((Component)buttons, "Center");
        AbstractButton btn = new JButton(I18n._("btn.UNDO"));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List l = Controls.this.main.lines;
                if (l.isEmpty()) {
                    return;
                }
                l.remove(l.size() - 1);
                Controls.this.main.repaintBuffer();
            }
        });
        this.format(btn);
        buttons.add(btn);
        String clear = I18n._("btn.CLEAR");
        if (clear.length() == 3) {
            clear = "  " + clear + "  ";
        }
        btn = new JButton(clear);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controls.this.main.clearLines();
                Controls.this.main.tv.centerTile();
            }
        });
        this.format(btn);
        buttons.add(btn);
        JPanel widths = new JPanel();
        widths.setLayout(new GridLayout(0, 5));
        panel.add((Component)widths, "North");
        this.bgStroke = new ButtonGroup();
        int i = 0;
        while (i < strokeWidths.length) {
            btn = new StrokeButton(this.main, strokeWidths[i]);
            this.bgStroke.add(btn);
            this.format(btn);
            widths.add(btn);
            if (i == 1) {
                btn.doClick();
            }
            ++i;
        }
        return panel;
    }

    public JPanel createColorControls() {
        this.colorPanel = new JPanel();
        this.colorCards = new CardLayout();
        this.colorPanel.setLayout(this.colorCards);
        this.colorChooser = new ColorChooser();
        this.colorChooser.setChosenColor(this.main.colors[0]);
        this.colorChooser.setBackground(this.main.colors[1]);
        this.colorChooser.addPropertyChangeListener("chosenColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evnt) {
                Controls.this.main.setColor((Color)evnt.getNewValue());
            }
        });
        this.colorPanel.add((Component)this.colorChooser, COLORS_CHOOSER);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 5));
        this.colorPanel.add((Component)panel, COLORS_FIXED);
        this.bgColor = new ButtonGroup();
        int i = 0;
        while (i < colors.length) {
            this.clrButtons[i] = new ColorButton(this.main, 9, 9, new Color(colors[i]));
            ColorButton btn = this.clrButtons[i];
            this.bgColor.add(btn);
            this.format(btn);
            panel.add(btn);
            if (i == 4) {
                btn.doClick();
            }
            ++i;
        }
        this.customColor = new JRadioButton("custom color");
        this.bgColor.add(this.customColor);
        return this.colorPanel;
    }

    void format(AbstractButton btn) {
        btn.setFont(buttonFont);
        if (this.main.kioskMode != null) {
            btn.setFocusPainted(false);
        }
    }

    JMenuBar createMenu() {
        JMenuItem itm;
        JMenuBar bar = new JMenuBar();
        JMenu m = new JMenu(I18n._("File"));
        if (this.main.kioskMode == null) {
            bar.add(m);
        }
        m.add(new JMenuItem(new ExportAction(this.main)));
        m.add(new JMenuItem(new RecogAction(this.main)));
        if (this.main.window != null) {
            m.add(new JMenuItem(new AbstractAction(I18n.dots(I18n._("file.Kiosk"))){
                KioskMode kioskMode;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.kioskMode == null) {
                        this.kioskMode = new KioskMode(Controls.this.main, Controls.this);
                    }
                    this.kioskMode.configure();
                }
            }));
        }
        m = new JMenu(I18n._("Grid"));
        bar.add(m);
        Action[] grids = new Action[]{new GridMode(1, I18n._("Tile")), new GridMode(2, I18n._("Cell")), new GridMode(4, I18n._("Properties")), new GridMode(8, I18n._("Buffer"))};
        int i = 0;
        while (i < grids.length) {
            m.add(new JCheckBoxMenuItem(grids[i]));
            ++i;
        }
        m = new JMenu(I18n._("Settings"));
        bar.add(m);
        JMenu m2 = new JMenu(I18n._("setting.Colors"));
        m.add(m2);
        ButtonGroup bgrp = new ButtonGroup();
        Action[] colorModes = new Action[]{new ColorMode(COLORS_FIXED, I18n._("colors.fixed")), new ColorMode(COLORS_CHOOSER, I18n._("colors.chooser"))};
        int i2 = 0;
        while (i2 < colorModes.length) {
            itm = new JRadioButtonMenuItem(colorModes[i2]);
            bgrp.add(itm);
            m2.add(itm);
            if (i2 == 0) {
                itm.setSelected(true);
            }
            ++i2;
        }
        itm = new JMenuItem(new AbstractAction(I18n.dots(I18n._("colors.configure"))){
            ColorDlg cdlg;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.cdlg == null) {
                    this.cdlg = new ColorDlg(Controls.this.main, Controls.this);
                }
                this.cdlg.show();
            }
        });
        if (this.main.kioskMode == null) {
            m2.addSeparator();
            m2.add(itm);
        }
        m2 = new JMenu(I18n._("Naming"));
        m.add(m2);
        bgrp = new ButtonGroup();
        Action[] namings = new Action[]{new NamingSystem(1, I18n._("Crystallographic")), new NamingSystem(3, I18n._("Orbifold")), new NamingSystem(2, I18n._("Orbifold (ASCII)"))};
        int i3 = 0;
        while (i3 < namings.length) {
            itm = new JRadioButtonMenuItem(namings[i3]);
            bgrp.add(itm);
            m2.add(itm);
            if (i3 == 0) {
                itm.setSelected(true);
            }
            ++i3;
        }
        itm = new JCheckBoxMenuItem(new AbstractAction(I18n._("settings.Antialias")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean aa = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.setAntiAlias(aa);
            }
        });
        itm.setSelected(true);
        m.add(itm);
        m.add(new JCheckBoxMenuItem(new AbstractAction(I18n._("setting.Ignore Line Widths")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controls.this.main.useStrokes = !((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.repaintBuffer();
            }
        }));
        m.add(new JCheckBoxMenuItem(new AbstractAction(I18n._("setting.Grid On Top")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controls.this.main.gridOnTop = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.repaintBuffer();
            }
        }));
        m.add(new JCheckBoxMenuItem(new AbstractAction(I18n._("setting.Shaded Tiles")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Controls.this.main.tv.shadeMode = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.tv.recalcTiling();
                Controls.this.main.tv.repaint();
            }
        }));
        this.bgImgAction = new AbstractAction(I18n._("settings.Background")){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean on = ((AbstractButton)e.getSource()).isSelected();
                Controls.this.main.showBackground(on);
            }
        };
        this.bgImgItem = new JCheckBoxMenuItem(this.bgImgAction);
        this.hasBackground(false);
        m.add(this.bgImgItem);
        m = new JMenu(I18n._("Help"));
        if (this.main.kioskMode == null) {
            bar.add(m);
        }
        m.add(new JMenuItem(new AbstractAction(I18n._("help.Manual")){
            Documentation doc;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.doc == null) {
                    String path = I18n._("help.Manual.path");
                    this.doc = new Documentation(Controls.this.main, path);
                } else {
                    this.doc.show();
                }
            }
        }));
        m.add(new JMenuItem(new AbstractAction(I18n._("help.About")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Controls.this.main, new AboutDlg(), I18n._("about.title"), -1);
            }
        }));
        return bar;
    }

    public void setGroup(Group group) {
        int i = 0;
        while (i < this.grpButtons.length) {
            GroupButton b = this.grpButtons[i];
            Group g = b.getSymmetryGroup();
            if (g.equals(group)) {
                b.doClick();
                return;
            }
            ++i;
        }
    }

    void setColor(Color color) {
        this.colorChooser.setChosenColor(color);
        int i = 0;
        while (i < this.clrButtons.length) {
            ColorButton b = this.clrButtons[i];
            if (b.c.equals(color)) {
                b.doClick();
                return;
            }
            ++i;
        }
        this.customColor.doClick();
    }

    void setBackgroundColor(Color color) {
        this.colorChooser.setBackground(color);
    }

    public void hasBackground(boolean hasBackground) {
        if (this.bgImgAction == null) {
            return;
        }
        this.bgImgAction.setEnabled(hasBackground);
        this.bgImgItem.setSelected(hasBackground);
    }

    class ColorMode
    extends AbstractAction {
        final String colorMode;

        ColorMode(String mode, String str) {
            super(str);
            this.colorMode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Controls.this.colorCards.show(Controls.this.colorPanel, this.colorMode);
        }
    }

    class GridMode
    extends AbstractAction {
        int mode;

        GridMode(int mode, String str) {
            super(str);
            this.mode = mode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Controls.this.main.setGrid(this.mode, ((AbstractButton)e.getSource()).isSelected());
        }
    }

    class NamingSystem
    extends AbstractAction {
        final int namingSystem;

        NamingSystem(int code, String str) {
            super(str);
            this.namingSystem = code;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < Controls.this.grpButtons.length) {
                Controls.this.grpButtons[i].setName(this.namingSystem);
                Controls.this.grpButtons[i].invalidate();
                ++i;
            }
        }
    }
}

