/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.gagern.ornament;

import de.tum.in.gagern.ornament.Constants;
import de.tum.in.gagern.ornament.Controls;
import de.tum.in.gagern.ornament.I18n;
import de.tum.in.gagern.ornament.Ornament;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

class ColorDlg
implements Constants,
TreeSelectionListener {
    Ornament main;
    Controls controls;
    Color[] colors;
    Color color;
    JDialog dlg;
    JColorChooser cc;
    JTree tree;
    JLabel sub;
    int index;
    boolean changes;

    ColorDlg(Ornament main, Controls controls) {
        this.main = main;
        this.controls = controls;
        Container c = main;
        while (this.dlg == null && c != null) {
            if (c instanceof Frame) {
                this.dlg = new JDialog((Frame)c);
            } else if (c instanceof Dialog) {
                this.dlg = new JDialog((Dialog)c);
            }
            c = c.getParent();
        }
        if (this.dlg == null) {
            this.dlg = new JDialog();
        }
        this.cc = new JColorChooser();
        this.tree = new JTree(new Node(new Node[]{new Node(0, I18n._("Pen")), new Node(1, I18n._("Background")), new Node(I18n._("Grid"), new Node[]{new Node(2, I18n._("Tile")), new Node(3, I18n._("Cell")), new Node(4, I18n._("Buffer")), new Node(5, I18n._("Properties"), new Node[]{new Node(6, I18n._("Class A")), new Node(7, I18n._("Class B")), new Node(8, I18n._("Class C")), new Node(9, I18n._("Class D"))})})}));
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, ((Node)value).index >= 0, row, focus);
            }
        };
        URL imgurl = this.getClass().getResource("ColorDlgIcon.gif");
        ImageIcon icon = new ImageIcon(imgurl);
        renderer.setLeafIcon(icon);
        renderer.setBackgroundNonSelectionColor(this.cc.getBackground());
        int r = 0;
        while (r < this.tree.getRowCount()) {
            this.tree.expandRow(r);
            ++r;
        }
        this.tree.setCellRenderer(renderer);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setBackground(this.cc.getBackground());
        this.tree.addTreeSelectionListener(this);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(new JButton(new AbstractAction(I18n._("OK")){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                ColorDlg.this.onOK();
            }
        }));
        buttons.add(new JButton(new AbstractAction(I18n._("Cancel")){

            @Override
            public void actionPerformed(ActionEvent evnt) {
                ColorDlg.this.dlg.setVisible(false);
            }
        }));
        this.sub = new JLabel(I18n._("Select a subsection"), 0);
        this.dlg.setBackground(this.cc.getBackground());
        this.dlg.getContentPane().setLayout(new BorderLayout());
        this.dlg.getContentPane().add((Component)this.tree, "West");
        this.dlg.getContentPane().add((Component)buttons, "South");
        this.dlg.getContentPane().add(this.sub);
        this.dlg.getContentPane().add((Component)this.cc, "East");
        this.sub.setVisible(false);
        this.dlg.pack();
    }

    public void show() {
        this.colors = (Color[])this.main.colors.clone();
        this.changes = false;
        if (this.tree.getSelectionCount() != 1) {
            this.tree.setSelectionRow(0);
        }
        this.index = ((Node)this.tree.getSelectionPath().getLastPathComponent()).index;
        this.color = this.colors[this.index];
        this.cc.setColor(this.color);
        this.dlg.setVisible(true);
    }

    public void onOK() {
        Color clr = this.cc.getColor();
        if (this.index >= 0 && this.color != null && !this.color.equals(clr)) {
            this.colors[this.index] = clr;
            this.changes = true;
        }
        this.dlg.setVisible(false);
        if (this.changes) {
            this.main.setColors(this.colors);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evnt) {
        int i;
        Color clr = this.cc.getColor();
        if (this.index >= 0 && this.color != null && !this.color.equals(clr)) {
            this.colors[this.index] = clr;
            this.changes = true;
        }
        if ((i = ((Node)evnt.getPath().getLastPathComponent()).index) >= 0) {
            this.color = this.colors[i];
            this.cc.setColor(this.color);
            this.cc.setVisible(true);
            this.sub.setVisible(false);
        } else {
            this.color = null;
            this.cc.setVisible(false);
            this.sub.setVisible(true);
        }
        this.index = i;
    }

    class Node
    implements TreeNode {
        int index;
        String name;
        Node[] children;
        Node parent;

        Node(Node[] c) {
            this(null, c);
        }

        Node(String n, Node[] c) {
            this(-1, n, c);
        }

        Node(int i, String n) {
            this(i, n, null);
        }

        Node(int i, String n, Node[] c) {
            this.index = i;
            this.name = n == null ? "" : n;
            this.children = c;
            if (c != null) {
                int j = 0;
                while (j < c.length) {
                    c[j].parent = this;
                    ++j;
                }
            }
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children[childIndex];
        }

        @Override
        public int getChildCount() {
            return this.children == null ? 0 : this.children.length;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            if (this.children == null) {
                return -1;
            }
            int i = 0;
            while (i < this.children.length) {
                if (node == this.children[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.children != null;
        }

        @Override
        public boolean isLeaf() {
            return this.children == null;
        }

        public Enumeration children() {
            return new Enumeration(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.i < Node.this.getChildCount();
                }

                public Object nextElement() {
                    return Node.this.getChildAt(this.i++);
                }
            };
        }

        public String toString() {
            return this.name;
        }
    }
}

