(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 11.1' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1064,         20]
NotebookDataLength[    204574,       3540]
NotebookOptionsPosition[    204970,       3535]
NotebookOutlinePosition[    205504,       3554]
CellTagsIndexPosition[    205461,       3551]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`skis$$ = 0.01, $CellContext`sS$$ = 
    3, $CellContext`ste$$ = 0.08, $CellContext`\[Theta]$$ = Rational[1, 2] Pi,
     Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`sS$$], 3, ""}, {
      1 -> Style[
        "Terra + Sol", 17, FontTracking -> "SemiCondensed", FontFamily -> 
         "Gill Sans MT Condensed"], 2 -> 
       Style["Terra + Lua", 17, FontTracking -> "SemiCondensed", FontFamily -> 
         "Gill Sans MT Condensed"], 3 -> 
       Style["Terra + Sol + Lua", 17, FontTracking -> "SemiCondensed", 
         FontFamily -> "Gill Sans MT Condensed"]}}, {{
       Hold[$CellContext`\[Theta]$$], Rational[1, 3] Pi, 
       Style[
       "Fase da Lua", 20.4, FontTracking -> "SemiCondensed", FontFamily -> 
        "Gill Sans MT Condensed"]}, 0, 2 Pi, Rational[1, 12] Pi}, {{
       Hold[$CellContext`ste$$], 0.08, 
       Dynamic[
        Style[
         Part[$CellContext`txt, 3, $CellContext`lingu], 20, FontTracking -> 
         "SemiCondensed", FontFamily -> "Gill Sans MT Condensed"]]}, 0.05, 
      0.2}, {{
       Hold[$CellContext`skis$$], 0.01, 
       Dynamic[
        Style[
         Part[$CellContext`txt, 7, $CellContext`lingu], 20, FontTracking -> 
         "SemiCondensed", FontFamily -> "Gill Sans MT Condensed"]]}, -0.02, 
      0.04}, {{
       Hold[$CellContext`sS$$], 3, ""}, {
      1 -> Style[
        "Terra + Sol", 17, FontTracking -> "SemiCondensed", FontFamily -> 
         "Gill Sans MT Condensed"], 2 -> 
       Style["Terra + Lua", 17, FontTracking -> "SemiCondensed", FontFamily -> 
         "Gill Sans MT Condensed"], 3 -> 
       Style["Terra + Sol + Lua", 17, FontTracking -> "SemiCondensed", 
         FontFamily -> "Gill Sans MT Condensed"]}}, {{
       Hold[$CellContext`\[Theta]$$], Rational[1, 3] Pi, 
       Style[
       "Fase da Lua", 20.4, FontTracking -> "SemiCondensed", FontFamily -> 
        "Gill Sans MT Condensed"]}, 0, 2 Pi, Rational[1, 12] Pi}, {{
       Hold[$CellContext`ste$$], 0.08, 
       Dynamic[
        Style[
         Part[$CellContext`txt, 3, $CellContext`lingu], $CellContext`siz 1.2, 
         FontTracking -> "SemiCondensed", FontFamily -> 
         "Gill Sans MT Condensed"]]}, 0.05, 0.2}, {{
       Hold[$CellContext`skis$$], 0.01, 
       Dynamic[
        Style[
         Part[$CellContext`txt, 7, $CellContext`lingu], $CellContext`siz 1.2, 
         FontTracking -> "SemiCondensed", FontFamily -> 
         "Gill Sans MT Condensed"]]}, -0.02, 0.04}, {
      Hold[
       Row[{
         Row[{
           Row[{
             Manipulate`Place[1], 
             Spacer[10], 
             Dynamic[
              If[$CellContext`sS$$ != 1, 
               Row[{
                 Manipulate`Place[2], 
                 Spacer[10], 
                 Dynamic[
                  Piecewise[{{
                    Style[
                    
                    Part[$CellContext`men, 
                    8, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], 
                    
                    Or[$CellContext`\[Theta]$$ == 0, $CellContext`\[Theta]$$ == 
                    2 Pi]}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    5, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi/2}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    6, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    7, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    3 (Pi/2)}, {"", True}}]]}], ""]]}, ImageSize -> 384.], 
           Spacer[10], 
           Manipulate`Place[3], 
           Spacer[20], 
           Manipulate`Place[4], 
           Spacer[75], 
           Graphics[
            Raster[CompressedData["
1:eJzsfWVgnNeV9jszsktfNoWkbcCObRkElmSLbNmSbYFBbDEzMzMzMzMz20m3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             "], {{0, 0}, {100, 200}}, {0, 255}, ColorFunction -> RGBColor], {
            ImageSize -> 33, ImageSize -> {100, 200}, 
             PlotRange -> {{0, 100}, {0, 200}}}]}, ImageSize -> 827], 
         Spacer[132], 
         Row[{
           Row[{
             Manipulate`Place[5], 
             Spacer[10], 
             Dynamic[
              If[$CellContext`sS$$ != 1, 
               Row[{
                 Manipulate`Place[6], 
                 Spacer[10], 
                 Dynamic[
                  Piecewise[{{
                    Style[
                    
                    Part[$CellContext`men, 
                    8, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], 
                    
                    Or[$CellContext`\[Theta]$$ == 0, $CellContext`\[Theta]$$ == 
                    2 Pi]}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    5, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi/2}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    6, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    7, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    3 (Pi/2)}, {"", True}}]]}], ""]]}, ImageSize -> 384.], 
           Spacer[10], 
           Manipulate`Place[7], 
           Spacer[20], 
           Manipulate`Place[8], 
           Spacer[75], 
           Graphics[
            Raster[CompressedData["
1:eJzsfXdgnNWV/TfFQEJIDwHjLku21VxlyZZtWbJsq9myJVm2ZPXeex313mYk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             "], {{0, 0}, {100, 200}}, {0, 255}, ColorFunction -> RGBColor], {
            ImageSize -> 33, ImageSize -> {100, 200}, 
             PlotRange -> {{0, 100}, {0, 200}}}]}, ImageSize -> 827]}, 
        ImageSize -> {1787.52, 66}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {1787.52, {449.03999999999996`, 456.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`sS$85489$$ = False, $CellContext`\[Theta]$85490$$ = 
    0, $CellContext`ste$85491$$ = 0, $CellContext`skis$85492$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`skis$$ = 0.01, $CellContext`sS$$ = 
        3, $CellContext`ste$$ = 0.08, $CellContext`\[Theta]$$ = 
        Rational[1, 3] Pi}, "ControllerVariables" :> {
        Hold[$CellContext`sS$$, $CellContext`sS$85489$$, False], 
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$85490$$, 0], 
        Hold[$CellContext`ste$$, $CellContext`ste$85491$$, 0], 
        Hold[$CellContext`skis$$, $CellContext`skis$85492$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Deploy[
        SVT28Abril17`SteV[
         Part[
          $CellContext`SLT2[$CellContext`\[Theta]$$, $CellContext`sS$$], 1], 
         "HDTV", False, 
         Transparent, $CellContext`ste$$, {{-3, 3}, {3, 22.2}, {-1, 3.2}}, 
         SVT28Abril17`Sva, SVT28Abril17`Svp, SVT28Abril17`Svv, 
         SVT28Abril17`Svc, SVT28Abril17`Ssiz, $CellContext`skis$$, 0, False]],
       "Specifications" :> {{{$CellContext`sS$$, 3, ""}, {
         1 -> Style[
           "Terra + Sol", 17, FontTracking -> "SemiCondensed", FontFamily -> 
            "Gill Sans MT Condensed"], 2 -> 
          Style["Terra + Lua", 17, FontTracking -> "SemiCondensed", 
            FontFamily -> "Gill Sans MT Condensed"], 3 -> 
          Style["Terra + Sol + Lua", 17, FontTracking -> "SemiCondensed", 
            FontFamily -> "Gill Sans MT Condensed"]}, ControlType -> 
         PopupMenu, ControlPlacement -> 
         1}, {{$CellContext`\[Theta]$$, Rational[1, 3] Pi, 
          Style[
          "Fase da Lua", 20.4, FontTracking -> "SemiCondensed", FontFamily -> 
           "Gill Sans MT Condensed"]}, 0, 2 Pi, Rational[1, 12] Pi, ImageSize -> 
         35, ControlPlacement -> 2}, {{$CellContext`ste$$, 0.08, 
          Dynamic[
           Style[
            Part[$CellContext`txt, 3, $CellContext`lingu], 20, FontTracking -> 
            "SemiCondensed", FontFamily -> "Gill Sans MT Condensed"]]}, 0.05, 
         0.2, ImageSize -> 40, ControlType -> Slider, ControlPlacement -> 
         3}, {{$CellContext`skis$$, 0.01, 
          Dynamic[
           Style[
            Part[$CellContext`txt, 7, $CellContext`lingu], 20, FontTracking -> 
            "SemiCondensed", FontFamily -> "Gill Sans MT Condensed"]]}, -0.02,
          0.04, ImageSize -> 40, ControlType -> Slider, ControlPlacement -> 
         4}, {{$CellContext`sS$$, 3, ""}, {
         1 -> Style[
           "Terra + Sol", 17, FontTracking -> "SemiCondensed", FontFamily -> 
            "Gill Sans MT Condensed"], 2 -> 
          Style["Terra + Lua", 17, FontTracking -> "SemiCondensed", 
            FontFamily -> "Gill Sans MT Condensed"], 3 -> 
          Style["Terra + Sol + Lua", 17, FontTracking -> "SemiCondensed", 
            FontFamily -> "Gill Sans MT Condensed"]}, ControlType -> 
         PopupMenu, ControlPlacement -> 
         5}, {{$CellContext`\[Theta]$$, Rational[1, 3] Pi, 
          Style[
          "Fase da Lua", 20.4, FontTracking -> "SemiCondensed", FontFamily -> 
           "Gill Sans MT Condensed"]}, 0, 2 Pi, Rational[1, 12] Pi, ImageSize -> 
         35, ControlPlacement -> 6}, {{$CellContext`ste$$, 0.08, 
          Dynamic[
           Style[
            Part[$CellContext`txt, 3, $CellContext`lingu], $CellContext`siz 
            1.2, FontTracking -> "SemiCondensed", FontFamily -> 
            "Gill Sans MT Condensed"]]}, 0.05, 0.2, ImageSize -> 40, 
         ControlType -> Slider, ControlPlacement -> 
         7}, {{$CellContext`skis$$, 0.01, 
          Dynamic[
           Style[
            Part[$CellContext`txt, 7, $CellContext`lingu], $CellContext`siz 
            1.2, FontTracking -> "SemiCondensed", FontFamily -> 
            "Gill Sans MT Condensed"]]}, -0.02, 0.04, ImageSize -> 40, 
         ControlType -> Slider, ControlPlacement -> 8}, 
        Row[{
          Row[{
            Row[{
              Manipulate`Place[1], 
              Spacer[10], 
              Dynamic[
               If[$CellContext`sS$$ != 1, 
                Row[{
                  Manipulate`Place[2], 
                  Spacer[10], 
                  Dynamic[
                   Piecewise[{{
                    Style[
                    
                    Part[$CellContext`men, 
                    8, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], 
                    
                    Or[$CellContext`\[Theta]$$ == 0, $CellContext`\[Theta]$$ == 
                    2 Pi]}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    5, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi/2}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    6, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    7, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    3 (Pi/2)}, {"", True}}]]}], ""]]}, ImageSize -> 384.], 
            Spacer[10], 
            Manipulate`Place[3], 
            Spacer[20], 
            Manipulate`Place[4], 
            Spacer[75], 
            Graphics[
             Raster[CompressedData["
1:eJzsfWVgnNeV9jszsktfNoWkbcCObRkElmSLbNmSbYFBbDEzMzMzMzMz20m3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              "], {{0, 0}, {100, 200}}, {0, 255}, ColorFunction -> 
              RGBColor], {
             ImageSize -> 33, ImageSize -> {100, 200}, 
              PlotRange -> {{0, 100}, {0, 200}}}]}, ImageSize -> 827], 
          Spacer[132], 
          Row[{
            Row[{
              Manipulate`Place[5], 
              Spacer[10], 
              Dynamic[
               If[$CellContext`sS$$ != 1, 
                Row[{
                  Manipulate`Place[6], 
                  Spacer[10], 
                  Dynamic[
                   Piecewise[{{
                    Style[
                    
                    Part[$CellContext`men, 
                    8, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], 
                    
                    Or[$CellContext`\[Theta]$$ == 0, $CellContext`\[Theta]$$ == 
                    2 Pi]}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    5, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi/2}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    6, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    Pi}, {
                    Style[
                    
                    Part[$CellContext`men, 
                    7, $CellContext`lingu], $CellContext`siz 1.2, Bold, 
                    FontTracking -> "SemiCondensed", FontFamily -> 
                    "Gill Sans MT Condensed"], $CellContext`\[Theta]$$ == 
                    3 (Pi/2)}, {"", True}}]]}], ""]]}, ImageSize -> 384.], 
            Spacer[10], 
            Manipulate`Place[7], 
            Spacer[20], 
            Manipulate`Place[8], 
            Spacer[75], 
            Graphics[
             Raster[CompressedData["
1:eJzsfXdgnNWV/TfFQEJIDwHjLku21VxlyZZtWbJsq9myJVm2ZPXeex313mYk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              "], {{0, 0}, {100, 200}}, {0, 255}, ColorFunction -> 
              RGBColor], {
             ImageSize -> 33, ImageSize -> {100, 200}, 
              PlotRange -> {{0, 100}, {0, 200}}}]}, ImageSize -> 827]}, 
         ImageSize -> {1787.52, 66}]}, 
      "Options" :> {
       AppearanceElements -> None, Paneled -> False, SynchronousUpdating -> 
        False, ImageMargins -> {{0, 0}, {0, 0}}}, "DefaultOptions" :> {}],
     ImageSizeCache->{1808., {498., 505.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({SVT28Abril17`SteV[
         Pattern[SVT28Abril17`Private`gr, 
          Blank[]], 
         Optional[
          Pattern[SVT28Abril17`Private`typ, 
           Blank[]], "HDTV"], 
         Optional[
          Pattern[SVT28Abril17`Private`img, 
           Blank[]], False], 
         Optional[
          Pattern[SVT28Abril17`Private`sbck, 
           Blank[]], 
          GrayLevel[1]], 
         Optional[
          Pattern[SVT28Abril17`Private`ste, 
           Blank[]], 0.08], 
         Optional[
          Pattern[SVT28Abril17`Private`pr, 
           Blank[]], "Automatic"], 
         Optional[
          Pattern[SVT28Abril17`Private`va, 
           Blank[]], Pi/28], 
         Optional[
          Pattern[SVT28Abril17`Private`vp, 
           Blank[]], {3.586790649960885, 0.5976572563612095, 
          3.431871011164602}], 
         Optional[
          Pattern[SVT28Abril17`Private`vv, 
           Blank[]], {-0.563709442937084, 0.015386169223094964`, 
          0.8258298430912997}], 
         Optional[
          Pattern[SVT28Abril17`Private`vc, 
           Blank[]], {{0.5, 0.5, 0.5}, {0.5, 0.5}}], 
         Optional[
          Pattern[SVT28Abril17`Private`siz, 
           Blank[]], {1787.52, 905.04}], 
         Optional[
          Pattern[SVT28Abril17`Private`kap, 
           Blank[]], 0.], 
         Optional[
          Pattern[SVT28Abril17`Private`spa, 
           Blank[]], 0.], 
         Optional[
          Pattern[SVT28Abril17`Private`cv, 
           Blank[]], False]] := 
       DynamicModule[{
         SVT28Abril17`Private`sizs, SVT28Abril17`Private`pra, 
          SVT28Abril17`Private`svp, SVT28Abril17`Private`svc, 
          SVT28Abril17`Private`sva, SVT28Abril17`Private`ssiz, 
          SVT28Abril17`Private`svv, SVT28Abril17`Private`skap, 
          SVT28Abril17`Private`sspa, SVT28Abril17`Private`amp}, 
         EventHandler[
         SVT28Abril17`Private`pra = 
           If[SVT28Abril17`Private`pr === "Automatic", 
             SVT28Abril17`Private`adjpr[
              Part[
               AbsoluteOptions[SVT28Abril17`Private`gr, PlotRange], 1, 2]], 
             If[
              NumberQ[SVT28Abril17`Private`pr], 
              SVT28Abril17`Private`pr {{-1, 1}, {-1.25, 1.1}, {-1, 1}}, 
              SVT28Abril17`Private`adjpr[SVT28Abril17`Private`pr]]]; 
          SVT28Abril17`Private`svp = SVT28Abril17`Private`vp; 
          SVT28Abril17`Private`svc = SVT28Abril17`Private`vc; 
          SVT28Abril17`Private`sva = SVT28Abril17`Private`va; 
          SVT28Abril17`Private`ssiz = SVT28Abril17`Private`siz; 
          SVT28Abril17`Private`svv = 
           SVT28Abril17`Private`Vvo[
            SVT28Abril17`Private`pra, SVT28Abril17`Private`svp, 
             SVT28Abril17`Private`vv, SVT28Abril17`Private`typ]; 
          SVT28Abril17`Private`sspa = SVT28Abril17`Private`spa; 
          SVT28Abril17`Private`amp = 
           Part[SVT28Abril17`Private`pra, All, 2] - Part[
            SVT28Abril17`Private`pra, All, 1]; 
          Which[SVT28Abril17`Private`typ == "HDTV", 
            SVT28Abril17`Private`skap = SVT28Abril17`Private`kap; 
            SVT28Abril17`Private`sizs = ImageDimensions[
               Show[
               SVT28Abril17`Private`gr, AspectRatio -> Automatic, ViewAngle -> 
                Dynamic[SVT28Abril17`Private`sva], ViewPoint -> 
                Dynamic[SVT28Abril17`Private`svp], ViewVertical -> 
                Dynamic[SVT28Abril17`Private`svv], PlotRange -> 
                SVT28Abril17`Private`pra, ImageSize -> All]]; 
            SVT28Abril17`svc1 = 
             Dynamic[SVT28Abril17`Private`svc + {{0, 0, 0}, {
                 SVT28Abril17`Private`skap, 0}}]; Row[{
               Deploy[
                Show[
                SVT28Abril17`Private`gr, Background -> 
                 SVT28Abril17`Private`sbck, Boxed -> False, Prolog -> 
                 If[SVT28Abril17`Private`img === False, {}, 
                   Inset[
                    Show[
                    Part[SVT28Abril17`Private`img, 1], AspectRatio -> Full], 
                    Scaled[{0.5, 0.5}], 
                    Scaled[{0.5, 0.5}], {2 827, 
                    Part[SVT28Abril17`Private`ssiz, 2]}/ImageDimensions[
                    Part[SVT28Abril17`Private`img, 1]]]], PlotRange -> 
                 SVT28Abril17`Private`pra, ViewAngle -> 
                 Dynamic[SVT28Abril17`Private`sva], ViewPoint -> Dynamic[
                   
                   RotationTransform[-SVT28Abril17`Private`ste, 
                    SVT28Abril17`Private`svv][SVT28Abril17`Private`svp]], 
                 ViewVertical -> Dynamic[SVT28Abril17`Private`svv], 
                 ViewCenter -> SVT28Abril17`svc1, 
                 AspectRatio -> (2 Part[SVT28Abril17`Private`sizs, 2])/Part[
                  SVT28Abril17`Private`sizs, 1], ImageSize -> {827, 
                   Part[SVT28Abril17`Private`ssiz, 2]}]], 
               Spacer[132], 
               Show[
               SVT28Abril17`Private`gr, Prolog -> 
                If[SVT28Abril17`Private`img === False, {}, 
                  Inset[
                   Show[
                    Part[SVT28Abril17`Private`img, 1], AspectRatio -> Full], 
                   Scaled[{0.5, 0.5}], 
                   Scaled[{
                    Part[SVT28Abril17`Private`img, 2], 0.5}], {2 827, 
                    Part[SVT28Abril17`Private`ssiz, 2]}/ImageDimensions[
                    Part[SVT28Abril17`Private`img, 1]]]], PlotRange -> 
                SVT28Abril17`Private`pra, ViewAngle -> 
                Dynamic[SVT28Abril17`Private`sva], ViewPoint -> 
                Dynamic[SVT28Abril17`Private`svp], ViewVertical -> 
                Dynamic[SVT28Abril17`Private`svv], ViewCenter -> 
                Dynamic[SVT28Abril17`Private`svc], 
                AspectRatio -> (2 Part[SVT28Abril17`Private`sizs, 2])/Part[
                 SVT28Abril17`Private`sizs, 1], Boxed -> False, Background -> 
                SVT28Abril17`Private`sbck, ImageSize -> {827, 
                  Part[SVT28Abril17`Private`ssiz, 2]}]}, ImageSize -> 
              SVT28Abril17`Private`ssiz, Background -> None], 
            SVT28Abril17`Private`typ == "AN", 
            Row[{
              Overlay[{
                EventHandler[
                 Show[
                 SVT28Abril17`Private`gr, Background -> 
                  SVT28Abril17`Private`sbck, PlotRange -> 
                  SVT28Abril17`Private`pra, ViewPoint -> 
                  Dynamic[SVT28Abril17`Private`svp], ViewVertical -> 
                  Dynamic[SVT28Abril17`Private`svv], Boxed -> False, 
                  ViewCenter -> Dynamic[SVT28Abril17`Private`svc], ViewAngle -> 
                  Dynamic[SVT28Abril17`Private`sva], ImageSize -> 
                  SVT28Abril17`Private`ssiz, SphericalRegion -> True], {
                 "MouseDown" :> (SVT28Abril17`Private`SanMouse = False), 
                  "MouseUp" :> (SVT28Abril17`Private`SanMouse = True)}, 
                 PassEventsDown -> True], 
                Dynamic[
                 If[
                 SVT28Abril17`Private`SanMouse, 
                  SVT28Abril17`Private`pra = 
                   If[SVT28Abril17`Private`pr === "Automatic", 
                    SVT28Abril17`Private`adjpr[
                    Part[
                    AbsoluteOptions[SVT28Abril17`Private`gr, PlotRange], 1, 
                    2]], 
                    If[
                    NumberQ[SVT28Abril17`Private`pr], 
                    SVT28Abril17`Private`pr {{-1, 1}, {-1, 1}, {-1, 1}}, 
                    SVT28Abril17`Private`adjpr[SVT28Abril17`Private`pr]]]; 
                  SVT28Abril17`Private`ssiz = SVT28Abril17`Private`siz; 
                  SVT28Abril17`Private`il = Image[
                    Show[
                    SVT28Abril17`Private`gr, Background -> 
                    SVT28Abril17`Private`sbck, PlotRange -> 
                    SVT28Abril17`Private`pra, ViewPoint -> 
                    RotationTransform[-SVT28Abril17`Private`ste, 
                    SVT28Abril17`Private`svv][SVT28Abril17`Private`svp], 
                    ViewVertical -> SVT28Abril17`Private`svv, Boxed -> False, 
                    ViewCenter -> Dynamic[SVT28Abril17`Private`svc], 
                    ViewAngle -> Dynamic[SVT28Abril17`Private`sva], 
                    SphericalRegion -> True], ImageSize -> 
                    SVT28Abril17`Private`ssiz]; 
                  SVT28Abril17`Private`ir = Image[
                    Show[
                    SVT28Abril17`Private`gr, Background -> 
                    SVT28Abril17`Private`sbck, PlotRange -> 
                    SVT28Abril17`Private`pra, ViewPoint -> 
                    SVT28Abril17`Private`svp, ViewVertical -> 
                    SVT28Abril17`Private`svv, Boxed -> False, ViewCenter -> 
                    Dynamic[SVT28Abril17`Private`svc], ViewAngle -> 
                    Dynamic[SVT28Abril17`Private`sva], SphericalRegion -> 
                    True], ImageSize -> SVT28Abril17`Private`ssiz]; 
                  SVT28Abril17`Private`ils = 
                   ColorSeparate[SVT28Abril17`Private`il]; 
                  SVT28Abril17`Private`finalimage = Image[
                    ColorCombine[
                    Join[{
                    ImageAdjust[
                    ImageAdd[
                    ImageMultiply[
                    Part[SVT28Abril17`Private`ils, 2], 0.9], 
                    ImageMultiply[
                    Part[SVT28Abril17`Private`ils, 3], 0.3]], {0, 0, 1.5}]}, 
                    Rest[
                    ColorSeparate[SVT28Abril17`Private`ir]]]], ImageSize -> 
                    SVT28Abril17`Private`ssiz]; 
                  SVT28Abril17`Private`finalimage, ""]]}, {1, 2}, 1]}], True, 
            SVT28Abril17`Private`skap = SVT28Abril17`Private`kap; 
            SVT28Abril17`svc1 = 
             Dynamic[SVT28Abril17`Private`svc + {{0, 0, 0}, {
                 SVT28Abril17`Private`skap, 0}}]; Row[{
               Deploy[
                Show[
                SVT28Abril17`Private`gr, Background -> 
                 SVT28Abril17`Private`sbck, Boxed -> False, Prolog -> 
                 If[SVT28Abril17`Private`img === False, {}, 
                   Inset[
                    Show[
                    Part[SVT28Abril17`Private`img, 1], AspectRatio -> Full], 
                    Scaled[{0.5, 0.5}], 
                    Scaled[{0.5, 0.5}], {960, 950}/ImageDimensions[
                    Part[SVT28Abril17`Private`img, 1]]]], PlotRange -> 
                 SVT28Abril17`Private`pra, SphericalRegion -> True, ViewAngle -> 
                 Dynamic[SVT28Abril17`Private`sva], ViewPoint -> Dynamic[
                   RotationTransform[
                    If[
                    SVT28Abril17`Private`cv, SVT28Abril17`Private`ste, -
                    SVT28Abril17`Private`ste], SVT28Abril17`Private`svv][
                   SVT28Abril17`Private`svp]], ViewVertical -> 
                 Dynamic[SVT28Abril17`Private`svv], ViewCenter -> 
                 SVT28Abril17`svc1, ImageSize -> SVT28Abril17`Private`ssiz]], 
               Spacer[SVT28Abril17`Private`sspa], 
               Show[
               SVT28Abril17`Private`gr, Boxed -> False, Prolog -> 
                If[SVT28Abril17`Private`img === False, {}, 
                  Inset[
                   Show[
                    Part[SVT28Abril17`Private`img, 1], AspectRatio -> Full], 
                   Scaled[{0.5, 0.5}], 
                   Scaled[{
                    Part[SVT28Abril17`Private`img, 2], 0.5}], {960, 950}/
                   ImageDimensions[
                    Part[SVT28Abril17`Private`img, 1]]]], PlotRange -> 
                SVT28Abril17`Private`pra, SphericalRegion -> True, ViewAngle -> 
                Dynamic[SVT28Abril17`Private`sva], ViewPoint -> 
                Dynamic[SVT28Abril17`Private`svp], ViewVertical -> 
                Dynamic[SVT28Abril17`Private`svv], ViewCenter -> 
                Dynamic[SVT28Abril17`Private`svc], ImageSize -> 
                SVT28Abril17`Private`ssiz, Background -> 
                SVT28Abril17`Private`sbck]}, Background -> None]], {
          "MouseUp" :> (SVT28Abril17`Sva = SVT28Abril17`Private`sva; 
            SVT28Abril17`Svp = SVT28Abril17`Private`svp; 
            SVT28Abril17`Svv = SVT28Abril17`Private`svv; 
            SVT28Abril17`Svc = SVT28Abril17`Private`svc)}, PassEventsDown -> 
          True]], 
       TagSet[SVT28Abril17`SteV, 
        MessageName[SVT28Abril17`SteV, "usage"], 
        "Fornece uma vers\[ATilde]o estereosc\[OAcute]pica do objecto gr \n \
SteV[gr_,typ_:Styp,img_:False,sbck_:Sbck,ste_:Ste,pr_:\"Automatic\",va_:Sva, \
vp_:Svp, vv_:Svv, vc_:Svc,siz_:Ssiz, kap_:Skap,spa_:Sspa, cv_:Scv]\n\n Se img \
for False o fundo \[EAcute] colorido com a cor sbck, caso contr\[AAcute]rio \
img deve ser um par ordenado em que a primeira entrada \[EAcute] a imagem que \
ser\[AAcute] colocada no fundo dos gr\[AAcute]ficos e a segunda entrada \
\[EAcute] um parametro entre 0 e 1 - \nsendo que se for 0.5 as duas imagens \
quando vista estereoscopicamente se sobrep\[OTilde]e, e se for inferior a 0.5 \
(p.e. 0.48) d\[AAcute] a sensa\[CCedilla]\[ATilde]o que o fundo est\[AAcute] \
mais distante do observador do que se for superior a 0.5"], 
       SVT28Abril17`Private`adjpr[
         Pattern[SVT28Abril17`Private`pr, 
          Blank[]]] := 
       Map[Part[SVT28Abril17`Private`pr, #] + 
         Part[Part[SVT28Abril17`Private`pr, All, 2] - Part[
            SVT28Abril17`Private`pr, All, 1], #] 
          Part[{{-0.1, 0.1}, {-0.4, 0.15}, {-0.1, 0.1}}, #]& , 
         Range[3]], 
       TagSet[SVT28Abril17`Private`adjpr, 
        MessageName[SVT28Abril17`Private`adjpr, "usage"], 
        "d\[AAcute] uma margem aos limites do plotrange em todos os eixos, \
mas maior no caso do eixo dos yy..."], SVT28Abril17`Private`Vvo[
         Pattern[SVT28Abril17`Private`pr, 
          Blank[]], 
         Pattern[SVT28Abril17`Private`vp, 
          Blank[]], 
         Pattern[SVT28Abril17`Private`vv, 
          Blank[]], 
         Pattern[SVT28Abril17`Private`typ, 
          Blank[]]] := 
       Block[{SVT28Abril17`Private`vvn, SVT28Abril17`Private`vpn, 
          SVT28Abril17`Private`amp, SVT28Abril17`Private`tt}, 
         SVT28Abril17`Private`vpn = Normalize[SVT28Abril17`Private`vp]; 
         SVT28Abril17`Private`amp = 
          Part[SVT28Abril17`Private`pr, All, 2] - Part[
           SVT28Abril17`Private`pr, All, 1]; 
         SVT28Abril17`Private`vvn = 
          Normalize[SVT28Abril17`Private`amp SVT28Abril17`Private`vv]; 
         SVT28Abril17`Private`tt = ReplaceAll[SVT28Abril17`Private`t, 
            Part[
             Solve[
             Dot[
               SVT28Abril17`Private`t 
                 SVT28Abril17`Private`vpn + (1 - SVT28Abril17`Private`t) 
                 SVT28Abril17`Private`vvn, SVT28Abril17`Private`vp] == 0, 
              SVT28Abril17`Private`t], 1]]; 
         Normalize[(
            SVT28Abril17`Private`tt 
             SVT28Abril17`Private`vpn + (1 - SVT28Abril17`Private`tt) 
             SVT28Abril17`Private`vvn)/SVT28Abril17`Private`amp]], 
       TagSet[SVT28Abril17`Private`Vvo, 
        MessageName[SVT28Abril17`Private`Vvo, "usage"], 
        "Vvo[pr,vp,vv,typ] calcula um vector no plano definido pelo viewpoint \
vp e view vertical vv, ortogonal a vp e converte-o, em \
fun\[CCedilla]\[ATilde]o do plotrange pr, para as coordenadas a usar em cada \
caso \n(expresso em coordenadas escaladas; experimentou-se Vvo2 com Cross, \
mas o tempo deu equivalente)"], SVT28Abril17`svc1 = 
       Dynamic[SVT28Abril17`Private`svc$85417 + {{0, 0, 0}, {
           SVT28Abril17`Private`skap$85417, 0}}], 
       TagSet[SVT28Abril17`svc1, 
        MessageName[SVT28Abril17`svc1, "usage"], "View Center 2"], 
       Attributes[SVT28Abril17`Private`svc$85417] = {Temporary}, 
       SVT28Abril17`Private`svc$85417 = {{0.5, 0.5, 0.5}, {0.5, 0.5}}, 
       Attributes[SVT28Abril17`Private`skap$85417] = {Temporary}, 
       SVT28Abril17`Private`skap$85417 = 0.01, SVT28Abril17`Private`SanMouse = 
       True, SVT28Abril17`Sva = Pi/28, 
       TagSet[SVT28Abril17`Sva, 
        MessageName[SVT28Abril17`Sva, "usage"], "ViewAngle"], 
       SVT28Abril17`Svp = {4.597482675106537, -1.337334758171912, 
        1.4403780047891932`}, 
       TagSet[SVT28Abril17`Svp, 
        MessageName[SVT28Abril17`Svp, "usage"], "View Point"], 
       SVT28Abril17`Svv = {-0.19816907028641356`, 0.013946186621529032`, 
        0.9800686320153993}, 
       TagSet[SVT28Abril17`Svv, 
        MessageName[SVT28Abril17`Svv, "usage"], "View Vertical"], 
       SVT28Abril17`Svc = {{0.5, 0.5, 0.5}, {0.5, 0.5}}, 
       TagSet[SVT28Abril17`Svc, 
        MessageName[SVT28Abril17`Svc, "usage"], 
        "View Center"], $CellContext`SLT2[
         Pattern[$CellContext`\[Theta], 
          Blank[]], 
         Optional[
          Pattern[$CellContext`sS, 
           Blank[]], 3], 
         Optional[
          Pattern[$CellContext`ims, 
           Blank[]], 1366]] := Deploy[
         Graphics3D[{{
            Specularity[White, 10], Brown, {
             Opacity[0.7], 
             Tube[{{0, 0, -0.6}, {0, 0, 2.5}}, 0.06], 
             Tube[
              BSplineCurve[
               Map[{0, 0, 1.7} + (1.3 $CellContext`rtt) {0, 
                   Cos[#], 
                   Sin[#]}& , 
                Range[Pi/2 - Pi/10, 3 (Pi/2) + Pi/10, Pi/10]]], 0.05], 
             If[$CellContext`sS != 1, {
               
               Tube[{{0, 0, 0.75}, {
                 1.2 Cos[$CellContext`\[Theta]], 1.2 
                  Sin[$CellContext`\[Theta]], 0.75}}, 0.06], 
               
               Tube[{{1.2 Cos[$CellContext`\[Theta]], 1.2 
                  Sin[$CellContext`\[Theta]], 0.75}, {
                 1.2 Cos[$CellContext`\[Theta]], 1.2 
                  Sin[$CellContext`\[Theta]], 2.2}}, 0.05], 
               Tube[
                BSplineCurve[
                 
                 Map[{1.2 Cos[$CellContext`\[Theta]], 1.2 
                    Sin[$CellContext`\[Theta]], 1.7} + (
                    1.3 $CellContext`rll) {
                    Cos[#] Cos[$CellContext`\[Theta]], Cos[#] 
                    Sin[$CellContext`\[Theta]], 
                    Sin[#]}& , 
                  Range[-(Pi/2) - Pi/10, Pi/2 + Pi/10, Pi/10]]], 0.04]}, {}], 
             If[$CellContext`sS != 2, {
               Tube[{{0, 20, -0.6}, {0, 20, 3}}, 0.1], 
               Tube[
                BSplineCurve[
                 Map[{0, 20, 1.7} + 1.2 {0, 
                    Cos[#], 
                    Sin[#]}& , 
                  Range[-(Pi/2) - Pi/10, Pi/2 + Pi/10, Pi/10]]], 0.06]}, {}], 
             EdgeForm[Brown], 
             
             Prism[{{0, -2.6, -0.9}, {-2.9, 22, -0.9}, {2.9, 22, -0.9}, {
               0, -2.6, -0.56}, {-2.9, 22, -0.56}, {2.9, 22, -0.56}}], 
             Tube[{{0, 0, -0.6}, {0, 20, -0.6}}, 0.1]}, {
             Style[
              Text[
               Part[$CellContext`astros, 2, $CellContext`lingu], {0, 0, 3.6}],
               Bold, Black, $CellContext`siz 2, FontTracking -> 
              "SemiCondensed", FontFamily -> "Gill Sans MT Condensed"], 
             Glow[Blue], Black, 
             Opacity[1], 
             Sphere[{0, 0, 1.7}, $CellContext`rtt], 
             Glow[
              GrayLevel[0.8]], Black, 
             If[$CellContext`sS != 1, {
               Style[
                Text[
                 Part[$CellContext`astros, 3, $CellContext`lingu], {
                 1.4 Cos[$CellContext`\[Theta]], 1.4 
                  Sin[$CellContext`\[Theta]], 2.8}], Bold, 
                Black, $CellContext`siz 2, FontTracking -> "SemiCondensed", 
                FontFamily -> "Gill Sans MT Condensed"], 
               
               Sphere[{
                1.2 Cos[$CellContext`\[Theta]], 1.2 
                 Sin[$CellContext`\[Theta]], 1.7}, $CellContext`rll]}, {}]}}, {
            Glow[Yellow], Black, 
            Specularity[White, 10], 
            If[$CellContext`sS != 2, {
              Style[
               Text[
                Part[$CellContext`astros, 1, $CellContext`lingu], {
                0, 20, 3.6}], Bold, Black, $CellContext`siz 2, FontTracking -> 
               "SemiCondensed", FontFamily -> "Gill Sans MT Condensed"], 
              Sphere[{0, 20, 1.7}, 1]}, {}]}}, ImageSize -> $CellContext`ims, 
          PlotRange -> {{-3, 3}, {-2.6, 22.2}, {-1, 3.2}}, PlotRangePadding -> 
          0, SphericalRegion -> False, ViewVertical -> {0, 0, 1}, ViewPoint -> 
          If[$CellContext`vc, {0, 0, 5}, 5 Normalize[
              RotationTransform[Pi/6, {0, 0, 1}][{2.3, -2.4, 1}]]], Boxed -> 
          False, Lighting -> {{
            "Point", White, {0, 20, 1.7}, {
             0.2, 0.9, 0}}}]], $CellContext`\[Theta]$$ = 
       Pi/2, $CellContext`rtt = 0.5, $CellContext`rll = 
       0.3, $CellContext`astros = {{"Sol", "Sun", "Soleil"}, {
         "Terra", "Earth", "Terre"}, {
         "Lua", "Moon", "Lune"}}, $CellContext`lingu = 1, $CellContext`siz = 
       17, $CellContext`vc = False, SVT28Abril17`Ssiz = {1787.52, 905.04}, 
       TagSet[SVT28Abril17`Ssiz, 
        MessageName[SVT28Abril17`Ssiz, "usage"], 
        "Tamanho"], $CellContext`txt = {{"Fase da Lua", " ", " "}, {
         "Fundo", "Background", "Fond"}, {
         "Efeito estereosc\[OAcute]pico", "Stereoscopic effect", 
          "Effet st\[EAcute]r\[EAcute]oscopique"}, {
         "Tamanho", "Size", "Taille"}, {
         "Espa\[CCedilla]amento", "Spacing", "\[CapitalEAcute]cartement"}, {
         "Vis\[ATilde]o cruzada", "Cross view", "Vision crois\[EAcute]e"}, {
         "Aproxima\[CCedilla]\[ATilde]o", "Approximation", "Approche"}, {
         "Textura", "Texture", "Texture"}}, $CellContext`men = {{
         "Terra + Sol", "Earth + Sun"}, {"Terra + Lua", "Earth + Moon"}, {
         "Terra + Sol + Lua", "Earth + Sun + Moon"}, {
         "Fase da Lua", "Moon phase"}, {"Lua Nova", "New Moon"}, {
         "Quarto Crescente", "First Quarter"}, {"Lua Cheia", "Full Moon"}, {
         "Quarto Minguante", "Third Quarter"}}}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]],ExpressionUUID->"521a1dbe-702c-4d0b-\
b64b-f4379435227a"]
},
ScreenStyleEnvironment->"SlideShow",
WindowSize->{Full, Full},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
TaggingRules->{
 "SlideshowSettings" -> {"Toolbar" -> False, "WindowElements" -> {}}},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (March 13, 2017)",
StyleDefinitions->FrontEnd`FileName[{"SlideShow"}, "Earth.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[1464, 33, 203502, 3500, 1013, InheritFromParent, "ExpressionUUID" -> \
"521a1dbe-702c-4d0b-b64b-f4379435227a"]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature puTxjNO4oaNmmA1piw43@cHw *)
