(* ::Package:: *)

(* 14 Julho *)
rt=6378;(* raio da Terra em Km *)
rl=1738;(* raio da Lua em Km *)
rs=696000;(* raio do Sol em Km *)
mt=5.97 10^24; (* massa da Terra em Kg *)
ms=2 10.^30;(* massa do Sol em Kg *)
ml=7.35 10^22;(* massa da Lua em Kg *)
dtl=3.844 10^5;(* dist\[AHat]ncia da Terra \[AGrave] Lua em Km *)
dts=1.496 10^8; (* dist\[AHat]ncia da Terra ao Sol em Km *)
rT=(rTL=rt/rl//N )rL; (* rT parece coincdir com rt ?? *) 
(* rT \[EAcute] o raio da Terra escrito em fun\[CCedilla]\[ATilde]o do raio da Lua (rT=3.66974 rL) e rTL \[EAcute] a raz\[ATilde]o entre os raios da Terra e da Lua (3.66974) *)
dTL=(dTLL=dtl/rl//N)rL; (* obs ~ *) (* dTL \[EAcute] a dist\[AHat]ncia da Terra \[AGrave] Lua escrita em fun\[CCedilla]\[ATilde]o do raio da Lua e dTLL \[EAcute] a raz\[ATilde]o entre a dist\[AHat]ncia da Terra \[AGrave] Lua e o raio da Lua *)
dTLT=dTLL rl/rt;  (*  = dtl/rt  *) (* raz\[ATilde]o entre a dist\[AHat]ncia da Terra \[AGrave] Lua e o raio da Terra *)
dTS=(dTST=dts/rt//N) RT;(* RT=? *)(* dTS \[EAcute] a dist\[AHat]ncia da Terra ao Sol escrita em fun\[CCedilla]\[ATilde]o do raio da Terra e dTST \[EAcute] a raz\[ATilde]o entre dist\[AHat]ncia da Terra ao Sol e o raio da Terra *)
dST=(dSTR=dts /rs //N)RS;   (* RS =? *) (* dST \[EAcute] a dist\[AHat]ncia da Terra ao Sol escrita em fun\[CCedilla]\[ATilde]o do raio do Sol e dSTR \[EAcute] a raz\[ATilde]o entre dist\[AHat]ncia da Terra ao Sol e o raio do Sol *)
rS=(rST=rs/rt//N) RT; (*  n\[ATilde]o definido *) (*  rS \[EAcute] o raio do Sol escrito em fun\[CCedilla]\[ATilde]o do raio da Terra e rST \[EAcute] a raz\[ATilde]o entre os raios do Sol e da Terra *)
kdsl=(dts/dtl);(* raz\[ATilde]o entre as dist\[AHat]ncias do Sol \[AGrave] Terra e da Lua \[AGrave] Terra *)
kmsl=ms/ml;(* raz\[ATilde]o entre as massas do Sol e da Lua *)
SL[\[Lambda]_]:=ml/ms (dTST/dTLT)^\[Lambda] (* raz\[ATilde]o entre atrac\[CCedilla]\[OTilde]es da Lua e do Sol na Terra,conforme o expoente;na verdade \[EAcute] para \[Lambda]=2 o real *);
SLinv1=Quiet[t/.Solve[SL[t]==1,t][[1]]];
dfsc=ms (1/(dts-rt)^2-1/dts^2);dfsb=ms (1/dts^2-1/(dts+rt)^2);(* n\[ATilde]o s\[ATilde]o usados *)
dflc=ml (1/(dtl-rt)^2-1/dtl^2);dflb=ml (1/dtl^2-1/(dtl+rt)^2);(* n\[ATilde]o s\[ATilde]o usados *)
dfsv[\[Lambda]_]:=ms(1/dts^\[Lambda]-1/(dts+rt)^\[Lambda]); (* diferen\[CCedilla]a entre for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o do sol \[AGrave] terra (centro) e for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o \[AGrave] superf\[IAcute]cie no lado oposto  *)
dflv[\[Lambda]_]:=ml(1/dtl^\[Lambda]-1/(dtl+rt)^\[Lambda]); (* an\[AAcute]logos para a for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o da lua *)

resHd:=("FullScreenArea"/.("ScreenInformation"/.SystemInformation["Devices"]))[[1,1,2]];
resVd:=("FullScreenArea"/.("ScreenInformation"/.SystemInformation["Devices"]))[[1,2,2]];
resH=resHd;
resV=resVd;
astros={{"Sol","Sun","Soleil"},{"Terra","Earth","Terre"},{"Lua","Moon","Lune"}};
mens={{"O(s) segmento(s) abaixo representa(m) o comprimento\nda parte n\[ATilde]o vis\[IAcute]vel no ecr\[ATilde] do segmento Terra-Sol:", "The segment(s) below represent the length of\nthe non-visible part of the segment Earth-Sun:", 
"Le(s) segment(s) ci-dessous repr\[EAcute]sente(nt) la longueur\nde la partie non-visible \[AGrave] l'\[EAcute]cran du segment Terre-Soleil"}, {"Escala:          ","Scale:            ","\[CapitalEAcute]chelle:         "},
{" - Tudo \[AGrave] escala                                                             ", " - Everything in scale                                                    ", " - Tout \[AGrave] l'\[EAcute]chelle                                                          " },
{" - Tudo \[AGrave] escala, excepto a dist\[AHat]ncia do Sol              ", " - Everything in scale, except distance from the Sun" ," - Tout \[AGrave] l'\[EAcute]chelle, sauf la distance du Soleil             "}, {"Fase da Lua","Moon phase",""},{"     Peso","    Weight",""},
{"    Horizontal","    Horizontal",""},{"   Curvas de n\[IAcute]vel", "   Level curves",""},{"Refor\[CCedilla]o atr. Sol+Lua ","Reinforce attr. Sun+Moon",""},{"Refor\[CCedilla]o atr. Sol","Reinforce attr. Sun",""},
{"Refor\[CCedilla]o extra atr. lunar","Extra reinforcement lunar attr.",""},{"Expoente","Exponent",""},{" For\[CCedilla]a Sol","Force sun",""},{" For\[CCedilla]a Lua","Force moon",""},
 { "Massas de Sol e Lua e dist\[AHat]ncias \[AGrave] Terra dos dois astros", "Masses of the Sun and Moon and distances to the Earth of both bodies", ""}, {"Massa do Sol", "Mass of the sun", ""}, {"Massa da Lua", "Mass of the moon", ""}, {"Dist\.aa (Terra-Lua)","Distance (Earth-Moon)", ""}, 
{"Dist\.aa (Terra-Sol)", "Distance (Earth-Sun)", ""}, {"   Quocientes entre massas de Sol e Lua e entre \nos quadrados das dist\[AHat]ncias \[AGrave] Terra dos dois astros", "Ratio between the masses of the Sun and Moon and between the \nsquares of the distances of the two bodies to Earth", ""},
 {"KmSL", "", ""}, {"Kd2LS","", ""},{"Atrac\[CCedilla]\[ATilde]o da Terra","Attraction of the Earth",""},
{" x atrac\[CCedilla]\[ATilde]o do Sol\n(se dens.Sol fosse "," x Attraction of the Sun \n(if the density of the Sun were ", ""}, {" maior)", " greater)", ""},{" x atrac\[CCedilla]\[ATilde]o da Lua\n(se dens.Lua fosse ", " x Attraction of the Moon \n(if the density of the Moon were ", ""},
{"Atrac\[CCedilla]\[ATilde]o conjunta do Sol e da Lua", "Joint attraction of the Sun and the Moon", ""}, {"Peso total (Terra+Sol)", "Total weight (Earth + Sun)", ""}, {"Peso total (Terra+Sol+Lua)","Total weight (Earth + Sun+Moon)", ""},
{"  Escala das for\[CCedilla]as", "  Scale of forces", ""},{"Direc\[CCedilla]\[ATilde]o de atrac\[CCedilla]\[ATilde]o do Sol","Direction of attraction of the Sun",""},{"Direc\[CCedilla]\[ATilde]o de atrac\[CCedilla]\[ATilde]o da Lua","Direction of attraction of the Moon",""},
{"Direc\[CCedilla]\[ATilde]o da resultante das\natrac\[CCedilla]\[OTilde]es do Sol e da Lua","Direction of the resultant of the \nattractions of the Sun and the Moon",""},{"S\[OAcute] Sol","Just the Sun",""},{"Sol+Lua","Sun+Moon",""},
{" Mostrar for\[CCedilla]as","Show forces",""},{"Arrastar o ponto para observar\ncomo variam as intensidades\ne direc\[CCedilla]\[OTilde]es das diversas for\[CCedilla]as","Drag the point to observe how \nthe intensities and directions \nof the various forces vary",""},
{"Para melhor visibilidade, exagerar for\[CCedilla]a do \nSol relativamente \[AGrave] da Terra","For better visibility, exaggerate force from the \nSun in relation to the Earth's",""},
{"Para melhor visibilidade, exagerar for\[CCedilla]as do \nSol e da Lua relativamente \[AGrave] da Terra","For better visibility, exaggerate forces from the \nSun and the Moon in relation to the Earth's",""},
{"Mostrar os vectores do peso nos diferentes pontos\n   (resultante das atrac\[CCedilla]\[OTilde]es da Terra e do Sol)","  Show the weight vectors at different points \n(resulting from the Earth's and Sun's attractions)",""},
{"Mostrar os vectores do peso nos diferentes pontos\n(resultante das atrac\[CCedilla]\[OTilde]es da Terra, do Sol e da Lua)","     Show the weight vectors at different points \n(resulting from the Earth's, Sun's and Moon's attractions)",""},
{"Mostrar em cada ponto uma pequena linha\n horizontal, perpendicular ao vector peso","Show at each point a small horizontal \nline, perpendicular to the weight vector",""},
{"Mostrar linhas que em cada ponto s\[ATilde]o\n  tangentes \[AGrave] horizontal desse ponto","Show lines which are at each point tangent \nto the horizontal atthat point",""},
{"Refor\[CCedilla]ar o exagero da for\[CCedilla]a da Lua \nrelativamente \[AGrave]s outras duas","Enhance the exaggeration of the Moon's \nstrength in relation to the other two",""},{"Raz\[ATilde]o entre a for\[CCedilla]a de atra\[CCedilla]\[ATilde]o do Sol e da Lua","Ratio between the force of attraction of the Sun and the Moon",""},
{"Correc\[CCedilla]\[ATilde]o da atra\[CCedilla]\[ATilde]o da Lua","Correction of the attraction of the Moon",""},{"Peso com a correc\[CCedilla]\[ATilde]o da atrac\[CCedilla]\[ATilde]o da Lua","Weight with the correction of the attraction of the moon",""},
{"Mostrar os vectores do peso nos diferentes pontos \n(resultante das atrac\[CCedilla]\[OTilde]es da Terra e da Lua)","Show the weight vectors at different points \n(resultant of the attractions of the Earth and the Moon)",""},
{"Mostrar os vectores do peso nos diferentes pontos \n(resultante das atrac\[CCedilla]\[OTilde]es da Terra e da Lua e da for\[CCedilla]a que a haste exerce)","Show the weight vectors at the different points \n(resultant of the attarctions of the Earth and the Moon and the force exerted by the rod)",""},
{"Baricentro","Barycenter",""},{"Mostrar os vectores do peso nos diferentes pontos \n  (resultante das atrac\[CCedilla]\[OTilde]es da Terra e da Lua)","  Show the weight vectors at different points \n(resulting from the Earth's and Moon's attractions)",""},
{"S\[OAcute] Lua","Just the Moon",""},{"Refor\[CCedilla]o atr. Lua","Reinforce attr. Moon",""},{"Para melhor visibilidade, exagerar for\[CCedilla]a da Lua \nrelativamente \[AGrave] da Terra","For better visibility, exaggerate force from the Moon \nin relation to the Earth's",""},
{"Peso total (Terra + Lua)","Total weight (Earth + Moon)",""}}; 

newmens={{"Hemisf\[EAcute]rio","Hemisphere",""},{"HN","NH",""},{"HS","SH",""},{"Rot. Terra","Earth rotation",""},{"Densidade da Lua","Moon density",""},{"Zoom","Zoom",""},
{"Correc\[CCedilla]\[ATilde]o relacionada com a Lua","Correction related to the Moon",""},{"Peso resultante","Resultant weight",""}};
extra[X_,dy_:4.,y0_:.3,min_:0.,max_:1000,cor_:White]:=Block[{lis,\[CapitalDelta],n,n1,n2,r,r1,r2,y,th={.0001,.003,.012}},y=y0;\[CapitalDelta]=max-min;n=Quotient[X,\[CapitalDelta]];r=Mod[X,\[CapitalDelta]];n1=Quotient[n,10];r1=Mod[n,10];n2=Quotient[n1,10];r2=Mod[n1,10];
(* r p.tos, r1 linhas, r2 linhas grossas, n2 linhas m.to grossas  *)Clear[lis];lis[nn_,dyy_,y_:y0]:=Table[{{min,y-(i-1)dyy},{max,y-(i-1)dyy}},{i,nn}]//Chop;
{Thickness[th[[1]]],cor,Line[{{min,y},{min+r,y}}],y=y-dy;Line[lis[r1,dy,y]],Thickness[th[[2]]],y=If[r1>0,y-1.5(r1)*dy,If[r2>0, y-2.dy,y+6.r1]];Line[lis[r2,2.dy,y]],Thickness[th[[3]]],y=y-3.5(r2)*dy;Line[lis[n2,4dy,y]]}
];
extra::usage=" representa o segmento horizontal de comprimento X no ecr\[ATilde], sendo que se X for superior \[AGrave] largura do ecr\[ATilde] (max - min) representa v\[AAcute]rios
segmentos...  10 segmentos s\[ATilde]o representados por um segmento mais espesso e 100 segmentos por um ainda mais espesso; dy determina a dist\[AHat]ncia entre os segmentos e y0 a ordenada dos pontos do segmento superior... -> Usado para representar o comprimento do segmento Terra Sol n\[ATilde]o vis\[IAcute]vel no ecr\[ATilde]  " ;

(*  tratamento do caso concreto, com dados referentes \[AGrave]s dist\[AHat]ncias reais, MAS com for\[CCedilla]as de atrac\[CCedilla]\[ATilde]o de S e L com constantes 100 vezes maior (se corr=1; quando corr>1, refor\[CCedilla]a-se ainda o valor de atrac\[CCedilla]\[ATilde]o de L pelo factor corr    *)

ku=1/5.97*10.^-24;(* inverso da massa da Terra *)
ks=60.ku;kl=ks; (* n\[ATilde]o usados *)
Ku=ku*mt; (* 1 *) 
Ks=ku*ms ;(*raz\[ATilde]o entre as massas do Sol e da Terra*)
Kl=ku*ml;(*raz\[ATilde]o entre as massas da Lua e da Terra*)
pt[\[Theta]_,h_:0.]:=(1.+h/rt){Cos[\[Theta]],Sin[\[Theta]]}; (* ponto \[AGrave] superf\[IAcute]cie da Terra; km como unidade *) 
sol={dTST,0.}  ;    (*   Orienta\[CCedilla]\[ATilde]o fixa, horizontal direita  *)(* centro do Sol considerando o raio da Terra 1 *)
lua[\[Lambda]_]:=dTLT*pt[\[Lambda]];(* centro da Lua considerando o raio da Terra 1,nas diferentes fase,luaN:\[Lambda]=0\[Rule]Lua Nova,luaC:\[Lambda]=\[Pi]\[Rule]Lua Cheia *)
{luaN=lua[0.],luaC=lua[\[Pi]]};
{dTST,dTLT,rST,rLT=rl/rt//N};
peso[P_]:=-(*Ku*)(1./Norm[P])^2 Normalize[P]; (* peso em P (de 1kg-massa proveniente da atrac\[CCedilla]\[ATilde]o da Terra); unidade do resultado: kg-for\[CCedilla]s *) 
fs[{x_,y_},corrSL_:60.]:=corrSL*Ks (1/Norm[sol-{x,y}])^2 Normalize[sol-{x,y}];
(* for\[CCedilla]a de atra\[CCedilla]\[ATilde]o do Sol no ponto {x,y},com uma corre\[CCedilla]\[ATilde]o de forma a intensificar a atra\[CCedilla]\[ATilde]o do Sol *)
fl[{x_,y_},\[Lambda]_: 0.,corrL_: 1.,corrSL_: 60.]:=corrL*corrSL*Kl (1/Norm[lua[\[Lambda]]-{x,y}])^2 Normalize[lua[\[Lambda]]-{x,y}];
(* for\[CCedilla]a de atra\[CCedilla]\[ATilde]o da Lua,numa dada fase definida por \[Lambda],no ponto {x,y},com a mesma corre\[CCedilla]\[ATilde]o anterior e uma corre\[CCedilla]\[ATilde]o extra de forma a intensificar mais a atra\[CCedilla]\[ATilde]o da Lua *)
fsl[P_,\[Lambda]_,corrL_: 1.,corrSL_: 60.]:=fs[P,corrSL]+fl[P,\[Lambda],corrL,corrSL];
(* for\[CCedilla]a de atra\[CCedilla]\[ATilde]o conjunta do Sol e da Lua,numa dada fase definida por \[Lambda],no ponto P,com as mesmas corre\[CCedilla]\[OTilde]es anteriores *)
pesoT[P_,\[Lambda]_: 0.,corrL_: 1.,corrSL_: 60.,sS_:3]:=peso[P]+If[sS==1,fs[P,corrSL],If[sS==2,fl[P,\[Lambda],1,corrSL],fsl[P,\[Lambda],corrL,corrSL]]];
(* peso total\[Rule]for\[CCedilla]a de atra\[CCedilla]\[ATilde]o conjunta do Sol,da Terra e da Lua,numa dada fase definida por \[Lambda],no ponto P,com as mesmas corre\[CCedilla]\[OTilde]es anteriores *)
horiz[P_,\[Lambda]_: 0.,corrL_: 1.,corrSL_: 60.,sS_:3]:=Normalize[Reverse[{1,-1}*pesoT[P,\[Lambda],corrL,corrSL,sS]]];(* horizontais no ponto P\[Rule]perpendiculares ao peso total em P *)

arrows2[P_,esc_:1., \[Lambda]_:\[Pi]/2.,corrL_:1.,corrSL_:60.,Ah_:.08,sS_:1, lingu_:1,siz_:12]:={Arrowheads[Ah], AbsoluteThickness[3.],Cyan,Tooltip[Arrow[{P,P+esc*peso[P]}],
Style[mens[[23,lingu]],siz]],{Dashing[{.125Ah,.25Ah}],
Line[{P+esc*If[sS==1,fs[P,corrSL],If[sS==2,fl[P,\[Lambda],1,corrSL],fsl[P,\[Lambda],corrL,corrSL]]],esc*peso[P]+P+esc*If[sS==1,fs[P,corrSL],If[sS==2,fl[P,\[Lambda],1,corrSL],
fsl[P,\[Lambda],corrL,corrSL]]]}]},Yellow,
If[sS!=2,Tooltip[Arrow[{P,P+esc*fs[P,corrSL]}],Style["     "<>ToString[Round[corrSL]]
<>mens[[24,lingu]]<>ToString[Round[corrSL]]<>mens[[25,lingu]],siz]],{}],


{Dashing[{.125Ah,.25Ah}],If[sS==1,Line[{P+esc*peso[P],P+esc*(peso[P]+fs[P,corrSL])}],If[sS==2,{},
Line[{P+esc*fl[P,\[Lambda],corrL,corrSL],P+esc*(fs[P,corrSL]+fl[P,\[Lambda],corrL,corrSL])}]]]},


White,If[sS==1,{},{If[sS==2,{Tooltip[Arrow[{P,P+esc*fl[P,\[Lambda],1,corrSL]}],Style["      "<>ToString[Round[corrSL]]<>mens[[26,lingu]]<>ToString[Round[corrSL]]<>mens[[25,lingu]],siz]],
{Dashing[{.125Ah,.25Ah}],
Line[{P+esc*peso[P],P+esc*(peso[P]+fl[P,\[Lambda],1,corrSL])}]}},
{Tooltip[Arrow[{P,P+esc*fl[P,\[Lambda],corrL,corrSL]}],Style["      "<>ToString[Round[corrL*corrSL]]<>mens[[26,lingu]]<>ToString[Round[corrL]]<>" x "<>ToString[Round[corrSL]]<>
mens[[25,lingu]],siz]],{Dashing[{.125Ah,.25Ah}],
Line[{P+esc*fs[P,corrSL],P+esc*(fs[P,corrSL]+fl[P,\[Lambda],corrL,corrSL])}]},Orange,Tooltip[Arrow[{P,P+esc*fsl[P,\[Lambda],corrL,corrSL]}],Style[mens[[27,lingu]],siz]],
{Dashing[{.125Ah,.25Ah}],Line[{P+esc*peso[P],esc*peso[P]+P+esc*fsl[P,\[Lambda],corrL,corrSL]}]}}]}],



Magenta,If[sS==1,Tooltip[Arrow[{P,P+esc*peso[P]+esc*fs[P,corrSL]}],Style[mens[[28,lingu]],siz]],If[sS==2, Tooltip[Arrow[{P,P+esc*peso[P]+esc*fl[P,\[Lambda],1,corrSL]}],
Style[mens[[55,lingu]],siz]],Tooltip[Arrow[{P,esc*peso[P]+P+esc*fsl[P,\[Lambda],corrL,corrSL]}],Style[mens[[29,lingu]],siz]]]],{GrayLevel[1.], Circle[P,1.5Ah],Black,Disk[P,1.2Ah]}};

m1str={{"Velocidade angular","Angular speed","Vitesse angulaire"},{"Clique para alterar o idioma","Click to change language","Cliquez pour changer la langue"},
{"Velocidade angular a que se move a esfera azul","Angular speed of the blue ball","Vitesse angulaire de la boule rouge"},
{"Massa da esfera azul (densidade constante)","Mass of the blue ball (constant density)","Masse de la boule rouge (densit\[EAcute] constante)"},
{"Comprimento da haste que segura a esfera azul","Length of the rod holding the blue ball","Longueur de la tige qui tient la boule rouge"},
{"Velocidade angular a que se move a esfera cinzenta","Angular speed of the gray ball","Vitesse angulaire de la boule bleue"},
{"Massa da esfera cinzenta (densidade constante)","Mass of the gray ball (constant density)","Masse de la boule bleue (densit\[EAcute] constante)"},
{"Comprimento da haste que segura a esfera cinzenta","Length of the rod holding the gray ball","Longueur de la tige qui tient la boule bleue"},
{"Duas esferas","Two balls","Deux boules"},{"Velocidades","Speeds","Vitesses"},{"\[CapitalAHat]ngulo entre as hastes das esferas","Angle between the rods of balls",
"Angle entre les tiges des boules"},{"Vista de Cima","View form the top","Vue d'en haut"},{"Vel. ang. iguais","Equal angular speeds","Vit. ang. \[EAcute]gales"},
{"For\[CCedilla]as","Forces","Forces"},{"Esferas diametralmente opostas","Diametrically opposite balls","Boules diam\[EAcute]tralement oppos\[EAcute]es"},
{"Clique para acrescentar uma esfera","Click to add a ball","Cliquez pour ajouter une boule"},{"Clique para retirar a esfera cinzenta","Click to remove the gray ball",
"Cliquez pour enlever la boule bleue"},{"Clique para ver os vectores representativos \ndas velocidades angular e linear da esfera",
"Click to see the vectors representing the \nangular and linear speeds of the ball","Cliquez pour voir les vecteurs repr\[EAcute]sentant les vitesses angulaire et lin\[EAcute]aire de la boule"},
{"Clique para ver os vectores representativos \ndas velocidades angular e linear das esferas","Click to see the vectors representing \nthe angular and linear speeds of the balls",
"Cliquez pour voir les vecteurs repr\[EAcute]sentant les vitesses angulaire et lin\[EAcute]aire des boules"},
{"Clique para ver o vector representativo da for\[CCedilla]a que a \narma\[CCedilla]\[ATilde]o exerce sobre a haste que segura a esfera",
"Click to see the vector representing the force \nthat the frame exerts on the rod holding the ball",
"Cliquez pour voir le vecteur repr\[EAcute]sentant la force que la structure exerce sur la tige tenant la boule"},
{"Clique para ver os dois vectores representativos das for\[CCedilla]as \nque a arma\[CCedilla]\[ATilde]o exerce sobre as hastes que seguram as esferas \ne a resultante dessas for\[CCedilla]as",
"Click to see the two vectors representing the forces that \nthe frame exerts on the rods holding the balls and the \nresultant of those forces",
"Cliquez pour voir les deux vecteurs repr\[EAcute]sentant les forces que la structure exerce sur les tiges qui tiennent les boules et la r\[EAcute]sultante de ces forces"},
{"Informa\[CCedilla]\[ATilde]o  ","Information   ","Information  "},{"Tirar a arma\[CCedilla]\[ATilde]o","Remove the frame","Enlevez la structure"},
{"Clique para tornar as velocidades angulares iguais. O programa escolhe como valor (comum) \nda velocidade angular a m\[EAcute]dia das velocidades angulares anteriores.",
"Click to make the angular velocities equal. The program chooses as the (common) \nangular speed the average of the previous angular speeds.",
"Cliquez pour rendre \[EAcute]gales les vitesses angulaires. Le programme choisit comme vitesse \nangulaire (commune) la moyenne entre les vitesses angulaires ant\[EAcute]rieures"},
{"Velocidade angular","Angular speed","Vitesse angulaire"},{"Intensidade da for\[CCedilla]a exercida pela arma\[CCedilla]\[ATilde]o \nsobre a haste que segura a esfera",
"Intensity of force exerted by the frame \non the rod holding the ball","Intensit\[EAcute] de la force exerc\[EAcute]e par la structure sur la tige tenant la boule"},
{ "Intensidade das for\[CCedilla]as exercidas pela arma\[CCedilla]\[ATilde]o \nsobre as hastes que seguram as esferas","Intensity of force exerted by the frame \non the rods holding the balls",
"Intensit\[EAcute] de la force exerc\[EAcute]e par la structure sur les tiges tenant les boules"},{"Intensidade da resultante das for\[CCedilla]as que a arma\[CCedilla]\[ATilde]o exerce",
"Intensity of the resultant of the forces that the frame exerts","Intensit\[EAcute] de la r\[EAcute]sultante des forces exerc\[EAcute]es par la structure"},
{"\nMassa","\nMass","\nMasse"},{"Comprimento \nda haste","Length of \nthe rod","Longueur \nde la tige"},
{"Clique para ocultar os vectores representativos \ndas velocidades angular e linear da esfera","Click to hide the vectors representing the \nangular and linear speeds of the ball",
"Cliquez pour cacher les vecteurs repr\[EAcute]sentant les vitesses angulaire et lin\[EAcute]aire de la boule"},
{"Clique para ocultar os vectores representativos \ndas velocidades angular e linear das esferas",
"Click to hide the vectors representing \nthe angular and linear speeds of the balls","Cliquez pour cacher les vecteurs repr\[EAcute]sentant les vitesses angulaire et lin\[EAcute]aire des boules"},
{"Clique para ocultar o vector representativo da for\[CCedilla]a \nque a arma\[CCedilla]\[ATilde]o exerce sobre a haste que segura a esfera",
"Click to hide the vector representing the force that \nthe frame exerts on the rod holding the ball",
"Cliquez pour cacher le vecteur repr\[EAcute]sentant la force que la structure exerce sur la tige qui tient la boule"},
{"Clique para ocultar os vectores representativos das for\[CCedilla]as \nque a arma\[CCedilla]\[ATilde]o exerce sobre as hastes que seguram as esferas \ne a resultante dessas for\[CCedilla]as",
"Click to hide the vectors representing the forces that \nthe frame exerts on the rods that hold the balls,and the \nresultant of these forces",
"Cliquez pour cacher les vecteurs repr\[EAcute]sentant les forces que la structure exerce sur les tiges qui tiennent les boules et la r\[EAcute]sultante de ces forces"},
{"For\[CCedilla]a  ","Force","Forces"},{"Voltar...","Return...","Revenir..."},
{"Clique para ver as for\[CCedilla]as exercidas pela haste nas esferas","Click to see the forces exerted by the rod on the balls",
"Cliquez pour voir les forces exerc\[EAcute]es par la tige sur les boules"},{"Clique para ocultar as for\[CCedilla]as exercidas pela haste nas esferas",
"Click to hide the forces exerted by the rod on the balls","Cliquez pour cacher les forces exerc\[EAcute]es par la tige sur les boules"},
{"Sobrevoe com o rato os elementos do programa para obter mais esclarecimentos. \nN\[ATilde]o se esque\[CCedilla]a de ler as diversas informa\[CCedilla]\[OTilde]es que surgem ao longo do programa.","Pass the mouse over the elements of the program for further information. \nDon't forget to read the various information that appears throughout the program.","Survolez avec la souris les \[EAcute]l\[EAcute]ments du programme pour avoir plus de renseignements.
N'oubliez pas de lire les diff\[EAcute]rentes informations qui se succ\[EGrave]dent tout le long du programme"},{"Clique para tirar a arma\[CCedilla]\[ATilde]o","Click to remove the frame",
"Cliquez pour enlever la structure"},
{"Clique para voltar a colocar a arma\[CCedilla]\[ATilde]o e definir as massas das esferas e \nos comprimentos das hastes iguais aos que estavam definidos no momento \nem que tirou a arma\[CCedilla]\[ATilde]o",
"Click to replace the frame and define the masses \nand the lengths of the rods to be the same as they \nwere when you removed the frame",
"Cliquez pour remettre en place la structure et red\[EAcute]finir les masses des boules et les longueurs \ndes tiges pour les valeurs \[EAcute]gales \[AGrave] celles qui \[EAcute]taient d\[EAcute]finies au moment 
o\[UGrave] on a enlev\[EAcute] la structure"},{"Clique para ter o modelo visto de cima","Click to see the model from above","Cliquez pour avoir une vue d'en haut"},
{"Clique para ter o modelo visto em perspectiva","Click to see the model en perspective","Cliquez pour voir le mod\[EGrave]le en perspective"},
{"Massa da esfera azul e comprimento da haste que a segura","Mass of the blue ball and length of the rod holding it","Masse de la boule rouge et longueur de la tige qui la tient"},
{"Massas da esferas e comprimentos das hastes que as seguram","Masses of the balls and lengths of the rods holding them","Masses des boules et longueurs des tiges qui les tiennent"},
{" e "," and "," et "},{"Aumentar ou diminuir as massas das duas \nesferas, pelo mesmo factor",
"Increase or decrease the masses of the two \nballs by the same factor",
"Augmenter ou diminuer les masses des deux boules,par le m\[EHat]me facteur"},{"Alterar:    ","Change:     ","Changer:      "},
{"Aumentar ou diminuir os comprimentos das hastes que seguram \nas duas esferas, pelo mesmo factor","Increase or decrease the masses of the \ntwo balls by the same factor",
"Augmenter ou diminuer les longueurs des tiges qui tiennent les deux boules, par le m\[EHat]me facteur"},
{"Aumentar a massa da esfera azul e diminuir o comprimento \nda haste que a segura, pelo mesmo factor ou vice-versa",
"Increase the mass of the blue ball and decrease the length \nof the rod holding it by the same factor or vice versa",
"Augmenter la masse de la boule rouge et diminuer la longueur de la tige qui la tient,par le m\[EHat]me facteur ou vice-versa"},
{"Aumentar ou diminuir a massa da esfera azul e o comprimento \nda haste que segura a esfera cinzenta, pelo mesmo factor",
"Increase or decrease the mass of the blue ball and the length \nof the rod holding the gray ball by the same factor","Augmenter ou diminuer la masse de la boule rouge et la longueur de la tige qui tient la boule bleue,par le m\[EHat]me facteur"},{"Produto da massa da esfera azul pelo comprimento da haste que a segura","Product of the mass of the blue ball by the length of the rod that holds it","Produit de la masse de la boule rouge par la longueur de la tige qui la tient"},{"Produto da massa da esfera cinzenta pelo comprimento da haste que a segura","Product of the mass of the gray ball by the length of the rod that holds it","Produit de la masse de la boule bleue par la longueur de la tige qui la tient"},{"Velocidades angulares","Angular speeds","Vitesses angulaires"},{"Clique para definir um \[AHat]ngulo de 180 graus entre as hastes das esferas","Click to define a 180\.ba angle between the balls","Cliquez pour d\[EAcute]finir un angle de 180 degr\[EAcute]s entre les tiges des boules"},{"Clique para poder escolher velocidades angulares diferentes","Click to be able to choose diferent angular speeds","Cliquez pour pouvoir choisir des vitesses angulaires diff\[EAcute]rentes"},{"Clique para poder alterar o \[AHat]ngulo entre as esferas","Click to be able to change tha angle between the  rods of balls","Cliquez pour pouvoir changer l'angle antre les tiges des deux boules"},
{"For\[CCedilla]a que a arma\[CCedilla]\[ATilde]o exerce sobre a haste \nque segura a esfera azul","Force exerted by the frame \non the rod holding the blue ball",
"Force que la structure exerce sur la tige qui tient la boule rouge"},{"For\[CCedilla]a que a arma\[CCedilla]\[ATilde]o exerce sobre a haste \nque segura a esfera cinzenta",
"Force exerted by the frame on the rod \nholding the gray ball","Force que la structure exerce sur la tige qui tient la boule bleue"},
{"For\[CCedilla]a que a haste exerce na esfera azul","Force exerted by the rod on the blue ball","Force que la tige exerce sur la boule rouge"},
{"For\[CCedilla]a que a haste exerce na esfera cinzenta","Force exerted by the rod on the gray ball","Force que la tige exerce sur la boule bleue"},
{"Resultante das for\[CCedilla]as que a arma\[CCedilla]\[ATilde]o \nexerce sobre as hastes","Resultant of the forces exerted \nby the frame on the rods",
"R\[EAcute]sultante des forces que la structure exerce sur les tiges"}};

m1obs={{"Este modelo (I) trata o movimento de uma ou duas esferas, presas por \n(uma ou duas) hastes a uma estrutura r\[IAcute]gida.",
"This model (I) deals with the movement of one or two balls, attached to \na rigid frame by (one or two) rods.",
"Ce mod\[EGrave]le (I) s'occupe du mouvement d'une ou de deux boules, tenues par \n(une ou deux) tiges \[AGrave] une structure rigide."},
{ "\n\nSe alterar a velocidade angular, a massa da esfera e/ou o comprimento da haste \nque a segura, a intensidade da for\[CCedilla]a exercida pela arma\[CCedilla]\[ATilde]o tamb\[EAcute]m \[EAcute] alterada. \nObserve de que forma estes par\[AHat]metros influenciam a for\[CCedilla]a que a arma\[CCedilla]\[ATilde]o exerce. \nQuando terminar, clique em \"Duas esferas\" para acrescentar uma esfera.","\n\nIf you change the angular velocity, the mass of the ball and / or the length of the \nrod which holds it, the intensity of the force exerted by the frame is also altered. \nNotice how these parameters influence the force that the frame exerts. When done, \nclick \"Two balls\" to add a ball.","\n\nSi vous changez la vitesse angulaire, la masse de la boule et/ou la longueur de la \ntige qui la tient, l'intensit\[EAcute] de la force exerc\[EAcute]e par la structure change, elle aussi. \nObservez de quelle fa\[CCedilla]on ces param\[EGrave]tres influencent la force que la structure exerce. \nQuand vous aurez termin\[EAcute], cliquez sur \"Deux boules\" pour ajouter une boule."},
{"Em geral, a intensidade da resultante das duas for\[CCedilla]as que a arma\[CCedilla]\[ATilde]o exerce sobre as \nhastes varia periodicamente, sendo m\[AAcute]xima quando as esferas est\[ATilde]o alinhadas do \nmesmo lado e m\[IAcute]nima quando est\[ATilde]o diametralmente opostas. Haver\[AAcute] velocidades \nangulares para as quais a intensidade da for\[CCedilla]a resultante, \!\(\*OverscriptBox[\(Fr\), \(\[RightArrow]\)]\), \[EAcute] constante?","In general, the intensity of the resultant of the two forces that the frame exerts on the \nrods varies periodically, reaching its maximum when the balls are aligned and its \nminimum when they are diametrically opposite. Are there angular speeds for which \nthe resulting force intensity, \!\(\*OverscriptBox[\(Fr\), \(\[RightArrow]\)]\), is constant?",
"En g\[EAcute]n\[EAcute]ral, l'intensit\[EAcute] de la r\[EAcute]sultante des deux forces que la structure exerce  sur les tiges \nchange p\[EAcute]riodiquement, ayant un maximum lorsque les boules sont align\[EAcute]es d'un m\[EHat]me \nc\[OHat]t\[EAcute] et un minimum lorsqu'elles sont diam\[EAcute]tralement oppos\[EAcute]es. Y-aura-t'il des \nvitesses angulaires pour lesquelles l'intensit\[EAcute] de la force r\[EAcute]sultant, \!\(\*OverscriptBox[\(Fr\), \(\[RightArrow]\)]\), est constante?"},{
"Nesta situa\[CCedilla]\[ATilde]o (velocidades angulares iguais) a intensidade da resultante das for\[CCedilla]as \nque a arma\[CCedilla]\[ATilde]o exerce sobre as hastes \[EAcute] constante. Como fazer para que, com \nvelocidade angular n\[ATilde]o nula, a intensidade da for\[CCedilla]a resultante, \!\(\*OverscriptBox[\(Fr\), \(\[RightArrow]\)]\), seja zero? ","In this situation (equal angular speeds) the intensity of the resultant forces exerted \non the rods is constant. With non-zero angular velocity, how can we make the \nresulting force intensity, \!\(\*OverscriptBox[\(Fr\), \(\[RightArrow]\)]\), zero?","Dans cette situation (vitesses angulaires \[EAcute]gales) l'intensit\[EAcute] de la r\[EAcute]sultante des forces \nque la structure exerce sur les tiges est constante. Comment faire de sorte que, \nla vitesse angulaire \[EAcute]tant non nulle, l'intensit\[EAcute] de la force r\[EAcute]sultante soit z\[EAcute]ro?"},{
"Nesta situa\[CCedilla]\[ATilde]o (descreva-a...) a resultante das for\[CCedilla]as exercidas pela arma\[CCedilla]\[ATilde]o nas \nhastes \[EAcute] nula. Portanto, a arma\[CCedilla]\[ATilde]o deixa de ser necess\[AAcute]ria ao suporte do \nmodelo. Experimente tir\[AAcute]-la.","In this situation (describe it ...) the resultant of the forces exerted by the frame \non the rods is zero. Therefore, the frame is no longer required to support \nthe model. Try removing it.","Dans cette situation (d\[EAcute]crivez-la...) la r\[EAcute]sultante des forces exerc\[EAcute]es par la \nstructure sur les tiges est nulle. Donc, la structure n'est plus n\[EAcute]cessaire \nau support du mod\[EGrave]le. Essayez de l'enlever."},{"Como ","Since ","Puisque "},{", o ponto em torno do qual est\[ATilde]o a rodar as esferas corresponde ao \ncentro de massa das duas esferas. Se alterar um dos par\[AHat]metros de uma das esferas, \n\[EAcute] necess\[AAcute]rio alterar outro par\[AHat]metro, de forma a manter o equil\[IAcute]brio. Explore as diferentes \naltera\[CCedilla]\[OTilde]es que pode fazer. Repare que, neste modelo, a haste continua a ser necess\[AAcute]ria.",", the point around which the balls are rotating corresponds to the \ncenter of mass of the two balls.If you change one of the parameters of one of the balls, \nit is necessary to change another parameter in order to maintain the balance. Explore \nthe different changes you can make. Note that, in this model, the rod is still required.",", le point autour duquel tournent les boules correspond au centre de masse \ndes deux boules. Si vous changez l'un des param\[EGrave]tres de l'une des boules, il faut changer un \nautre param\[EGrave]tre, de fa\[CCedilla]on \[AGrave] maintenir l'\[EAcute]quilibre. Explorez les diff\[EAcute]rents changements que l'on \npeut faire. Remarquez que, dans ce mod\[EGrave]le, la tige continue \[AGrave] \[EHat]tre n\[EAcute]cessaire."}};

siz=If[resH<1400,13,14];Circle3D[{x_,y_,z_},r_,ang1_,ang2_]:=Line[Table[{x,y,z}+{r Cos[t],r Sin[ t],0},{t,ang1,ang2,Pi/40}]];
arm=False;arm2=False;m1alt=False;m1inf=True;m1c=0;m1act=True;

str={{"Velocidade angular","Angular speed",""},
{"Clique para alterar o idioma","Click to change language",""},
{"Diminuir a dist\[AHat]ncia entre as esferas e aumentar a velocidade angular (ou vice-versa)","Decrease the distance between the balls and increase the angular speed (or vice versa)",""},
{"Dist\[AHat]ncia entre as duas esferas (soma das dist\[AHat]ncias \nentre cada esfera e o centro de massa)","Distance between the two balls (sum of the distances \nbetween each ball and the center of mass)",""},
{"Clique para ver os vectores representativos das velocidades angular e linear das esferas","Click to see the vectors representing the angular and linear velocities of the balls",""},
{"Clique para ocultar os vectores representativos das velocidades angular e linear das esferas","Click to hide the vectors representing the angular and linear velocities of the balls",""},{"Velocidades","Speeds",""},{"For\[CCedilla]as","Forces",""},
{"Vista de Cima","See from above",""},{"Clique para ver os vectores representativos das for\[CCedilla]as que actuam nas esferas","Click to see the vectors representing the forces that act on the balls",""},
{"Clique para ocultar os vectores representativos das for\[CCedilla]as que actuam nas esferas","Click to hide the vectors representing the forces that act on the balls",""},
{"Sobrevoe com o rato os elementos do programa para obter mais esclarecimentos. \nN\[ATilde]o se esque\[CCedilla]a de ler as diversas informa\[CCedilla]\[OTilde]es que surgem ao longo do programa.","Pass the mouse over the elements of the program for further information.
Don't forget to read the various information that appears throughout the program.",""},{"Informa\[CCedilla]\[ATilde]o  ","Information  ",""},
{"Intensidade comum das for\[CCedilla]as que a haste exerce ao segurar as esferas","Common intensity of the forces exerted by the rod when holding the balls",""},{"Atrac\[CCedilla]\[ATilde]o","Atraction",""},
{"Clique para activar uma for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o entre as duas esferas","Click to activate a force of attraction between the two balls",""},
{"Clique para desactivar a for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o entre as duas esferas","Click to deactivate a force of attraction between the two balls",""},
{"Intensidade da for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o entre as duas esferas","Intensity of the force of attraction between the two balls",""},{"Centro de Massa das duas esferas","Center of mass of the two balls",""},{"","",""},{"","",""},{"Tirar a haste","Remove the rod",""},
{"Colocar a haste","Place the rod",""},{"Clique para ter o modelo visto de cima","Click to see the model from above",""},{"Clique para ter o modelo visto em perspectiva","Click to see the model in perspective",""},{"Massas","Masses",""},
{"Dist\[AHat]ncias","Distances",""},{"Clique para tirar a haste","Click to remove the rod",""},
{ "Clique para voltar a colocar a haste e definir a velocidade angular e a dist\[AHat]ncia \nentre as esferas iguais \[AGrave]s que estavam definidas no momento em que tirou a haste",
"Click to replace the rod and define the angular speed and distance between the \nballs to be the same as they were when you removed the rod",""},
{"Intensidade comum das for\[CCedilla]as que a haste exerceria ao segurar as esferas, caso n\[ATilde]o houvesse atrac\[CCedilla]\[ATilde]o","Common intensity of the forces which the rod would exert when holding the balls if there were no attraction",""},
{"Intensidade comum das for\[CCedilla]as que a haste exerce ao segurar as esferas \n(positiva, se dirigidas para o interior da haste; negativa, caso contr\[AAcute]rio)",
"Common intensity of the forces which the rod exerts when holding the balls \n(positive if directed to the inside of the rod,negative otherwise)",""},
{"For\[CCedilla]a que a haste exerce ao segurar a esfera cinzenta","Force the rod exerts while holding the gray ball",""},{"For\[CCedilla]a que a haste exerce ao segurar a esfera azul","Force the rod exerts while holding the blue ball",""},
{"For\[CCedilla]a de atrac\[CCedilla]\[ATilde]o que a esfera azul exerce sobre a esfera cinzenta","Force of attraction that the blue ball exerts on the gray ball",""},{"For\[CCedilla]a de atrac\[CCedilla]\[ATilde]o que a esfera cinzenta exerce sobre a esfera azul",
"Force of attraction that the gray ball exerts on the blue ball",""}};

obs={{"Este modelo (2) trata o movimento circular de duas esferas ligadas por uma \nhaste r\[IAcute]gida, em torno do centro de massa (suposto fixo). O modelo permite \ntamb\[EAcute]m fazer intervir uma for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o entre as esferas. ",
      "This model (2) deals with the circular movement of two balls, connected by a \nrigid rod, around the center of mass (assumed fixed).The model also allows \nthe action of a force of attraction between the balls.",""},
{"\n\nSe alterar a velocidade angular ou a dist\[AHat]ncia entre as esferas, a intensidade comum \ndas for\[CCedilla]as exercidas pela haste tamb\[EAcute]m \[EAcute] alterada. Observe de que forma estes \npar\[AHat]metros influenciam essa intensidade. Quando terminar, clique em \"Atrac\[CCedilla]\[ATilde]o\" para \nacrescentar a for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o entre as esferas.",
 "\n\nIf you change the angular speed or the distance between the balls, the common intensity \nof the forces exerted by the rod is also changed. Notice how these parameters \ninfluence that intensity. When done, click on \"Attraction\" to add the force of \nattraction between the balls.",""},
{
"Note que a for\[CCedilla]a de atra\[CCedilla]\[ATilde]o s\[OAcute] depende de d. Escolha valores de \[Omega] e d que tornem \nF-Fa nula.",
"Note that the force of attraction depends only on d.Choose values of \[Omega] and d that \nmake F-Fa zero.",""},{
"Nesta situa\[CCedilla]\[ATilde]o a haste n\[ATilde]o exerce qualquer for\[CCedilla]a sobre as esferas. Portanto, ja n\[ATilde]o \n\[EAcute] necess\[AAcute]ria ao suporte do modelo. Experimente tir\[AAcute]-la.",
"In this situation the rod does not exert any force on the balls. Therefore, it is \nno longer required to support the model. Try removing it.",""},{
"Se se aproximarem ou afastarem as esferas, a velocidade angular ser\[AAcute] alterada de modo \na manter o equilibrio. Observe essas altera\[CCedilla]\[OTilde]es.",
"If the balls approach or move away,the angular speed will be altered in order to \nmaintain equilibrium. Note these changes.",""}};

mens2={{"For\[CCedilla]a de atra\[CCedilla]\[ATilde]o que a Terra exerce sobre a Lua","Force of attraction exerted by the Earth on the Moon",""},
{"For\[CCedilla]a de atra\[CCedilla]\[ATilde]o que a Lua exerce sobre a Terra","Force of attraction exerted by the Moon on the Earth",""},
{"For\[CCedilla]a que a haste tem de exercer face \[AGrave] varia\[CCedilla]\[ATilde]o da velocidade","Force which the rod must exert due to the change of speed",""},
{"Centro de massa","Centre of mass",""},{"Pontos que est\[ATilde]o em equil\[IAcute]brio","Points which are in equilibrium",""},{"Desvio da posi\[CCedilla]\[ATilde]o de equil\[IAcute]brio","Deviation from the equilibrium position",""},
{"Altera\[CCedilla]\[ATilde]o da velocidade angular \n(a velocidade real \[EAcute] multiplicada por este factor)","Change in angular velocity (actual \nvelocity is multiplied by this factor)",""}};






hast2=False;hast=False;inf=True;lingu=1;act=True;altv=False;altd=False;

km=2.5;rm=10;rm1=km*rm;kk\[Omega]=0;c=0;
xtf[kd_:1]:=dtl*kd*ml/(kd*ml+mt);
xtf::usage="xtf[kd] d\[AAcute] a dist\[AHat]ncia entre o centro de massa TL e o centro da Terra, supondo a densidade da lua kd vezes a que realmente \[EAcute] (e mantendo a dimens\[ATilde]o da lua); usa as constantes mt, ml e dtl; pode tamb\[EAcute]m ser visto como dando a localiza\[CCedilla]\[ATilde]o do centro de massa no segmento de dimens\[ATilde]o fixa TL (de comprimento dtl";
xlf[kd_:1]:=mt*xtf[kd]/(kd*ml);
xlf::usage="xlf[kd] d\[AAcute] a dist\[AHat]ncia entre o centro de massa TL e o centro da Lua, supondo a densidade da lua kd vezes a que realmente \[EAcute] (e mantendo a dimens\[ATilde]o da lua); usa as constantes mt, ml e dtl; pode tamb\[EAcute]m ser visto como dando a localiza\[CCedilla]\[ATilde]o do centro de massa no segmento de dimens\[ATilde]o fixa TL (de comprimento dtl";

somaf[kd_:1]:=xtf[kd]+xlf[kd];(* A soma d\[AAcute] sempre dtl *)

par[kd_:81, uz_:0 (* zoom na Terra *),ims_:1290 (* 1240 *) , lingu_:1, msg_:False]:=Block[{xt,xl},xt=xtf@kd;xl=xlf@kd;If[msg,Print["xt=",xt,"    xl=",xl,"    xt+xl=",xt+xl,"      kd=",kd],{}];
Graphics[{Cyan,Tooltip[Disk[{xt,0},rt],astros[[2,lingu]]],White,Disk[{-xl,0},rl],GrayLevel@.5,AbsoluteThickness[.4],Dashed,Tooltip[Line[{{-xl,0},{xt,0}}],mens[[32,lingu]]],White,Tooltip[ Point[{0,0}],mens[[50,lingu]]]},Background->GrayLevel@.6,
PlotRange->{{(1-uz^(1/3))*(-xl)+uz^(1/3)(xt-3rt)-2rl,xt+1.4rt},1.2{-rt,rt}},
ImageSize->{ims,Automatic}
]];
par::usage="par[kd,uz_,ims,msg] mostra com zoom uz (0 nenhum, 1 m\[AAcute]ximo) a Terra, a lua e o centro de massa dos dois"; 
(* const de gravit univ \[EAcute] G tal que a atrac\[CCedilla]\[ATilde]o de dois corpos seja dada por F = G m1 m2/dist^2 *)

kkg=(1/1.46759188)10^-17; (* kkg \[EAcute] a constante de gravita\[CCedilla]\[ATilde]o adequada a dar kg-for\[CCedilla]a como unidade com km como unid de comprimento e kg como unidade de massa, 
, porque kkg * mt * 1 /rt ^2 = 1  se mt e 1 em kg e rt em km *)

gL=-kkg ml;gT=-kkg mt;
flC[kd_:1,tl_:dtl]:=gL kd /tl^2;  (* for\[CCedilla]a da Lua sobre o centro da Terra - \[EAcute] um escalar *) 
flp[\[Theta]_,h_:0,kd_:1,tl_:dtl]:=gL kd/(tl+(rt+h)Cos@\[Theta])^2; (* for\[CCedilla]a da Lua sobre um ponto na Terra \[AGrave] altitude h *)
flm3[h_:0,kd_:1,tl_:dtl,centro_:True]:=gL kd*If[centro,1/tl^2, 1/(tl+rt+h)^2]; (* medida positivamente para a direita *)(* n\[ATilde]o depende de \[Theta], logo \[EAcute] v\[AAcute]lida apenas quando \[Theta] \[EAcute] zero *)

\[CapitalDelta]fl[\[Theta]_,h_:0.,kd_:1,tl_:dtl]:=  
Block[{dpl},dpl=(rt+h)Cos[\[Theta]];-2kd*gL*dpl/(tl+dpl/2)^3]; 
(* dpl d\[AAcute] quanto mais pr\[OAcute]ximo (<0, |\[Theta]|>\[Pi]/2)(ou mais afastado (>0, Abs[\[Theta]]<\[Pi]/2)) da lua est\[AAcute] o ponto (de altitude h e posi\[CCedilla]\[ATilde]o \[Theta]), do que o centro da Terra; Lua \[AGrave] esquerda; o sinal de \[CapitalDelta]fl \[EAcute] o  oposto do de dpl: portanto, como a atrac\[CCedilla]\[ATilde]o da lua tem abcissa negativa, quando \[CapitalDelta]fl \[EAcute] positivo, diminui o valor absoluto da for\[CCedilla]a e quando \[EAcute] negativo aumenta *)
\[CapitalDelta]fl::usage="\[CapitalDelta]fl[\[Theta],h,kd,tl] d\[AAcute] ~ a diferen\[CCedilla]a de for\[CCedilla]as de atrac\[CCedilla]\[ATilde]o da lua sobre o centro da Terra e sobre o ponto dado por \[Theta], h: for\[CCedilla]as positivas para a direita"; (*calculada usando o teorema dos acr\[EAcute]scimos finitos com a derivada no ponto m\[EAcute]dio*)

ptm3[ctx_,\[Theta]_,h_:0.]:={ctx,0}+(rt+h){Cos[\[Theta]],Sin[\[Theta]]}; (* ponto \[AGrave] superf\[IAcute]cie da Terra (Terra com centro em {ctx,0} e raio rt; ou a altitude h>0; km como unidade *) 
pesom3[P_,ct_:{0,0}]:=gT (1./Norm[P-ct])^2 Normalize[P-ct]; (* peso em P (de 1kg-massa proveniente da atrac\[CCedilla]\[ATilde]o da Terra de centro ct); unidade resultado: kg-for\[CCedilla]a *) 

ini[kd_:1,kf0_:200000]:=
(Clear[kd0,atrL0,xt0,kL0,pesos,corrL,corrxL,pesos,pesoTL,kpeso,horizTL,cl,clx];
kd0=kd;kf=kf0; (* kf refor\[CCedilla]a direct/ a atrac\[CCedilla]\[ATilde]o da lua de forma a tornar os efeitos percept\[IAcute]veis no modelo *)
(* kd0 \[EAcute] um factor para a densidade da lua; permite p\[OHat]r o centro de massa fora da Terra e aumenta a for\[CCedilla]a da atrac\[CCedilla]\[ATilde]o da lua;  MUDAR ESTE kd0 e os seguintes dele dependentes; procedendo assim, evitam-se muitas contas repetidas que de outro modo estariam
 sempre a ser feitas  *)
atrL0=flC[kd0,dtl]; (* escalar negativo *)
xt0=xtf@kd0;
kL0=gL*kd0;(* flp[\[Theta]_,h_:0,kd_:1,tl_:dtl]:=kL0/(tl+(rt+h)Cos@\[Theta])^2; *)
corrLm3[\[Theta]_:0,h_:0]:=kf*(kL0/(dtl+(rt+h)Cos@\[Theta])^2-atrL0 );  (* kl0 = gl*kd0 = (-kkg ml)*kd0 *)
corrxLm3[x_]:=kf*(kL0/(dtl+(x-xt0))^2  -atrL0 )(* \[EAcute] um escalar *); 
pesoTL[{x_,y_},kh_:0]:=pesom3[{x,y},{xt0,0}]+{kh+corrxLm3@x,0}; (* pesoTl entra com kh, que \[EAcute] a for\[CCedilla]a exercida pela haste quando a for\[CCedilla]a de atrac\[CCedilla]\[ATilde]o
 n\[ATilde]o "compensa" naturalmente a velocidade angular escolhida;  *)
kpeso=5*10^3; (* kpeso \[EAcute] constante (ensaiada na figura) para dar um comprimento razo\[AAcute]vel para os diversos vectores-for\[CCedilla]a da figura; pode ser alterada s/ pbms *)
pesos[\[Theta]_:\[Pi]/4,h_:0]:=Block[{pp,pT,cl,clx,pTL},Column[{"     xt0             pp                pT (\[Theta],h)          cl        clx             pTL (cl)",{xt0,pp=ptm3[xt0,\[Theta],h],pT=pesom3[pp,{xt0,0}], cl=corrLm3[\[Theta],h],clx=corrxLm3[xt0+(rt+h)*Cos@\[Theta]],pTL=pT+{cl,0}}}]]//N;
horizTL[{x_,y_},kh_:0]:=Normalize[Reverse[{1,-1}*pesoTL[{x,y},kh]]]);

menstab1={{"mL = ","mm = "},{"dTS = ","dES = "},{"dTL = ","dEM = "},{"mS = ", "ms = "}}
{{"mL = ","mm = "},{"dTS = ","dES = "},{"dTL = ","dEM = "},{"mS = ","ms = "}}
tabela1[lingu_:1, fs1_:35] := Column[{
      Grid[{{Style["kg", FontFamily -> "Constantia", fs1, Yellow], 
         Style["kg", FontFamily -> "Constantia", fs1, White], 
         Style["km", FontFamily -> "Constantia", fs1, Yellow], 
         Style["km", FontFamily -> "Constantia", fs1, White]}, 
        {Style[mens[[16,lingu]], FontFamily -> "Constantia", fs1, Yellow, 
          Bold], Style[mens[[17,lingu]], FontFamily -> "Constantia", fs1, 
          White, Bold], Style[TraditionalForm[mens[[19,lingu]]], 
          FontFamily -> "Constantia", fs1, Yellow, Bold], 
         Style[TraditionalForm[mens[[18,lingu]]], FontFamily -> "Constantia", 
          fs1, White, Bold]},{ Row[{Style[menstab1[[4,lingu]], Yellow, FontFamily -> "Constantia", 
          1.3*fs1],Style[ms, Yellow, FontFamily -> "Constantia", 
          1.3*fs1]}],Row[{Style[menstab1[[1,lingu]], White, FontFamily -> "Constantia", 
          1.3*fs1], Style[ml, White, FontFamily -> "Constantia", 1.3*fs1]}], 
         
         
         Row[{Style[menstab1[[2,lingu]], Yellow, FontFamily -> "Constantia", 
          1.3*fs1],
         
         Style[dts, FontFamily -> "Constantia", 1.3*fs1, Yellow]}], 
         
           Row[{Style[menstab1[[3,lingu]], White, FontFamily -> "Constantia", 
          1.3*fs1],
          
         Style[dtl, White, FontFamily -> "Constantia", 1.3*fs1]}]}}, 
       FrameStyle -> Directive[White, AbsoluteThickness[2.]], Frame -> All, 
       Alignment -> {Center, Center}, ItemSize -> {{Scaled@.2,Scaled@.21,Scaled@.26,Scaled@.27} ,2}, Background -> GrayLevel[0.4], 
       Spacings -> {3, 2}]}, Alignment -> Center, Spacings -> 2, 
     Background -> None]

 
menstab={{"Quocientes entre massas","Ratio between masses",""},{"Quocientes entre quadrados de dist\[AHat]ncias","Ratio between the distances squared",""},{" Qual \[EAcute] maior:   ","Which is larger:  ",""},
{"  ou ","   or ",""},{"  Portanto: a atrac\[CCedilla]\[ATilde]o do Sol - \
kS - ser\[AAcute] maior do que a da\n Lua - kL - se e s\[OAcute] se a raz\[ATilde]o das massas mS/mL for maior\ndo que a dos quadrados das dist\[AHat]ncias \[AGrave] Terra \!\(\*SuperscriptBox[\(dTS\), \(2\)]\)/\!\(\*SuperscriptBox[\(dTL\), \(2\)]\)",
"Therefore: the attraction of the Sun - kS - will be greater than \nthat of Moon - kL - if and only if the mass ratio mS / mL is \nlarger than that of the distances to the Earth squared \!\(\*SuperscriptBox[\(dTS\), \(2\)]\)/ \!\(\*SuperscriptBox[\(dTL\), \(2\)]\) ",""},{" se..."," if...",""}};


tabela2[lingu_:1, fs2_:40] := 
    Grid[{{Style[menstab[[1,lingu]], Bold, fs2, 
        FontFamily -> "Times New Roman"], 
       Style[menstab[[2,lingu]], Bold, fs2, 
        FontFamily -> "Times New Roman"]}, 
      {Style[TraditionalForm[mens[[16,lingu]]/mens[[17,lingu]]], 1.4*fs2, 
        FontFamily -> "Times New Roman", Yellow], 
       Style[TraditionalForm[mens[[19,lingu]]^2/mens[[18,lingu]]^2], 1.4*fs2, 
        FontFamily -> "Times New Roman", Yellow]}, 
      {Style[Round[ms/ml], fs2, FontFamily -> "Times New Roman", Yellow], 
       Style[Round[(dts/dtl)^2], fs2, FontFamily -> "Times New Roman", 
        Yellow]}}, Frame -> All, FrameStyle -> Directive[White, 
       AbsoluteThickness[2.]], Frame -> All, Background -> 
      {None, {None, GrayLevel[0.4], GrayLevel[0.4]}}, 
     Alignment -> {Center, Center, Center}, ItemSize -> {Full, 3}, 
     Spacings -> {4, 3}]
 

tabela3[\[Lambda]_:2, lingu_:1, fs3_:36] := 
    Grid[{{Style[If[lingu==1,"fS = k ","fs = k "],FontFamily -> "Constantia", fs3, Bold, Yellow]
     If[lingu==1,Style[TraditionalForm[HoldForm[mS/dTS^\[Lambda]\[Lambda]]]/.\[Lambda]\[Lambda]->Quiet[NumberForm[\[Lambda],3]],FontFamily -> "Constantia", fs3, Bold, 
         Yellow], Style[TraditionalForm[HoldForm[ms/dES^\[Lambda]\[Lambda]]]/.\[Lambda]\[Lambda]->Quiet[NumberForm[\[Lambda],3]],FontFamily -> "Constantia", fs3, Bold, 
         Yellow]],
 Style[If[lingu==1,"fL = k ","fm = k "],FontFamily -> "Constantia", fs3, Bold, White]*
      If[lingu==1, Style[ TraditionalForm[HoldForm[mL/dTL^\[Lambda]\[Lambda]]]/.\[Lambda]\[Lambda]->Quiet[NumberForm[\[Lambda],3]], fs3, 
         FontFamily -> "Constantia", White, Bold],Style[ TraditionalForm[HoldForm[mm/dEM^\[Lambda]\[Lambda]]]/.\[Lambda]\[Lambda]->Quiet[NumberForm[\[Lambda],3]], fs3, 
         FontFamily -> "Constantia", White, Bold]] ,
       Style[TraditionalForm[If[lingu==1,"fS","fs"]/If[lingu==1,"fL","fm"]], FontFamily -> "Constantia",fs3, Yellow, Bold], 
       Style[TraditionalForm[If[lingu==1,"fL","fm"]/If[lingu==1,"fS","fs"]], FontFamily -> "Constantia",fs3, White, Bold]}, 
      {Style[StringJoin["k x ", Quiet[ToString[TraditionalForm[NumberForm[ms/dts^\[Lambda],3]]]]], 
        FontFamily -> "Constantia",Bold, Yellow, fs3], Style[StringJoin["k x ", 
         Quiet[ToString[TraditionalForm[NumberForm[ml/dtl^\[Lambda],3]]]]], Bold, White,
         FontFamily -> "Constantia", fs3], 
       Style[StringJoin["\[TildeTilde]", ToString[
          Round[(ms/ml)*(dtl^\[Lambda]/dts^\[Lambda]), 0.1]]], Yellow, Bold, 
        FontFamily -> "Constantia",fs3], Style[StringJoin["\[TildeTilde]", 
         ToString[Round[(ml/ms)*(dts^\[Lambda]/dtl^\[Lambda]), 0.01]]], Bold, 
        FontFamily -> "Constantia",fs3, White]}}, Frame -> All, FrameStyle -> Directive[White, 
       AbsoluteThickness[2.]], Background -> GrayLevel[0.4], 
     ItemSize -> {{.0145*resH, .0145*resH, .007*resH, .007*resH}, .00145*resH}, Alignment -> {Center}, 
     Spacings -> {.0007*resH, .0014*resH}]

 

 
grs[x_:2, lingu_:1, backg_:GrayLevel[0.4]] := 
    GraphicsRow[{Show[Plot[1/SL[\[Lambda]], {\[Lambda], 1.97, 3}, 
        PlotRange -> All, PlotRangePadding -> None, Axes -> True, 
        Ticks -> {{2, 2.2, 2.4, 2.6, 2.8, 3}, {0, 50, 100, 150, 
           Round[1/SL[2], 0.1], 200}}, TicksStyle -> Directive[White, Bold, 
          16], AxesOrigin -> {1.97, 0}, AxesStyle -> Directive[White, 
          AbsoluteThickness[2.]], PlotLabel -> 
         Style[StringJoin[mens[[13,lingu]], "/", mens[[14,lingu]],menstab[[6,lingu]]], Bold, 
          Yellow, 32], AxesLabel -> {Style[mens[[12,lingu]], White, 24], 
          None}, PlotStyle -> Directive[AbsoluteThickness[3.], Yellow], 
        ImageSize -> 0.43*resH, Background -> backg], 
       Graphics[{AbsolutePointSize[10], Yellow, Point[{x, 1/SL[x]}], Dashed, 
         AbsoluteThickness[1.5], White, Line[{{2, 0}, {2, 1/SL[2]}, 
           {1.97, 1/SL[2]}}], Yellow, Dashing[{0.02, 0.01}], 
         Line[{{x, 0}, {x, 1/SL[x]}, {1.97, 1/SL[x]}}]},Background -> None]], 
      Show[Plot[{SL[\[Lambda]]}, {\[Lambda], 1.97, 3}, 
        PlotRange -> {{1.95, 3.04}, {-0.04, 2.19}}, PlotRangePadding -> None, 
        Axes -> True, Ticks -> {{2, 2.2, 2.4, 2.6, 2.8, 2.87, 3}, 
          {0, 0.5, 1, 1.5, 2, Round[SL[3], 0.01]}}, TicksStyle -> 
         Directive[White, Bold, 16], AxesOrigin -> {1.97, 0}, 
        AxesStyle -> Directive[White, AbsoluteThickness[2.]], 
        PlotLabel -> Style[StringJoin[mens[[14,lingu]], "/", 
           mens[[13,lingu]],menstab[[6,lingu]]], Bold, White, 32], AxesLabel -> 
         {Style[mens[[12,lingu]], White, 24], None}, 
        PlotStyle -> Directive[AbsoluteThickness[3.], White], 
        ImageSize -> 0.417*resH, Background -> backg], 
       Graphics[{AbsolutePointSize[10], White, Point[{{x, SL[x]}, {2.87, 1}, 
           {3, SL[3]}}], Dashed, AbsoluteThickness[2.], White, 
         Line[{{3, 0}, {3, SL[3]}, {1.97, SL[3]}}], 
         Line[{{SLinv1, 0}, {SLinv1, 1}, {1.97, 1}}], Dashing[{0.02, 0.01}], 
         Line[{{x, 0}, {x, SL[x]}, {1.97, SL[x]}}]},Background -> None]]},
     ImageSize -> 0.91*resH, Spacings -> 0]
tabela0[fase_:1, fs0_:48, lingu_:1] := 
    Framed[Column[{Row[{Style[menstab[[3,lingu]], FontFamily -> 
           "Times New Roman", fs0], Style["kS = mS/\!\(\*SuperscriptBox[\(dTS\), \(2\)]\)", 
          FontFamily -> "Times New Roman", Bold, fs0], 
         Style[menstab[[4,lingu]], fs0], Style[" kL = mL/\!\(\*SuperscriptBox[\(dTL\), \(2\)]\) ", 
          FontFamily -> "Times New Roman", Bold, fs0], Style["?", fs0, 
          FontFamily -> "Times New Roman"]}], 
       Row[If[1 < fase, {Style["  kL < kS", FontFamily -> "Times New Roman", 
           Bold, fs0], Style["    \[DoubleLongLeftRightArrow]    1 < ", 
           FontFamily -> "Times New Roman", fs0], Style[Evaluate["kS"/"kL"], 
           FontFamily -> "Times New Roman", fs0], 
          Style["   \[DoubleLongLeftRightArrow]   1 < ", FontFamily -> 
            "Times New Roman", fs0], Style[HoldForm["mS"/"dTS"^2]/
            HoldForm["mL"/"dTL"^2], FontFamily -> "Times New Roman", fs0], 
          Style["   \[DoubleLongLeftRightArrow]   ", FontFamily -> 
            "Times New Roman", fs0], Style["1 < ", FontFamily -> 
            "Times New Roman", Bold, fs0], Style[HoldForm["mS"/"mL"]/
            HoldForm["dTS"^2/"dTL"^2], FontFamily -> "Times New Roman", Bold, 
           fs0]}, {"                     "}]], 
       Row[If[2 < fase, {Style[menstab[[5,lingu]], FontFamily -> 
            "Times New Roman", fs0]}, {"    "}]]}, Spacings -> {0, 5}, 
      Background -> None], Alignment -> Top, FrameMargins -> 
      {{30, 30}, {20, 20}}, ImageSize -> {Full, .417*resH}];
