/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import pattern.LightPatternSolver;

public final class ProgressVisualizer
extends JFrame
implements LightPatternSolver.IProgressListener {
    private JProgressBar bar;
    private JLabel text;

    public ProgressVisualizer(String pattern, Component cp) {
        super("Calculating Pattern " + pattern);
        this.setLocationRelativeTo(cp);
        this.setDefaultCloseOperation(0);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(gridbag);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 0, 5);
        this.text = new JLabel("Initialize ...");
        gridbag.setConstraints(this.text, c);
        this.getContentPane().add(this.text);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        this.bar = new JProgressBar(0, 1);
        gridbag.setConstraints(this.bar, c);
        this.getContentPane().add(this.bar);
        this.pack();
        this.setSize(400, 80);
        this.setVisible(true);
    }

    @Override
    public void updateAccuracy(int digits, int maxDigits) {
        if (this.bar.getMaximum() != maxDigits) {
            this.bar.setMaximum(maxDigits);
        }
        this.text.setText("Accuracy: " + digits + " / " + maxDigits + " digits");
        this.bar.setValue(digits);
    }
}

