/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import common.Globals;
import common.Log;
import common.Profiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lattice.Circle;
import math.IFunction;
import math.VecMath;

public final class LightPatternSolver<T extends Number> {
    private static final String[] HEADERS;
    public static final short INI_AC = 20;
    private static final float[] OPT_DAMPS;
    private final VecMath<T> mt;
    private T opt_damp;
    private T damp;
    private int accuracy;
    private int updateAc;
    private final int margin;
    private ArrayList<IProgressListener> listeners;
    private long updateTime;
    private boolean term;
    private long startTime;
    private List<Node> curNodes;
    private List<Node> newNodes;
    private int curAc;
    private boolean log;
    private int threads;

    public LightPatternSolver(float rOverGap, boolean log, VecMath<T> vm) {
        this.log = log;
        this.mt = vm;
        this.margin = 30;
        float p = 2.0f * rOverGap;
        float p0 = (float)((int)(p * 10.0f)) / 10.0f;
        float p1 = (float)((int)(p * 10.0f) + 1) / 10.0f;
        float d0 = OPT_DAMPS[(int)(p * 10.0f)];
        float d1 = OPT_DAMPS[Math.min((int)(p * 10.0f) + 1, 10)];
        float t = (p - p0) / (p1 - p0);
        this.setInitialDamp(this.mt.util.round(this.mt.util.cast(OPT_DAMPS[9]), 2));
        this.setOptimalDamp(this.mt.util.round(this.mt.util.cast(d0 + t * (d1 - d0)), 2));
        this.threads = Runtime.getRuntime().availableProcessors();
    }

    private void init(List<Circle<T>> circles, List<Float> m_init) {
        this.startTime = System.currentTimeMillis();
        this.correctGradients(circles, m_init);
        this.curNodes = Collections.synchronizedList(new ArrayList());
        this.newNodes = Collections.synchronizedList(new ArrayList());
        for (int k = 0; k < circles.size(); ++k) {
            this.newNodes.add(null);
        }
        this.updateAc = 0;
        this.curAc = 0;
        for (int i = 0; i < circles.size(); ++i) {
            Node n = new Node();
            n.m0 = this.mt.util.copy(this.mt.ZERO, 10);
            if (m_init != null) {
                n.m0 = this.mt.util.cast(m_init.get(i).floatValue());
            }
            n.m = n.m0;
            this.curNodes.add(n);
        }
    }

    public List<T[]> solve(T[] mBnd, boolean[] dirBnd, List<Circle<T>> circles, List<Float> m_init) {
        Node n;
        int i;
        this.init(circles, m_init);
        Number[] moveVecStart = null;
        Number[] moveVecEnd = null;
        for (i = 0; i < circles.size(); ++i) {
            Number[] ctr2;
            Number[] ctr1;
            n = this.curNodes.get(i);
            if (i == 0) {
                moveVecStart = this.calcMoveVector(circles.get(0), (Number)mBnd[0], !dirBnd[0]);
                ctr1 = (Number[])circles.get(0).getCenter().clone();
                this.mt.add(ctr1, moveVecStart, ctr1);
            } else {
                ctr1 = circles.get(i - 1).getCenter();
            }
            if (i == circles.size() - 1) {
                moveVecEnd = this.calcMoveVector(circles.get(i), (Number)mBnd[1], dirBnd[1]);
                ctr2 = (Number[])circles.get(i).getCenter().clone();
                this.mt.add(ctr2, moveVecEnd, ctr2);
            } else {
                ctr2 = circles.get(i + 1).getCenter();
            }
            this.updatePoint(n, circles.get(i), ctr1, ctr2);
        }
        for (i = 0; i < circles.size(); ++i) {
            n = this.curNodes.get(i);
            if (i == 0) {
                n.dy1 = mBnd[0];
                n.dx1 = this.mt.ONE;
            } else {
                Number[] pt1 = this.curNodes.get(i - 1).reflPnt;
                n.dy1 = this.mt.sub(n.reflPnt[1], pt1[1]);
                n.dx1 = this.mt.sub(n.reflPnt[0], pt1[0]);
            }
            if (i < circles.size() - 1) {
                Number[] pt2 = this.curNodes.get(i + 1).reflPnt;
                n.dy2 = this.mt.sub(n.reflPnt[1], pt2[1]);
                n.dx2 = this.mt.sub(n.reflPnt[0], pt2[0]);
                continue;
            }
            n.dy2 = mBnd[1];
            n.dx2 = this.mt.ONE;
        }
        ArrayList<SolveRbl> rbls = new ArrayList<SolveRbl>();
        for (int i2 = 0; i2 < Math.min(circles.size(), this.threads); ++i2) {
            rbls.add(new SolveGradGradRbl(this, circles, mBnd, moveVecStart, moveVecEnd));
        }
        return this.solve(rbls);
    }

    private List<T[]> solve(List<SolveRbl> rbls) {
        if (Globals.LOG_VERBOSE) {
            this.printReflectionNodes(this.curNodes, (byte)0);
        }
        Common com = new Common(this.curNodes.size() - 1);
        for (int i = 0; i < rbls.size(); ++i) {
            rbls.get((int)i).com = com;
            if (i <= 0) continue;
            new Thread(rbls.get(i)).start();
        }
        int steps = 0;
        while (this.curAc < this.accuracy && !this.term) {
            int k;
            for (k = 0; k < this.newNodes.size(); ++k) {
                this.newNodes.set(k, null);
            }
            com.reset();
            int i = com.nextPos();
            while (i != -1 && !this.term) {
                rbls.get(0).updateNode(i);
                i = com.nextPos();
            }
            for (k = 0; k < this.newNodes.size() && !this.term; ++k) {
                if (this.newNodes.get(k) != null) continue;
                k = -1;
            }
            for (k = 0; k < this.newNodes.size(); ++k) {
                this.curNodes.set(k, this.newNodes.get(k));
            }
            if (this.curAc > 20 && this.mt.cmp(this.damp, this.opt_damp) != 0) {
                this.damp = this.opt_damp;
            }
            this.handleProgressListeners(this.curAc);
            ++steps;
        }
        if (!this.term) {
            this.printInfo(steps, this.startTime, this.curNodes, (byte)0);
            return this.getReflPoints(this.curNodes);
        }
        com.reset();
        return null;
    }

    public List<T[]> solve(T[] start, T endM, boolean endDir, List<Circle<T>> circles, List<Float> m_init) {
        Node n;
        int i;
        this.init(circles, m_init);
        Number[] moveVec = null;
        for (i = 0; i < circles.size(); ++i) {
            Number[] ctr2;
            T[] ctr1;
            n = this.curNodes.get(i);
            Object[] objectArray = ctr1 = i == 0 ? start : circles.get(i - 1).getCenter();
            if (i == circles.size() - 1) {
                moveVec = this.calcMoveVector(circles.get(i), (Number)endM, endDir);
                ctr2 = (Number[])circles.get(i).getCenter().clone();
                this.mt.add(ctr2, moveVec, ctr2);
            } else {
                ctr2 = circles.get(i + 1).getCenter();
            }
            this.updatePoint(n, circles.get(i), (Number[])ctr1, ctr2);
        }
        for (i = 0; i < circles.size(); ++i) {
            n = this.curNodes.get(i);
            T[] pt1 = i == 0 ? start : this.curNodes.get(i - 1).reflPnt;
            n.dy1 = this.mt.sub(n.reflPnt[1], (Number)pt1[1]);
            n.dx1 = this.mt.sub(n.reflPnt[0], (Number)pt1[0]);
            if (i < circles.size() - 1) {
                Number[] pt2 = this.curNodes.get(i + 1).reflPnt;
                n.dy2 = this.mt.sub(n.reflPnt[1], pt2[1]);
                n.dx2 = this.mt.sub(n.reflPnt[0], pt2[0]);
                continue;
            }
            n.dy2 = endM;
            n.dx2 = this.mt.ONE;
        }
        ArrayList<SolveRbl> rbls = new ArrayList<SolveRbl>();
        for (int i2 = 0; i2 < Math.min(circles.size(), this.threads); ++i2) {
            rbls.add(new SolvePointGradRbl(this, circles, start, moveVec, endM));
        }
        return this.solve(rbls);
    }

    public List<T[]> solve(T stM, boolean stDir, T[] end, List<Circle<T>> circles, List<Float> m_init) {
        Node n;
        int i;
        this.init(circles, m_init);
        Number[] moveVec = null;
        for (i = 0; i < circles.size(); ++i) {
            Number[] ctr1;
            n = this.curNodes.get(i);
            if (i == 0) {
                moveVec = this.calcMoveVector(circles.get(0), (Number)stM, !stDir);
                ctr1 = (Number[])circles.get(0).getCenter().clone();
                this.mt.add(ctr1, moveVec, ctr1);
            } else {
                ctr1 = circles.get(i - 1).getCenter();
            }
            T[] ctr2 = i == circles.size() - 1 ? end : circles.get(i + 1).getCenter();
            this.updatePoint(n, circles.get(i), ctr1, (Number[])ctr2);
        }
        for (i = 0; i < circles.size(); ++i) {
            n = this.curNodes.get(i);
            if (i == 0) {
                n.dy1 = stM;
                n.dx1 = this.mt.ONE;
            } else {
                Number[] pt1 = this.curNodes.get(i - 1).reflPnt;
                n.dy1 = this.mt.sub(n.reflPnt[1], pt1[1]);
                n.dx1 = this.mt.sub(n.reflPnt[0], pt1[0]);
            }
            T[] pt2 = i == circles.size() - 1 ? end : this.curNodes.get(i + 1).reflPnt;
            n.dy2 = this.mt.sub(n.reflPnt[1], (Number)pt2[1]);
            n.dx2 = this.mt.sub(n.reflPnt[0], (Number)pt2[0]);
        }
        ArrayList<SolveRbl> rbls = new ArrayList<SolveRbl>();
        for (int i2 = 0; i2 < Math.min(circles.size(), this.threads); ++i2) {
            rbls.add(new SolveGradPointRbl(this, circles, end, moveVec, stM));
        }
        return this.solve(rbls);
    }

    public List<T[]> solve(T[] start, T[] end, List<Circle<T>> circles, List<Float> m_init) {
        Node n;
        int i;
        this.init(circles, m_init);
        for (i = 0; i < circles.size(); ++i) {
            n = this.curNodes.get(i);
            T[] ctr1 = i == 0 ? start : circles.get(i - 1).getCenter();
            T[] ctr2 = i == circles.size() - 1 ? end : circles.get(i + 1).getCenter();
            this.updatePoint(n, circles.get(i), (Number[])ctr1, (Number[])ctr2);
        }
        for (i = 0; i < circles.size(); ++i) {
            n = this.curNodes.get(i);
            T[] pt1 = i == 0 ? start : this.curNodes.get(i - 1).reflPnt;
            T[] pt2 = i == circles.size() - 1 ? end : this.curNodes.get(i + 1).reflPnt;
            n.dy1 = this.mt.sub(n.reflPnt[1], (Number)pt1[1]);
            n.dx1 = this.mt.sub(n.reflPnt[0], (Number)pt1[0]);
            n.dy2 = this.mt.sub(n.reflPnt[1], (Number)pt2[1]);
            n.dx2 = this.mt.sub(n.reflPnt[0], (Number)pt2[0]);
        }
        ArrayList<SolveRbl> rbls = new ArrayList<SolveRbl>();
        for (int i2 = 0; i2 < Math.min(circles.size(), this.threads); ++i2) {
            rbls.add(new SolvePointPointRbl(this, circles, start, end));
        }
        return this.solve(rbls);
    }

    public void setTerminated(boolean t) {
        this.term = t;
    }

    public boolean getTerminated() {
        return this.term;
    }

    private void correctGradients(List<Circle<T>> cls, List<Float> iniGrad) {
        for (int i = 1; i < cls.size(); ++i) {
            Float[] ctr1;
            Float[] ctr0 = this.mt.util.cast2FloatArray(cls.get(i - 1).getCenter());
            if (ctr0[0] != (ctr1 = this.mt.util.cast2FloatArray(cls.get(i - 1).getCenter()))[0] || Math.abs(ctr0[1].floatValue() - ctr1[1].floatValue()) != 1.0f || iniGrad.get(i - 1).floatValue() != -iniGrad.get(i).floatValue()) continue;
            iniGrad.set(i, Float.valueOf(iniGrad.get(i).floatValue() + 0.01f));
        }
    }

    private void handleProgressListeners(int ac) {
        if (this.listeners != null) {
            long t = System.currentTimeMillis();
            if (ac > 20 && this.updateAc != ac && (ac % 10 == 0 || ac == this.accuracy || t - this.updateTime >= 1000L)) {
                this.updateTime = t;
                this.updateAc = ac;
                for (IProgressListener pl : this.listeners) {
                    pl.updateAccuracy(Math.min(ac, this.accuracy), this.accuracy);
                }
            }
        }
    }

    private List<T[]> getReflPoints(List<Node> nodes) {
        ArrayList<T[]> reflPts = new ArrayList<T[]>();
        for (int i = 0; i < nodes.size(); ++i) {
            Number[] pt = nodes.get(i).reflPnt;
            int digits = Math.max(this.mt.util.getScale(pt[0]), 0) + this.accuracy;
            pt[0] = this.mt.util.copy(pt[0], digits);
            digits = Math.max(this.mt.util.getScale(pt[1]), 0) + this.accuracy;
            pt[1] = this.mt.util.copy(pt[1], digits);
            reflPts.add(pt);
        }
        return reflPts;
    }

    private T[] calcMoveVector(Circle<T> c, T m, boolean dir) {
        Number[] retVal = this.mt.util.array(2);
        Object r10 = this.mt.mul(this.mt.TEN, c.getRadius());
        retVal[0] = r10;
        retVal[1] = this.mt.mul(r10, m);
        if (!dir) {
            this.mt.neg(retVal);
        }
        return retVal;
    }

    private void calcNewNode(Node nw, Node cur, Circle<T> c, int ac, T[] p1, T[] p2) {
        nw.reflPntDir = cur.reflPntDir;
        this.updateGradient(nw, cur);
        Profiler.getInstance().startTimeMeas("New Node");
        nw.m = this.dampGradientChange(nw.m, cur.m);
        Number er = this.mt.abs(this.mt.sub(nw.m, cur.m));
        if (this.mt.cmp(er, (Number)this.mt.ZERO) == 0) {
            nw.ac = cur.ac;
        } else {
            nw.ac = -this.mt.util.getScale(er) - 1;
        }
        int errDigitPos = -this.mt.util.getErrorScale(nw.m);
        if (errDigitPos < ac + this.margin) {
            nw.m = this.mt.util.copy(nw.m, this.mt.util.precision(nw.m) + ac - errDigitPos + this.margin);
        }
        Profiler.getInstance().endTimeMeas("New Node");
        this.updatePoint(nw, c, (Number[])p1, (Number[])p2);
    }

    private T dampGradientChange(T m_new, T m_old) {
        T retVal = m_new;
        T er = this.mt.abs(this.mt.sub(m_new, m_old));
        if (this.mt.cmp(er, this.mt.ZERO) != 0) {
            boolean signChanged;
            int errPos = -this.mt.util.getScale(er);
            int firstPos = Math.max(-this.mt.util.getScale(m_new), -this.mt.util.getScale(m_old));
            boolean bl = signChanged = this.mt.sign(m_new) != this.mt.sign(m_old);
            if (errPos - firstPos < 3 || signChanged) {
                T s1 = this.mt.sqrt(this.mt.add(this.mt.mul(m_old, m_old), this.mt.ONE), this.accuracy + this.margin);
                T s2 = this.mt.sqrt(this.mt.add(this.mt.mul(m_new, m_new), this.mt.ONE), this.accuracy + this.margin);
                if (this.mt.cmp(this.mt.mul(m_new, m_old), this.mt.MINUS_ONE) < 0) {
                    T dx1 = this.mt.inv(s1);
                    if (this.mt.sign(m_old) < 0) {
                        dx1 = this.mt.neg(dx1);
                    }
                    T dx2 = this.mt.inv(s2);
                    if (this.mt.sign(m_new) < 0) {
                        dx2 = this.mt.neg(dx2);
                    }
                    T dx = this.mt.add(dx1, this.mt.mul(this.mt.sub(dx2, dx1), this.damp));
                    retVal = this.mt.sqrt(this.mt.sub(this.mt.inv(this.mt.mul(dx, dx)), this.mt.ONE));
                    if (this.mt.sign(dx) < 0) {
                        retVal = this.mt.neg(retVal);
                    }
                } else {
                    Object tmp;
                    T dy1 = this.mt.div(m_old, s1);
                    T dy2 = this.mt.div(m_new, s2);
                    T dy = this.mt.add(dy1, this.mt.mul(this.mt.sub(dy2, dy1), this.damp));
                    T dyy = this.mt.mul(dy, dy);
                    retVal = m_old;
                    if (this.mt.cmp(dyy, this.mt.ONE) < 1 && this.mt.cmp(tmp = this.mt.sqrt(this.mt.sub(this.mt.ONE, dyy)), this.mt.ZERO) != 0) {
                        retVal = this.mt.div(dy, tmp);
                    }
                }
                if (Globals.LOG_VERBOSE && signChanged) {
                    Log.getIstc().logln("Sign changed: errPos= " + errPos + " retVal=" + retVal);
                }
            } else {
                retVal = this.mt.add(m_old, this.mt.mul(this.mt.sub(m_new, m_old), this.damp));
            }
        }
        return retVal;
    }

    private void updateGradient(Node nw, Node cur) {
        if (cur.ac <= 20) {
            nw.m = this.gradientExact(nw.dx1, nw.dy1, nw.dx2, nw.dy2, cur.m);
        } else {
            this.gradientApprox(nw, cur);
        }
    }

    private T gradientExact(T dx1, T dy1, T dx2, T dy2, T m_old) {
        T tmp1 = this.mt.add(this.mt.mul(dy1, dx2), this.mt.mul(dy2, dx1));
        T tmp2 = this.mt.sub(this.mt.mul(dy1, dy2), this.mt.mul(dx1, dx2));
        Object tmp3 = this.mt.ZERO;
        Object tmp4 = this.mt.ZERO;
        if (this.mt.cmp(tmp1, this.mt.ZERO) != 0) {
            tmp1 = this.mt.div(tmp2, tmp1);
            tmp2 = this.mt.sqrt(this.mt.add(this.mt.mul(tmp1, tmp1), this.mt.ONE), this.accuracy + this.margin);
            tmp3 = this.mt.add(tmp1, tmp2);
            tmp4 = this.mt.sub(tmp1, tmp2);
        }
        double phiOld = Math.atan(((Number)m_old).doubleValue());
        double phi1 = Math.atan(((Number)tmp3).doubleValue());
        double phi2 = Math.atan(((Number)tmp4).doubleValue());
        T retVal = null;
        retVal = LightPatternSolver.linesAngleDelta(phi1, phiOld) < LightPatternSolver.linesAngleDelta(phi2, phiOld) ? (T)tmp3 : (T)tmp4;
        return retVal;
    }

    private void gradientApprox(Node nw, Node cur) {
        if (nw.step1 == -1 || ++nw.step1 == 15) {
            boolean calcRef;
            Profiler.getInstance().startTimeMeas("Newton Gradient Update");
            Number a = this.mt.sub(this.mt.mul(nw.dy1, nw.dy2), this.mt.mul(nw.dx1, nw.dx2));
            Number b = this.mt.add(this.mt.mul(nw.dy1, nw.dx2), this.mt.mul(nw.dy2, nw.dx1));
            GradientApproximator gradApprox = new GradientApproximator();
            gradApprox.a = a;
            gradApprox.b = b;
            try {
                nw.m = this.mt.approximateRoot(gradApprox.f, gradApprox.dfOverdx, cur.m);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = calcRef = nw.step1 != -1;
            if (!calcRef) {
                boolean bl2 = calcRef = cur.ac + this.mt.util.getScale(a) >= 10 && cur.ac + this.mt.util.getScale(b) >= 10;
            }
            if (calcRef) {
                nw.refAc1 = cur.ac;
                nw.refM1 = nw.m;
                nw.refDx1 = nw.dx1;
                nw.refDy1 = nw.dy1;
                nw.refDx2 = nw.dx2;
                nw.refDy2 = nw.dy2;
                Number oneOverM = this.mt.inv(nw.m);
                nw.k1 = this.mt.div((Number)this.mt.TWO, this.mt.mul(b, this.mt.add((Number)this.mt.ONE, this.mt.mul(oneOverM, oneOverM))));
                nw.k2 = this.mt.mul((Number)this.mt.ONE_OVER_TWO, this.mt.sub(nw.m, oneOverM));
                nw.step1 = 0;
            }
            Profiler.getInstance().endTimeMeas("Newton Gradient Update");
        } else {
            Profiler.getInstance().startTimeMeas("Linear Gradient Update");
            Number ddx1 = this.mt.sub(nw.dx1, nw.refDx1);
            Number ddy1 = this.mt.sub(nw.dy1, nw.refDy1);
            Number ddx2 = this.mt.sub(nw.dx2, nw.refDx2);
            Number ddy2 = this.mt.sub(nw.dy2, nw.refDy2);
            Number da1 = this.mt.add(this.mt.mul(ddx1, nw.refDx2), this.mt.mul(ddx2, nw.refDx1));
            Number da = this.mt.sub(this.mt.add(this.mt.mul(ddy1, nw.refDy2), this.mt.mul(ddy2, nw.refDy1)), da1);
            Number db1 = this.mt.add(this.mt.mul(ddx1, nw.refDy2), this.mt.mul(ddy2, nw.refDx1));
            Number db = this.mt.add(this.mt.add(this.mt.mul(ddy1, nw.refDx2), this.mt.mul(ddx2, nw.refDy1)), db1);
            Number dm = this.mt.mul(nw.k1, this.mt.sub(da, this.mt.mul(nw.k2, db)));
            nw.m = this.mt.add(nw.refM1, dm);
            Profiler.getInstance().endTimeMeas("Linear Gradient Update");
        }
    }

    public void setLog(boolean l) {
        this.log = l;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int ac) {
        this.accuracy = ac;
    }

    public int getNodeAccuracy(int pos) {
        return this.curNodes.get(pos).ac;
    }

    public void setOptimalDamp(T od) {
        this.opt_damp = this.mt.util.copy(od, this.margin);
    }

    public T getOptimalDamp() {
        return this.opt_damp;
    }

    public void setInitialDamp(T d) {
        this.damp = this.mt.util.copy(d, this.margin);
    }

    public void addProgressListener(IProgressListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (l != null) {
            this.listeners.add(l);
        }
    }

    private void updatePoint(Node rn, Circle<T> c, T[] p1, T[] p2) {
        Number relY;
        Number relX;
        boolean b;
        int digits = rn.ac + this.mt.util.getScale(rn.m);
        boolean bl = b = digits > 10;
        if (!b || rn.step2 == -1 || ++rn.step2 == 20) {
            Number tmp1;
            Number tmp2;
            Number m;
            Profiler.getInstance().startTimeMeas("Point Update");
            int p = this.mt.util.precision(rn.m);
            Number number = m = p <= 0x7FFFFFFA && b ? (Number)this.mt.util.copy(rn.m, p + 5) : (Number)rn.m;
            if (rn.sqrtOneOverM2PlusOne != null) {
                Number tmp = this.mt.util.copy(rn.sqrtOneOverM2PlusOne, this.mt.util.precision(m));
                tmp2 = this.mt.add(tmp, this.mt.inv(this.mt.mul(tmp, this.mt.add(this.mt.mul(m, m), (Number)this.mt.ONE))));
                tmp2 = this.mt.mul((Number)this.mt.ONE_OVER_TWO, tmp2);
                tmp1 = this.mt.mul(tmp2, tmp2);
            } else {
                tmp1 = this.mt.inv(this.mt.add(this.mt.mul(m, m), (Number)this.mt.ONE));
                tmp2 = this.mt.sqrt(tmp1, this.accuracy + this.margin);
            }
            relX = this.mt.mul((Number)c.getRadius(), tmp2);
            relY = this.mt.mul(m, relX);
            if (b) {
                rn.step2 = 0;
                rn.refAc2 = rn.ac;
                rn.refRelX = relX;
                rn.refRelY = relY;
                rn.refRelXOverM2PlusOne = this.mt.mul(rn.refRelX, tmp1);
                rn.refRelYOverM2PlusOne = this.mt.mul(rn.refRelY, tmp1);
                rn.refM2 = m;
                if (digits > 100) {
                    rn.sqrtOneOverM2PlusOne = tmp2;
                }
            } else {
                rn.step2 = -1;
            }
            Profiler.getInstance().endTimeMeas("Point Update");
        } else {
            Profiler.getInstance().startTimeMeas("Linear Point Update");
            Number dm = this.mt.sub(rn.m, rn.refM2);
            relX = this.mt.sub(rn.refRelX, this.mt.mul(rn.refRelYOverM2PlusOne, dm));
            relY = this.mt.add(rn.refRelY, this.mt.mul(rn.refRelXOverM2PlusOne, dm));
            Profiler.getInstance().endTimeMeas("Linear Point Update");
        }
        Node.access$402(rn, this.calcReflPoint(c.getCenter(), (Number[])p1, (Number[])p2, relX, relY));
    }

    private T[] calcReflPoint(T[] ctr, T[] p1, T[] p2, T dx, T dy) {
        Profiler.getInstance().startTimeMeas("Calc Point");
        float ctrXf = ((Number)ctr[0]).floatValue();
        float ctrYf = ((Number)ctr[1]).floatValue();
        float dxf = ((Number)dx).floatValue();
        float dyf = ((Number)dy).floatValue();
        float pt1Xf = ctrXf + dxf;
        float pt1Yf = ctrYf + dyf;
        float pt2Xf = ctrXf - dxf;
        float pt2Yf = ctrYf - dyf;
        float p1x = ((Number)p1[0]).floatValue();
        float p1y = ((Number)p1[1]).floatValue();
        float p2x = ((Number)p2[0]).floatValue();
        float p2y = ((Number)p2[1]).floatValue();
        float d1 = LightPatternSolver.distSqrd(pt1Xf, pt1Yf, p1x, p1y, p2x, p2y);
        float d2 = LightPatternSolver.distSqrd(pt2Xf, pt2Yf, p1x, p1y, p2x, p2y);
        Number[] retVal = this.mt.util.array(2);
        if (d2 >= d1) {
            retVal[0] = this.mt.add(ctr[0], dx);
            retVal[1] = this.mt.add(ctr[1], dy);
        } else {
            retVal[0] = this.mt.sub(ctr[0], dx);
            retVal[1] = this.mt.sub(ctr[1], dy);
        }
        Profiler.getInstance().endTimeMeas("Calc Point");
        return retVal;
    }

    private static float distSqrd(float px, float py, float p1x, float p1y, float p2x, float p2y) {
        float dx1 = px - p1x;
        float dy1 = py - p1y;
        float dx2 = px - p2x;
        float dy2 = py - p2y;
        return dx1 * dx1 + dy1 * dy1 + dx2 * dx2 + dy2 * dy2;
    }

    private static double linesAngleDelta(double a1, double a2) {
        double delta;
        if (a1 >= 0.0 == a2 >= 0.0) {
            delta = a2 > a1 ? a2 - a1 : a1 - a2;
        } else {
            double sum = (a1 >= 0.0 ? a1 : -a1) + (a2 >= 0.0 ? a2 : -a2);
            double complSum = Math.PI * 2 - sum;
            delta = sum > complSum ? complSum : sum;
        }
        double complDelta = Math.PI - delta;
        return delta > complDelta ? complDelta : delta;
    }

    private void printInfo(int steps, long t0, List<Node> nodes, byte offset) {
        if (this.log) {
            this.printReflectionNodes(nodes, offset);
            int t = (int)((float)(System.currentTimeMillis() - t0) / 1000.0f);
            Log.getIstc().log(", Time = " + t + " sec");
            if (nodes.size() > 0) {
                float speed = (float)((int)((float)this.accuracy * 100.0f / (float)steps + 0.5f)) / 100.0f;
                Log.getIstc().log(", Steps = " + steps);
                Log.getIstc().log("\nDigits/Steps = " + speed);
                Log.getIstc().log(", Damp = " + this.damp);
                Log.getIstc().log(", Margin = " + this.margin + " digits");
            }
            Log.getIstc().log("\n");
        }
    }

    private void printReflectionNodes(List<Node> nodes, byte offset) {
        if (this.log && nodes.size() > 0) {
            Log.getIstc().logln("**********************************************************");
            for (String h : HEADERS) {
                Log.getIstc().log(h);
            }
            Log.getIstc().log("\n");
            float dphiMax = Float.MIN_VALUE;
            for (int i = 0; i < nodes.size(); ++i) {
                Node rn = nodes.get(i);
                Log.getIstc().logf(i + 1 + offset + "", HEADERS[0].length());
                String delta = "";
                if (this.mt.cmp(rn.m0, rn.m) != 0) {
                    Log.getIstc().logf("1e-" + rn.ac + "", HEADERS[1].length());
                    float phi = (float)Math.atan(rn.m.floatValue());
                    float phi0 = (float)Math.atan(rn.m0.floatValue());
                    float dphi = (float)(LightPatternSolver.linesAngleDelta(phi, phi0) * 180.0 / Math.PI);
                    dphi = (float)((int)((double)(dphi * 10.0f) + 0.5)) / 10.0f;
                    delta = dphi + "\u00b0";
                    dphiMax = dphiMax < dphi ? dphi : dphiMax;
                } else {
                    Log.getIstc().logf("", HEADERS[1].length());
                }
                String m = this.mt.util.toPlainString(rn.m);
                m = m.substring(0, Math.min(32, m.length()));
                Log.getIstc().logf(m, HEADERS[2].length());
                Log.getIstc().logf(delta, HEADERS[3].length());
                if (Globals.LOG_VERBOSE) {
                    if (this.mt.cmp(rn.dx1, (Number)this.mt.ZERO) == 0) {
                        Log.getIstc().logf("infinity", HEADERS[2].length());
                    } else {
                        Number m1 = this.mt.util.copy(this.mt.div(rn.dy1, rn.dx1), 20);
                        Log.getIstc().logf("" + m1, HEADERS[2].length());
                    }
                    if (this.mt.cmp(rn.dx2, (Number)this.mt.ZERO) == 0) {
                        Log.getIstc().logf("infinity", HEADERS[2].length());
                    } else {
                        Number m2 = this.mt.util.copy(this.mt.div(rn.dy2, rn.dx2), 20);
                        Log.getIstc().logf("" + m2, HEADERS[2].length());
                    }
                    Log.getIstc().logf("" + this.mt.util.copy(rn.reflPnt[0], 10), 17);
                    Log.getIstc().logf("" + this.mt.util.copy(rn.reflPnt[1], 10), 17);
                }
                Log.getIstc().log("\n");
            }
            Log.getIstc().logln("**********************************************************");
            if (dphiMax != Float.MIN_VALUE) {
                Log.getIstc().log("Max. Delta = " + dphiMax + "\u00b0");
            }
        }
    }

    static {
        OPT_DAMPS = new float[11];
        LightPatternSolver.OPT_DAMPS[0] = 0.9f;
        LightPatternSolver.OPT_DAMPS[1] = 0.9f;
        LightPatternSolver.OPT_DAMPS[2] = 0.9f;
        LightPatternSolver.OPT_DAMPS[3] = 0.86f;
        LightPatternSolver.OPT_DAMPS[4] = 0.8f;
        LightPatternSolver.OPT_DAMPS[5] = 0.73f;
        LightPatternSolver.OPT_DAMPS[6] = 0.65f;
        LightPatternSolver.OPT_DAMPS[7] = 0.56f;
        LightPatternSolver.OPT_DAMPS[8] = 0.46f;
        LightPatternSolver.OPT_DAMPS[9] = 0.35f;
        LightPatternSolver.OPT_DAMPS[10] = 0.23f;
        HEADERS = new String[4];
        LightPatternSolver.HEADERS[0] = "Circle  ";
        LightPatternSolver.HEADERS[1] = "Accuracy  ";
        LightPatternSolver.HEADERS[2] = "Gradient (Truncated)               ";
        LightPatternSolver.HEADERS[3] = "Delta ";
    }

    private final class Node {
        private T[] reflPnt;
        private T m0;
        private T m;
        private T dy1;
        private T dx1;
        private T dy2;
        private T dx2;
        private int ac = 0;
        private boolean reflPntDir;
        private int step1 = -1;
        private int refAc1;
        private T refM1;
        private T refDy1;
        private T refDx1;
        private T refDy2;
        private T refDx2;
        private T k1;
        private T k2;
        private int step2 = -1;
        private int refAc2;
        private T refM2;
        private T refRelX;
        private T refRelY;
        private T refRelXOverM2PlusOne;
        private T refRelYOverM2PlusOne;
        private T sqrtOneOverM2PlusOne;

        Node(Node rn) {
            this.m0 = rn.m0;
            this.refAc1 = rn.refAc1;
            this.step1 = rn.step1;
            this.refM1 = rn.refM1;
            this.refDy1 = rn.refDy1;
            this.refDx1 = rn.refDx1;
            this.refDy2 = rn.refDy2;
            this.refDx2 = rn.refDx2;
            this.k1 = rn.k1;
            this.k2 = rn.k2;
            this.step2 = rn.step2;
            this.refAc2 = rn.refAc2;
            this.refM2 = rn.refM2;
            this.refRelX = rn.refRelX;
            this.refRelY = rn.refRelY;
            this.refRelXOverM2PlusOne = rn.refRelXOverM2PlusOne;
            this.refRelYOverM2PlusOne = rn.refRelYOverM2PlusOne;
            this.sqrtOneOverM2PlusOne = rn.sqrtOneOverM2PlusOne;
        }

        Node() {
        }

        static /* synthetic */ Number[] access$402(Node x0, Number[] x1) {
            x0.reflPnt = x1;
            return x1;
        }
    }

    private final class GradientApproximator {
        private T a;
        private T b;
        private T tmp2;
        private T tmp3;
        private final IFunction<T> f;
        private final IFunction<T> dfOverdx;

        private GradientApproximator() {
            this.f = new IFunction<T>(){

                @Override
                public T f(T x) {
                    GradientApproximator.this.tmp2 = LightPatternSolver.this.mt.mul(((LightPatternSolver)LightPatternSolver.this).mt.TWO, GradientApproximator.this.a);
                    GradientApproximator.this.tmp3 = LightPatternSolver.this.mt.mul(GradientApproximator.this.b, x);
                    return LightPatternSolver.this.mt.sub(LightPatternSolver.this.mt.mul(GradientApproximator.this.tmp3, x), LightPatternSolver.this.mt.add(GradientApproximator.this.b, LightPatternSolver.this.mt.mul(GradientApproximator.this.tmp2, x)));
                }
            };
            this.dfOverdx = new IFunction<T>(){

                @Override
                public T f(T x) {
                    return LightPatternSolver.this.mt.sub(LightPatternSolver.this.mt.mul(GradientApproximator.this.tmp3, ((LightPatternSolver)LightPatternSolver.this).mt.TWO), GradientApproximator.this.tmp2);
                }
            };
        }
    }

    public static interface IProgressListener {
        public void updateAccuracy(int var1, int var2);
    }

    private static final class SolvePointPointRbl
    extends SolveRbl {
        private T[] start;
        private T[] end;
        final /* synthetic */ LightPatternSolver this$0;

        SolvePointPointRbl(List<Circle<T>> cls, T[] s, T[] e) {
            this.this$0 = var1_1;
            this.circles = cls;
            this.start = s;
            this.end = e;
        }

        @Override
        void prepareUpdateNode(int i, Node newNode, Node curNode) {
            if (i == 0) {
                newNode.dy1 = this.this$0.mt.sub(this.pt[1], this.start[1]);
                newNode.dx1 = this.this$0.mt.sub(this.pt[0], this.start[0]);
                this.pt1 = this.start;
            } else {
                this.pt1 = ((Node)this.this$0.curNodes.get(i - 1)).reflPnt;
                this.updateNodeGradient1(i, newNode);
            }
            this.pt2 = i == this.circles.size() - 1 ? this.end : ((Node)this.this$0.curNodes.get(i + 1)).reflPnt;
            newNode.dy2 = this.this$0.mt.sub(this.pt[1], this.pt2[1]);
            newNode.dx2 = this.this$0.mt.sub(this.pt[0], this.pt2[0]);
        }
    }

    private static final class SolveGradPointRbl
    extends SolveRbl {
        private T[] end;
        private T[] moveVec;
        private T stM;
        final /* synthetic */ LightPatternSolver this$0;

        SolveGradPointRbl(List<Circle<T>> cls, T[] e, T[] v, T sm) {
            this.this$0 = var1_1;
            this.circles = cls;
            this.moveVec = v;
            this.end = e;
            this.stM = sm;
        }

        @Override
        void prepareUpdateNode(int i, Node newNode, Node curNode) {
            if (i == 0) {
                newNode.dy1 = this.stM;
                newNode.dx1 = ((LightPatternSolver)this.this$0).mt.ONE;
                this.pt1 = (Number[])((Node)this.this$0.curNodes.get(0)).reflPnt.clone();
                this.this$0.mt.add(this.pt1, (Number[])this.moveVec, this.pt1);
            } else {
                this.pt1 = ((Node)this.this$0.curNodes.get(i - 1)).reflPnt;
                this.updateNodeGradient1(i, newNode);
            }
            this.pt2 = i == this.circles.size() - 1 ? this.end : ((Node)this.this$0.curNodes.get(i + 1)).reflPnt;
            newNode.dy2 = this.this$0.mt.sub(this.pt[1], this.pt2[1]);
            newNode.dx2 = this.this$0.mt.sub(this.pt[0], this.pt2[0]);
        }
    }

    private static final class SolvePointGradRbl
    extends SolveRbl {
        private T[] start;
        private T[] moveVec;
        private T endM;
        final /* synthetic */ LightPatternSolver this$0;

        SolvePointGradRbl(List<Circle<T>> cls, T[] s, T[] v, T em) {
            this.this$0 = var1_1;
            this.circles = cls;
            this.moveVec = v;
            this.start = s;
            this.endM = em;
        }

        @Override
        void prepareUpdateNode(int i, Node newNode, Node curNode) {
            if (i == 0) {
                newNode.dy1 = this.this$0.mt.sub(this.pt[1], this.start[1]);
                newNode.dx1 = this.this$0.mt.sub(this.pt[0], this.start[0]);
                this.pt1 = this.start;
            } else {
                this.pt1 = ((Node)this.this$0.curNodes.get(i - 1)).reflPnt;
                this.updateNodeGradient1(i, newNode);
            }
            if (i < this.circles.size() - 1) {
                this.pt2 = ((Node)this.this$0.curNodes.get(i + 1)).reflPnt;
                newNode.dy2 = this.this$0.mt.sub(this.pt[1], this.pt2[1]);
                newNode.dx2 = this.this$0.mt.sub(this.pt[0], this.pt2[0]);
            } else {
                newNode.dy2 = this.endM;
                newNode.dx2 = ((LightPatternSolver)this.this$0).mt.ONE;
                this.pt2 = (Number[])((Node)this.this$0.curNodes.get(i)).reflPnt.clone();
                this.this$0.mt.add(this.pt2, (Number[])this.moveVec, this.pt2);
            }
        }
    }

    private static final class SolveGradGradRbl
    extends SolveRbl {
        private T[] moveVecStart;
        private T[] moveVecEnd;
        private T[] mBnd;
        final /* synthetic */ LightPatternSolver this$0;

        SolveGradGradRbl(List<Circle<T>> cls, T[] mbd, T[] v1, T[] v2) {
            this.this$0 = var1_1;
            this.circles = cls;
            this.mBnd = mbd;
            this.moveVecStart = v1;
            this.moveVecEnd = v2;
        }

        @Override
        void prepareUpdateNode(int i, Node newNode, Node curNode) {
            if (i == 0) {
                newNode.dy1 = this.mBnd[0];
                newNode.dx1 = ((LightPatternSolver)this.this$0).mt.ONE;
                this.pt1 = (Number[])((Node)this.this$0.curNodes.get(0)).reflPnt.clone();
                this.this$0.mt.add(this.pt1, (Number[])this.moveVecStart, this.pt1);
            } else {
                this.pt1 = ((Node)this.this$0.curNodes.get(i - 1)).reflPnt;
                this.updateNodeGradient1(i, newNode);
            }
            if (i < this.circles.size() - 1) {
                this.pt2 = ((Node)this.this$0.curNodes.get(i + 1)).reflPnt;
                newNode.dy2 = this.this$0.mt.sub(this.pt[1], this.pt2[1]);
                newNode.dx2 = this.this$0.mt.sub(this.pt[0], this.pt2[0]);
            } else {
                newNode.dy2 = this.mBnd[1];
                newNode.dx2 = ((LightPatternSolver)this.this$0).mt.ONE;
                this.pt2 = (Number[])((Node)this.this$0.curNodes.get(i)).reflPnt.clone();
                this.this$0.mt.add(this.pt2, (Number[])this.moveVecEnd, this.pt2);
            }
        }
    }

    private abstract class SolveRbl
    implements Runnable {
        List<Circle<T>> circles;
        Common com;
        T[] pt;
        T[] pt1;
        T[] pt2;

        private SolveRbl() {
        }

        @Override
        public void run() {
            while (!LightPatternSolver.this.term) {
                this.updateNode(this.com.nextPosOrWait());
            }
        }

        final void updateNodeGradient1(int i, Node newNode) {
            if (LightPatternSolver.this.threads == 1) {
                newNode.dy1 = ((Node)LightPatternSolver.this.newNodes.get(i - 1)).dy2;
                newNode.dx1 = ((Node)LightPatternSolver.this.newNodes.get(i - 1)).dx2;
            } else {
                newNode.dy1 = LightPatternSolver.this.mt.sub(this.pt1[1], this.pt[1]);
                newNode.dx1 = LightPatternSolver.this.mt.sub(this.pt1[0], this.pt[0]);
            }
        }

        final void updateNode(int i) {
            Node curNode = (Node)LightPatternSolver.this.curNodes.get(i);
            Node newNode = new Node(curNode);
            this.pt = curNode.reflPnt;
            this.prepareUpdateNode(i, newNode, curNode);
            LightPatternSolver.this.calcNewNode(newNode, curNode, this.circles.get(i), LightPatternSolver.this.curAc, this.pt1, this.pt2);
            LightPatternSolver.this.curAc = Math.max(LightPatternSolver.this.curAc, newNode.ac);
            this.releaseMemory(i);
            LightPatternSolver.this.newNodes.set(i, newNode);
        }

        abstract void prepareUpdateNode(int var1, Node var2, Node var3);

        final void releaseMemory(int i) {
            if (--i > 0 && LightPatternSolver.this.newNodes.get(i) != null) {
                while (i > 0 && LightPatternSolver.this.newNodes.get(i - 1) != null) {
                    LightPatternSolver.this.curNodes.set(i--, null);
                }
            }
        }
    }

    private class Common {
        final int maxPos;
        int pos = 0;
        boolean active = false;

        Common(int mp) {
            this.maxPos = mp;
        }

        synchronized int nextPosOrWait() {
            while (!this.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.pos > this.maxPos) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.nextPosOrWait();
            }
            return ++this.pos - 1;
        }

        synchronized int nextPos() {
            return this.pos > this.maxPos ? -1 : ++this.pos - 1;
        }

        synchronized void reset() {
            this.pos = 0;
            this.active = true;
            this.notifyAll();
        }
    }
}

