/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pattern.ILightPatternSequence;

public class LightPatternSequence
implements ILightPatternSequence {
    protected List<short[]> cells;
    protected List<Float> m_init;

    LightPatternSequence() {
    }

    LightPatternSequence(LightPatternSequence lps) {
        this.cells = new ArrayList<short[]>();
        for (short[] cell : lps.getCellSequence()) {
            this.cells.add((short[])cell.clone());
        }
        this.m_init = new ArrayList<Float>();
        Iterator<Object> i$ = lps.getInitialGradients().iterator();
        while (i$.hasNext()) {
            float x = ((Float)i$.next()).floatValue();
            this.m_init.add(Float.valueOf(x));
        }
    }

    public boolean equals(Object o) {
        LightPatternSequence s = (LightPatternSequence)o;
        boolean b = true;
        b &= this.cells != null == (s.cells != null);
        b &= this.m_init != null == (s.m_init != null);
        if (this.cells != null && this.m_init != null) {
            b &= this.cells.size() == s.cells.size();
            if (b &= this.m_init.size() == s.m_init.size()) {
                int i;
                for (i = 0; i < this.cells.size(); ++i) {
                    b &= this.cells.get(i)[0] == s.cells.get(i)[0];
                    b &= this.cells.get(i)[1] == s.cells.get(i)[1];
                }
                for (i = 0; i < this.m_init.size(); ++i) {
                    b &= this.m_init.get(i).floatValue() == s.m_init.get(i).floatValue();
                }
            }
        }
        return b;
    }

    @Override
    public void setCellSequence(List<short[]> cells) {
        this.cells = cells;
    }

    @Override
    public void setInitialGradients(List<Float> mInit) {
        this.m_init = mInit;
    }

    @Override
    public List<short[]> getCellSequence() {
        return this.cells;
    }

    @Override
    public List<Float> getInitialGradients() {
        return this.m_init;
    }
}

