/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import common.Globals;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import math.VecMath;
import pattern.BaseLightPattern;
import pattern.LightChar;

public class LightCharPattern<T extends Number>
extends BaseLightPattern<T> {
    public static final byte MAX_RADIUS = 70;
    private static final byte ORI_HB = 0;
    private static final byte ORI_HT = 1;
    private static final byte ORI_DP = 2;
    private static final byte ORI_DN = 3;
    private static final byte ORI_VP = 4;
    private static final byte ORI_VN = 5;
    private LightChar[] lightChars;
    private String text;

    public LightCharPattern(String name, String txt, LightChar[] lcs, VecMath<T> mt) throws Exception {
        super(mt);
        this.lightChars = lcs;
        this.text = txt;
        this.setName(name);
        this.setText(txt);
        short maxPrec = Globals.PRECISIONS[Globals.PRECISIONS.length - 1];
        Object maxR = mt.util.cast(70);
        this.setMaxShapeSize(mt.util.copy(maxR, maxPrec));
        this.setStartBndValType((byte)2);
        this.setStartIndex(0);
        this.setPropagating(true);
    }

    public LightCharPattern(String name, String txt, boolean store, LightChar[] lcs, VecMath<T> mt) throws Exception {
        this(name, txt, lcs, mt);
        this.setStoreCalculation(store);
    }

    public LightCharPattern(LightCharPattern<T> p) {
        super(p);
        this.lightChars = p.lightChars;
        this.text = p.text;
    }

    @Override
    protected int[] calcDigitLossLowHigh() {
        float[] lossLowHigh = this.calcSequenceDigitLossLowHigh();
        return new int[]{(int)lossLowHigh[0], (int)((double)lossLowHigh[1] + 0.5)};
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) throws Exception {
        this.text = text;
        if (text != null) {
            String rText = LightCharPattern.reduce(text);
            this.gridSize = LightCharPattern.calcGridSize(rText);
            this.buildPattern(rText);
            this.setEndBndValType(this.gridSize % 2 == 1 ? (byte)1 : 2);
        }
    }

    @Override
    public void setParameters(T[] gridCorner, T gap, T r) {
        super.setParameters(gridCorner, gap, r);
        T t = this.mt.div(r, gap);
        T m = this.mt.div(t, this.mt.sqrt(this.mt.sub(this.mt.ONE, this.mt.mul(this.mt.TWO, t))));
        this.setStartBndVal(m);
        this.setEndBndVal(this.gridSize % 2 == 1 ? this.mt.neg(m) : m);
    }

    private void buildPattern(String txt) throws Exception {
        String charList = this.listUnknownChars(txt);
        if (charList == null) {
            this.m_init = new ArrayList();
            this.cells = new ArrayList();
            txt = LightCharPattern.prepare(txt, this.gridSize);
            int charCtr = 0;
            boolean flow = false;
            for (int row = this.gridSize - 2; row >= 0; --row) {
                int col;
                int n = col = flow ? 0 : this.gridSize - 2;
                while (col >= 0 && col < this.gridSize - 1) {
                    LightChar lc;
                    if (col == this.gridSize - 2) {
                        lc = this.getLightChar("eol").copy();
                        lc.move((short)col, (short)row);
                        this.append(lc, flow ? DIR.RIGHT : DIR.DOWN);
                    } else if (col == 0) {
                        lc = this.getLightChar("bol").copy();
                        lc.move((short)col, (short)row);
                        this.append(lc, flow ? DIR.DOWN : DIR.LEFT);
                    } else {
                        lc = this.getLightChar(txt.charAt(charCtr++) + "").copy();
                        lc.move((short)col, (short)row);
                        this.append(lc, flow ? DIR.RIGHT : DIR.LEFT);
                    }
                    col += flow ? 1 : -1;
                }
                flow = !flow;
            }
        } else {
            String chars = "";
            for (LightChar lc : this.lightChars) {
                if (lc.getChar().compareTo("eol") == 0 || lc.getChar().compareTo("bol") == 0) continue;
                chars = chars + lc.getChar();
            }
            throw new Exception("Found unsupported characters: " + charList + "\nAvailable: " + chars);
        }
        this.m_init.set(0, Float.valueOf(0.0f));
        this.m_init.set(this.m_init.size() - 1, Float.valueOf(0.0f));
    }

    private void append(LightChar s, DIR dir) {
        if (this.cells.size() > 0) {
            if (dir == DIR.DOWN) {
                this.mergeByRemove(s.m_init, 0.0f);
            } else {
                int sign;
                boolean reverse = dir == DIR.LEFT;
                byte o1 = LightCharPattern.orientation(this.cells, true);
                int n = sign = reverse ? -1 : 1;
                if (reverse && s.getChar().compareToIgnoreCase("bol") != 0 && s.getChar().compareToIgnoreCase("eol") != 0) {
                    Collections.reverse(s.cells);
                    Collections.reverse(s.m_init);
                }
                byte o2 = LightCharPattern.orientation(s.cells, false);
                block0 : switch (o1) {
                    case 0: {
                        switch (o2) {
                            case 0: {
                                this.mergeByInsert(false, 100.0f);
                                break;
                            }
                            case 2: {
                                this.mergeByRemove(s.m_init, -2.8f * (float)sign);
                                break;
                            }
                            case 4: {
                                this.mergeByRemove(s.m_init, -1.23f * (float)sign);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (o2) {
                            case 1: {
                                this.mergeByInsert(true, 100.0f);
                                break;
                            }
                            case 3: {
                                this.mergeByRemove(s.m_init, 2.8f * (float)sign);
                                break;
                            }
                            case 5: {
                                this.mergeByRemove(s.m_init, 1.23f * (float)sign);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (o2) {
                            case 1: {
                                this.mergeByRemove(s.m_init, -2.8f * (float)sign);
                                break;
                            }
                            case 3: {
                                this.mergeByRemove(s.m_init, 100.0f);
                                break;
                            }
                            case 5: {
                                this.mergeByRemove(s.m_init, 2.7f * (float)sign);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (o2) {
                            case 0: {
                                this.mergeByRemove(s.m_init, 2.8f * (float)sign);
                                break;
                            }
                            case 2: {
                                this.mergeByRemove(s.m_init, 100.0f);
                                break;
                            }
                            case 4: {
                                this.mergeByRemove(s.m_init, -2.7f * (float)sign);
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (o2) {
                            case 1: {
                                this.mergeByRemove(s.m_init, -1.23f * (float)sign);
                                break;
                            }
                            case 3: {
                                this.mergeByRemove(s.m_init, -2.7f * (float)sign);
                                break;
                            }
                            case 5: {
                                this.mergeByRemove(s.m_init, 100.0f);
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (o2) {
                            case 0: {
                                this.mergeByRemove(s.m_init, 1.23f * (float)sign);
                                break block0;
                            }
                            case 2: {
                                this.mergeByRemove(s.m_init, 2.7f * (float)sign);
                                break block0;
                            }
                            case 4: {
                                this.mergeByRemove(s.m_init, 100.0f);
                            }
                        }
                    }
                }
            }
        }
        this.cells.addAll(s.cells);
        this.m_init.addAll(s.m_init);
    }

    private void mergeByRemove(List<Float> l3, float m) {
        this.m_init.remove(this.m_init.size() - 1);
        this.cells.remove(this.cells.size() - 1);
        l3.set(0, Float.valueOf(m));
    }

    private void mergeByInsert(boolean botOrTop, float m) {
        short[] cell = (short[])((short[])this.cells.get(this.cells.size() - 1)).clone();
        cell[1] = (short)(cell[1] + (botOrTop ? -1 : 1));
        this.cells.add(cell);
        this.m_init.add(Float.valueOf(m));
    }

    private static byte orientation(List<short[]> cellList, boolean frontOrEnd) {
        int i0 = frontOrEnd ? cellList.size() - 1 : 0;
        int inc = frontOrEnd ? -1 : 1;
        short x1 = cellList.get(i0)[0];
        short y1 = cellList.get(i0)[1];
        short x2 = cellList.get(i0 + inc)[0];
        short y2 = cellList.get(i0 + inc)[1];
        if (y1 != y2) {
            if (x1 != x2) {
                return y1 > y2 == frontOrEnd ? (byte)2 : 3;
            }
            return y1 > y2 == frontOrEnd ? (byte)4 : 5;
        }
        int i = i0 + 2 * inc;
        while (y1 == (y2 = cellList.get(i)[1])) {
            i += inc;
        }
        return y1 > y2 ? (byte)1 : 0;
    }

    private LightChar getLightChar(String sbl) {
        for (LightChar lc : this.lightChars) {
            if (lc.getChar().compareToIgnoreCase(sbl) != 0) continue;
            return lc;
        }
        return null;
    }

    private String listUnknownChars(String txt) {
        StringBuffer sb = new StringBuffer();
        for (char c : txt.toCharArray()) {
            if (this.getLightChar(c + "") != null) continue;
            sb.append(c).append(" ");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return null;
    }

    public static String reduce(String text) {
        text = text.trim();
        text = text.replace("\n", "");
        text = text.replace('\t', ' ');
        text = text.replace('\b', ' ');
        text = text.replace('\f', ' ');
        text = text.replace('\r', ' ');
        text = text.replace('`', '\'');
        return text;
    }

    private static String prepare(String text, short size) {
        StringBuffer tbuf = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            int j;
            boolean e = i % 2 == 0;
            int n = j = e ? size - 4 : 0;
            while (j >= 0 && j < size - 3) {
                int idx = i * (size - 3) + j;
                tbuf.append(idx < text.length() ? text.charAt(idx) : (char)' ');
                j += e ? -1 : 1;
            }
        }
        return tbuf.toString();
    }

    public static String[] preview(String text, short size) {
        text = text.replace(" ", "/");
        if (size > 0) {
            int i;
            String[] lines = new String[size - 1];
            String space = "";
            for (i = 0; i < size - 3; ++i) {
                space = space + "/";
            }
            for (i = 0; i < lines.length; ++i) {
                int k0 = i * (size - 3);
                int k1 = Math.min(k0 + size - 3, text.length());
                if (k0 < text.length()) {
                    int k2 = k1 % (size - 3);
                    String insert = k2 != 0 ? space.substring(k2) : "";
                    lines[i] = "[" + text.substring(k0, k1) + insert + "]";
                    continue;
                }
                lines[i] = "[" + space + "]";
            }
            return lines;
        }
        return new String[0];
    }

    public static short calcGridSize(String text) {
        return (short)Math.ceil(2.0 + Math.sqrt(1 + text.length()));
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("text = ");
        sb.append(this.getText());
        sb.append("\n");
        sb.append("store_calc = ");
        sb.append(this.isStoreCalcEnabled());
        return sb.toString();
    }

    private static enum DIR {
        LEFT,
        RIGHT,
        DOWN;

    }
}

