/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.util.ArrayList;
import pattern.LightPatternSequence;

public class LightChar
extends LightPatternSequence
implements Comparable<LightChar> {
    public static boolean HORIZONTAL = false;
    public static boolean VERTICAL = true;
    private String character;
    private boolean orientation;

    public LightChar(String cr) {
        this.character = cr;
        this.orientation = HORIZONTAL;
    }

    public LightChar copy() {
        LightChar s = new LightChar(this.character);
        s.m_init = new ArrayList(this.m_init);
        s.cells = new ArrayList();
        for (int i = 0; i < this.cells.size(); ++i) {
            s.cells.add(((short[])this.cells.get(i)).clone());
        }
        return s;
    }

    public String getChar() {
        return this.character;
    }

    public void move(short dx, short dy) {
        for (int i = 0; i < this.cells.size(); ++i) {
            short[] sArray = (short[])this.cells.get(i);
            sArray[0] = (short)(sArray[0] + dx);
            short[] sArray2 = (short[])this.cells.get(i);
            sArray2[1] = (short)(sArray2[1] + dy);
        }
    }

    public void setOrientation(boolean ori) {
        this.orientation = ori;
    }

    public boolean getOrientation() {
        return this.orientation;
    }

    @Override
    public int compareTo(LightChar lc) {
        if (!Character.isLetter(this.character.toCharArray()[0])) {
            return 1;
        }
        if (!Character.isLetter(lc.getChar().toCharArray()[0])) {
            return -1;
        }
        if (this.character.length() < lc.getChar().length()) {
            return -1;
        }
        if (this.character.length() > lc.getChar().length()) {
            return 1;
        }
        return this.character.compareTo(lc.getChar());
    }
}

