/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import common.Globals;
import common.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import math.VecMath;

public class CalculationRecords<T extends Number> {
    private String patternName;
    private List<Record> records;
    private VecMath<T> math;
    private short gridSize;

    public CalculationRecords(String name, short gridSize, VecMath<T> mt) {
        this.patternName = name;
        this.math = mt;
        this.gridSize = gridSize;
    }

    public CalculationRecords(String name, String content, VecMath<T> mt) throws Exception {
        this(name, -1, mt);
        StringTokenizer st = new StringTokenizer(content, "\n");
        int l = 0;
        short maxp = Globals.PRECISIONS[Globals.PRECISIONS.length - 1];
        try {
            Record cr = null;
            while (st.hasMoreTokens()) {
                if (cr == null) {
                    cr = new Record();
                }
                ++l;
                String line = st.nextToken().trim();
                int idx = line.indexOf("=");
                if (idx != -1) {
                    int k;
                    String key = line.substring(0, idx).trim();
                    String val = line.substring(idx + 1).trim();
                    if (key.compareTo("radius") == 0) {
                        k = val.indexOf("%");
                        if (k != -1) {
                            val = val.substring(0, k).trim();
                        }
                        Object value = this.math.util.copy(this.math.util.parse(val), maxp);
                        cr.setShapeSize(value);
                    } else if (key.equalsIgnoreCase("height")) {
                        Object value = this.math.util.copy(this.math.util.parse(val), maxp);
                        cr.setHeight(value);
                    } else if (key.equalsIgnoreCase("distance")) {
                        Object value = this.math.util.copy(this.math.util.parse(val), maxp);
                        cr.setDistance(value);
                    } else if (key.equalsIgnoreCase("angle")) {
                        Object value = this.math.util.copy(this.math.util.parse(val), maxp);
                        cr.setAngle(value);
                    } else if (key.equalsIgnoreCase("size")) {
                        k = val.indexOf("x");
                        if (k != -1) {
                            val = val.substring(0, k).trim();
                        }
                        short s = Short.parseShort(val);
                        this.setGridSize(s);
                    } else {
                        throw new Exception("Unknown key: " + key);
                    }
                }
                if (cr.getHeight() == null || cr.getDistance() == null || cr.getAngle() == null) continue;
                this.add(cr);
                cr = null;
            }
        }
        catch (Exception e) {
            Log.getIstc().logln("Error while parsing record " + name + ".");
            Log.getIstc().logln("Can't read line " + l + ".");
            throw e;
        }
    }

    public void add(Record cr) {
        if (this.records == null) {
            this.records = new ArrayList<Record>();
        }
        if (this.getRecord(cr.shapeSize) == null) {
            int i = this.records.size();
            for (i = 0; i < this.records.size() && this.math.cmp(this.records.get(i).shapeSize, cr.shapeSize) <= 0; ++i) {
            }
            this.records.add(i, cr);
        }
    }

    public void add(T size, T distance, T height, T angle) {
        this.add(new Record(this, size, distance, height, angle));
    }

    public Record getRecord(int idx) {
        return this.records.get(idx);
    }

    public Record getRecord(T size) {
        for (Record cr : this.records) {
            if (this.math.cmp((Number)size, cr.shapeSize) != 0) continue;
            return cr;
        }
        return null;
    }

    public List<Record> getRecords() {
        return new ArrayList<Record>(this.records);
    }

    public void setRecords(List<Record> recs) {
        this.records = recs;
    }

    public short getGridSize() {
        return this.gridSize;
    }

    public String getPatternName() {
        return this.patternName;
    }

    public void setPatternName(String name) {
        this.patternName = name;
    }

    public void setGridSize(short s) {
        this.gridSize = s;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("size     = ");
        sb.append(this.gridSize).append(" x ").append(this.gridSize);
        sb.append("\n");
        if (this.records.size() > 1) {
            sb.append("\n");
        }
        for (Record cr : this.records) {
            sb.append(cr).append("\n");
        }
        return sb.toString();
    }

    public class Record {
        private T shapeSize;
        private T height;
        private T angle;
        private T distance;

        public Record() {
        }

        public Record(T s, T d, T h, T phi) {
            this.shapeSize = s;
            this.height = h;
            this.distance = d;
            this.angle = phi;
        }

        public T getShapeSize() {
            return this.shapeSize;
        }

        public T getHeight() {
            return this.height;
        }

        public T getAngle() {
            return this.angle;
        }

        public T getDistance() {
            return this.distance;
        }

        public void setShapeSize(T s) {
            this.shapeSize = s;
        }

        public void setHeight(T h) {
            this.height = h;
        }

        public void setAngle(T a) {
            this.angle = a;
        }

        public void setDistance(T d) {
            this.distance = d;
        }

        public CalculationRecords<T> getEnclosingType() {
            return CalculationRecords.this;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("radius   = ").append(this.shapeSize);
            sb.append("%\n");
            sb.append("height   = ").append(this.height);
            sb.append("\n");
            sb.append("distance = ").append(this.distance);
            sb.append("\n");
            sb.append("angle    = ").append(this.angle);
            sb.append("\n");
            return sb.toString();
        }
    }
}

