/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import common.Log;
import java.util.ArrayList;
import java.util.List;
import lattice.Circle;
import lattice.Ray;
import lattice.RayPolygon;
import math.VecMath;
import pattern.ILightPattern;
import pattern.LightPatternSequence;
import pattern.LightPatternSolver;

public class BaseLightPattern<T extends Number>
extends LightPatternSequence
implements ILightPattern<T> {
    public static final byte POINT = 0;
    public static final byte GRAD_RIGHT = 1;
    public static final byte GRAD_LEFT = 2;
    private boolean log = true;
    private T startBndVal;
    private T endBndVal;
    private T[] endPt;
    private T[] startPt;
    private T[] reflPt;
    private byte startBndValType;
    private byte endBndValType;
    private T[] reflPt2;
    private String name;
    private T maxShapeSize;
    private T m;
    private LightPatternSolver.IProgressListener pl;
    protected LightPatternSolver<T> solver;
    protected final VecMath<T> mt;
    protected short gridSize;
    protected T gap;
    protected T r;
    protected T[] corner;
    protected int acUpperBnd;
    private List<T[]> reflPts;
    private int acLowerBnd;
    private boolean storeCalc;
    private int startIndex;
    private boolean propagating;

    public BaseLightPattern(VecMath<T> math) {
        this.mt = math;
        this.name = "";
        this.startBndVal = math.ZERO;
        this.endBndVal = math.ZERO;
        this.startBndValType = 0;
        this.endBndValType = 0;
        this.gridSize = 0;
        this.maxShapeSize = math.ZERO;
        this.storeCalc = false;
        this.startIndex = -1;
        this.propagating = false;
    }

    public BaseLightPattern(String name, VecMath<T> math) {
        this(math);
        this.name = name;
    }

    public BaseLightPattern(BaseLightPattern<T> p) {
        super(p);
        this.name = p.name;
        this.mt = p.mt;
        this.startBndVal = p.startBndVal;
        this.endBndVal = p.endBndVal;
        this.startBndValType = p.startBndValType;
        this.endBndValType = p.endBndValType;
        this.gridSize = p.gridSize;
        this.maxShapeSize = p.maxShapeSize;
        this.storeCalc = p.storeCalc;
        this.startIndex = p.startIndex;
        this.propagating = p.propagating;
    }

    public boolean equals(BaseLightPattern<T> p) {
        boolean b = super.equals(p);
        b &= this.mt.cmp(this.startBndVal, p.startBndVal) == 0;
        b &= this.mt.cmp(this.endBndVal, p.endBndVal) == 0;
        b &= this.startBndValType == p.startBndValType;
        b &= this.endBndValType == p.endBndValType;
        b &= this.gridSize == p.gridSize;
        b &= this.mt.cmp(this.maxShapeSize, p.maxShapeSize) == 0;
        b &= this.storeCalc == p.storeCalc;
        return b &= this.propagating == p.propagating;
    }

    @Override
    public void setParameters(T[] gridCorner, T g, T rs) {
        boolean precChange = false;
        if (this.gap != null && this.r != null) {
            precChange = ((Number)g).doubleValue() == ((Number)this.gap).doubleValue();
            precChange &= ((Number)rs).doubleValue() == ((Number)this.r).doubleValue();
        }
        this.corner = gridCorner;
        this.gap = g;
        this.r = rs;
        this.solver = new LightPatternSolver<T>(((Number)this.r).floatValue() / ((Number)this.gap).floatValue(), false, this.mt);
        if (!precChange) {
            boolean oldLog = this.log;
            this.log = false;
            int[] lossLowHigh = this.calcDigitLossLowHigh();
            this.log = oldLog;
            int spread = (int)Math.sqrt(2 * this.cells.size());
            this.acLowerBnd = lossLowHigh[0] + 8;
            this.acUpperBnd = lossLowHigh[1] + 8 + spread;
            if (this.log) {
                Log.getIstc().logln("Pattern " + this.name + " : required accuracy = 1e-" + this.acUpperBnd);
            }
        }
        int ac = this.isPropagating() ? Math.min(this.acUpperBnd, this.mt.PRECISION - 5) : this.mt.PRECISION - 5;
        this.solver.setAccuracy(ac);
        this.solver.setLog(this.log);
        this.solver.addProgressListener(this.pl);
    }

    @Override
    public int estimateCalcTime() {
        float speed = this.mt.getCalculationSpeed();
        double t = 10.88 * Math.exp(-2.63 * (double)((Number)this.solver.getOptimalDamp()).floatValue());
        t *= 2.7E-6 * (double)this.acUpperBnd * (double)this.acUpperBnd + 7.1E-4 * (double)this.acUpperBnd + 0.13;
        t /= 1.1600000000000001;
        t = (double)((speed /= (float)Runtime.getRuntime().availableProcessors() * 0.8f) * (float)this.m_init.size()) * t;
        int o = (int)Math.log10(t);
        if (o >= 2) {
            t = Math.pow(10.0, o - 1) * (double)((int)(t / Math.pow(10.0, o - 1) + 0.5));
        }
        return (int)(t + 0.5);
    }

    public void setProgressListener(LightPatternSolver.IProgressListener l) {
        this.pl = l;
        if (this.solver != null) {
            this.solver.addProgressListener(this.pl);
        }
    }

    @Override
    public T[] getStart(T worldMaxX, T phi, T[] sinCosPhi) {
        Number[] retVal = null;
        if (this.getMaxShapeSize() == null || this.mt.cmp(this.r, this.getMaxShapeSize()) <= 0) {
            retVal = (Number[])this.reflPt.clone();
            this.mt.rotate2D(retVal, (Number[])this.mt.ZERO2D, (Number)sinCosPhi[0], (Number)sinCosPhi[1]);
            if (this.isPropagating()) {
                retVal[0] = worldMaxX;
            } else {
                T gapDiv2 = this.mt.div(this.gap, this.mt.TWO);
                retVal[0] = this.mt.add(retVal[0], (Number)this.mt.sub(gapDiv2, this.r));
            }
        }
        return retVal;
    }

    @Override
    public boolean isPropagating() {
        return this.propagating;
    }

    public void setPropagating(boolean b) {
        this.propagating = b;
    }

    @Override
    public T getRotation() {
        T retVal = null;
        if (this.getMaxShapeSize() == null || this.mt.cmp(this.r, this.getMaxShapeSize()) <= 0) {
            if (this.startBndValType == 0 && this.endBndValType == 0) {
                this.calcGradientPP();
            } else if (this.startBndValType == 0 && BaseLightPattern.isGradBndType(this.endBndValType)) {
                this.calcGradientPG();
            } else if (BaseLightPattern.isGradBndType(this.startBndValType) && this.endBndValType == 0) {
                this.calcGradientGP();
            } else if (BaseLightPattern.isGradBndType(this.startBndValType) && BaseLightPattern.isGradBndType(this.endBndValType)) {
                this.calcGradientGG();
            }
            if (this.m != null) {
                T phi = this.mt.atan(this.m);
                Object dy = null;
                Object dx = null;
                if (this.reflPt2 != null) {
                    dy = this.mt.sub(this.reflPt[1], this.reflPt2[1]);
                    dx = this.mt.sub(this.reflPt[0], this.reflPt2[0]);
                } else {
                    boolean dir;
                    if (this.getStartIndex() == 0) {
                        dir = this.startBndValType == 1;
                        dy = dir ? this.startBndVal : this.mt.neg(this.startBndVal);
                    } else {
                        dir = this.endBndValType == 2;
                        dy = dir ? this.endBndVal : this.mt.neg(this.endBndVal);
                    }
                    dx = dir ? this.mt.ONE : this.mt.MINUS_ONE;
                }
                if (this.mt.cmp(dy, this.mt.ZERO) == 0) {
                    retVal = this.mt.cmp(dx, this.mt.ZERO) > 0 ? this.mt.PI : this.mt.ZERO;
                } else {
                    boolean ydir;
                    boolean bl = ydir = this.mt.cmp(dy, this.mt.ZERO) > 0;
                    retVal = this.mt.cmp(phi, this.mt.ZERO) > 0 ? (T)(ydir ? this.mt.sub(this.mt.PI, phi) : this.mt.neg(phi)) : (T)(ydir ? this.mt.neg(phi) : this.mt.sub(this.mt.neg(phi), this.mt.PI));
                }
            }
        }
        return retVal;
    }

    private static boolean isGradBndType(byte bt) {
        return bt == 2 || bt == 1;
    }

    private List<Circle<T>> buildCircles(List<short[]> cellList, int i0, int i1) {
        ArrayList<Circle<T>> circles = new ArrayList<Circle<T>>();
        T gapOver2 = this.mt.div(this.gap, this.mt.TWO);
        for (int i = i0; i < i1; ++i) {
            Number[] center = this.mt.util.array(2);
            center[0] = this.mt.add(this.mt.mul(this.gap, cellList.get(i)[0]), gapOver2);
            center[1] = this.mt.add(this.mt.mul(this.gap, cellList.get(i)[1]), gapOver2);
            this.mt.add(center, (Number[])this.corner, center);
            Circle circle = new Circle(center, this.r, this.mt);
            circles.add(circle);
        }
        return circles;
    }

    private void calcGradientPP() {
        this.startPt = this.calcBoundPoint((short[])this.cells.get(0), ((Number)this.startBndVal).byteValue());
        this.endPt = this.calcBoundPoint((short[])this.cells.get(this.cells.size() - 1), ((Number)this.endBndVal).byteValue());
        if (this.cells.size() > 2) {
            int ac;
            List<Circle<T>> circles = this.buildCircles(this.cells, 1, this.cells.size() - 1);
            this.reflPts = this.solver.solve((Number[])this.startPt, (Number[])this.endPt, circles, this.m_init);
            if (this.solver.getTerminated()) {
                this.m = null;
                return;
            }
            int idx = this.getStartIndex();
            if (idx <= 1) {
                this.reflPt = (Number[])this.reflPts.get(0);
                this.reflPt2 = this.startPt;
                ac = this.solver.getNodeAccuracy(0);
            } else if (idx == this.cells.size() - 1) {
                this.reflPt = this.endPt;
                this.reflPt2 = (Number[])this.reflPts.get(this.reflPts.size() - 1);
                ac = this.solver.getNodeAccuracy(this.reflPts.size() - 1);
            } else {
                this.reflPt = (Number[])this.reflPts.get(idx - 1);
                this.reflPt2 = (Number[])this.reflPts.get(idx - 2);
                ac = Math.min(this.solver.getNodeAccuracy(idx - 1), this.solver.getNodeAccuracy(idx - 2));
            }
            if (this.log) {
                Log.getIstc().logln("Accuracy Spread = " + (this.solver.getAccuracy() - ac));
            }
        } else {
            this.reflPts = new ArrayList<T[]>();
            this.reflPt = this.endPt;
            this.reflPt2 = this.startPt;
        }
        this.m = this.mt.div(this.mt.sub(this.reflPt[1], this.reflPt2[1]), this.mt.sub(this.reflPt[0], this.reflPt2[0]));
    }

    private void calcGradientPG() {
        this.startPt = this.calcBoundPoint((short[])this.cells.get(0), ((Number)this.startBndVal).byteValue());
        boolean boundDir = this.endBndValType == 1;
        T val = this.endBndVal;
        if (this.cells.size() > 1) {
            int ac;
            List<Circle<T>> circles = this.buildCircles(this.cells, 1, this.cells.size());
            this.reflPts = this.solver.solve((Number[])this.startPt, (Number)val, boundDir, circles, this.m_init);
            if (this.solver.getTerminated()) {
                this.m = null;
                return;
            }
            int idx = this.getStartIndex();
            if (idx <= 1) {
                this.reflPt = (Number[])this.reflPts.get(0);
                this.reflPt2 = this.startPt;
                ac = this.solver.getNodeAccuracy(0);
            } else {
                this.reflPt = (Number[])this.reflPts.get(idx - 1);
                this.reflPt2 = (Number[])this.reflPts.get(idx - 2);
                ac = Math.min(this.solver.getNodeAccuracy(idx - 1), this.solver.getNodeAccuracy(idx - 2));
            }
            if (this.log) {
                Log.getIstc().logln("Accuracy Spread = " + (this.solver.getAccuracy() - ac));
            }
            val = this.mt.div(this.mt.sub(this.reflPt[1], this.reflPt2[1]), this.mt.sub(this.reflPt[0], this.reflPt2[0]));
        } else {
            this.reflPt = this.startPt;
        }
        this.m = this.mt.util.truncate(val, this.solver.getAccuracy());
    }

    private void calcGradientGP() {
        this.endPt = this.calcBoundPoint((short[])this.cells.get(this.cells.size() - 1), ((Number)this.endBndVal).byteValue());
        boolean boundDir = this.startBndValType == 1;
        T val = this.startBndVal;
        if (this.cells.size() > 1) {
            int ac;
            List<Circle<T>> circles = this.buildCircles(this.cells, 0, this.cells.size() - 1);
            this.reflPts = this.solver.solve((Number)val, boundDir, (Number[])this.endPt, circles, this.m_init);
            if (this.solver.getTerminated()) {
                this.m = null;
                return;
            }
            int idx = this.getStartIndex();
            if (idx == 0) {
                this.reflPt = (Number[])this.reflPts.get(0);
                ac = this.solver.getNodeAccuracy(0);
            } else {
                this.reflPt = (Number[])this.reflPts.get(idx);
                this.reflPt2 = (Number[])this.reflPts.get(idx - 1);
                val = this.mt.div(this.mt.sub(this.reflPt[1], this.reflPt2[1]), this.mt.sub(this.reflPt[0], this.reflPt2[0]));
                ac = Math.min(this.solver.getNodeAccuracy(idx), this.solver.getNodeAccuracy(idx - 1));
            }
            if (this.log) {
                Log.getIstc().logln("Accuracy Spread = " + (this.solver.getAccuracy() - ac));
            }
        } else {
            this.reflPt = this.endPt;
        }
        this.m = this.mt.util.truncate(val, this.solver.getAccuracy());
    }

    private void calcGradientGG() {
        boolean boundDir1 = this.startBndValType == 1;
        boolean boundDir2 = this.endBndValType == 1;
        boolean[] boundDirs = new boolean[]{boundDir1, boundDir2};
        Number[] boundValues = this.mt.util.array(2);
        boundValues[0] = this.startBndVal;
        boundValues[1] = this.endBndVal;
        Number val = boundValues[0];
        if (this.cells.size() > 0) {
            int ac;
            List<Circle<T>> circles = this.buildCircles(this.cells, 0, this.cells.size());
            this.reflPts = this.solver.solve(boundValues, boundDirs, circles, this.m_init);
            if (this.solver.getTerminated()) {
                this.m = null;
                return;
            }
            int idx = this.getStartIndex();
            if (idx == 0) {
                this.reflPt = (Number[])this.reflPts.get(0);
                ac = this.solver.getNodeAccuracy(0);
            } else if (idx == this.cells.size()) {
                this.reflPt = (Number[])this.reflPts.get(this.cells.size() - 1);
                ac = this.solver.getNodeAccuracy(this.cells.size() - 1);
                val = boundValues[1];
            } else {
                this.reflPt = (Number[])this.reflPts.get(idx);
                this.reflPt2 = (Number[])this.reflPts.get(idx - 1);
                val = this.mt.div(this.mt.sub(this.reflPt[1], this.reflPt2[1]), this.mt.sub(this.reflPt[0], this.reflPt2[0]));
                ac = Math.min(this.solver.getNodeAccuracy(idx), this.solver.getNodeAccuracy(idx - 1));
            }
            if (this.log) {
                Log.getIstc().logln("Accuracy Spread = " + (this.solver.getAccuracy() - ac));
            }
        }
        this.m = this.mt.util.truncate(val, this.solver.getAccuracy());
    }

    private T[] calcBoundPoint(short[] cell, byte bndIdx) {
        Number[] retVal = this.mt.util.array(2);
        T gapOver2 = this.mt.div(this.gap, this.mt.TWO);
        retVal[0] = this.mt.add(this.mt.mul(this.gap, cell[0]), gapOver2);
        retVal[1] = this.mt.add(this.mt.mul(this.gap, cell[1]), gapOver2);
        this.mt.add(retVal, (Number[])this.corner, retVal);
        T dxy = this.mt.div(this.r, this.mt.sqrt(this.mt.TWO, this.mt.PRECISION));
        switch (bndIdx) {
            case 0: {
                retVal[0] = this.mt.add(retVal[0], (Number)this.r);
                break;
            }
            case 1: {
                retVal[0] = this.mt.add(retVal[0], (Number)dxy);
                retVal[1] = this.mt.add(retVal[1], (Number)dxy);
                break;
            }
            case 2: {
                retVal[1] = this.mt.add(retVal[1], (Number)this.r);
                break;
            }
            case 3: {
                retVal[0] = this.mt.sub(retVal[0], (Number)dxy);
                retVal[1] = this.mt.add(retVal[1], (Number)dxy);
                break;
            }
            case 4: {
                retVal[0] = this.mt.sub(retVal[0], (Number)this.r);
                break;
            }
            case 5: {
                retVal[0] = this.mt.sub(retVal[0], (Number)dxy);
                retVal[1] = this.mt.sub(retVal[1], (Number)dxy);
                break;
            }
            case 6: {
                retVal[1] = this.mt.sub(retVal[1], (Number)this.r);
                break;
            }
            case 7: {
                retVal[0] = this.mt.add(retVal[0], (Number)dxy);
                retVal[1] = this.mt.sub(retVal[1], (Number)dxy);
            }
        }
        return retVal;
    }

    public void setStartIndex(int idx) {
        this.startIndex = idx;
    }

    public void setStartBndVal(T sbv) {
        this.startBndVal = sbv;
    }

    public void setEndBndVal(T ebv) {
        this.endBndVal = ebv;
    }

    public void setStartBndValType(byte bt) {
        this.startBndValType = bt;
    }

    public void setEndBndValType(byte bt) {
        this.endBndValType = bt;
    }

    public void setGridSize(short s) {
        this.gridSize = s;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxShapeSize(T maxSize) {
        this.maxShapeSize = maxSize;
    }

    public void setStoreCalculation(boolean b) {
        this.storeCalc = b;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public T getStartBndVal() {
        return this.startBndVal;
    }

    @Override
    public T getEndBndVal() {
        return this.endBndVal;
    }

    @Override
    public byte getStartBndValType() {
        return this.startBndValType;
    }

    @Override
    public byte getEndBndValType() {
        return this.endBndValType;
    }

    @Override
    public short getGridSize() {
        return this.gridSize;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getMaxShapeSize() {
        return this.maxShapeSize;
    }

    @Override
    public boolean isStoreCalcEnabled() {
        return this.storeCalc;
    }

    public boolean check() {
        String msg = null;
        if (this.cells == null) {
            msg = "ERROR: No cells have been defined for pattern " + this.getName();
        } else if (this.startBndValType == 0 && this.endBndValType == 0) {
            if (this.cells.size() < 2) {
                msg = "ERROR: Pattern " + this.getName() + " must have at least 2 cells";
            } else if (this.cells.size() < this.m_init.size() + 2) {
                msg = "ERROR: Found to many initial gradients in pattern " + this.getName();
            } else if (this.cells.size() > this.m_init.size() + 2) {
                msg = "ERROR: Missing initial gradients in pattern " + this.getName();
            }
        } else if (this.cells.size() < 1) {
            msg = "ERROR: Pattern " + this.getName() + " must have at least 1 cell";
        }
        if (msg != null) {
            Log.getIstc().logln(msg);
            return false;
        }
        return true;
    }

    public void stopCalc() {
        if (this.solver != null) {
            this.solver.setTerminated(true);
        }
    }

    public void setAccuracy(int ac) {
        this.solver.setAccuracy(ac);
    }

    @Override
    public int getAccuracy() {
        return this.solver.getAccuracy();
    }

    @Override
    public int getAccuracyUpperBound() {
        return this.acUpperBnd;
    }

    @Override
    public int getAccuracyLowerBound() {
        return this.acLowerBnd;
    }

    protected int[] calcDigitLossLowHigh() {
        float[] lossLowHigh = this.calcSequenceDigitLossLowHigh();
        float dll = lossLowHigh[0];
        if (!this.isPropagating()) {
            dll *= (float)this.getRotations();
        }
        float dlh = lossLowHigh[1];
        if (this.isPropagating()) {
            dlh *= (float)this.gridSize;
            if (this.startBndValType != 0 || this.endBndValType != 0) {
                dlh *= 2.0f;
            }
        } else {
            dlh *= (float)this.getRotations();
        }
        int[] errors = new int[]{(int)dll, (int)((double)dlh + 0.5)};
        return errors;
    }

    protected float[] calcSequenceDigitLossLowHigh() {
        this.solver.setAccuracy(5);
        this.getRotation();
        RayPolygon rp = new RayPolygon(this.mt.util, this.solver.getAccuracy());
        rp.setShape(new Circle((Number[])this.mt.ZERO2D.clone(), this.r, this.mt));
        if (this.startBndValType == 0) {
            Circle<T> c = this.buildCircles(this.cells, 0, 1).get(0);
            if (this.reflPts.size() > 0) {
                ((ArrayList)rp).add(this.mirrorPoint(c.getCenter(), (Number[])this.startPt, (Number[])this.reflPts.get(0)));
            } else if (this.endBndValType == 0) {
                ((ArrayList)rp).add(this.mirrorPoint(c.getCenter(), (Number[])this.startPt, (Number[])this.endPt));
            }
            ((ArrayList)rp).add(this.startPt);
        } else {
            rp.setInRay(this.boundRay((Number[])this.reflPts.get(0), (Number)this.startBndVal));
        }
        for (int i = 0; i < this.reflPts.size(); ++i) {
            ((ArrayList)rp).add((Number[])this.reflPts.get(i));
        }
        if (this.endBndValType == 0) {
            ((ArrayList)rp).add(this.endPt);
            if (this.reflPts.size() > 0) {
                Circle<T> c = this.buildCircles(this.cells, this.cells.size() - 1, this.cells.size()).get(0);
                ((ArrayList)rp).add(this.mirrorPoint(c.getCenter(), (Number[])this.endPt, (Number[])this.reflPts.get(this.reflPts.size() - 1)));
            }
        } else {
            rp.setOutRay(this.boundRay((Number[])this.reflPts.get(this.reflPts.size() - 1), (Number)this.endBndVal));
        }
        float dlh = rp.getDigitLossHigh();
        float dllTmp = rp.getDigitLossLow();
        if (this.startBndValType == 0) {
            ((ArrayList)rp).remove(0);
        }
        if (this.endBndValType == 0) {
            rp.removeLast();
        }
        if (!this.isPropagating()) {
            dlh -= (dlh - rp.getDigitLossHigh()) / 2.0f;
        }
        float dll = rp.getDigitLossLow();
        dll += (dllTmp - dll) / 2.0f;
        return new float[]{dll, dlh};
    }

    private Ray<T> boundRay(T[] a, T grad) {
        Number[] v = this.mt.util.array(2);
        v[0] = this.mt.ONE;
        v[1] = grad;
        this.mt.normalize(v);
        return new Ray(a, v, this.mt.util);
    }

    private T[] mirrorPoint(T[] ctr, T[] bndPt, T[] prevPt) {
        Number[] n = this.mt.util.array(2);
        this.mt.diff((Number[])bndPt, (Number[])ctr, n);
        this.mt.normalize(n);
        Number[] x = this.mt.util.array(2);
        this.mt.diff((Number[])prevPt, (Number[])bndPt, x);
        this.mt.mirror(x, n, x);
        this.mt.add(x, (Number[])bndPt, x);
        return x;
    }

    public void calcStartIndex() {
        short[] cell;
        int pos = -1;
        int i = this.cells.size() - 1;
        while (i >= 0 && (cell = (short[])this.cells.get(i))[0] >= 0 && cell[1] >= 0 && cell[0] < this.gridSize && cell[1] < this.gridSize) {
            pos = i--;
        }
        this.startIndex = pos;
    }

    @Override
    public int getPeriod() {
        if (this.isPropagating()) {
            return -1;
        }
        int bndPts = this.startBndValType == 0 ? 1 : 0;
        return this.getRotations() * (2 * this.cells.size() - (bndPts += this.endBndValType == 0 ? 1 : 0)) / 2;
    }

    private int getRotations() {
        if (this.isPropagating()) {
            return -1;
        }
        int rotations = 8;
        byte v1 = ((Number)this.startBndVal).byteValue();
        byte v2 = ((Number)this.endBndVal).byteValue();
        if (this.startBndValType != 0) {
            v1 = (byte)(v1 + 2);
        }
        if (this.endBndValType != 0) {
            v2 = (byte)(v2 + 2);
        }
        if (Math.abs(v1 - v2) == 4) {
            rotations = 2;
        } else if (v1 % 2 == 0 == (v2 % 2 == 0)) {
            rotations = 4;
        }
        return rotations;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("boundary_types = ");
        switch (this.getStartBndValType()) {
            case 0: {
                sb.append("p");
                break;
            }
            case 2: {
                sb.append("-g");
                break;
            }
            case 1: {
                sb.append("+g");
            }
        }
        sb.append(",");
        switch (this.getEndBndValType()) {
            case 0: {
                sb.append("p");
                break;
            }
            case 2: {
                sb.append("-g");
                break;
            }
            case 1: {
                sb.append("+g");
            }
        }
        sb.append("\n");
        sb.append("boundary_values = ");
        sb.append(this.getStartBndVal()).append(",");
        sb.append(this.getEndBndVal()).append("\n");
        sb.append("initial_gradients = ");
        for (float ig : this.getInitialGradients()) {
            String val = ig + "";
            int idx = val.indexOf(".");
            if (idx != -1) {
                val = val.substring(0, Math.min(idx + 3, val.length()));
            }
            sb.append(val).append(",");
        }
        sb.replace(sb.length() - 1, sb.length(), "\n");
        sb.append("reflection_path = ");
        for (short[] cell : this.getCellSequence()) {
            sb.append("(").append(cell[0]).append(",");
            sb.append(cell[1]).append("),");
        }
        sb.replace(sb.length() - 1, sb.length(), "\n");
        sb.append("grid_size = ");
        sb.append(this.getGridSize()).append("\n");
        sb.append("max_radius = ");
        T maxr = this.getMaxShapeSize();
        sb.append(this.mt.util.toPlainString(maxr)).append("%\n");
        sb.append("store_calc = ");
        sb.append(this.isStoreCalcEnabled());
        return sb.toString();
    }

    public void setLogging(boolean l) {
        this.log = l;
    }
}

