/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.ArrayList;

public class Symbols {
    public static final String SINE = "sin";
    public static final String COSINE = "cos";
    public static final String TAN = "tan";
    public static final String ARCSINE = "arcsin";
    public static final String ARCCOSINE = "arccos";
    public static final String ARCTAN = "arctan";
    public static final String SQRT = "sqrt";
    public static final String LOG = "ln";
    public static final String[] FUNCTIONS = new String[]{"sin", "cos", "tan", "arcsin", "arccos", "arctan", "sqrt", "ln"};
    public static final String FAC = "!";
    public static final String MUL = "*";
    public static final String DIV = "/";
    public static final String ADD = "+";
    public static final String SUB = "-";
    public static final String POW = "^";
    public static final String[] OPERATORS = new String[]{"!", "^", "/", "*", "-", "+"};
    public static final String EULER = "e";
    public static final String PI = "pi";
    public static final String REFERENCE = "$";
    public static final String DELIMITER = ",";

    public static final int[] precedence(ArrayList<String> op) {
        int[] retVal = new int[op.size()];
        int idx = 0;
        for (int i = 0; i < OPERATORS.length; ++i) {
            for (int k = 0; k < op.size(); ++k) {
                if (OPERATORS[i].compareTo(op.get(k)) != 0) continue;
                retVal[idx++] = k;
            }
        }
        return retVal;
    }

    public static final boolean isUnary(String op) {
        return op.compareTo(FAC) == 0;
    }

    public static boolean isFunction(String name) {
        for (String f : FUNCTIONS) {
            if (name.compareTo(f) != 0) continue;
            return true;
        }
        return false;
    }
}

